/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.jengine.internal.utils;

import org.eclipse.stp.b2j.core.jengine.internal.compiler.TranslatorLog;

/**
 * 
 * @author amiguel
 *
 * Used to log information about the translation of BPEL into engine Programs
 */
public class StringBufferTranslatorLog implements TranslatorLog {
	StringBuffer info = new StringBuffer();
	StringBuffer warnings = new StringBuffer();
	StringBuffer errors = new StringBuffer();
	
	StringBuffer chronological = new StringBuffer();
	
	public void logInfo(String source, String s) {
		info.append(source).append(": ");
		info.append(s).append('\n');
		chronological.append(source).append(": ");
		chronological.append(s).append('\n');
	}
	public void logWarning(String source, String s) {
		warnings.append(source).append(": ");
		warnings.append(s).append('\n');
		chronological.append(source).append(": ");
		chronological.append(s).append('\n');
	}
	public void logError(String source, String s) {
		errors.append(source).append(": ");
		errors.append(s).append('\n');
		chronological.append(source).append(": ");
		chronological.append(s).append('\n');
	}
	
	public String toString() {
		return chronological.toString();
	}
	
	public String getAll() {
		return chronological.toString();
	}
	public String getInfo() {
		return info.toString();
	}
	public String getWarnings() {
		return warnings.toString();
	}
	public String getErrors() {
		return errors.toString();
	}
}