/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.publicapi.example;

import java.io.File;
import java.io.FileOutputStream;
import java.io.ObjectOutputStream;

import org.eclipse.stp.b2j.core.publicapi.engine.BPELEngineListener;
import org.eclipse.stp.b2j.core.publicapi.engine.IndependantBPELEngine;
import org.eclipse.stp.b2j.core.publicapi.program.BPELProgram;
import org.eclipse.stp.b2j.core.publicapi.program.IndependantBPELProgram;

public class RuntimeOnlyCompileExample {

	private static void usage() {
		System.out.println("Usage: RuntimeOnlyCompileExample <file>");
		System.out.println("");
		System.out.println("e.g. RuntimeOnlyCompileExample mytest.bpel  (requires full JAR)");
		System.out.println("     RuntimeOnlyExecuteExample mytest.bpel.b2jprog  (requires runtime only JAR)");
		System.exit(1);
	}
	
	public static void main(String[] args) throws Exception {
		
		if (args.length < 1) {
			usage();
		}
		
		String file = args[0];
		
		BPELProgram program = new IndependantBPELProgram(new File(file));		
		IndependantBPELEngine engine = new IndependantBPELEngine(program);
		program = engine.compileProgram(new PrintoutEngineListener());
		
		ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(file+".b2jprog"));
		out.writeObject(program);
		out.close();
		
		System.out.println("\nProgram compilation OK");
		System.out.println("Wrote: "+file+".b2jprog");
	}
	
	private static class PrintoutEngineListener implements BPELEngineListener {

		public void printInfo(String s) {
			System.out.println("INFO: "+s);
		}

		public void printDebug(String s) {
			System.out.println("DEBUG: "+s);
		}

		public void printEngineInfo(String s) {
			System.out.println("ENGINE_INFO: "+s);
		}

		public void printEngineDebug(String s) {
			System.out.println("ENGINE_DEBUG: "+s);
		}
		
	}
	
}