/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.publicapi.extension.sessiontransport;

import java.util.ArrayList;
import java.util.Properties;

import org.eclipse.stp.b2j.core.misc.internal.B2jClassLoader;
import org.eclipse.stp.b2j.core.publicapi.B2jPlatform;
import org.eclipse.stp.b2j.core.publicapi.DependencyInfo;

/**
 * 
 * @author amiguel
 *
 * A utility class to load all extensions of the Session Transport extension point
 */
public class SessionTransportLoader {

	public static SessionTransportProvider getTransportProvider(String classname) {
		try {
			SessionTransportProvider[] transports = getTransports();
			for (int i = 0; i < transports.length; i++) {
				if (transports[i].getProviderClassName().equals(classname)) {
					return transports[i];
				}
			}
			return null;
		} catch (Throwable t) {
			
			try {
				return (SessionTransportProvider)B2jClassLoader.load(classname).newInstance();
			} catch (Throwable t2) {
				return null;
			}
		}
	}
	
	public static SessionTransportProvider[] getTransportsUnfiltered() throws Exception {
		ArrayList providers = getExtensionPointClasses();
		SessionTransportProvider[] array = new SessionTransportProvider[providers.size()];
		providers.toArray(array);
		return array;
	}
		
	public static SessionTransportProvider[] getTransports() throws Exception {
		ArrayList providers = getExtensionPointClasses();
		SessionTransportProvider[] array = new SessionTransportProvider[providers.size()];
		providers.toArray(array);
		return array;
	}
	
	private static ArrayList getExtensionPointClasses() throws ClassNotFoundException, IllegalAccessException, InstantiationException {
		ArrayList classes = new ArrayList();
		
		DependencyInfo[] deps = B2jPlatform.getAllDependencyInfo();
		for (int i = 0; i < deps.length; i++) {
			Properties[] props = deps[i].getSessionTransports();
			for (int k = 0; k < props.length; k++) {
				Class z = B2jClassLoader.load(props[k].getProperty("Class"));
				classes.add(z.newInstance());
			}
		}
		
		return classes;
	}
	
}