/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.publicapi.program;

import java.io.Serializable;

import org.eclipse.stp.b2j.core.jengine.internal.mainengine.SoapDaemon;
import org.eclipse.stp.b2j.core.publicapi.transport.session.SessionAddress;

public interface BPELProgram extends Serializable {
	
	public static int DEFAULT_DAEMON_PORT = SoapDaemon.DAEMON_PORT;
	
	/**
	 * Get a name to identify this bpel program (will be presented to the user)
	 * @return
	 */
	public String getName();
	
	/**
	 * Get the base URI for the BPEL file
	 * @return
	 */
	public String getBaseURI() throws Exception;
	
	/**
	 * Get the BPEL source to run
	 * @return
	 */
	public String getBpelSource() throws Exception;
	
	/**
	 * Get a list of the worker daemon hosts
	 * @return
	 */
	public SessionAddress[] getWorkerDaemons();
	
	/**
	 * Get a list of the worker hosts
	 * @return
	 */
	public SessionAddress[] getWorkerHosts();
	
	/**
	 * Get the coordinator host
	 * @return
	 */
	public SessionAddress getCoordinatorHost();
	
	/**
	 * Get the coordinator host daemon
	 * @return
	 */
	public SessionAddress getCoordinatorDaemon();
	
	/**
	 * Get a list of JARDependency objects which this program requires to run
	 * @return
	 */
	public String[] getProgramDependencies();
	
	/**
	 * Set the coordinator host if this program is to run over a number of hosts
	 * @param address an address containing a listener host corresponding to the coordinator host
	 */
	public void setCoordinatorHost(SessionAddress daemon_address, SessionAddress coordinator_address);

	/**
	 * Add a worker host if this program is to run over a number of hosts
	 * @param address an address containing a listener host corresponding to the worker host
	 */
	public void addWorkerHost(SessionAddress daemon_address, SessionAddress worker_address);
	
	/**
	 * Include a JAR on the classpath of the engine program
	 * @param localJarPath
	 */
	public void addJarDependency(String localJarPath);
	
	
	//
	// Internal use
	//
	
	public void setCompiledData(String key, Object o);
	public Object getCompiledData(String key);
}