/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.ui.internal.debug;

import java.util.ArrayList;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IRegisterGroup;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.stp.b2j.core.B2jPlugin;
import org.eclipse.stp.b2j.core.jengine.internal.debug.DebugConstants;
import org.eclipse.stp.b2j.core.jengine.internal.message.Message;

/**
 * 
 * @author amiguel
 *
 * Represents a stackframe in a runner in the engine
 */
public class RunnerStackFrame extends ControllerDebugElement implements IStackFrame {
	RunnerStackFrame parent;
	RunnerDebugThread thread;
	
	String name;
	
	ArrayList variables = new ArrayList();
	
	
	public RunnerStackFrame(RunnerStackFrame parent, RunnerDebugThread thread, String frame) {
		super((ControllerDebugTarget)thread.getDebugTarget());
		this.parent = parent;
		this.thread = thread;
		name = frame;
	}
	
	public void addFrameMessage(Message m) {
		System.err.println("FRAME ADD MESSAGE "+m);
		if (m.getType() == DebugConstants.STACKTRACE_THREAD_NAME) {
			//do nothing
		} else if (m.getType() == DebugConstants.STACKTRACE_VARIABLES) {
			//VARIABLES!
			for (int i = 0; i < m.length(); i++) {
				Message mv = (Message)m.get(i);
				String name = (String)mv.get(0);
				variables.add(new RunnerDebugVariable(this,name));
			}
		}
	}

	public IThread getThread() {
		System.err.println("GET THREAD");
		return thread;
	}

	public String getName() throws DebugException {
		System.err.println("GET NAME");
		return name;
	}

	public IDebugTarget getDebugTarget() {
		System.err.println("GET DEBUG TARGET");
		return thread.getDebugTarget();
	}

	public ILaunch getLaunch() {
		System.err.println("GET LAUNCH");
		return thread.getLaunch();
	}


	public boolean canResume() {
		System.err.println("CAN RESUME");
		return thread.canResume();
	}

	public boolean canSuspend() {
		System.err.println("GET SUSPEND");
		return thread.canSuspend();
	}

	public boolean isSuspended() {
		System.err.println("IS SUSPENDED");
		return thread.isSuspended();
	}

	public void resume() throws DebugException {
		System.err.println("RESUME");
		thread.resume();
	}

	public void suspend() throws DebugException {
		System.err.println("SUSPEND");
		thread.suspend();
	}

	public String getModelIdentifier() {
		return B2jPlugin.DEBUG_MODEL_ID;
	}
	
	public boolean hasVariables() throws DebugException {
		System.err.println("HAS VARIABLES");
		return variables.size() > 0;
	}

	public IVariable[] getVariables() throws DebugException {
		System.err.println("GET VARIABLES");
		ArrayList tmp = new ArrayList();
		if (parent != null) {
			IVariable[] tmpvars = parent.getVariables();
			for (int i = 0; i < tmpvars.length; i++) {
				tmp.add(tmpvars[i]);
			}
		}
		tmp.addAll(variables);
		
		IVariable[] vars = new IVariable[tmp.size()];
		tmp.toArray(vars);
		return vars;
	}

	public Object getAdapter(Class adapter) {
		System.err.println("GET ADAPTER");
		if (adapter == getClass()) {
			return this;
		}
		return super.getAdapter(adapter);
	}

	public boolean canTerminate() {
		System.err.println("CAN TERMINATE");
		return thread.canTerminate();
	}

	public boolean isTerminated() {
		System.err.println("IS TERMINATED");
		return thread.isTerminated();
	}

	public void terminate() throws DebugException {
		thread.terminate();
	}
	
//
// UNIMPLEMENTED
//
	
	/* (non-Javadoc)
	 * @see org.eclipse.debug.core.model.IStackFrame#getLineNumber()
	 */
	public int getLineNumber() throws DebugException {
		// TODO Auto-generated method stub
		return 0;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.debug.core.model.IStackFrame#getCharStart()
	 */
	public int getCharStart() throws DebugException {
		// TODO Auto-generated method stub
		return 0;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.debug.core.model.IStackFrame#getCharEnd()
	 */
	public int getCharEnd() throws DebugException {
		// TODO Auto-generated method stub
		return 0;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.debug.core.model.IStackFrame#getRegisterGroups()
	 */
	public IRegisterGroup[] getRegisterGroups() throws DebugException {
		// TODO Auto-generated method stub
		return null;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.debug.core.model.IStackFrame#hasRegisterGroups()
	 */
	public boolean hasRegisterGroups() throws DebugException {
		// TODO Auto-generated method stub
		return false;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.debug.core.model.IStep#canStepInto()
	 */
	public boolean canStepInto() {
		// TODO Auto-generated method stub
		return false;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.debug.core.model.IStep#canStepOver()
	 */
	public boolean canStepOver() {
		// TODO Auto-generated method stub
		return false;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.debug.core.model.IStep#canStepReturn()
	 */
	public boolean canStepReturn() {
		// TODO Auto-generated method stub
		return false;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.debug.core.model.IStep#isStepping()
	 */
	public boolean isStepping() {
		// TODO Auto-generated method stub
		return false;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.debug.core.model.IStep#stepInto()
	 */
	public void stepInto() throws DebugException {
		// TODO Auto-generated method stub
		
	}

	/* (non-Javadoc)
	 * @see org.eclipse.debug.core.model.IStep#stepOver()
	 */
	public void stepOver() throws DebugException {
		// TODO Auto-generated method stub
		
	}

	/* (non-Javadoc)
	 * @see org.eclipse.debug.core.model.IStep#stepReturn()
	 */
	public void stepReturn() throws DebugException {
		// TODO Auto-generated method stub
		
	}

}