/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.xpath.internal;

/* Generated By:JavaCC: Do not edit this line. XPathParser.java */
        public class XPathParser implements XPathParserConstants {
                XPathVisitor visitor;

  final public void NCName() throws ParseException {
        Token t;
    switch (jj_nt.kind) {
    case NCName:
      t = jj_consume_token(NCName);
      break;
    case ID:
      t = jj_consume_token(ID);
      break;
    case OR:
      t = jj_consume_token(OR);
      break;
    case AND:
      t = jj_consume_token(AND);
      break;
    case MOD:
      t = jj_consume_token(MOD);
      break;
    case DIV:
      t = jj_consume_token(DIV);
      break;
    case KEY:
      t = jj_consume_token(KEY);
      break;
    case NODE:
      t = jj_consume_token(NODE);
      break;
    case TEXT:
      t = jj_consume_token(TEXT);
      break;
    case COMMENT:
      t = jj_consume_token(COMMENT);
      break;
    case PI:
      t = jj_consume_token(PI);
      break;
    default:
      jj_la1[0] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                visitor.push(t.image);
  }

  final public void NCName_Without_NodeType() throws ParseException {
        Token t;
    switch (jj_nt.kind) {
    case NCName:
      t = jj_consume_token(NCName);
      break;
    case ID:
      t = jj_consume_token(ID);
      break;
    case OR:
      t = jj_consume_token(OR);
      break;
    case AND:
      t = jj_consume_token(AND);
      break;
    case MOD:
      t = jj_consume_token(MOD);
      break;
    case DIV:
      t = jj_consume_token(DIV);
      break;
    case KEY:
      t = jj_consume_token(KEY);
      break;
    default:
      jj_la1[1] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                visitor.push(t.image);
  }

  final public void QName() throws ParseException {
    NCName();
    switch (jj_nt.kind) {
    case 35:
      jj_consume_token(35);
      NCName();
                        visitor.evaluateQName();
      break;
    default:
      jj_la1[2] = jj_gen;
      ;
    }
  }

  final public void QName_Without_NodeType() throws ParseException {
    NCName_Without_NodeType();
    switch (jj_nt.kind) {
    case 35:
      jj_consume_token(35);
      NCName_Without_NodeType();
                        visitor.evaluateQNameWONodeType();
      break;
    default:
      jj_la1[3] = jj_gen;
      ;
    }
  }

/* ################################################################################### */
/* XSLT Patterns (http://www.w3.org/1999/08/WD-xslt-19990813)                          */
/* ################################################################################### */

/* [XSLT1] Pattern ::= LocationPathPattern | Pattern '|' LocationPathPattern  */
  final public void Pattern() throws ParseException {
        Token t;
    LocationPathPattern();
    label_1:
    while (true) {
      switch (jj_nt.kind) {
      case UNION:
        ;
        break;
      default:
        jj_la1[4] = jj_gen;
        break label_1;
      }
      t = jj_consume_token(UNION);
                        visitor.push(t.image);
      LocationPathPattern();
                        visitor.evaluatePattern();
    }
    jj_consume_token(0);
  }

/* [XSLT2] LocationPathPattern ::=
   '/' RelativePathPattern? | IdKeyPattern (('/' | '//' RelativePathPattern)? | '//'? RelativePathPattern
*/
  final public void LocationPathPattern() throws ParseException {
        Token t;
        boolean slashslash = false;
    switch (jj_nt.kind) {
    case SLASH:
      t = jj_consume_token(SLASH);
                             visitor.push(t.image); visitor.processSlash();
      switch (jj_nt.kind) {
      case ID:
      case OR:
      case AND:
      case MOD:
      case DIV:
      case KEY:
      case NODE:
      case TEXT:
      case COMMENT:
      case PI:
      case NCName:
      case 43:
      case 44:
        RelativePathPattern();
        break;
      default:
        jj_la1[5] = jj_gen;
        ;
      }
                        visitor.evaluateLocationPathPattern();
      break;
    case SLASHSLASH:
    case ID:
    case OR:
    case AND:
    case MOD:
    case DIV:
    case KEY:
    case NODE:
    case TEXT:
    case COMMENT:
    case PI:
    case NCName:
    case 43:
    case 44:
      if (jj_2_1(2147483647)) {
        IdKeyPattern();
        switch (jj_nt.kind) {
        case SLASH:
        case SLASHSLASH:
          switch (jj_nt.kind) {
          case SLASH:
            t = jj_consume_token(SLASH);
            break;
          case SLASHSLASH:
            t = jj_consume_token(SLASHSLASH);
            break;
          default:
            jj_la1[6] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
                                        visitor.push(t.image);
                                        visitor.processSlash();
          RelativePathPattern();
          break;
        default:
          jj_la1[7] = jj_gen;
          ;
        }
                                visitor.evaluateLocationIDPathPattern();
      } else {
        switch (jj_nt.kind) {
        case SLASHSLASH:
        case ID:
        case OR:
        case AND:
        case MOD:
        case DIV:
        case KEY:
        case NODE:
        case TEXT:
        case COMMENT:
        case PI:
        case NCName:
        case 43:
        case 44:
          switch (jj_nt.kind) {
          case SLASHSLASH:
            t = jj_consume_token(SLASHSLASH);
                                           visitor.push(t.image); slashslash=true; visitor.processSlash();
            break;
          default:
            jj_la1[8] = jj_gen;
            ;
          }
                                if (slashslash == false)
                                {
                                        visitor.push("NOOP");
                                }
          RelativePathPattern();
                                visitor.evaluateLocationRelPathPattern();
          break;
        default:
          jj_la1[9] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      break;
    default:
      jj_la1[10] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/* [XSLT3] IdKeyPattern    ::=    'id' '(' Literal ')' | 'key' '(' Literal ',' Literal ')'  */
  final public void IdKeyPattern() throws ParseException {
        Token t;
    switch (jj_nt.kind) {
    case ID:
      t = jj_consume_token(ID);
                        visitor.push(t.image);
      jj_consume_token(36);
                      visitor.push("(");
      t = jj_consume_token(Literal);
      jj_consume_token(37);
                        visitor.push(t.image);
                        visitor.processLiteral();
                        visitor.push(")");
                        visitor.evaluateSingleIDKeyPattern();
      break;
    case KEY:
      t = jj_consume_token(KEY);
                        visitor.push(t.image);
                        visitor.push("(");
      jj_consume_token(36);
      t = jj_consume_token(Literal);
                        visitor.push(t.image);
                        visitor.processLiteral();
      jj_consume_token(38);
      t = jj_consume_token(Literal);
                        visitor.push(t.image);
                        visitor.processLiteral();
                        visitor.push(")");
                        visitor.evaluateDoubleIDKeyPattern();
      jj_consume_token(37);
      break;
    default:
      jj_la1[11] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/* [XSLT4] RelativePathPattern    ::=    StepPattern | RelativePathPattern '/' StepPattern 
   						| RelativePathPattern '//' StepPattern  
*/
  final public void RelativePathPattern() throws ParseException {
        Token t;
    StepPattern();
    label_2:
    while (true) {
      switch (jj_nt.kind) {
      case SLASH:
      case SLASHSLASH:
        ;
        break;
      default:
        jj_la1[12] = jj_gen;
        break label_2;
      }
      switch (jj_nt.kind) {
      case SLASH:
        t = jj_consume_token(SLASH);
        break;
      case SLASHSLASH:
        t = jj_consume_token(SLASHSLASH);
        break;
      default:
        jj_la1[13] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                                visitor.push(t.image);
                                visitor.processSlash();
      StepPattern();
                                visitor.evaluateRelativePathPattern();
    }
  }

/* [XSLT5]    StepPattern    ::=    AbbreviatedAxisSpecifier NodeTest Predicate*   */
  final public void StepPattern() throws ParseException {
    AbbreviatedAxisSpecifier();
                        visitor.evaluateAbbreviatedAxisSpecifier();
    NodeTest();
                        visitor.evaluateStepPredicate();
    label_3:
    while (true) {
      switch (jj_nt.kind) {
      case 39:
        ;
        break;
      default:
        jj_la1[14] = jj_gen;
        break label_3;
      }
                                visitor.prePredicateEval();
      Predicate();
                                visitor.postPredicateEval();
    }
  }

/* ################################################################################### */
/* XPath (http://www.w3.org/1999/08/WD-xpath-19990813 )                                */
/* ################################################################################### */


/*------------------*/
/* 2 Location Paths */
/*------------------*/
  final public void XPath(XPathVisitor v) throws ParseException {
        visitor = v;
        visitor.visit("[XPath()]");
    Expr();
    jj_consume_token(0);
  }

/* [1] LocationPath ::= RelativeLocationPath | AbsoluteLocationPath  */
  final public void LocationPath() throws ParseException {
    switch (jj_nt.kind) {
    case ID:
    case OR:
    case AND:
    case MOD:
    case DIV:
    case KEY:
    case NODE:
    case TEXT:
    case COMMENT:
    case PI:
    case AxisName:
    case NCName:
    case 41:
    case 42:
    case 43:
    case 44:
                        visitor.setContextNode();
      RelativeLocationPath();
      break;
    case SLASH:
    case SLASHSLASH:
      AbsoluteLocationPath();
      break;
    default:
      jj_la1[15] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/* [2] AbsoluteLocationPath ::= '/' RelativeLocationPath? | AbbreviatedAbsoluteLocationPath  */
  final public void AbsoluteLocationPath() throws ParseException {
        Token t;
    switch (jj_nt.kind) {
    case SLASHSLASH:
      AbbreviatedAbsoluteLocationPath();
      break;
    case SLASH:
      t = jj_consume_token(SLASH);
                       visitor.push(t.image); visitor.processAbsoluteSlash();
      if (jj_2_2(2147483647)) {
        RelativeLocationPath();
                        visitor.evaluateAbsoluteLocationPath();
      } else {
        ;
      }
      break;
    default:
      jj_la1[16] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/* [3] RelativeLocationPath ::= Step | RelativeLocationPath '/' Step | AbbreviatedRelativeLocationPath */
  final public void RelativeLocationPath() throws ParseException {
        Token t;
    Step();
    if (jj_2_3(2147483647)) {
      switch (jj_nt.kind) {
      case SLASH:
        t = jj_consume_token(SLASH);
        break;
      case SLASHSLASH:
        t = jj_consume_token(SLASHSLASH);
        break;
      default:
        jj_la1[17] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                        visitor.push(t.image);
                        visitor.processSlash();
      RelativeLocationPath();
                        visitor.evaluateRelativeLocationPath();
    } else {
      ;
    }
  }

/*--------------------*/
/* 2.1 Location Steps */
/*--------------------*/

/* [4] Step ::= AxisSpecifier NodeTest Predicate*   | AbbreviatedStep  */
  final public void Step() throws ParseException {
    switch (jj_nt.kind) {
    case ID:
    case OR:
    case AND:
    case MOD:
    case DIV:
    case KEY:
    case NODE:
    case TEXT:
    case COMMENT:
    case PI:
    case AxisName:
    case NCName:
    case 43:
    case 44:
      AxisSpecifier();
                visitor.evaluateAxisSpecifier();
      NodeTest();
                visitor.evaluateStepPredicate();
      label_4:
      while (true) {
        switch (jj_nt.kind) {
        case 39:
          ;
          break;
        default:
          jj_la1[18] = jj_gen;
          break label_4;
        }
                        visitor.prePredicateEval();
        Predicate();
                        visitor.postPredicateEval();
      }
      break;
    case 41:
    case 42:
      AbbreviatedStep();
      break;
    default:
      jj_la1[19] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/* [5] AxisSpecifier ::=    AxisName '::' | AbbreviatedAxisSpecifier  */
  final public void AxisSpecifier() throws ParseException {
    switch (jj_nt.kind) {
    case AxisName:
      AxisName();
      break;
    default:
      jj_la1[20] = jj_gen;
      AbbreviatedAxisSpecifier();
                        visitor.evaluateAbbreviatedAxisSpecifier();
    }
  }

/*----------*/
/* 2.2 Axes */
/*----------*/

/* [6] AxisName ::= 'ancestor' | 'ancestor-or-self' | 'attribute'  | 'child' | 'descendant'  
					| 'descendant-or-self' | 'following' | 'following-sibling' | 'namespace'  
   					| 'parent' | 'preceding' | 'preceding-sibling' | 'self'
*/
  final public void AxisName() throws ParseException {
        Token t;
    t = jj_consume_token(AxisName);
                visitor.push(t.image);
  }

/*----------------*/
/* 2.3 Node Tests */
/*----------------*/

/* [7] NodeTest ::= WildcardName | NodeType '(' ')' | 'processing-instruction' '(' Literal ')' */
  final public void NodeTest() throws ParseException {
        Token t;
    if (jj_2_4(2147483647)) {
      NodeType();
      jj_consume_token(36);
      jj_consume_token(37);
                        visitor.push("(");
                        visitor.push(")");
                        visitor.evaluateNodeTypeTest();
    } else if (jj_2_5(2147483647)) {
      t = jj_consume_token(PI);
                        visitor.push(t.image);
      jj_consume_token(36);
      t = jj_consume_token(Literal);
                        visitor.push("(");
                        visitor.push(t.image);
                        visitor.processLiteral();
                        visitor.push(")");
                        visitor.evaluateProcessingInstruction();
      jj_consume_token(37);
    } else {
      switch (jj_nt.kind) {
      case ID:
      case OR:
      case AND:
      case MOD:
      case DIV:
      case KEY:
      case NODE:
      case TEXT:
      case COMMENT:
      case PI:
      case NCName:
      case 44:
        WildcardName();
                        visitor.evaluateNameTest();
        break;
      default:
        jj_la1[21] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

/*----------------*/
/* 2.4 Predicates */
/*----------------*/

/* [8] Predicate ::= '[' PredicateExpr ']'  */
  final public void Predicate() throws ParseException {

    jj_consume_token(39);
    PredicateExpr();
    jj_consume_token(40);

  }

/* [9] PredicateExpr ::=  Expr  */
  final public void PredicateExpr() throws ParseException {
    Expr();
  }

/*------------------------*/
/* 2.5 Abbreviated Syntax */
/*------------------------*/
/* [10]    AbbreviatedAbsoluteLocationPath    ::=    '//' RelativeLocationPath  */
  final public void AbbreviatedAbsoluteLocationPath() throws ParseException {
        Token t;
    t = jj_consume_token(SLASHSLASH);
                visitor.push(t.image);
                visitor.processAbbreviatedAbsoluteSlash();
    RelativeLocationPath();
                visitor.evaluateAbbreviatedAbsoluteLocationPath();
  }

/* [11]    AbbreviatedRelativeLocationPath    ::=    RelativeLocationPath '//' Step  */
  final public void AbbreviatedRelativeLocationPath() throws ParseException {
        Token t;
    RelativeLocationPath();
    t = jj_consume_token(SLASHSLASH);
                visitor.push(t.image);
                visitor.processAbbreviatedRelativeSlash();
    Step();
                visitor.evaluateAbbreviatedRelativeLocationPath();
  }

/* [12]    AbbreviatedStep    ::=    '.'  | '..'  */
  final public void AbbreviatedStep() throws ParseException {
    switch (jj_nt.kind) {
    case 41:
      jj_consume_token(41);
             visitor.push(".");
      break;
    case 42:
      jj_consume_token(42);
                                          visitor.push("..");
      break;
    default:
      jj_la1[22] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/* [13]    AbbreviatedAxisSpecifier    ::=    '@'? */
  final public void AbbreviatedAxisSpecifier() throws ParseException {
        boolean b = false;
    switch (jj_nt.kind) {
    case 43:
      jj_consume_token(43);
               visitor.push("@"); b = true;
      break;
    default:
      jj_la1[23] = jj_gen;
      ;
    }
  }

/*---------------*/
/* 3 Expressions */
/*---------------*/

/*------------*/
/* 3.1 Basics */
/*------------*/

/*
The effect of the grammar is that the order of precedence is (lowest precedence first): 
	or 
	and 
	=, != 
	<=, <, >=, > 
and all operators are left associative.
For example, 3 > 2 > 1 is equivalent to (3 > 2) > 1, which evaluates to false. 
*/

/* [14] Expr ::= OrExpr */
  final public void Expr() throws ParseException {
    OrExpr();
  }

/* [15] PrimaryExpr ::= VariableReference | '(' Expr ')' | Literal | Number | FunctionCall */
  final public void PrimaryExpr() throws ParseException {
        Token t;
    switch (jj_nt.kind) {
    case VARIABLE:
      VariableReference();
      break;
    case 36:
      jj_consume_token(36);
      Expr();
      jj_consume_token(37);
      break;
    case Literal:
      t = jj_consume_token(Literal);
                                visitor.push(t.image);  visitor.processLiteral();
      break;
    case Number:
      t = jj_consume_token(Number);
                              visitor.push(t.image); visitor.processNumber();
      break;
    case ID:
    case OR:
    case AND:
    case MOD:
    case DIV:
    case KEY:
    case NCName:
      FunctionCall();
      break;
    default:
      jj_la1[24] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/*--------------------*/
/* 3.2 Function Calls */
/*--------------------*/

/* [16]    FunctionCall    ::=    FunctionName '(' ( Argument ( ',' Argument)*)? ')'  */
  final public void FunctionCall() throws ParseException {
        int i = 0;
    FunctionName();
    jj_consume_token(36);
             visitor.push("(");
    switch (jj_nt.kind) {
    case SLASH:
    case SLASHSLASH:
    case MINUS:
    case VARIABLE:
    case Literal:
    case Number:
    case ID:
    case OR:
    case AND:
    case MOD:
    case DIV:
    case KEY:
    case NODE:
    case TEXT:
    case COMMENT:
    case PI:
    case AxisName:
    case NCName:
    case 36:
    case 41:
    case 42:
    case 43:
    case 44:
      Argument();
                        i=1;
      label_5:
      while (true) {
        switch (jj_nt.kind) {
        case 38:
          ;
          break;
        default:
          jj_la1[25] = jj_gen;
          break label_5;
        }
        jj_consume_token(38);
        Argument();
                                i++;
      }
      break;
    default:
      jj_la1[26] = jj_gen;
      ;
    }
    jj_consume_token(37);
             visitor.push(new Integer(i)); visitor.push(")");
         visitor.evaluateFunctionCall();
  }

/* [17]    Argument    ::=    Expr */
  final public void Argument() throws ParseException {
    Expr();
  }

/*---------------*/
/* 3.3 Node-sets */
/*---------------*/

/* [18] UnionExpr    ::=    PathExpr | UnionExpr '|' PathExpr */
  final public void UnionExpr() throws ParseException {
        Token t;
    PathExpr();
    label_6:
    while (true) {
      switch (jj_nt.kind) {
      case UNION:
        ;
        break;
      default:
        jj_la1[27] = jj_gen;
        break label_6;
      }
      t = jj_consume_token(UNION);
                        visitor.push(t.image);
      PathExpr();
                        visitor.evaluateUnionExpr();
    }
  }

/* [19] PathExpr ::= LocationPath | FilterExpr | FilterExpr '/' RelativeLocationPath | FilterExpr '//' RelativeLocationPath  */
  final public void PathExpr() throws ParseException {
        Token t;
    if (jj_2_6(2147483647)) {
      FilterExpr();
      switch (jj_nt.kind) {
      case SLASH:
      case SLASHSLASH:
        switch (jj_nt.kind) {
        case SLASH:
          t = jj_consume_token(SLASH);
          break;
        case SLASHSLASH:
          t = jj_consume_token(SLASHSLASH);
          break;
        default:
          jj_la1[28] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
                        visitor.push(t.image);
                        visitor.processSlash();
        RelativeLocationPath();
                        visitor.evaluatePathExpr();
        break;
      default:
        jj_la1[29] = jj_gen;
        ;
      }
    } else {
      switch (jj_nt.kind) {
      case SLASH:
      case SLASHSLASH:
      case ID:
      case OR:
      case AND:
      case MOD:
      case DIV:
      case KEY:
      case NODE:
      case TEXT:
      case COMMENT:
      case PI:
      case AxisName:
      case NCName:
      case 41:
      case 42:
      case 43:
      case 44:
        LocationPath();
        break;
      default:
        jj_la1[30] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

/* [20]    FilterExpr    ::=    PrimaryExpr    | FilterExpr Predicate */
  final public void FilterExpr() throws ParseException {
    PrimaryExpr();
                visitor.evaluatePrimaryFilterExpr();
    label_7:
    while (true) {
      switch (jj_nt.kind) {
      case 39:
        ;
        break;
      default:
        jj_la1[31] = jj_gen;
        break label_7;
      }
                        visitor.prePredicateEval();
      Predicate();
                        visitor.postPredicateEval();
    }
  }

/*--------------*/
/* 3.4 Booleans */
/*--------------*/

/* [21] OrExpr    ::=    AndExpr | OrExpr 'or' AndExpr */
  final public void OrExpr() throws ParseException {
        Token t;
    AndExpr();
    label_8:
    while (true) {
      switch (jj_nt.kind) {
      case OR:
        ;
        break;
      default:
        jj_la1[32] = jj_gen;
        break label_8;
      }
      t = jj_consume_token(OR);
                        visitor.push(t.image);
      AndExpr();
                        visitor.evaluateOrExpr();
    }
  }

/* [22] AndExpr    ::=    EqualityExpr  | AndExpr 'and' EqualityExpr  */
  final public void AndExpr() throws ParseException {
        Token t;
    EqualityExpr();
    label_9:
    while (true) {
      switch (jj_nt.kind) {
      case AND:
        ;
        break;
      default:
        jj_la1[33] = jj_gen;
        break label_9;
      }
      t = jj_consume_token(AND);
                        visitor.push(t.image);
      EqualityExpr();
                        visitor.evaluateAndExpr();
    }
  }

/* [23] EqualityExpr    ::=    RelationalExpr | EqualityExpr '=' RelationalExpr | EqualityExpr '!=' RelationalExpr */
  final public void EqualityExpr() throws ParseException {
        Token t;
    RelationalExpr();
    label_10:
    while (true) {
      switch (jj_nt.kind) {
      case EQ:
      case NEQ:
        ;
        break;
      default:
        jj_la1[34] = jj_gen;
        break label_10;
      }
      switch (jj_nt.kind) {
      case EQ:
        t = jj_consume_token(EQ);
        break;
      case NEQ:
        t = jj_consume_token(NEQ);
        break;
      default:
        jj_la1[35] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                        visitor.push(t.image);
      RelationalExpr();
                        visitor.evaluateEqualityExpr();
    }
  }

/* [24] RelationalExpr    ::=    AdditiveExpr | RelationalExpr '<' AdditiveExpr | RelationalExpr '>' AdditiveExpr  
					   | RelationalExpr '<=' AdditiveExpr  | RelationalExpr '>=' AdditiveExpr */
  final public void RelationalExpr() throws ParseException {
        Token t;
    AdditiveExpr();
    label_11:
    while (true) {
      switch (jj_nt.kind) {
      case LT:
      case LTE:
      case GT:
      case GTE:
        ;
        break;
      default:
        jj_la1[36] = jj_gen;
        break label_11;
      }
      switch (jj_nt.kind) {
      case LT:
        t = jj_consume_token(LT);
        break;
      case GT:
        t = jj_consume_token(GT);
        break;
      case LTE:
        t = jj_consume_token(LTE);
        break;
      case GTE:
        t = jj_consume_token(GTE);
        break;
      default:
        jj_la1[37] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                        visitor.push(t.image);
      AdditiveExpr();
                        visitor.evaluateRelationalExpr();
    }
  }

/*-------------*/
/* 3.5 Numbers */
/*-------------*/

/* [25] AdditiveExpr ::= MultiplicativeExpr  | AdditiveExpr '+' MultiplicativeExpr  | AdditiveExpr '-' MultiplicativeExpr  */
  final public void AdditiveExpr() throws ParseException {
        Token t;
    MultiplicativeExpr();
    label_12:
    while (true) {
      switch (jj_nt.kind) {
      case PLUS:
      case MINUS:
        ;
        break;
      default:
        jj_la1[38] = jj_gen;
        break label_12;
      }
      switch (jj_nt.kind) {
      case PLUS:
        t = jj_consume_token(PLUS);
        break;
      case MINUS:
        t = jj_consume_token(MINUS);
        break;
      default:
        jj_la1[39] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                        visitor.push(t.image);
      MultiplicativeExpr();

                        visitor.evaluateAdditiveExpr();
    }
  }

/* [26] MultiplicativeExpr ::= UnaryExpr | MultiplicativeExpr MultiplyOperator UnaryExpr
			| MultiplicativeExpr 'div' UnaryExpr | MultiplicativeExpr 'mod' UnaryExpr  */
  final public void MultiplicativeExpr() throws ParseException {
        Token t;
    UnaryExpr();
    label_13:
    while (true) {
      switch (jj_nt.kind) {
      case MOD:
      case DIV:
      case 44:
        ;
        break;
      default:
        jj_la1[40] = jj_gen;
        break label_13;
      }
      switch (jj_nt.kind) {
      case 44:
        t = jj_consume_token(44);
        break;
      case DIV:
        t = jj_consume_token(DIV);
        break;
      case MOD:
        t = jj_consume_token(MOD);
        break;
      default:
        jj_la1[41] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                        visitor.push(t.image);
      UnaryExpr();
                        visitor.evaluateMultiplicativeExpr();
    }
  }

/* [27]    UnaryExpr    ::=    UnionExpr  | '-' UnaryExpr  */
  final public void UnaryExpr() throws ParseException {
        Token t;
    switch (jj_nt.kind) {
    case SLASH:
    case SLASHSLASH:
    case VARIABLE:
    case Literal:
    case Number:
    case ID:
    case OR:
    case AND:
    case MOD:
    case DIV:
    case KEY:
    case NODE:
    case TEXT:
    case COMMENT:
    case PI:
    case AxisName:
    case NCName:
    case 36:
    case 41:
    case 42:
    case 43:
    case 44:
      UnionExpr();
      break;
    case MINUS:
      t = jj_consume_token(MINUS);
                visitor.push(t.image);
      UnaryExpr();
                visitor.evaluateUnaryExpr();
      break;
    default:
      jj_la1[42] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/*-------------*/
/* 3.6 Strings */
/*-------------*/

/*----------------------------------*/
/* 3.7 Expression Lexical Structure */
/*----------------------------------*/
/*
The following special tokenization rules must be applied in the order
specified to disambiguate the grammar:

1. If there is a preceding token and the preceding token is not one of
   @, ::, (, [, , or an Operator,
   then a * must be recognized as a MultiplyOperator and an NCName must
   be recognized as an OperatorName.

2. If the character following an NCName (possibly after intervening ExprWhitespace)
   is (, then the token must be recognized as a NodeType or a FunctionName.

3. If the two characters following an NCName (possibly after intervening ExprWhitespace)
   are ::, then the token must be recognized as an AxisName.

4. Otherwise, the token must not be recognized as a MultiplyOperator, an OperatorName,
   a NodeType, a FunctionName, or an AxisName.
*/

/*
[28]    ExprToken    ::=    '(' | ')' | '[' | ']' | '.' | '..' | '@' | ',' | '::'  
   | WildcardName  | NodeType  | Operator  | FunctionName  | AxisName  | Literal  
   | Number  | VariableReference  
*/
/* [34]    MultiplyOperator    ::=    '*'  */

/* [35]    FunctionName    ::=    QName - NodeType   */
  final public void FunctionName() throws ParseException {
    QName_Without_NodeType();
  }

/* [36]    VariableReference    ::=    '$' QName  */
  final public void VariableReference() throws ParseException {
        Token t;
    t = jj_consume_token(VARIABLE);
                visitor.push(t.image);
    QName();
                visitor.evaluateVariableReference();
  }

/* [37]    WildcardName    ::=    '*'     | NCName ':' '*'     | QName  */
  final public void WildcardName() throws ParseException {
        Token t;
    switch (jj_nt.kind) {
    case 44:
      jj_consume_token(44);
                        visitor.evaluateWildCardStar();
      break;
    default:
      jj_la1[43] = jj_gen;
      if (jj_2_7(2147483647)) {
        NCName();
        jj_consume_token(35);
        jj_consume_token(44);
                        visitor.evaluateWildCardNCName();
      } else {
        switch (jj_nt.kind) {
        case ID:
        case OR:
        case AND:
        case MOD:
        case DIV:
        case KEY:
        case NODE:
        case TEXT:
        case COMMENT:
        case PI:
        case NCName:
          QName();
                        visitor.evaluateWildCardQName();
          break;
        default:
          jj_la1[44] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
  }

/* [38]    NodeType    ::=    'comment' | 'text'  | 'processing-instruction'  | 'node'  */
  final public void NodeType() throws ParseException {
        Token t;
    switch (jj_nt.kind) {
    case TEXT:
      t = jj_consume_token(TEXT);
      break;
    case NODE:
      t = jj_consume_token(NODE);
      break;
    case COMMENT:
      t = jj_consume_token(COMMENT);
      break;
    case PI:
      t = jj_consume_token(PI);
      break;
    default:
      jj_la1[45] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                visitor.push(t.image);
  }

  final private boolean jj_2_1(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_1(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  final private boolean jj_2_2(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_2(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  final private boolean jj_2_3(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_3(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(2, xla); }
  }

  final private boolean jj_2_4(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_4(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(3, xla); }
  }

  final private boolean jj_2_5(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_5(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(4, xla); }
  }

  final private boolean jj_2_6(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_6(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(5, xla); }
  }

  final private boolean jj_2_7(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_7(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(6, xla); }
  }

  final private boolean jj_3R_37() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_47()) {
    jj_scanpos = xsp;
    if (jj_3R_48()) return true;
    }
    return false;
  }

  final private boolean jj_3R_47() {
    if (jj_scan_token(41)) return true;
    return false;
  }

  final private boolean jj_3R_38() {
    if (jj_scan_token(VARIABLE)) return true;
    if (jj_3R_49()) return true;
    return false;
  }

  final private boolean jj_3R_23() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(2)) {
    jj_scanpos = xsp;
    if (jj_scan_token(3)) return true;
    }
    if (jj_3R_15()) return true;
    return false;
  }

  final private boolean jj_3R_58() {
    if (jj_scan_token(OR)) return true;
    if (jj_3R_57()) return true;
    return false;
  }

  final private boolean jj_3_2() {
    if (jj_3R_15()) return true;
    return false;
  }

  final private boolean jj_3R_51() {
    if (jj_3R_59()) return true;
    return false;
  }

  final private boolean jj_3R_15() {
    if (jj_3R_22()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_23()) jj_scanpos = xsp;
    return false;
  }

  final private boolean jj_3R_50() {
    if (jj_3R_57()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_58()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3R_93() {
    if (jj_3R_15()) return true;
    return false;
  }

  final private boolean jj_3R_91() {
    if (jj_scan_token(SLASH)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_93()) jj_scanpos = xsp;
    return false;
  }

  final private boolean jj_3R_90() {
    if (jj_3R_92()) return true;
    return false;
  }

  final private boolean jj_3R_89() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_90()) {
    jj_scanpos = xsp;
    if (jj_3R_91()) return true;
    }
    return false;
  }

  final private boolean jj_3R_25() {
    if (jj_3R_33()) return true;
    return false;
  }

  final private boolean jj_3R_88() {
    if (jj_3R_89()) return true;
    return false;
  }

  final private boolean jj_3R_92() {
    if (jj_scan_token(SLASHSLASH)) return true;
    if (jj_3R_15()) return true;
    return false;
  }

  final private boolean jj_3R_87() {
    if (jj_3R_15()) return true;
    return false;
  }

  final private boolean jj_3R_86() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_87()) {
    jj_scanpos = xsp;
    if (jj_3R_88()) return true;
    }
    return false;
  }

  final private boolean jj_3R_84() {
    if (jj_3R_86()) return true;
    return false;
  }

  final private boolean jj_3R_17() {
    if (jj_3R_24()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_25()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3R_41() {
    if (jj_3R_39()) return true;
    return false;
  }

  final private boolean jj_3R_69() {
    if (jj_scan_token(35)) return true;
    if (jj_3R_68()) return true;
    return false;
  }

  final private boolean jj_3R_18() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(2)) {
    jj_scanpos = xsp;
    if (jj_scan_token(3)) return true;
    }
    if (jj_3R_15()) return true;
    return false;
  }

  final private boolean jj_3R_85() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(2)) {
    jj_scanpos = xsp;
    if (jj_scan_token(3)) return true;
    }
    if (jj_3R_15()) return true;
    return false;
  }

  final private boolean jj_3R_59() {
    if (jj_3R_68()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_69()) jj_scanpos = xsp;
    return false;
  }

  final private boolean jj_3R_79() {
    if (jj_scan_token(MINUS)) return true;
    if (jj_3R_76()) return true;
    return false;
  }

  final private boolean jj_3R_78() {
    if (jj_3R_80()) return true;
    return false;
  }

  final private boolean jj_3R_56() {
    if (jj_scan_token(35)) return true;
    if (jj_3R_19()) return true;
    return false;
  }

  final private boolean jj_3R_33() {
    if (jj_scan_token(39)) return true;
    if (jj_3R_41()) return true;
    if (jj_scan_token(40)) return true;
    return false;
  }

  final private boolean jj_3R_76() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_78()) {
    jj_scanpos = xsp;
    if (jj_3R_79()) return true;
    }
    return false;
  }

  final private boolean jj_3_6() {
    if (jj_3R_17()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_18()) jj_scanpos = xsp;
    return false;
  }

  final private boolean jj_3R_46() {
    if (jj_3R_55()) return true;
    return false;
  }

  final private boolean jj_3R_49() {
    if (jj_3R_19()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_56()) jj_scanpos = xsp;
    return false;
  }

  final private boolean jj_3R_83() {
    if (jj_3R_17()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_85()) jj_scanpos = xsp;
    return false;
  }

  final private boolean jj_3R_81() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_83()) {
    jj_scanpos = xsp;
    if (jj_3R_84()) return true;
    }
    return false;
  }

  final private boolean jj_3R_68() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(34)) {
    jj_scanpos = xsp;
    if (jj_scan_token(23)) {
    jj_scanpos = xsp;
    if (jj_scan_token(24)) {
    jj_scanpos = xsp;
    if (jj_scan_token(25)) {
    jj_scanpos = xsp;
    if (jj_scan_token(26)) {
    jj_scanpos = xsp;
    if (jj_scan_token(27)) {
    jj_scanpos = xsp;
    if (jj_scan_token(28)) return true;
    }
    }
    }
    }
    }
    }
    return false;
  }

  final private boolean jj_3_5() {
    if (jj_scan_token(PI)) return true;
    if (jj_scan_token(36)) return true;
    if (jj_scan_token(Literal)) return true;
    if (jj_scan_token(37)) return true;
    return false;
  }

  final private boolean jj_3R_77() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(44)) {
    jj_scanpos = xsp;
    if (jj_scan_token(27)) {
    jj_scanpos = xsp;
    if (jj_scan_token(26)) return true;
    }
    }
    if (jj_3R_76()) return true;
    return false;
  }

  final private boolean jj_3R_82() {
    if (jj_scan_token(UNION)) return true;
    if (jj_3R_81()) return true;
    return false;
  }

  final private boolean jj_3_4() {
    if (jj_3R_16()) return true;
    if (jj_scan_token(36)) return true;
    if (jj_scan_token(37)) return true;
    return false;
  }

  final private boolean jj_3R_45() {
    if (jj_scan_token(PI)) return true;
    if (jj_scan_token(36)) return true;
    if (jj_scan_token(Literal)) return true;
    if (jj_scan_token(37)) return true;
    return false;
  }

  final private boolean jj_3R_74() {
    if (jj_3R_76()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_77()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3R_80() {
    if (jj_3R_81()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_82()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3R_44() {
    if (jj_3R_16()) return true;
    if (jj_scan_token(36)) return true;
    if (jj_scan_token(37)) return true;
    return false;
  }

  final private boolean jj_3R_75() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(5)) {
    jj_scanpos = xsp;
    if (jj_scan_token(6)) return true;
    }
    if (jj_3R_74()) return true;
    return false;
  }

  final private boolean jj_3R_35() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_44()) {
    jj_scanpos = xsp;
    if (jj_3R_45()) {
    jj_scanpos = xsp;
    if (jj_3R_46()) return true;
    }
    }
    return false;
  }

  final private boolean jj_3R_60() {
    if (jj_3R_39()) return true;
    return false;
  }

  final private boolean jj_3R_61() {
    if (jj_scan_token(38)) return true;
    if (jj_3R_60()) return true;
    return false;
  }

  final private boolean jj_3R_19() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(34)) {
    jj_scanpos = xsp;
    if (jj_scan_token(23)) {
    jj_scanpos = xsp;
    if (jj_scan_token(24)) {
    jj_scanpos = xsp;
    if (jj_scan_token(25)) {
    jj_scanpos = xsp;
    if (jj_scan_token(26)) {
    jj_scanpos = xsp;
    if (jj_scan_token(27)) {
    jj_scanpos = xsp;
    if (jj_scan_token(28)) {
    jj_scanpos = xsp;
    if (jj_scan_token(29)) {
    jj_scanpos = xsp;
    if (jj_scan_token(30)) {
    jj_scanpos = xsp;
    if (jj_scan_token(31)) {
    jj_scanpos = xsp;
    if (jj_scan_token(32)) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  final private boolean jj_3R_72() {
    if (jj_3R_74()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_75()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3R_52() {
    if (jj_3R_60()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_61()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3R_53() {
    if (jj_scan_token(AxisName)) return true;
    return false;
  }

  final private boolean jj_3R_40() {
    if (jj_3R_51()) return true;
    if (jj_scan_token(36)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_52()) jj_scanpos = xsp;
    if (jj_scan_token(37)) return true;
    return false;
  }

  final private boolean jj_3R_73() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(9)) {
    jj_scanpos = xsp;
    if (jj_scan_token(11)) {
    jj_scanpos = xsp;
    if (jj_scan_token(10)) {
    jj_scanpos = xsp;
    if (jj_scan_token(12)) return true;
    }
    }
    }
    if (jj_3R_72()) return true;
    return false;
  }

  final private boolean jj_3R_21() {
    if (jj_scan_token(KEY)) return true;
    if (jj_scan_token(36)) return true;
    if (jj_scan_token(Literal)) return true;
    if (jj_scan_token(38)) return true;
    if (jj_scan_token(Literal)) return true;
    if (jj_scan_token(37)) return true;
    return false;
  }

  final private boolean jj_3R_43() {
    if (jj_3R_54()) return true;
    return false;
  }

  final private boolean jj_3R_32() {
    if (jj_3R_40()) return true;
    return false;
  }

  final private boolean jj_3R_42() {
    if (jj_3R_53()) return true;
    return false;
  }

  final private boolean jj_3R_31() {
    if (jj_scan_token(Number)) return true;
    return false;
  }

  final private boolean jj_3R_30() {
    if (jj_scan_token(Literal)) return true;
    return false;
  }

  final private boolean jj_3R_29() {
    if (jj_scan_token(36)) return true;
    if (jj_3R_39()) return true;
    if (jj_scan_token(37)) return true;
    return false;
  }

  final private boolean jj_3R_28() {
    if (jj_3R_38()) return true;
    return false;
  }

  final private boolean jj_3R_24() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_28()) {
    jj_scanpos = xsp;
    if (jj_3R_29()) {
    jj_scanpos = xsp;
    if (jj_3R_30()) {
    jj_scanpos = xsp;
    if (jj_3R_31()) {
    jj_scanpos = xsp;
    if (jj_3R_32()) return true;
    }
    }
    }
    }
    return false;
  }

  final private boolean jj_3R_34() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_42()) {
    jj_scanpos = xsp;
    if (jj_3R_43()) return true;
    }
    return false;
  }

  final private boolean jj_3R_70() {
    if (jj_3R_72()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_73()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3R_27() {
    if (jj_3R_37()) return true;
    return false;
  }

  final private boolean jj_3R_14() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_20()) {
    jj_scanpos = xsp;
    if (jj_3R_21()) return true;
    }
    return false;
  }

  final private boolean jj_3R_20() {
    if (jj_scan_token(ID)) return true;
    if (jj_scan_token(36)) return true;
    if (jj_scan_token(Literal)) return true;
    if (jj_scan_token(37)) return true;
    return false;
  }

  final private boolean jj_3_7() {
    if (jj_3R_19()) return true;
    if (jj_scan_token(35)) return true;
    if (jj_scan_token(44)) return true;
    return false;
  }

  final private boolean jj_3R_36() {
    if (jj_3R_33()) return true;
    return false;
  }

  final private boolean jj_3R_16() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(30)) {
    jj_scanpos = xsp;
    if (jj_scan_token(29)) {
    jj_scanpos = xsp;
    if (jj_scan_token(31)) {
    jj_scanpos = xsp;
    if (jj_scan_token(32)) return true;
    }
    }
    }
    return false;
  }

  final private boolean jj_3R_39() {
    if (jj_3R_50()) return true;
    return false;
  }

  final private boolean jj_3R_71() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(7)) {
    jj_scanpos = xsp;
    if (jj_scan_token(8)) return true;
    }
    if (jj_3R_70()) return true;
    return false;
  }

  final private boolean jj_3R_65() {
    if (jj_3R_49()) return true;
    return false;
  }

  final private boolean jj_3R_48() {
    if (jj_scan_token(42)) return true;
    return false;
  }

  final private boolean jj_3R_64() {
    if (jj_3R_19()) return true;
    if (jj_scan_token(35)) return true;
    if (jj_scan_token(44)) return true;
    return false;
  }

  final private boolean jj_3R_66() {
    if (jj_3R_70()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_71()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3R_55() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_63()) {
    jj_scanpos = xsp;
    if (jj_3R_64()) {
    jj_scanpos = xsp;
    if (jj_3R_65()) return true;
    }
    }
    return false;
  }

  final private boolean jj_3R_63() {
    if (jj_scan_token(44)) return true;
    return false;
  }

  final private boolean jj_3_1() {
    if (jj_3R_14()) return true;
    return false;
  }

  final private boolean jj_3R_26() {
    if (jj_3R_34()) return true;
    if (jj_3R_35()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_36()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3R_22() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_26()) {
    jj_scanpos = xsp;
    if (jj_3R_27()) return true;
    }
    return false;
  }

  final private boolean jj_3R_67() {
    if (jj_scan_token(AND)) return true;
    if (jj_3R_66()) return true;
    return false;
  }

  final private boolean jj_3R_62() {
    if (jj_scan_token(43)) return true;
    return false;
  }

  final private boolean jj_3R_54() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_62()) jj_scanpos = xsp;
    return false;
  }

  final private boolean jj_3_3() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(2)) {
    jj_scanpos = xsp;
    if (jj_scan_token(3)) return true;
    }
    if (jj_3R_15()) return true;
    return false;
  }

  final private boolean jj_3R_57() {
    if (jj_3R_66()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_67()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  public XPathParserTokenManager token_source;
  JavaCharStream jj_input_stream;
  public Token token, jj_nt;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  public boolean lookingAhead = false;
  private boolean jj_semLA;
  private int jj_gen;
  final private int[] jj_la1 = new int[46];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static {
      jj_la1_0();
      jj_la1_1();
   }
   private static void jj_la1_0() {
      jj_la1_0 = new int[] {0xff800000,0x1f800000,0x0,0x0,0x10,0xff800000,0xc,0xc,0x8,0xff800008,0xff80000c,0x10800000,0xc,0xc,0x0,0xff80000c,0xc,0xc,0x0,0xff800000,0x0,0xff800000,0x0,0x0,0x1f816000,0x0,0xff81604c,0x10,0xc,0xc,0xff80000c,0x0,0x1000000,0x2000000,0x180,0x180,0x1e00,0x1e00,0x60,0x60,0xc000000,0xc000000,0xff81604c,0x0,0xff800000,0xe0000000,};
   }
   private static void jj_la1_1() {
      jj_la1_1 = new int[] {0x5,0x4,0x8,0x8,0x0,0x1805,0x0,0x0,0x0,0x1805,0x1805,0x0,0x0,0x0,0x80,0x1e07,0x0,0x0,0x80,0x1e07,0x2,0x1005,0x600,0x800,0x14,0x40,0x1e17,0x0,0x0,0x0,0x1e07,0x80,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1000,0x1000,0x1e17,0x1000,0x5,0x1,};
   }
  final private JJCalls[] jj_2_rtns = new JJCalls[7];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  public XPathParser(java.io.InputStream stream) {
    jj_input_stream = new JavaCharStream(stream, 1, 1);
    token_source = new XPathParserTokenManager(jj_input_stream);
    token = new Token();
    token.next = jj_nt = token_source.getNextToken();
    jj_gen = 0;
    for (int i = 0; i < 46; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(java.io.InputStream stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    token.next = jj_nt = token_source.getNextToken();
    jj_gen = 0;
    for (int i = 0; i < 46; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public XPathParser(java.io.Reader stream) {
    jj_input_stream = new JavaCharStream(stream, 1, 1);
    token_source = new XPathParserTokenManager(jj_input_stream);
    token = new Token();
    token.next = jj_nt = token_source.getNextToken();
    jj_gen = 0;
    for (int i = 0; i < 46; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    token.next = jj_nt = token_source.getNextToken();
    jj_gen = 0;
    for (int i = 0; i < 46; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public XPathParser(XPathParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    token.next = jj_nt = token_source.getNextToken();
    jj_gen = 0;
    for (int i = 0; i < 46; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(XPathParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    token.next = jj_nt = token_source.getNextToken();
    jj_gen = 0;
    for (int i = 0; i < 46; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  final private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken = token;
    if ((token = jj_nt).next != null) jj_nt = jj_nt.next;
    else jj_nt = jj_nt.next = token_source.getNextToken();
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen) c.first = null;
            c = c.next;
          }
        }
      }
      return token;
    }
    jj_nt = token;
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  static private final class LookaheadSuccess extends java.lang.Error { }
  final private LookaheadSuccess jj_ls = new LookaheadSuccess();
  final private boolean jj_scan_token(int kind) {
    if (jj_scanpos == jj_lastpos) {
      jj_la--;
      if (jj_scanpos.next == null) {
        jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
      } else {
        jj_lastpos = jj_scanpos = jj_scanpos.next;
      }
    } else {
      jj_scanpos = jj_scanpos.next;
    }
    if (jj_rescan) {
      int i = 0; Token tok = token;
      while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
      if (tok != null) jj_add_error_token(kind, i);
    }
    if (jj_scanpos.kind != kind) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
    return false;
  }

  final public Token getNextToken() {
    if ((token = jj_nt).next != null) jj_nt = jj_nt.next;
    else jj_nt = jj_nt.next = token_source.getNextToken();
    jj_gen++;
    return token;
  }

  final public Token getToken(int index) {
    Token t = lookingAhead ? jj_scanpos : token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  private java.util.Vector jj_expentries = new java.util.Vector();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
    if (pos >= 100) return;
    if (pos == jj_endpos + 1) {
      jj_lasttokens[jj_endpos++] = kind;
    } else if (jj_endpos != 0) {
      jj_expentry = new int[jj_endpos];
      for (int i = 0; i < jj_endpos; i++) {
        jj_expentry[i] = jj_lasttokens[i];
      }
      boolean exists = false;
      for (java.util.Enumeration e = jj_expentries.elements(); e.hasMoreElements();) {
        int[] oldentry = (int[])(e.nextElement());
        if (oldentry.length == jj_expentry.length) {
          exists = true;
          for (int i = 0; i < jj_expentry.length; i++) {
            if (oldentry[i] != jj_expentry[i]) {
              exists = false;
              break;
            }
          }
          if (exists) break;
        }
      }
      if (!exists) jj_expentries.addElement(jj_expentry);
      if (pos != 0) jj_lasttokens[(jj_endpos = pos) - 1] = kind;
    }
  }

  public ParseException generateParseException() {
    jj_expentries.removeAllElements();
    boolean[] la1tokens = new boolean[45];
    for (int i = 0; i < 45; i++) {
      la1tokens[i] = false;
    }
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 46; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 45; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.addElement(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = (int[])jj_expentries.elementAt(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  final public void enable_tracing() {
  }

  final public void disable_tracing() {
  }

  final private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 7; i++) {
      JJCalls p = jj_2_rtns[i];
      do {
        if (p.gen > jj_gen) {
          jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
          switch (i) {
            case 0: jj_3_1(); break;
            case 1: jj_3_2(); break;
            case 2: jj_3_3(); break;
            case 3: jj_3_4(); break;
            case 4: jj_3_5(); break;
            case 5: jj_3_6(); break;
            case 6: jj_3_7(); break;
          }
        }
        p = p.next;
      } while (p != null);
    }
    jj_rescan = false;
  }

  final private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) { p = p.next = new JJCalls(); break; }
      p = p.next;
    }
    p.gen = jj_gen + xla - jj_la; p.first = token; p.arg = xla;
  }

  static final class JJCalls {
    int gen;
    Token first;
    int arg;
    JJCalls next;
  }

        }
