/*******************************************************************************
 * Copyright (c) 2005-2006 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Sybase, Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.soas.internal.deploy.emf.refactoring;

import java.util.List;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

/**
 * Use for references stored as workspace relative paths in string objects.
 * 
 * @author rcernich
 * 
 * Created on Sep 28, 2005
 */
public class WorkspaceRelativeNameChangeExtension implements
		IReferenceNameChangeExtension {

	private EStructuralFeature mFeature;

	public WorkspaceRelativeNameChangeExtension(EStructuralFeature feature) {
		super();
		mFeature = feature;
	}

	public EStructuralFeature getFeature() {
		return mFeature;
	}

	public IResource getReferencedResource(EObject object, Object referenceValue) {
		if (referenceValue == null) {
			return null;
		}
		IResource resource = null;
		try {
			resource = ResourcesPlugin.getWorkspace().getRoot().getFile(
					new Path((String) referenceValue));
		}
		catch (Exception e) {
			return null;
		}
		return resource;
	}

	public void updateReference(EObject object, IResourceDelta delta) {
		if (mFeature.isMany()) {
			List list = (List) object.eGet(mFeature);
			int index = list.indexOf(delta.getResource().getFullPath()
					.toString());
			if (index < 0) {
				// RJC: TODO: might want to log something
				return;
			}
			list.set(index, delta.getMovedToPath().toString());
		}
		else {
			object.eSet(mFeature, delta.getMovedToPath().toString());
		}
	}
}