/*******************************************************************************

* Copyright (c) 2006 IONA Technologies PLC

* All rights reserved. This program and the accompanying materials

* are made available under the terms of the Eclipse Public License v1.0

* which accompanies this distribution, and is available at

* http://www.eclipse.org/legal/epl-v10.html

* 

* Contributors:

*     IONA Technologies PLC - initial API and implementation

*******************************************************************************/
package org.eclipse.stp.sc.xmlvalidator.classbuilder;

import java.lang.reflect.Modifier;
import java.util.ArrayList;

/**
 * @author jma
 *
 */

public class JClass extends JMember{
    ArrayList<JField> fields = new ArrayList<JField>();
    ArrayList<JMethod> methods = new ArrayList<JMethod>();
    ArrayList<JMethod> constructors = new ArrayList<JMethod>();
    JConstantPool pool = new JConstantPool();
    String superClass ;
    
    public JClass(String name) {
    	this(name, "java.lang.Object");
    }
    
    public JClass(String name, String superCls) {
    	this(name, superCls, Modifier.PUBLIC);
    }
    
    public JClass(String name, int modifiers) {
    	this(name, "java.lang.Object", modifiers);
    }
    
    public JClass(String name, String superCls, int modifiers) {
    	super(name, modifiers);
    	superClass = superCls;
    }
    
    
    public void setSuperClass(String clsName) {
    	superClass = clsName;
    }
    
    public String getSuperClass() {
    	return superClass;
    }
    
    public ArrayList<JField> getFields() {
    	return fields;
    }
    
    public void addField(JField field) {
    	fields.add(field);
    }
    
    public ArrayList getMethods() {
    	return methods;
    }
    
    public void addMethod(JMethod method) {
    	methods.add(method);
    }

    public void accept(JVisitor visitor) throws Exception {
    	//set constant pool
    	visitor.setConstantPool(this.pool);
        for (JField field: fields) {
    		field.accept(visitor);
    	}
        
        for (JMethod constructor: constructors) {
    		constructor.accept(visitor);
    	}
        for (JMethod method: methods) {
    		method.accept(visitor);
    	}
        //pool.accept(visitor);
        visitor.visitClass(this);
        
    }
    
    public String toString() {
    	StringBuffer sb = new StringBuffer();
    	if (Modifier.isInterface(this.getModifiers())) {
    		sb.append("Interface ");
    	} else {
    		sb.append("Class ");
    	}
    	sb.append(name + " extends " + superClass + LINE_END);
    	for (JField field: fields) {
    		sb.append(field.toString());
    	}
    	
    	for (JMethod constructor: constructors) {
    		sb.append(constructor.toString());
    	}
    	
    	for (JMethod method: methods) {
    		sb.append(method.toString());
    	}
    	
    	
    	return sb.toString();
    }
    
}
