/*******************************************************************************

* Copyright (c) 2006 IONA Technologies PLC

* All rights reserved. This program and the accompanying materials

* are made available under the terms of the Eclipse Public License v1.0

* which accompanies this distribution, and is available at

* http://www.eclipse.org/legal/epl-v10.html

* 

* Contributors:

*     IONA Technologies PLC - initial API and implementation

*******************************************************************************/
package org.eclipse.stp.sc.xmlvalidator.rule.model;

import java.util.ArrayList;

import org.eclipse.core.resources.IMarker;

/**
 * @author jma
 * This class is used to represent one validating rule definition in rule files.
 *
 */
public class VRuleDef {
	public enum SEVERITY {
		ERROR,
		INFO,
		WARNING
	};
	/**
	 * the rule id
	 */
	String id;
	
	/**
	 * the rule description
	 */
	String description;
	
	
	/**
	 * 
	 */
	String contextNode;
	
	boolean enabled = true;
	
	SEVERITY severity = SEVERITY.ERROR;
	
	
	ArrayList<VRuleAssert> assertList = new ArrayList<VRuleAssert>();
	
	
	public VRuleDef() {
		
	}
	
	public VRuleDef(String idVal) {
		id = idVal;
	}
	
	
	public int hashCode() {
		return id.hashCode();
	}

	public String getContextNode() {
		return contextNode;
	}

	public void setContextNode(String contextNode) {
		this.contextNode = contextNode;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}




	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}
	
	
	public SEVERITY getSeverity() {
		return severity;
	}

	public void setSeverity(SEVERITY s) {
		this.severity = s;
	}
	
	public boolean getEnabled() {
		return enabled;
	}

	public void setEnabled(boolean b) {
		this.enabled = b;
	}
	
	public void addRuleAssert(VRuleAssert ruleAssert) {
		assertList.add(ruleAssert);
	}
	
	public ArrayList<VRuleAssert> getAssertList() {
		return assertList;
	}
	
	public String toString() {
		StringBuffer sb = new StringBuffer();
		sb.append("[rule]id:" + id + " desc:" + description);
		sb.append(" context:" + contextNode);
		for (VRuleAssert ruleAssert: assertList) {
			sb.append(ruleAssert.toString());	
		}
		
		return sb.toString();
	}
	
	public boolean equals(Object obj) {
		VRuleDef def = (VRuleDef)obj;
		if (!def.id.equals(id)) {
			return false;
		}
		return true;
	}
	
	public int getSeverityAsInt() {
	    if (severity == SEVERITY.ERROR) {
	    	return IMarker.SEVERITY_ERROR;
	    } else if (severity == SEVERITY.WARNING) {
	        return IMarker.SEVERITY_WARNING;	
	    } else {
	    	return IMarker.SEVERITY_INFO;
	    }
	}
}
