/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.b2j.core.jengine.internal.compiler.xmlns;

import java.util.HashMap;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.Util;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.xmlns.NamespaceException;
import org.eclipse.stp.b2j.core.jengine.internal.utils.FStack;
import org.eclipse.stp.b2j.core.xml.internal.w3c.Element;
import org.eclipse.stp.b2j.core.xml.internal.w3c.NamedNodeMap;
import org.eclipse.stp.b2j.core.xml.internal.w3c.Node;

public class NamespaceTranslator {
    private static final boolean USE_PREFIX = true;
    public static final String NAMESPACE_XSD = "http://www.w3.org/2001/XMLSchema";
    public static final String NAMESPACE_XSI = "http://www.w3.org/2001/XMLSchema-instance";
    public static final String NAMESPACE_WSDL = "http://schemas.xmlsoap.org/wsdl/";
    public static final String NAMESPACE_BPEL = "http://schemas.xmlsoap.org/ws/2004/03/business-process/";
    public static final String NAMESPACE_WSA = "http://schemas.xmlsoap.org/ws/2004/03/addressing";
    public static final String NAMESPACE_ENGINE = "http://www.eclipse.org/stp/b2j/2006/02";
    private String PACKAGE_XSD = "error.xsd.package.not.set";
    private static final String DEFAULT_PREFIX = "XSD_DEFAULT_";
    private static final String TAGNAME_PREFIX = "XSD_TAG_";
    private static final String ATTRIBUTE_PREFIX = "XSD_ATTR_";
    private static final String ELEMENT_PREFIX = "XSD_ELEM_";
    private static final String CLASS_PREFIX = "_";
    private static NamespaceMapping NSMAPPING_DEFAULT = new NamespaceMapping("", "xmlns.defaultns");
    private static NamespaceMapping NSMAPPING_XSD = new NamespaceMapping("http://www.w3.org/2001/XMLSchema", NamespaceTranslator.namespaceToPackage("http://www.w3.org/2001/XMLSchema"));
    public String PROGRAM_PREFIX = "";
    NamespaceStack targetNamespaces = new NamespaceStack();
    NamespaceStack defaultNamespaces = new NamespaceStack();
    HashMap mappings = new HashMap();
    Util util;

    private void pushNamespace(String key, NamespaceMapping ns) {
        NamespaceStack stack = (NamespaceStack)this.mappings.get(key);
        if (stack == null) {
            stack = new NamespaceStack();
            this.mappings.put(key, stack);
        }
        stack.push(ns);
    }

    private NamespaceMapping fetchNamespace(String key) throws NamespaceException {
        NamespaceStack stack = (NamespaceStack)this.mappings.get(key);
        if (stack == null) {
            throw new NamespaceException("Asked to fetch namespace " + key + " but namespace not found");
        }
        if (stack.size() == 0) {
            throw new NamespaceException("Asked to fetch namespace " + key + " but namespace not found (declared out of scope?)");
        }
        return (NamespaceMapping)stack.peek();
    }

    private void popNamespace(String key) {
        NamespaceStack stack = (NamespaceStack)this.mappings.get(key);
        stack.pop();
    }

    public NamespaceTranslator(String program_prefix) {
        this.PROGRAM_PREFIX = program_prefix;
        this.targetNamespaces.push(NSMAPPING_DEFAULT);
        this.defaultNamespaces.push(NSMAPPING_DEFAULT);
        NamespaceStack stack = new NamespaceStack();
        this.mappings.put("xsd", stack);
        stack.push(NSMAPPING_XSD);
        try {
            this.PACKAGE_XSD = this.getPackage("xsd:faketagname", false);
        }
        catch (NamespaceException namespaceException) {
            throw new Error("Incurred namespace exception while generating XSD package");
        }
    }

    public NamespaceTranslator(String program_prefix, Util compiler_util) {
        this(program_prefix);
        this.util = compiler_util;
    }

    public static String getAttribute(String attr_name) {
        return ATTRIBUTE_PREFIX + attr_name;
    }

    public static String getDefaultElement(String elem_name) {
        return DEFAULT_PREFIX + elem_name;
    }

    public static String getElement(String elem_name) {
        return ELEMENT_PREFIX + elem_name;
    }

    public static String getElementTagName() {
        return "XSD_TAG_name";
    }

    public static String getRealName(String name) {
        if (name.startsWith(ELEMENT_PREFIX)) {
            return name.substring(ELEMENT_PREFIX.length());
        }
        if (name.startsWith(ATTRIBUTE_PREFIX)) {
            return name.substring(ATTRIBUTE_PREFIX.length());
        }
        if (name.startsWith(DEFAULT_PREFIX)) {
            return name.substring(DEFAULT_PREFIX.length());
        }
        return name;
    }

    public String getXSDPackage() {
        return this.PACKAGE_XSD;
    }

    public boolean addNamespace(String attname, String value) {
        return this.doNamespace(attname, value, true);
    }

    public boolean removeNamespace(String attname, String value) {
        return this.doNamespace(attname, value, false);
    }

    public void addNamespaces(Element elem) {
        this.doNamespaces(elem.getAttributes(), true);
    }

    public void removeNamespaces(Element elem) {
        this.doNamespaces(elem.getAttributes(), false);
    }

    private boolean doNamespace(String name, String value, boolean add) {
        if (name.equals("xmlns")) {
            if (add) {
                NamespaceMapping ns = new NamespaceMapping(value, NamespaceTranslator.namespaceToPackage(value));
                this.defaultNamespaces.push(ns);
            } else {
                this.defaultNamespaces.pop();
            }
            return true;
        }
        if (name.startsWith("xmlns:")) {
            name = name.substring(6);
            if (add) {
                NamespaceMapping ns = new NamespaceMapping(value, NamespaceTranslator.namespaceToPackage(value));
                this.pushNamespace(name, ns);
            } else {
                this.popNamespace(name);
            }
            return true;
        }
        if (name.equals("targetNamespace")) {
            if (add) {
                NamespaceMapping ns = new NamespaceMapping(value, NamespaceTranslator.namespaceToPackage(value));
                this.targetNamespaces.push(ns);
            } else {
                this.targetNamespaces.pop();
            }
            return true;
        }
        return false;
    }

    private void doNamespaces(NamedNodeMap map, boolean add) {
        int i = 0;
        while (i < map.getLength()) {
            Node attribute = map.item(i);
            if (attribute.getNodeType() == Node.ATTRIBUTE_NODE) {
                String name = attribute.getNodeName();
                String value = attribute.getNodeValue();
                this.doNamespace(name, value, add);
            }
            ++i;
        }
    }

    private static String namespaceToPackage(String name) {
        StringBuffer ns = new StringBuffer("xmlns.");
        name = name.toLowerCase();
        int i = 0;
        while (i < name.length()) {
            char c = name.charAt(i);
            if (c == '/') {
                ns.append(CLASS_PREFIX);
            } else if (c == '.') {
                ns.append(CLASS_PREFIX);
            } else if (c == ':') {
                ns.append(CLASS_PREFIX);
            } else if (c == '-') {
                ns.append(CLASS_PREFIX);
            } else if (c == '@') {
                ns.append(CLASS_PREFIX);
            } else if (c == '#') {
                ns.append(CLASS_PREFIX);
            } else {
                ns.append(c);
            }
            ++i;
        }
        return ns.toString();
    }

    public static String getJavaClassName(String s) {
        return CLASS_PREFIX + NamespaceTranslator.getName(s);
    }

    public static String getName(String name) {
        int index = name.indexOf(":");
        if (index == -1) {
            return name;
        }
        return name.substring(index + 1);
    }

    public static String getName(Element e) {
        return NamespaceTranslator.getName(e.getTagName());
    }

    public boolean checkQName(Element elem, String xmlnamespace, String ncname) throws NamespaceException {
        String namespace;
        String name = NamespaceTranslator.getName(elem);
        return name.equals(ncname) && (namespace = this.getNamespace(elem, false)).equals(xmlnamespace);
    }

    public boolean checkQName(String qname, String xmlnamespace, String ncname) throws NamespaceException {
        String namespace;
        String name = NamespaceTranslator.getName(qname);
        return name.equals(ncname) && (namespace = this.getNamespace(qname, false)).equals(xmlnamespace);
    }

    public String getNamespace(String name, boolean target) throws NamespaceException {
        int index = name.indexOf(":");
        if (index == -1) {
            if (target) {
                NamespaceMapping ns = (NamespaceMapping)this.targetNamespaces.peek();
                return ns.xml_namespace;
            }
            NamespaceMapping ns = (NamespaceMapping)this.defaultNamespaces.peek();
            return ns.xml_namespace;
        }
        String key = name.substring(0, index);
        NamespaceMapping ns = this.fetchNamespace(key);
        if (ns == null) {
            throw new NamespaceException("Namespace not found \"" + key + "\"");
        }
        return ns.xml_namespace;
    }

    public String getNamespace(Element e, boolean target) throws NamespaceException {
        return this.getNamespace(e.getTagName(), target);
    }

    public String getPackage(String name, boolean target) throws NamespaceException {
        int index = name.indexOf(":");
        if (index == -1) {
            if (target) {
                NamespaceMapping ns = (NamespaceMapping)this.targetNamespaces.peek();
                return String.valueOf(this.PROGRAM_PREFIX) + ns.java_namespace;
            }
            NamespaceMapping ns = (NamespaceMapping)this.defaultNamespaces.peek();
            return String.valueOf(this.PROGRAM_PREFIX) + ns.java_namespace;
        }
        String key = name.substring(0, index);
        NamespaceMapping ns = this.fetchNamespace(key);
        return String.valueOf(this.PROGRAM_PREFIX) + ns.java_namespace;
    }

    public String getPackage(Element e, boolean target) throws NamespaceException {
        return this.getPackage(e.getTagName(), target);
    }

    public String qualify(String name, boolean target) throws NamespaceException {
        name.indexOf(":");
        String pkg = this.getPackage(name, target);
        String nm = NamespaceTranslator.getName(name);
        String qname = String.valueOf(pkg) + "." + CLASS_PREFIX + nm;
        if (this.util != null) {
            this.util.addJavaQNameMapping(qname, this.getNamespace(name, target), nm);
        }
        String qbase = null;
        if (this.util != null) {
            qbase = this.util.getXsdTypeDirectAlias(qname);
        }
        if (qbase != null) {
            return qbase;
        }
        return qname;
    }

    static class NamespaceMapping {
        String xml_namespace;
        String java_namespace;

        public NamespaceMapping() {
        }

        public NamespaceMapping(String xmlns, String javans) {
            this.xml_namespace = xmlns;
            this.java_namespace = javans;
        }
    }

    class NamespaceStack
    extends FStack {
        NamespaceStack() {
        }
    }
}

