/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.b2j.core.jengine.internal.mainengine;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.BindException;
import java.net.InetAddress;
import java.net.URL;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Vector;
import org.eclipse.stp.b2j.core.jengine.internal.Version;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.Switches;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.Util;
import org.eclipse.stp.b2j.core.jengine.internal.core.bpel.WSEndpointReference;
import org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.soap.SOAPFactory;
import org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.soap.SOAPServerTransportListener;
import org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.soap.SOAPUtils;
import org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.soap.http.HTTPException;
import org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.soap.http.HTTPNotFoundException;
import org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.soap.http.HTTPServer;
import org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.soap.http.HTTPServerListener;
import org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.soap.http.HTTPUtils;
import org.eclipse.stp.b2j.core.jengine.internal.mainengine.Controller;
import org.eclipse.stp.b2j.core.jengine.internal.mainengine.SoapDaemonUtils;
import org.eclipse.stp.b2j.core.jengine.internal.mainengine.SubController;
import org.eclipse.stp.b2j.core.jengine.internal.message.Message;
import org.eclipse.stp.b2j.core.jengine.internal.message.MessageUtils;
import org.eclipse.stp.b2j.core.jengine.internal.utils.GCThread;
import org.eclipse.stp.b2j.core.jengine.internal.utils.Logger;
import org.eclipse.stp.b2j.core.jengine.internal.utils.VMFork;
import org.eclipse.stp.b2j.core.misc.internal.HexData;
import org.eclipse.stp.b2j.core.publicapi.B2jConfig;
import org.eclipse.stp.b2j.core.publicapi.B2jPlatform;
import org.eclipse.stp.b2j.core.publicapi.JARDependency;
import org.eclipse.stp.b2j.core.publicapi.transport.session.SessionAddress;
import org.eclipse.stp.b2j.core.xml.internal.w3c.Element;

public class SoapDaemon
extends Thread
implements SOAPServerTransportListener,
HTTPServerListener {
    private Object TRANSACTION_LOCK = new Object();
    public static String STDOUT_LOGFILE = null;
    public static FileOutputStream stdlog = null;
    public static boolean FORK_PROCESSES = true;
    public static int DAEMON_PORT = 11000;
    private static boolean USE_SSL = false;
    private static boolean HAS_PASSWORD = false;
    private static String PASSWORD = "password";
    public static boolean SOAP_HTTP_PROXY_ON = false;
    public static String SOAP_HTTP_PROXY_HOST = "";
    public static int SOAP_HTTP_PROXY_PORT = 8080;
    public static boolean SOAP_HTTPS_PROXY_ON = false;
    public static String SOAP_HTTPS_PROXY_HOST = "";
    public static int SOAP_HTTPS_PROXY_PORT = 8080;
    public static String[] SOAP_PROXY_EXCLUDED_HOSTS = new String[0];
    public static final String SOAPACTION_CREATE_CONTROLLER = "Daemon/CreateController";
    public static final String SOAPACTION_CREATE_SUBCONTROLLER = "Daemon/CreateSubcontroller";
    public static final String SOAPACTION_GET_VERSION = "Daemon/GetVersion";
    public static final String SOAPACTION_SUPPORTS_VERSION = "Daemon/SupportsVersion";
    public static final String SOAPACTION_ADD_VERSION = "Daemon/AddVersion";
    public static final String SOAPACTION_LIST_ENGINES = "Daemon/ListEngines";
    public static final String SOAPACTION_KILL_ENGINE = "Daemon/TerminateEngine";
    static Object VERSIONS_LOCK = new Object();
    static String VERSION_PREFIX = "b2j";
    static ArrayList version_jars = new ArrayList();
    static ArrayList version_tmp_jars = new ArrayList();
    static Object CONF_LOCK = new Object();
    static long last_loaded = -1L;
    Object LIVE_PROCESSES_LOCK = new Object();
    long live_process_id = 0L;
    Vector live_processes = new Vector(1, 1);
    WSEndpointReference epr;
    WSEndpointReference daemon_service_epr;
    int port = DAEMON_PORT;
    static String dprefix = "(DAEMON)";
    private SecureRandom sr = new SecureRandom();
    static String java_exe;
    static String java_cp;
    static ArrayList java_extrajars;
    static String[] java_vmargs;
    int jvm_count = 0;
    static String cd;
    static String basejar;

    static {
        cd = null;
        basejar = null;
    }

    private SoapDaemon(String[] args) {
        cd = "." + File.separatorChar;
        basejar = String.valueOf(cd) + "b2j.jar";
        try {
            Runtime.getRuntime().addShutdownHook(new ProcessKillerThread());
            try {
                SoapDaemon.loadProperties();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.port = DAEMON_PORT;
            this.start_socket();
            this.run();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        try {
            Thread.sleep(4000L);
        }
        catch (Exception exception) {}
    }

    public SoapDaemon(File enginedir, File base_jar, int port) {
        cd = enginedir.getAbsolutePath();
        if (!cd.endsWith(File.separator)) {
            cd = String.valueOf(cd) + File.separator;
        }
        basejar = base_jar.getAbsolutePath();
        try {
            Runtime.getRuntime().addShutdownHook(new ProcessKillerThread());
            try {
                SoapDaemon.loadProperties();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.port = port;
            this.start_socket();
            this.start();
            Thread.sleep(1000L);
        }
        catch (BindException bindException) {
            Logger.direct(String.valueOf(dprefix) + "Daemon could not start - something already bound to socket " + port);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void killEngines() {
        new ProcessKillerThread().run();
    }

    private String[] filterEmpties(String[] commands) {
        int count = 0;
        int i = 0;
        while (i < commands.length) {
            if (commands[i] == null) {
                ++count;
            } else if (commands[i].length() == 0) {
                ++count;
            }
            ++i;
        }
        String[] tmp = new String[commands.length - count];
        int index = 0;
        int i2 = 0;
        while (i2 < commands.length) {
            if (commands[i2] != null && commands[i2].length() > 0) {
                tmp[index++] = commands[i2];
            }
            ++i2;
        }
        return tmp;
    }

    private Process forkJVMAsCommand(String[] vmargs, String classpath, String classname, String[] args, String[] jars, StringBuffer cmdline) throws Exception {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(java_exe);
        commands.add(java_cp);
        StringBuffer sb = new StringBuffer();
        String sep = System.getProperty("path.separator");
        sb.append(classpath).append(sep);
        int i = 0;
        while (i < jars.length) {
            sb.append(jars[i]).append(sep);
            ++i;
        }
        commands.add(sb.toString());
        i = 0;
        while (i < vmargs.length) {
            commands.add(vmargs[i]);
            ++i;
        }
        commands.add(classname);
        i = 0;
        while (i < args.length) {
            commands.add(args[i]);
            ++i;
        }
        String[] fork_exe = new String[commands.size()];
        commands.toArray(fork_exe);
        Runtime r = Runtime.getRuntime();
        Logger.info(String.valueOf(dprefix) + "Launching engine component");
        fork_exe = this.filterEmpties(fork_exe);
        System.gc();
        int i2 = 0;
        while (i2 < fork_exe.length) {
            Logger.info(String.valueOf(dprefix) + "arg " + i2 + ": " + fork_exe[i2]);
            cmdline.append("[" + fork_exe[i2] + "]");
            ++i2;
        }
        Process p = r.exec(fork_exe, null, new File(cd));
        return p;
    }

    private Process forkJVMAsVMFork(String[] vmargs, String classpath, String classname, String[] args, String[] jars, StringBuffer cmdline) throws Exception {
        VMFork vmfork = new VMFork(classname, args, new File(cd));
        vmfork.setVMSpecificArgs(vmargs);
        vmfork.setBaseClasspath(new String[]{classpath});
        String[] tmp = new String[jars.length + java_extrajars.size()];
        System.arraycopy(jars, 0, tmp, 0, jars.length);
        int i = 0;
        while (i < java_extrajars.size()) {
            tmp[jars.length + i] = (String)java_extrajars.get(i);
            ++i;
        }
        jars = tmp;
        vmfork.setClasspathExtras(jars);
        cmdline.append("[(VMFork java?)]");
        i = 0;
        while (i < vmargs.length) {
            cmdline.append("[" + vmargs[i] + "]");
            ++i;
        }
        cmdline.append("[(VMFork -cp?)]");
        cmdline.append("[");
        cmdline.append(classpath);
        cmdline.append(System.getProperty("path.separator"));
        i = 0;
        while (i < jars.length) {
            cmdline.append(jars[i]);
            cmdline.append(System.getProperty("path.separator"));
            ++i;
        }
        cmdline.append("]");
        cmdline.append("[" + classname + "]");
        i = 0;
        while (i < args.length) {
            cmdline.append("[" + args[i] + "]");
            ++i;
        }
        Process p = vmfork.fork();
        System.gc();
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SessionAddress forkJVM(String[] vmargs, String classpath, String classname, String[] classargs, JARDependency[] deps, Message deps_msg, String desc, String req_address_hex, String description) throws Exception {
        int depsize;
        String deps_hex;
        System.gc();
        StringBuffer sb = new StringBuffer();
        String[] dependencies = new String[deps.length + java_extrajars.size()];
        int i = 0;
        while (i < deps.length) {
            JARDependency.writeTemporaryDependency(deps[i]);
            dependencies[i] = deps[i].getFilePath();
            ++i;
        }
        i = 0;
        while (i < java_extrajars.size()) {
            dependencies[i + deps.length] = (String)java_extrajars.get(i);
            ++i;
        }
        if (java_vmargs.length > 0) {
            vmargs = new String[java_vmargs.length];
            i = 0;
            while (i < java_vmargs.length) {
                String s = java_vmargs[i];
                int index = s.indexOf("$TIME");
                vmargs[i] = index != -1 ? String.valueOf(s.substring(0, index)) + System.currentTimeMillis() + s.substring(index + 5) : s;
                ++i;
            }
        }
        Process p = java_exe == null ? this.forkJVMAsVMFork(vmargs, classpath, classname, classargs, dependencies, sb) : this.forkJVMAsCommand(vmargs, classpath, classname, classargs, dependencies, sb);
        BufferedReader bread = new BufferedReader(new InputStreamReader(p.getInputStream()));
        BufferedReader eread = new BufferedReader(new InputStreamReader(p.getErrorStream()));
        PrintStream pout = new PrintStream(p.getOutputStream());
        pout.println(req_address_hex);
        pout.flush();
        Logger.info(String.valueOf(dprefix) + "wrote address " + req_address_hex);
        if (deps_msg != null) {
            deps_hex = HexData.byteArrayToHexString(MessageUtils.messageToBytes(deps_msg));
            depsize = deps_hex.length() / 2 / 1024;
            Logger.info(String.valueOf(dprefix) + "writing " + depsize + "k of JAR dependencies");
            pout.println(deps_hex);
            pout.flush();
        } else {
            deps_hex = HexData.byteArrayToHexString(MessageUtils.messageToBytes(new Message()));
            depsize = deps_hex.length() / 2 / 1024;
            Logger.info(String.valueOf(dprefix) + "writing " + depsize + "k of JAR dependencies");
            pout.println(deps_hex);
            pout.flush();
        }
        Logger.info(String.valueOf(dprefix) + "wrote JAR dependencies");
        pout.println(classpath);
        pout.flush();
        Logger.info(String.valueOf(dprefix) + "waiting for actual address");
        String act_address = bread.readLine();
        if (act_address == null) {
            try {
                throw new Exception("Daemon started engine but it terminated unexpectedly with exit code " + p.exitValue());
            }
            catch (Exception exception) {
                InstanceReader br = new InstanceReader("FAILED PROCESS(" + desc + "):", bread);
                br.start();
                InstanceReader er = new InstanceReader("FAILED PROCESS(" + desc + "):", eread);
                er.start();
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception2) {}
                throw new Exception("Expected port number for engine process but got '" + br.info + "' / '" + er.info + "', command was " + sb);
            }
        }
        SessionAddress actual_address = null;
        try {
            actual_address = SessionAddress.fromString(HexData.hexStringToString(act_address.trim()));
        }
        catch (Exception exception) {
            throw new Exception("Expected SessionAddress of bound controller/subcontroller but received: " + act_address.trim());
        }
        Logger.info(String.valueOf(dprefix) + "Got back address of component: " + actual_address);
        long instance_time = System.currentTimeMillis();
        String prefix = String.valueOf(this.jvm_count) + "-" + instance_time;
        ++this.jvm_count;
        InstanceReader nr = new InstanceReader(String.valueOf(prefix) + "(" + desc + "):", bread);
        nr.start();
        nr = new InstanceReader(String.valueOf(prefix) + "(" + desc + "):", eread);
        nr.start();
        JEngineProcess jp = new JEngineProcess(p, prefix, classname, description);
        Object object = this.LIVE_PROCESSES_LOCK;
        synchronized (object) {
            long jpid = ++this.live_process_id;
            jp.setId(jpid);
            this.live_processes.add(jp);
        }
        System.gc();
        InstanceTracker tr = new InstanceTracker(String.valueOf(prefix) + ":", jp);
        tr.start();
        System.gc();
        return actual_address;
    }

    private SessionAddress forkController(int id, SessionAddress address, Message versions, JARDependency[] deps, Message deps_msg, String description) throws Exception {
        String jarpath = SoapDaemon.getVersion(versions);
        if (jarpath == null) {
            throw new Exception("Unsupported version - " + Version.toString(versions));
        }
        if (!FORK_PROCESSES) {
            if (!versions.equals(Version.getVersion())) {
                throw new Exception("Disallowing fork means controller version not available - " + Version.toString(versions) + " (only " + Version.getVersionAsString() + ")");
            }
            Controller c = new Controller(address, id, deps_msg, jarpath);
            return c.getAddress();
        }
        String[] vmargs = new String[]{"-Xmx128m"};
        String classname = "org.eclipse.stp.b2j.core.jengine.internal.mainengine.Controller";
        String[] args = new String[]{"" + id};
        if (HAS_PASSWORD) {
            address.setRequiresPassword(true);
            address.setPassword(String.valueOf(this.sr.nextLong()) + "_" + this.sr.nextLong() + "_" + this.sr.nextLong());
        }
        return this.forkJVM(vmargs, jarpath, classname, args, deps, deps_msg, "Controller", HexData.stringToHexString(SessionAddress.toString(address)), description);
    }

    private SessionAddress forkSubController(int id, SessionAddress address, Message versions, JARDependency[] deps, Message deps_msg) throws Exception {
        String jarpath = SoapDaemon.getVersion(versions);
        if (jarpath == null) {
            throw new Exception("Unsupported version - " + versions);
        }
        if (!FORK_PROCESSES) {
            if (!versions.equals(Version.getVersion())) {
                throw new Exception("Disallowing fork means controller version not available - " + Version.toString(versions) + " (only " + Version.getVersionAsString() + ")");
            }
            SubController c = new SubController(address, id);
            return c.getAddress();
        }
        String[] vmargs = new String[]{"-Xmx256m"};
        String classname = "org.eclipse.stp.b2j.core.jengine.internal.mainengine.SubController";
        String[] args = new String[]{"" + id};
        if (HAS_PASSWORD) {
            address.setRequiresPassword(true);
            address.setPassword(String.valueOf(this.sr.nextLong()) + "_" + this.sr.nextLong() + "_" + this.sr.nextLong());
        }
        return this.forkJVM(vmargs, jarpath, classname, args, deps, deps_msg, "SubController@" + address.getListenerHost(), HexData.stringToHexString(SessionAddress.toString(address)), "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadProperties() throws Exception {
        Object object = CONF_LOCK;
        synchronized (object) {
            ArrayList<String> tmp;
            B2jConfig config = B2jPlatform.getB2jConfig();
            if (B2jPlatform.getB2jConfigLastModified() <= last_loaded) {
                return;
            }
            last_loaded = B2jPlatform.getB2jConfigLastModified();
            Logger.info(String.valueOf(dprefix) + "Engine configuration file path = " + new File("./conf/Default/conf.xml").getCanonicalPath());
            try {
                java_exe = config.getProperty("Config/JvmFork/ForkCommand/JavaExe");
                java_cp = config.getProperty("Config/JvmFork/ForkCommand/JavaClasspathArg");
                tmp = new ArrayList<String>();
                String[] extra_jars = config.getProperties("Config/JvmFork/ExtraClasspath");
                int i = 0;
                while (i < extra_jars.length) {
                    tmp.add(extra_jars[i].trim());
                    ++i;
                }
                java_extrajars = tmp;
                java_vmargs = config.getProperties("Config/JvmFork/ForkCommand/JavaVmArg");
            }
            catch (Exception e) {
                e.printStackTrace();
                java_exe = null;
                java_cp = null;
                java_extrajars = null;
                java_vmargs = null;
                throw new Exception("error reading java command from config file");
            }
            try {
                if (config.getProperty("Config/SoapDaemon/LogInfo").equals("true")) {
                    Logger.PRINT_INFO = true;
                }
            }
            catch (Exception exception) {
                Logger.PRINT_INFO = false;
            }
            try {
                FORK_PROCESSES = config.getProperty("Config/JvmFork/Fork").equals("true");
            }
            catch (NullPointerException nullPointerException) {
                FORK_PROCESSES = true;
            }
            try {
                DAEMON_PORT = Integer.parseInt(config.getProperty("Config/SoapDaemon/Port"));
            }
            catch (Exception exception) {
                DAEMON_PORT = 11000;
            }
            try {
                USE_SSL = config.getProperty("Config/SoapDaemon/SSL").equals("true");
            }
            catch (NullPointerException nullPointerException) {
                USE_SSL = false;
            }
            try {
                HAS_PASSWORD = config.getProperty("Config/SoapDaemon/UsePassword").equals("true");
            }
            catch (NullPointerException nullPointerException) {
                HAS_PASSWORD = false;
            }
            try {
                PASSWORD = config.getProperty("Config/SoapDaemon/Password");
            }
            catch (NullPointerException nullPointerException) {
                PASSWORD = null;
            }
            try {
                int index;
                tmp = new ArrayList();
                String proxy_hosts = config.getProperty("Config/Soap/ExcludedProxyHosts");
                do {
                    String proxy_host;
                    if ((index = proxy_hosts.indexOf(44)) != -1) {
                        proxy_host = proxy_hosts.substring(0, index);
                        proxy_hosts = proxy_hosts.substring(index + 1);
                    } else {
                        proxy_host = proxy_hosts;
                    }
                    proxy_host = proxy_host.trim();
                    if (proxy_host.length() <= 0) continue;
                    tmp.add(proxy_host);
                } while (index != -1);
                SOAP_PROXY_EXCLUDED_HOSTS = new String[tmp.size()];
                tmp.toArray(SOAP_PROXY_EXCLUDED_HOSTS);
            }
            catch (NullPointerException nullPointerException) {
                SOAP_PROXY_EXCLUDED_HOSTS = new String[0];
            }
            try {
                SOAP_HTTPS_PROXY_ON = config.getProperty("Config/Soap/HttpsProxy/Use").equals("true");
            }
            catch (NullPointerException nullPointerException) {
                SOAP_HTTPS_PROXY_ON = false;
            }
            try {
                SOAP_HTTPS_PROXY_HOST = config.getProperty("Config/Soap/HttpsProxy/Host");
            }
            catch (NullPointerException nullPointerException) {
                SOAP_HTTPS_PROXY_ON = false;
            }
            try {
                SOAP_HTTPS_PROXY_PORT = Integer.parseInt(config.getProperty("Config/Soap/HttpsProxy/Port"));
            }
            catch (Exception exception) {
                SOAP_HTTPS_PROXY_ON = false;
            }
            try {
                SOAP_HTTP_PROXY_ON = config.getProperty("Config/Soap/HttpProxy/Use").equals("true");
            }
            catch (NullPointerException nullPointerException) {
                SOAP_HTTPS_PROXY_ON = false;
            }
            try {
                SOAP_HTTP_PROXY_HOST = config.getProperty("Config/Soap/HttpProxy/Host");
            }
            catch (NullPointerException nullPointerException) {
                SOAP_HTTP_PROXY_ON = false;
            }
            try {
                SOAP_HTTP_PROXY_PORT = Integer.parseInt(config.getProperty("Config/Soap/HttpProxy/Port"));
            }
            catch (Exception exception) {
                SOAP_HTTP_PROXY_ON = false;
            }
            if (HAS_PASSWORD) {
                if (PASSWORD == null) {
                    PASSWORD = "password";
                }
                if (PASSWORD == "") {
                    PASSWORD = "password";
                }
            }
            Logger.info(String.valueOf(dprefix) + "Loaded new Configuration:");
            Logger.info(String.valueOf(dprefix) + "\t(By Default) Daemon will listen on port " + DAEMON_PORT);
            Logger.info(String.valueOf(dprefix) + "\t");
            if (FORK_PROCESSES) {
                Logger.info(String.valueOf(dprefix) + "\tDaemon will fork JVM for engine components");
                Logger.info(String.valueOf(dprefix) + "\t");
                if (java_extrajars != null && java_extrajars.size() > 0) {
                    int i = 0;
                    while (i < java_extrajars.size()) {
                        Logger.info(String.valueOf(dprefix) + "\tForced Required JAR: " + java_extrajars.get(i));
                        ++i;
                    }
                    Logger.info(String.valueOf(dprefix) + "\t");
                }
                if (java_exe != null) {
                    Logger.info(String.valueOf(dprefix) + "\tUsing specific command to spawn controllers");
                    Logger.info(String.valueOf(dprefix) + "\tJava executable: " + java_exe);
                    Logger.info(String.valueOf(dprefix) + "\tJava classpath arg: " + java_cp);
                    int i = 0;
                    while (i < java_vmargs.length) {
                        Logger.info(String.valueOf(dprefix) + "\tJava VM arg: " + java_vmargs[i]);
                        ++i;
                    }
                    Logger.info(String.valueOf(dprefix) + "\t");
                } else {
                    Logger.info(String.valueOf(dprefix) + "\tUsing cross-platform JVM fork instead of specific command");
                    Logger.info(String.valueOf(dprefix) + "\t");
                }
            } else {
                Logger.info(String.valueOf(dprefix) + "\tDaemon will run engine components in current JVM");
                Logger.info(String.valueOf(dprefix) + "\t");
            }
            if (SOAP_HTTP_PROXY_ON) {
                Logger.info(String.valueOf(dprefix) + "\tSOAP HTTP proxy is ON (" + SOAP_HTTP_PROXY_HOST + ":" + SOAP_HTTP_PROXY_PORT + ")");
                Logger.info(String.valueOf(dprefix) + "\t");
            } else {
                Logger.info(String.valueOf(dprefix) + "\tSOAP HTTP proxy is OFF (direct HTTP connections)");
                Logger.info(String.valueOf(dprefix) + "\t");
            }
            if (SOAP_HTTPS_PROXY_ON) {
                Logger.info(String.valueOf(dprefix) + "\tSOAP HTTPS proxy is ON (" + SOAP_HTTPS_PROXY_HOST + ":" + SOAP_HTTPS_PROXY_PORT + ")");
                Logger.info(String.valueOf(dprefix) + "\t");
            } else {
                Logger.info(String.valueOf(dprefix) + "\tSOAP HTTPS proxy is OFF (direct HTTPS connections)");
                Logger.info(String.valueOf(dprefix) + "\t");
            }
            if (SOAP_HTTP_PROXY_ON || SOAP_HTTPS_PROXY_ON) {
                int i = 0;
                while (i < SOAP_PROXY_EXCLUDED_HOSTS.length) {
                    Logger.info(String.valueOf(dprefix) + "\tHost excluded from Proxies: " + SOAP_PROXY_EXCLUDED_HOSTS[i]);
                    ++i;
                }
                Logger.info(String.valueOf(dprefix) + "\t");
            }
            if (HAS_PASSWORD) {
                Logger.info(String.valueOf(dprefix) + "\tPassword IS required");
                Logger.info(String.valueOf(dprefix) + "\t");
            } else {
                Logger.info(String.valueOf(dprefix) + "\tPassword IS NOT required");
                Logger.info(String.valueOf(dprefix) + "\t");
            }
            if (USE_SSL) {
                Logger.info(String.valueOf(dprefix) + "\tDaemon will accept ONLY SSL connections");
                Logger.info(String.valueOf(dprefix) + "\tDaemon will NOT accept standard TCP/IP connections");
                Logger.info(String.valueOf(dprefix) + "\t");
            } else {
                Logger.info(String.valueOf(dprefix) + "\tDaemon will NOT accept SSL connections");
                Logger.info(String.valueOf(dprefix) + "\tDaemon will accept ONLY standard TCP/IP connections");
                Logger.info(String.valueOf(dprefix) + "\t");
            }
            if (!HAS_PASSWORD || !USE_SSL) {
                Logger.info(String.valueOf(dprefix) + "\t************************");
                Logger.info(String.valueOf(dprefix) + "\t* Daemon IS NOT SECURE *");
                Logger.info(String.valueOf(dprefix) + "\t************************");
                Logger.info(String.valueOf(dprefix) + "\t");
            }
        }
    }

    public void run() {
        Thread th = Thread.currentThread();
        th.setName("B2J Daemon [Listener] Thread (PORT: " + this.port + ")");
        SoapDaemon.readVersions();
        String postfix = "";
        postfix = USE_SSL ? String.valueOf(postfix) + " (HTTPS)" : String.valueOf(postfix) + " (HTTP)";
        postfix = HAS_PASSWORD ? String.valueOf(postfix) + " (Password Required)" : String.valueOf(postfix) + " (No Password)";
        Logger.direct(String.valueOf(dprefix) + "B2J daemon listening for connections on port " + this.port + postfix);
        System.gc();
        try {
            HTTPServer.addHttpListener(new URL(String.valueOf(this.epr.getAddress()) + "/public.wsdl"), this);
            HTTPServer.addHttpListener(new URL(String.valueOf(this.epr.getAddress()) + "/"), this);
            SOAPFactory.addServerTransportListenerForEPR(this.daemon_service_epr, null, false, this);
            while (true) {
                try {
                    while (true) {
                        Thread.sleep(99999999L);
                    }
                }
                catch (Exception exception) {
                    continue;
                }
                break;
            }
        }
        catch (Throwable t) {
            Logger.direct("Failed to listen for incoming connections: " + t);
            Logger.error("Failed to listen for incoming connections", t);
            return;
        }
    }

    private void start_socket() throws IOException {
        System.gc();
        if (USE_SSL) {
            this.epr = new WSEndpointReference("https://localhost:" + this.port);
            this.daemon_service_epr = new WSEndpointReference("https://localhost:" + this.port + "/services/engine/");
        } else {
            this.epr = new WSEndpointReference("http://localhost:" + this.port);
            this.daemon_service_epr = new WSEndpointReference("http://localhost:" + this.port + "/services/engine/");
        }
    }

    public static void main(String[] args) {
        if (Switches.CONSTANT_GARBAGE_COLLECTION) {
            GCThread.startThread();
        }
        new SoapDaemon(args);
    }

    public static String getStackTrace(Throwable t) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(os);
        t.printStackTrace(ps);
        return os.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addVersion(Message versions, byte[] dat) throws Exception {
        Object object = VERSIONS_LOCK;
        synchronized (object) {
            File jar_file;
            StringBuffer name = new StringBuffer(VERSION_PREFIX);
            int i = 0;
            while (i < versions.length()) {
                name.append("-");
                name.append((Integer)versions.get(i));
                ++i;
            }
            name.append(".jar");
            FileOutputStream fout = null;
            boolean permanent = false;
            try {
                jar_file = new File(String.valueOf(cd) + "versions/" + name.toString());
                fout = new FileOutputStream(jar_file);
                permanent = true;
            }
            catch (IOException iOException) {
                jar_file = File.createTempFile(VERSION_PREFIX, ".jar");
                fout = new FileOutputStream(jar_file);
                permanent = false;
            }
            fout.write(dat, 0, dat.length);
            fout.flush();
            fout.close();
            JARVersion ver = new JARVersion();
            ver.version = versions;
            ver.path = jar_file.getAbsolutePath();
            if (permanent) {
                version_jars.add(ver);
            } else {
                version_tmp_jars.add(ver);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readVersions() {
        Object object = VERSIONS_LOCK;
        synchronized (object) {
            try {
                version_jars.clear();
                File version_dir = new File(String.valueOf(cd) + "versions");
                if (!version_dir.exists()) {
                    version_dir.mkdirs();
                } else {
                    File[] files = version_dir.listFiles();
                    int i = 0;
                    while (i < files.length) {
                        String name = files[i].getName();
                        Message versions = new Message();
                        int until = 0;
                        while (until < name.length()) {
                            int nextDot;
                            int nextHyphen = (name = name.substring(until)).indexOf(45);
                            if (nextHyphen == -1) {
                                nextHyphen = name.length();
                            }
                            if ((nextDot = name.indexOf(46)) == -1) {
                                nextDot = name.length();
                            }
                            until = Math.min(nextHyphen, nextDot);
                            String str = name.substring(0, until);
                            ++until;
                            try {
                                int n = Integer.parseInt(str);
                                versions.append(n);
                            }
                            catch (Exception exception) {}
                        }
                        if (versions.length() > 0) {
                            JARVersion ver = new JARVersion();
                            ver.version = versions;
                            ver.path = files[i].getAbsolutePath();
                            Logger.direct(String.valueOf(dprefix) + "Detected support for version " + ver);
                            version_jars.add(ver);
                        }
                        ++i;
                    }
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getVersion(Message versions) {
        if (versions.equals(Version.getVersion())) {
            return basejar;
        }
        Object object = VERSIONS_LOCK;
        synchronized (object) {
            JARVersion ver;
            int i = 0;
            while (i < version_jars.size()) {
                ver = (JARVersion)version_jars.get(i);
                if (ver.version.equals(versions)) {
                    return ver.path;
                }
                ++i;
            }
            i = 0;
            while (i < version_tmp_jars.size()) {
                ver = (JARVersion)version_tmp_jars.get(i);
                if (ver.version.equals(versions)) {
                    return ver.path;
                }
                ++i;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String doRequest(int httpport, boolean rpc_type, String operationNamespace, String operation, String soapAction, String payload) throws Exception {
        try {
            Object object = this.TRANSACTION_LOCK;
            synchronized (object) {
                try {
                    SoapDaemon.loadProperties();
                }
                catch (Exception exception) {}
                Element body_elem = SoapDaemonUtils.getDocumentEncodedMessageBody(payload);
                Element part_Password = Util.getFirstElement(body_elem, "Password");
                if (HAS_PASSWORD) {
                    if (part_Password != null) {
                        String pword = SoapDaemonUtils.elementToPassword(part_Password);
                        if (!pword.equals(PASSWORD)) {
                            throw new Exception("password incorrect");
                        }
                    } else {
                        throw new Exception("password required");
                    }
                }
                StringBuffer responseXml = new StringBuffer();
                if (soapAction.equals(SOAPACTION_CREATE_CONTROLLER)) {
                    Element part_SessionAddress = Util.getFirstElement(body_elem, "SessionAddress");
                    Element part_Dependencies = Util.getFirstElement(body_elem, "Dependencies");
                    Element part_Versions = Util.getFirstElement(body_elem, "Versions");
                    Element part_Description = Util.getFirstElement(body_elem, "Description");
                    SessionAddress address = SoapDaemonUtils.elementToSessionAddress(part_SessionAddress);
                    JARDependency[] deps = SoapDaemonUtils.elementToJARDependency(part_Dependencies);
                    String description = "";
                    if (part_Description != null) {
                        description = SoapDaemonUtils.elementToDescription(part_Description);
                    } else {
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd_HHmmssSSS");
                        description = sdf.format(new Date());
                    }
                    Message dependencies = new Message();
                    int i = 0;
                    while (i < deps.length) {
                        dependencies.append(JARDependency.toMessage(deps[i]));
                        ++i;
                    }
                    Message versions = SoapDaemonUtils.elementToVersion(part_Versions);
                    address.setListenerPortMinimum(this.port + 1);
                    address.setListenerPortMaximum(-1);
                    address = this.forkController(0, address, versions, deps, dependencies, description);
                    responseXml.append(SoapDaemonUtils.sessionAddressToElement(address));
                    System.gc();
                } else if (soapAction.equals(SOAPACTION_CREATE_SUBCONTROLLER)) {
                    Element part_ID = Util.getFirstElement(body_elem, "ID");
                    Element part_SessionAddress = Util.getFirstElement(body_elem, "SessionAddress");
                    Element part_Dependencies = Util.getFirstElement(body_elem, "Dependencies");
                    Element part_Versions = Util.getFirstElement(body_elem, "Versions");
                    Integer id = new Integer(SoapDaemonUtils.elementToId(part_ID));
                    SessionAddress address = SoapDaemonUtils.elementToSessionAddress(part_SessionAddress);
                    JARDependency[] deps = SoapDaemonUtils.elementToJARDependency(part_Dependencies);
                    Message dependencies = new Message();
                    int i = 0;
                    while (i < deps.length) {
                        dependencies.append(JARDependency.toMessage(deps[i]));
                        ++i;
                    }
                    Message versions = SoapDaemonUtils.elementToVersion(part_Versions);
                    address.setListenerPortMinimum(this.port + 1);
                    address.setListenerPortMaximum(-1);
                    address = this.forkSubController(id, address, versions, deps, null);
                    responseXml.append(SoapDaemonUtils.sessionAddressToElement(address));
                    System.gc();
                } else if (soapAction.equals(SOAPACTION_GET_VERSION)) {
                    Message version = Version.getVersion();
                    responseXml.append(SoapDaemonUtils.versionToElement(version));
                    System.gc();
                } else if (soapAction.equals(SOAPACTION_SUPPORTS_VERSION)) {
                    Element part_Versions = Util.getFirstElement(body_elem, "Versions");
                    Message versions = SoapDaemonUtils.elementToVersion(part_Versions);
                    boolean supported = false;
                    supported = SoapDaemon.getVersion(versions) != null;
                    responseXml.append(SoapDaemonUtils.supportedToElement(supported));
                    System.gc();
                } else if (soapAction.equals(SOAPACTION_ADD_VERSION)) {
                    Element part_Versions = Util.getFirstElement(body_elem, "Versions");
                    Element part_JAR = Util.getFirstElement(body_elem, "JAR");
                    Message versions = SoapDaemonUtils.elementToVersion(part_Versions);
                    byte[] dat = HexData.hexStringToByteArray(Util.getTextDirectlyUnder(part_JAR));
                    SoapDaemon.addVersion(versions, dat);
                    System.gc();
                } else if (soapAction.equals(SOAPACTION_LIST_ENGINES)) {
                    responseXml.append("<EngineInstances>");
                    Object part_Versions = this.LIVE_PROCESSES_LOCK;
                    synchronized (part_Versions) {
                        int i = 0;
                        while (i < this.live_processes.size()) {
                            JEngineProcess proc = (JEngineProcess)this.live_processes.get(i);
                            if (proc.getDescription().length() > 0) {
                                responseXml.append(SoapDaemonUtils.engineToElement(proc.getId(), proc.getDescription()));
                            }
                            ++i;
                        }
                    }
                    responseXml.append("</EngineInstances>");
                    System.gc();
                } else if (soapAction.equals(SOAPACTION_KILL_ENGINE)) {
                    Element part_Instance = Util.getFirstElement(body_elem, "EngineInstance");
                    long id = Long.parseLong(Util.getTextDirectlyUnder(Util.getFirstElement(part_Instance, "id")));
                    responseXml.append("<EngineInstances>");
                    Object object2 = this.LIVE_PROCESSES_LOCK;
                    synchronized (object2) {
                        int i = 0;
                        while (i < this.live_processes.size()) {
                            JEngineProcess proc = (JEngineProcess)this.live_processes.get(i);
                            if (proc.getId() == id && proc.getDescription().length() > 0) {
                                try {
                                    proc.destroy();
                                }
                                catch (Throwable throwable) {}
                                this.live_processes.remove(i--);
                            } else if (proc.getDescription().length() > 0) {
                                responseXml.append(SoapDaemonUtils.engineToElement(proc.getId(), proc.getDescription()));
                            }
                            ++i;
                        }
                    }
                    responseXml.append("</EngineInstances>");
                    System.gc();
                }
                return SOAPUtils.basicWrapInSoapEnvelopeDocument(responseXml.toString());
            }
        }
        catch (Throwable t) {
            String s = t.getMessage();
            if (s == null) {
                s = SOAPUtils.getStackTrace(t);
            } else if (s.trim().length() == 0) {
                s = SOAPUtils.getStackTrace(t);
            }
            return SOAPUtils.basicWrapInSoapEnvelopeDocument(SoapDaemonUtils.errorToElement(s));
        }
    }

    public String doRequest(int port, String resource, String payload, HashMap lc_headers) throws HTTPException {
        try {
            if (resource.toLowerCase().indexOf("wsdl") != -1) {
                String protocol = "http";
                if (USE_SSL) {
                    protocol = "https";
                }
                return "<?xml version=\"1.0\" encoding=\"UTF-8\"?><definitions xmlns=\"http://schemas.xmlsoap.org/wsdl/\" targetNamespace=\"http://www.eclipse.org/stp/b2j/2006/02\" xmlns:tns=\"http://www.eclipse.org/stp/b2j/2006/02\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:wsdl=\"http://schemas.xmlsoap.org/wsdl/\" xmlns:soap=\"http://schemas.xmlsoap.org/wsdl/soap/\" ><types> <schema targetNamespace=\"http://www.eclipse.org/stp/b2j/2006/02\" xmlns:tns=\"http://www.eclipse.org/stp/b2j/2006/02\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns=\"http://www.w3.org/2001/XMLSchema\"> <complexType name=\"Versions\"> <sequence> <element name=\"Version\" type=\"xsd:int\" minOccurs=\"1\" maxOccurs=\"unbounded\" nillable=\"false\" /> </sequence> </complexType> <complexType name=\"EngineInstance\"> <sequence> <element name=\"id\" type=\"xsd:long\" minOccurs=\"1\" maxOccurs=\"1\" nillable=\"false\" /> <element name=\"description\" type=\"xsd:string\" minOccurs=\"0\" maxOccurs=\"1\" nillable=\"false\" /> </sequence> </complexType> <complexType name=\"EngineInstances\"> <sequence> <element name=\"EngineInstance\" type=\"tns:EngineInstance\" minOccurs=\"0\" maxOccurs=\"unbounded\" nillable=\"false\" /> </sequence> </complexType> </schema> </types> <message name=\"GetVersionRequest\"> <part name=\"Password\" type=\"xsd:string\" /> </message> <message name=\"GetVersionResponse\"> <part name=\"Versions\" type=\"tns:Versions\" /> <part name=\"Error\" type=\"xsd:string\" /> </message> <message name=\"ListEnginesRequest\"> </message> <message name=\"ListEnginesResponse\"> <part name=\"EngineInstances\" type=\"tns:EngineInstances\" /> </message> <message name=\"TerminateEnginesRequest\"> <part name=\"EngineInstance\" type=\"tns:EngineInstance\" /> </message> <message name=\"TerminateEnginesResponse\"> <part name=\"EngineInstances\" type=\"tns:EngineInstances\" /> </message> <portType name=\"B2jDaemon\"> <operation name=\"getVersion\"> <input message=\"tns:GetVersionRequest\" name=\"GetVersionRequest\" /> <output message=\"tns:GetVersionResponse\" name=\"GetVersionResponse\" /> </operation> <operation name=\"listEngines\"> <input message=\"tns:ListEnginesRequest\" name=\"ListEnginesRequest\" /> <output message=\"tns:ListEnginesResponse\" name=\"ListEnginesResponse\" /> </operation> <operation name=\"terminateEngine\"> <input message=\"tns:TerminateEnginesRequest\" name=\"TerminateEnginesRequest\" /> <output message=\"tns:TerminateEnginesResponse\" name=\"TerminateEnginesResponse\" /> </operation> </portType> <binding name=\"B2jDaemonSoapBinding\" type=\"tns:B2jDaemon\"> <soap:binding transport=\"http://schemas.xmlsoap.org/soap/http\" style=\"document\"/> <operation name=\"getVersion\"> <soap:operation soapAction=\"Daemon/GetVersion\" style=\"document\"/> <wsdl:input name=\"GetVersionRequest\" > <soap:body use=\"literal\"/> </wsdl:input> <wsdl:output name=\"GetVersionResponse\" > <soap:body use=\"literal\"/> </wsdl:output> </operation> <operation name=\"listEngines\"> <soap:operation soapAction=\"Daemon/ListEngines\" style=\"document\"/> <wsdl:input name=\"ListEnginesRequest\" > <soap:body use=\"literal\"/> </wsdl:input> <wsdl:output name=\"ListEnginesResponse\" > <soap:body use=\"literal\"/> </wsdl:output> </operation> <operation name=\"terminateEngine\"> <soap:operation soapAction=\"Daemon/TerminateEngine\" style=\"document\"/> <wsdl:input name=\"TerminateEnginesRequest\" > <soap:body use=\"literal\"/> </wsdl:input> <wsdl:output name=\"TerminateEnginesResponse\" > <soap:body use=\"literal\"/> </wsdl:output> </operation> </binding> <service> <port name=\"B2jDaemonPort\" binding=\"tns:B2jDaemonSoapBinding\"> <soap:address location=\"" + protocol + "://" + InetAddress.getLocalHost().getHostAddress() + ":" + port + "/services/engine/\"/> " + "</port> " + "</service> " + "</definitions> ";
            }
            if (payload == null) {
                StringBuffer sb = new StringBuffer();
                sb.append("<ul>");
                sb.append("<li><a href=\"/public.wsdl\">Daemon Public WSDL (/public.wsdl)</a></li>");
                sb.append("</ul>");
                return HTTPUtils.getHtml("B2J Engine Daemon", sb.toString());
            }
        }
        catch (Exception e) {
            throw new HTTPException("" + e);
        }
        throw new HTTPNotFoundException("Not Found");
    }

    private class InstanceReader
    extends Thread {
        String prefix;
        BufferedReader bread;
        String info = null;

        public InstanceReader(String prefix, BufferedReader bread) {
            this.prefix = prefix;
            this.bread = bread;
            this.setDaemon(true);
        }

        public void run() {
            try {
                String s;
                while ((s = this.bread.readLine()) != null) {
                    if (this.info == null) {
                        this.info = s;
                    }
                    Logger.log(String.valueOf(this.prefix) + s);
                }
            }
            catch (Exception exception) {}
        }
    }

    private class InstanceTracker
    extends Thread {
        JEngineProcess p;
        String prefix;

        public InstanceTracker(String prefix, JEngineProcess p) {
            this.prefix = prefix;
            this.p = p;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object;
            try {
                this.p.waitFor();
                object = SoapDaemon.this.LIVE_PROCESSES_LOCK;
                synchronized (object) {
                    this.p.destroy();
                }
            }
            catch (Throwable throwable) {
                object = SoapDaemon.this.LIVE_PROCESSES_LOCK;
                synchronized (object) {
                    this.p.destroy();
                }
            }
            try {
                int n = this.p.exitValue();
                Logger.direct(String.valueOf(this.prefix) + " PROCESS EXITED, returning " + n);
            }
            catch (Exception exception) {
                Logger.direct(String.valueOf(this.prefix) + " PROCESS EXITED, returning <unknown>");
            }
            try {
                Object object2 = SoapDaemon.this.LIVE_PROCESSES_LOCK;
                synchronized (object2) {
                    SoapDaemon.this.live_processes.remove(this.p);
                }
            }
            catch (Exception exception) {}
        }
    }

    public static class JARVersion {
        Message version;
        String path;

        public String toString() {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < this.version.length()) {
                if (i > 0) {
                    sb.append("-");
                }
                sb.append(this.version.get(i));
                ++i;
            }
            sb.append(" (");
            sb.append(this.path.substring(this.path.lastIndexOf(File.separatorChar) + 1));
            sb.append(")");
            return sb.toString();
        }
    }

    private class JEngineProcess {
        Process p;
        String prefix;
        String name;
        String description;
        long id;

        JEngineProcess(Process p, String prefix, String name, String description) {
            this.p = p;
            this.prefix = prefix;
            this.name = name;
            this.description = description;
        }

        public void setId(long l) {
            this.id = l;
        }

        public long getId() {
            return this.id;
        }

        public String getDescription() {
            return this.description;
        }

        public void waitFor() throws InterruptedException {
            this.p.waitFor();
        }

        public void destroy() {
            this.p.destroy();
        }

        public int exitValue() {
            return this.p.exitValue();
        }

        public String toString() {
            return this.name;
        }
    }

    private class ProcessKillerThread
    extends Thread {
        private ProcessKillerThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Logger.direct(String.valueOf(dprefix) + "Destroying any live engine components...");
            Object object = SoapDaemon.this.LIVE_PROCESSES_LOCK;
            synchronized (object) {
                int i = 0;
                while (i < SoapDaemon.this.live_processes.size()) {
                    try {
                        JEngineProcess p = (JEngineProcess)SoapDaemon.this.live_processes.get(i);
                        try {
                            p.destroy();
                            try {
                                int n = p.exitValue();
                                Logger.direct(String.valueOf(dprefix) + "PROCESS " + p.prefix + " DESTROYED <" + n + "> " + p);
                            }
                            catch (Exception exception) {
                                Logger.direct(String.valueOf(dprefix) + "PROCESS " + p.prefix + " DESTROYED <unknown> " + p);
                            }
                        }
                        catch (Throwable throwable) {
                            Logger.direct(String.valueOf(dprefix) + "UNABLE TO DESTROY PROCESS " + p.prefix + " " + p);
                        }
                    }
                    catch (Throwable throwable) {}
                    ++i;
                }
            }
        }
    }
}

