/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.b2j.core.misc.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.stp.b2j.core.xml.internal.w3c.Document;
import org.eclipse.stp.b2j.core.xml.internal.w3c.DocumentBuilder;
import org.eclipse.stp.b2j.core.xml.internal.w3c.DocumentWriter;
import org.eclipse.stp.b2j.core.xml.internal.w3c.Element;
import org.eclipse.stp.b2j.core.xml.internal.w3c.Node;
import org.eclipse.stp.b2j.core.xml.internal.w3c.NodeList;

public class XMLUtil {
    public static String nodeToString(Node n) throws Exception {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        XMLUtil.nodeToString(n, bout);
        return new String(bout.toByteArray());
    }

    public static String nodeChildrenToString(Node n) throws Exception {
        StringBuffer sb = new StringBuffer();
        NodeList children = n.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            sb.append(XMLUtil.nodeToString(children.item(i)));
            ++i;
        }
        return sb.toString();
    }

    public static void nodeToString(Node n, OutputStream out) throws Exception {
        String s = new DocumentWriter("").writeNode(n, false);
        out.write(s.getBytes("UTF8"));
    }

    public static String documentToString(Node n) throws Exception {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        XMLUtil.documentToString(n, bout);
        return new String(bout.toByteArray());
    }

    public static void documentToString(Node n, OutputStream out) throws Exception {
        String s = new DocumentWriter("").writeDoc(n, false);
        out.write(s.getBytes("UTF8"));
    }

    public static void documentToCleanString(Node n, OutputStream out) throws Exception {
        String s = new DocumentWriter("").writeDoc(n, false);
        out.write(s.getBytes("UTF8"));
    }

    public static Document documentFromString(String doc) throws Exception {
        return XMLUtil.getDocumentBuilder().parse(new ByteArrayInputStream(doc.getBytes()));
    }

    public static Document documentFromString(InputStream in) throws Exception {
        return XMLUtil.getDocumentBuilder().parse(in);
    }

    public static Document blankDocument(String type) throws Exception {
        Document doc = XMLUtil.getDocumentBuilder().newDocument();
        Element element = doc.createElement(type);
        doc.appendChild(element);
        return doc;
    }

    public static DocumentBuilder getDocumentBuilder() throws Exception {
        return new DocumentBuilder();
    }
}

