/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.b2j.core.jengine.internal.compiler.bpel;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Properties;
import java.util.Stack;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import org.eclipse.stp.b2j.core.jengine.internal.api.JavaProgramFactory;
import org.eclipse.stp.b2j.core.jengine.internal.api.Program;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.ScopeStack;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.Switches;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.TranslatorLog;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.Util;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.bpel.BPELCorrelation;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.bpel.BPELTranslatorException;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.locks.LockModel;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.locks.LockModelEquivalenceOptimiser;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.locks.LockModelScopeOptimiser;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.locks.LockSync;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.wsdl.WSDLTranslator;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.wsdlmap.BPELPartnerLinkRole;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.wsdlmap.BPELPartnerLinkType;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.wsdlmap.WSDLMap;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.wsdlmap.WSDLMessage;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.wsdlmap.WSDLOperation;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.wsdlmap.WSDLPortType;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.xmlns.NamespaceException;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.xmlns.NamespaceTranslator;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.xpath.XPATHTreeTranslator;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.xsd.XSDTranslator;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.xsdmap.XSDMap;
import org.eclipse.stp.b2j.core.jengine.internal.core.bpel.WSEndpointReference;
import org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.internal.InternalBindingTranslator;
import org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.internal.XMLAccessible;
import org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.wsif.ports.DeploymentStrategyPort;
import org.eclipse.stp.b2j.core.jengine.internal.portgen.WsdlGenerator;
import org.eclipse.stp.b2j.core.jengine.internal.utils.TranslatorUtils;
import org.eclipse.stp.b2j.core.jengine.internal.utils.UIDPool;
import org.eclipse.stp.b2j.core.misc.internal.StringSplitter;
import org.eclipse.stp.b2j.core.misc.internal.XMLUtil;
import org.eclipse.stp.b2j.core.publicapi.B2jPlatform;
import org.eclipse.stp.b2j.core.publicapi.DependencyInfo;
import org.eclipse.stp.b2j.core.publicapi.JARDependency;
import org.eclipse.stp.b2j.core.publicapi.extension.wsdlbinding.WSDLBindingTranslator;
import org.eclipse.stp.b2j.core.publicapi.extension.wsdlbinding.WSDLBindingTranslatorException;
import org.eclipse.stp.b2j.core.publicapi.extension.wsdlbinding.XSDTypeTranslator;
import org.eclipse.stp.b2j.core.publicapi.importresolver.WsdlImportResolver;
import org.eclipse.stp.b2j.core.publicapi.jcompiler.CompilerUnit;
import org.eclipse.stp.b2j.core.publicapi.jcompiler.JavaCompiler;
import org.eclipse.stp.b2j.core.xml.internal.w3c.Document;
import org.eclipse.stp.b2j.core.xml.internal.w3c.DocumentBuilder;
import org.eclipse.stp.b2j.core.xml.internal.w3c.Element;
import org.eclipse.stp.b2j.core.xml.internal.w3c.Node;
import org.eclipse.stp.b2j.core.xml.internal.w3c.NodeList;
import org.eclipse.stp.b2j.core.xml.internal.w3c.Text;

public class BPELTranslator {
    String DEFAULT_BPEL_FILENAME = "(Final BPEL Source)";
    URLClassLoader deps_loader;
    String LOG_SOURCE = "BPEL Translator";
    TranslatorLog log;
    boolean debug = false;
    private static final String INSERT_LOCAL_VARIABLE_CREATION = "INSERT_LOCAL_VARIABLE_CREATION";
    String runner_imports = "import java.util.*;\nimport org.eclipse.stp.b2j.core.jengine.internal.core.*;\nimport org.eclipse.stp.b2j.core.jengine.internal.core.api.*;\nimport org.eclipse.stp.b2j.core.jengine.internal.core.datapool.*;\nimport org.eclipse.stp.b2j.core.jengine.internal.message.Message;\nimport org.eclipse.stp.b2j.core.jengine.internal.api.*;\nimport org.eclipse.stp.b2j.core.jengine.internal.core.bpel.*;\nimport org.eclipse.stp.b2j.core.jengine.internal.mutex.*;\nimport org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.wsif.ports.*;import org.eclipse.stp.b2j.core.jengine.internal.utils.*;\n";
    String runner_template = "///////////////////////\n// SET BY REFLECTION //\n///////////////////////\npublic org.eclipse.stp.b2j.core.jengine.internal.core.RunnerInterface engine;\npublic long runner_id;\npublic Message runner_args;\n\n//////////////////////////////////////////////////\n// FOR LOCAL THREADS WHICH NEED TO SHARE MEMORY //\n//////////////////////////////////////////////////\npublic void run() {\n\t//for local, shared memory threading\n}\n\n//////////////////////////////////\n// ENTRY POINT FOR FIRST RUNNER //\n//////////////////////////////////\nSharedHashMap bpelThreadMap;\nSharedHashMap bpelDebugMap;\nSharedVariable bpelDebugSuspend;\nMessage bpelDebugStack;\nMessage bpelThreadIdList = new Message();\nint bpelThreadChildIndex = 1;\nString bpelThreadId = \"\";\nstatic volatile int flowHost = -1;\nThrowable myfault = null;\npublic void engine_main() throws Exception {\n  //Run this compiled BPEL process\n  activity1();\n}\n\n";
    UIDPool operation_uidpool = new UIDPool();
    HashMap operation_uids = new HashMap();
    static final int FIRST_THREAD_ID = 1;
    XSDTypeTranslator[] codecs;
    WSDLBindingTranslator[] bindings;
    WSDLMap wsdlmap;
    XSDMap xsdmap;
    NamespaceTranslator nt;
    Util compiler_util;
    LockModel lock_model;
    HashMap partnerLinks = new HashMap();
    HashMap variable_assets = new HashMap();
    HashMap semaphore_assets = new HashMap();
    int bpelAssetID = 0;
    int bpelThreadID = 0;
    Stack bpel_threads = new Stack();
    ScopeStack scopes;
    ScopeStack flow_scopes;
    int NSEQ = 1;
    int METHOD = 1;
    int UID = 1;
    int TUID = 1;
    int XPATHID = 1;

    public BPELTranslator(String program_prefix, Switches switches) {
        this.compiler_util = new Util(program_prefix, switches);
        this.nt = new NamespaceTranslator(program_prefix);
        this.scopes = new ScopeStack(this.compiler_util);
        this.flow_scopes = new ScopeStack(this.compiler_util);
    }

    public ArrayList getAllAssets() {
        ArrayList assets = new ArrayList();
        assets.addAll(this.variable_assets.values());
        assets.addAll(this.semaphore_assets.values());
        return assets;
    }

    public BPELAsset getOrCreateVariable(String name, String basename, String qtype) {
        BPELAsset asset = (BPELAsset)this.variable_assets.get(name);
        if (asset == null) {
            asset = new BPELAsset(name, basename, qtype, 0);
            this.variable_assets.put(name, asset);
        }
        return asset;
    }

    public BPELAsset getVariable(String name, String basename) {
        BPELAsset asset = (BPELAsset)this.variable_assets.get(name);
        return asset;
    }

    public void addVariableRef(String basename, Node source) throws BPELTranslatorException {
        if (basename == null) {
            return;
        }
        if (basename.length() == 0) {
            return;
        }
        String name = this.scopes.getVariableName(basename, source);
        BPELThread thread = (BPELThread)this.bpel_threads.peek();
        BPELAsset asset = this.getVariable(name, basename);
        if (!asset.threads.contains(thread)) {
            asset.threads.add(thread);
        }
    }

    public void addVariableRefs(ArrayList names, Node source) throws BPELTranslatorException {
        BPELThread cfr_ignored_0 = (BPELThread)this.bpel_threads.peek();
        int i = 0;
        while (i < names.size()) {
            this.addVariableRef((String)names.get(i), source);
            ++i;
        }
    }

    public boolean canBeLocal(BPELAsset asset) {
        ArrayList threads = asset.threads;
        boolean singleThreaded = true;
        if (threads.size() == 1) {
            BPELThread thread = (BPELThread)threads.get(0);
            if (thread.multiple_copies) {
                singleThreaded = false;
            }
        } else if (threads.size() > 1) {
            singleThreaded = false;
        }
        if (!singleThreaded) {
            StringBuffer sb = new StringBuffer();
            sb.append("Asset " + asset.name + " cannot be local - ");
            int i = 0;
            while (i < threads.size()) {
                sb.append(((BPELThread)threads.get((int)i)).id);
                ++i;
            }
            return false;
        }
        return true;
    }

    public boolean canBeConcurrentlyAccessed(BPELAsset asset) {
        ArrayList threads = asset.threads;
        HashMap<BPELFlow, BPELThread> flows = new HashMap<BPELFlow, BPELThread>();
        int i = 0;
        while (i < threads.size()) {
            BPELThread thread = (BPELThread)threads.get(i);
            if (thread.flow != null) {
                BPELThread existing = (BPELThread)flows.get(thread.flow);
                if (existing != null && !thread.hasParent(existing) && !existing.hasParent(thread)) {
                    return true;
                }
                flows.put(thread.flow, thread);
            }
            ++i;
        }
        return false;
    }

    private String getNextXPath() {
        return "xpath_expr" + this.XPATHID++;
    }

    private String peekNextXPath() {
        return "xpath_expr" + this.XPATHID;
    }

    private String getNextMethod() {
        return "activity" + this.METHOD++;
    }

    private String peekNextMethod() {
        return "activity" + this.METHOD;
    }

    private String getPartnerLinkName(String ncname) {
        return "bpel_plink_" + ncname;
    }

    private int nextUID() {
        return this.UID++;
    }

    private int nextThreadUID() {
        return this.TUID++;
    }

    public BPELTranslator() {
    }

    public BPELCorrelation[] getCorrelations(Element msgActivity) {
        ArrayList bpel_correlations = new ArrayList();
        ArrayList correlationsList = Util.getAllElements(msgActivity);
        int i = 0;
        while (i < correlationsList.size()) {
            Element correlations = (Element)correlationsList.get(i);
            if (NamespaceTranslator.getName(correlations).equals("correlations")) {
                ArrayList correlationList = Util.getAllElements(correlations);
                int k = 0;
                while (k < correlationList.size()) {
                    Element correlation = (Element)correlationList.get(k);
                    if (NamespaceTranslator.getName(correlation).equals("correlation")) {
                        String pattern;
                        BPELCorrelation corr = new BPELCorrelation();
                        corr.setncname = correlation.getAttribute("set");
                        String initiate = correlation.getAttribute("initiate");
                        if (initiate != null && initiate.equalsIgnoreCase("true")) {
                            corr.initiate = true;
                        }
                        if ((pattern = correlation.getAttribute("pattern")) != null) {
                            if (pattern.equals("in")) {
                                corr.pattern = 0;
                            } else if (pattern.equals("out")) {
                                corr.pattern = 1;
                            } else if (pattern.equals("out-in")) {
                                corr.pattern = 2;
                            }
                        }
                    }
                    ++k;
                }
            }
            ++i;
        }
        BPELCorrelation[] array = new BPELCorrelation[bpel_correlations.size()];
        bpel_correlations.toArray(array);
        return array;
    }

    public void translatePartnerLinks(BPELState state, Element links) throws BPELTranslatorException, NamespaceException {
        state.appendLine("//PARTNER LINKS");
        state.incrementScope();
        ArrayList list = Util.getAllElements(links, "partnerLink");
        int i = 0;
        while (i < list.size()) {
            Element e = (Element)list.get(i);
            this.translatePartnerLink(state, e);
            ++i;
        }
        state.decrementScope();
        state.appendLine("//END PARTNER LINKS");
    }

    public void translatePartnerLink(BPELState state, Element link) throws BPELTranslatorException, NamespaceException {
        state.appendLine("//PARTNER LINK");
        this.nt.addNamespaces(link);
        BPELPartnerLink plink = new BPELPartnerLink();
        plink.name = link.getAttribute("name");
        plink.qtype = this.nt.qualify(link.getAttribute("partnerLinkType"), false);
        String myRoleName = link.getAttribute("myRole");
        String partnerRoleName = link.getAttribute("partnerRole");
        if (myRoleName == null) {
            myRoleName = "";
        }
        if (partnerRoleName == null) {
            partnerRoleName = "";
        }
        if (myRoleName.length() > 0) {
            plink.myRoleName = myRoleName;
        }
        if (partnerRoleName.length() > 0) {
            plink.partnerRoleName = partnerRoleName;
        }
        String useBindingName = null;
        Element useBinding = Util.getFirstElement(link, "useBinding");
        if (useBinding != null) {
            useBindingName = Util.getTextDirectlyUnder(useBinding);
            try {
                plink.requiredBindingName = this.nt.qualify(useBindingName, false);
            }
            catch (NamespaceException ee) {
                throw new BPELTranslatorException(this.compiler_util, (Node)useBinding, ee);
            }
        }
        this.partnerLinks.put(plink.name, plink);
        state.appendLine("//Initialise the partner link");
        state.appendLine("BPELPartnerLink.createPartnerLink(\"" + this.getPartnerLinkName(plink.name) + "\");");
        BPELPartnerLinkType ptype = this.wsdlmap.getPartnerLinkType(plink.qtype);
        if (ptype == null) {
            throw new BPELTranslatorException(this.compiler_util, (Node)link, "partner link type not found " + plink.qtype);
        }
        BPELPartnerLinkRole myRole = null;
        BPELPartnerLinkRole partnerRole = null;
        if (myRoleName.length() > 0) {
            myRole = ptype.getRole(myRoleName);
            if (myRole == null) {
                throw new BPELTranslatorException(this.compiler_util, (Node)link, "myRole (" + myRoleName + ") not found for partner link " + plink.name);
            }
            plink.myRole = myRole;
        }
        if (partnerRoleName.length() > 0) {
            partnerRole = ptype.getRole(partnerRoleName);
            if (partnerRole == null) {
                throw new BPELTranslatorException(this.compiler_util, (Node)link, "partnerRole (" + partnerRoleName + ") not found for partner link " + plink.name);
            }
            plink.partnerRole = partnerRole;
        }
        if (plink.myRole == null && plink.partnerRole == null) {
            throw new BPELTranslatorException(this.compiler_util, (Node)link, "Partner Link " + plink.name + " has no myRole and no partnerRole, must have either one or both");
        }
        boolean translated = false;
        ArrayList<WSDLBindingTranslatorException> exceptions = new ArrayList<WSDLBindingTranslatorException>();
        StringBuffer errors = new StringBuffer();
        int i = 0;
        while (!translated && i < this.bindings.length) {
            try {
                String pvar;
                StringBuffer translation = new StringBuffer();
                if (myRole != null) {
                    pvar = "bpel_partner_link" + this.nextUID();
                    translation.append("BPELPartnerLink " + pvar + " = BPELPartnerLink.getPartnerLink(\"" + this.getPartnerLinkName(plink.name) + "\");\n");
                    translation.append(pvar);
                    translation.append(".myRole = ");
                    translation.append(this.bindings[i].translateDefaultEPR(this.nt, myRole.getQualifiedPortType(), plink.requiredBindingName));
                    translation.append(";\n");
                    translation.append("BPELPartnerLink.setPartnerLink(\"" + this.getPartnerLinkName(plink.name) + "\"," + pvar + ");");
                }
                if (partnerRole != null) {
                    pvar = "bpel_partner_link" + this.nextUID();
                    translation.append("BPELPartnerLink " + pvar + " = BPELPartnerLink.getPartnerLink(\"" + this.getPartnerLinkName(plink.name) + "\");\n");
                    translation.append(pvar);
                    translation.append(".partnerRole = ");
                    translation.append(this.bindings[i].translateDefaultEPR(this.nt, partnerRole.getQualifiedPortType(), plink.requiredBindingName));
                    translation.append(";\n");
                    translation.append("BPELPartnerLink.setPartnerLink(\"" + this.getPartnerLinkName(plink.name) + "\"," + pvar + ");");
                }
                this.log.logInfo(this.LOG_SOURCE, "partner link " + plink.name + " translated by binding " + this.bindings[i].getClass().getName());
                translated = true;
                state.appendLine(translation.toString());
            }
            catch (WSDLBindingTranslatorException e) {
                exceptions.add(e);
                errors.append("Binding " + i + " (" + this.bindings[i].getClass().getName() + ") failed - " + e + "\n");
            }
            ++i;
        }
        if (!translated) {
            this.log.logWarning(this.LOG_SOURCE, "All " + this.bindings.length + " bindings failed to translate default EPR for partner link '" + plink.name + "' (" + this.compiler_util.getQNameFromQName(plink.qtype) + ")");
            i = 0;
            while (i < exceptions.size()) {
                Exception tmp = (Exception)exceptions.get(i);
                this.log.logWarning(this.LOG_SOURCE, "Binding translation failure: " + tmp.getMessage());
                ++i;
            }
            throw new BPELTranslatorException(this.compiler_util, (Node)link, "All " + this.bindings.length + " bindings failed to translate default EPR for partner link '" + plink.name + "' (" + this.compiler_util.getQNameFromQName(plink.qtype) + ")");
        }
        this.nt.removeNamespaces(link);
    }

    public void translateVariables(BPELState state, Element variables, String debugVariablesId) throws BPELTranslatorException, NamespaceException {
        state.appendLine("//VARIABLES");
        state.incrementScope();
        int uid = this.nextUID();
        String lock = "nonLocalScopeVariablesLock" + uid;
        String init = "nonLocalScopeVariables" + uid;
        String init_this = "this_nonLocalScopeVariables" + uid;
        String method = "initNonLocalScopeVariables" + uid;
        if (this.compiler_util.getSwitches().FLOW_GRAPH_ASSET_OPTIMISATION) {
            state.appendDeclaration("static Object " + lock + " = new Object();");
            state.appendDeclaration("boolean " + init + " = false;");
            state.appendDeclaration("boolean " + init_this + " = false;");
            state.appendDeclaration("public void " + method + "() throws Exception {");
            state.appendDeclaration("  synchronized(" + lock + ") {");
            state.appendDeclaration("    if (!" + init + ") {");
            state.appendDeclaration("      " + init + " = true;");
            state.appendDeclaration("      " + init_this + " = true;");
        }
        ArrayList list = Util.getAllElements(variables, "variable");
        int i = 0;
        while (i < list.size()) {
            Element e = (Element)list.get(i);
            this.translateVariable(state, e, debugVariablesId);
            ++i;
        }
        if (this.compiler_util.getSwitches().FLOW_GRAPH_ASSET_OPTIMISATION) {
            state.appendDeclaration("    }");
            state.appendDeclaration("  }");
            state.appendDeclaration("}");
            state.appendLine("if (!" + init_this + ") " + method + "();");
        }
        i = 0;
        while (i < list.size()) {
            Element variable = (Element)list.get(i);
            String variableName = variable.getAttribute("name");
            Element fromElem = Util.getFirstElement(variable, "from");
            if (fromElem != null) {
                String ncname = NamespaceTranslator.getName(fromElem);
                String qname = fromElem.getTagName();
                String prefix = "";
                if (ncname.length() != qname.length()) {
                    prefix = qname.substring(0, qname.length() - ncname.length());
                }
                Document doc = variable.getOwnerDocument();
                Element toElem = doc.createElement(String.valueOf(prefix) + "to");
                toElem.setAttribute("variable", variableName);
                variable.appendChild(toElem);
                this.translateCopy(state, variable, 0);
                variable.removeChild(toElem);
            }
            ++i;
        }
        state.decrementScope();
        state.appendLine("");
    }

    public void translateVariable(BPELState state, Element variable, String debugVariablesId) throws BPELTranslatorException, NamespaceException {
        state.appendLine("//NEW VARIABLE");
        String name = variable.getAttribute("name");
        String messageType = variable.getAttribute("messageType");
        String schemaType = variable.getAttribute("type");
        String elementType = variable.getAttribute("element");
        if (name.length() == 0) {
            throw new BPELTranslatorException(this.compiler_util, (Node)variable, "no name specified for new variable: " + TranslatorUtils.toJavaString(variable));
        }
        String qmsg = null;
        if (messageType.length() > 0) {
            qmsg = this.nt.qualify(messageType, false);
            if (this.wsdlmap.getMessage(qmsg) == null) {
                throw new BPELTranslatorException(this.compiler_util, (Node)variable, "WSDL Message type " + messageType + " specified for variable but no WSDL message of that name found");
            }
        } else if (schemaType.length() > 0) {
            qmsg = this.nt.qualify(schemaType, false);
            if (this.xsdmap.getType(qmsg) == null) {
                throw new BPELTranslatorException(this.compiler_util, (Node)variable, "XSD type " + schemaType + " specified for variable but no XSD type of that name found");
            }
        } else if (elementType.length() > 0) {
            qmsg = this.nt.qualify(elementType, false);
            if (this.xsdmap.getRootElementTypeByQName(qmsg) == null) {
                throw new BPELTranslatorException(this.compiler_util, (Node)variable, "XSD Element " + elementType + " specified for variable but no XSD type mapping found for element of that name");
            }
            qmsg = this.xsdmap.getRootElementTypeByQName(qmsg).getQualifiedType();
        } else {
            throw new BPELTranslatorException(this.compiler_util, (Node)variable, "no WSDL message type (messageType), XML Schema type (type) or XML Schema element (element) specified for new variable: " + TranslatorUtils.toJavaString(variable));
        }
        this.scopes.addVariable(name, qmsg);
        this.lock_model.pushLock(this.compiler_util, variable, "IScopeLock:" + name);
        this.lock_model.pushLock(this.compiler_util, variable, "AssignLock:" + name);
        BPELAsset asset = this.getOrCreateVariable(this.scopes.getVariableName(name, variable), name, qmsg);
        if (this.compiler_util.getSwitches().FLOW_GRAPH_ASSET_OPTIMISATION) {
            state.appendDeclaration("      BPELVariable.createVariable(engine,\"" + this.scopes.getVariableName(name, variable) + "\"," + qmsg + ".toEngineMessage(new " + qmsg + "())," + asset.getJavaRef() + ");");
        } else {
            state.appendLine("BPELVariable.createVariable(engine,\"" + this.scopes.getVariableName(name, variable) + "\"," + qmsg + ".toEngineMessage(new " + qmsg + "())," + asset.getJavaRef() + ");");
            if (this.debug) {
                String msgDebugName = "bpel_variable_debug" + this.nextUID();
                state.appendLine("Message " + msgDebugName + " = new Message();");
                state.appendLine(String.valueOf(msgDebugName) + ".append(\"" + this.scopes.getVariableName(name, variable) + "\");");
                state.appendLine(String.valueOf(debugVariablesId) + ".append(" + msgDebugName + ");");
            }
        }
    }

    public void translatePreFaultHandlers(BPELState state, Element faultHandlers) throws BPELTranslatorException, NamespaceException {
        state.appendLine("//FAULT HANDLERS");
        state.appendLine("try {");
    }

    public void translatePostFaultHandlers(BPELState state, Element faultHandlers) throws BPELTranslatorException, NamespaceException {
        String faultVariableName = "bpel_fault_" + this.nextUID();
        state.appendLine("} catch (BPELFault " + faultVariableName + ") {");
        state.appendLine("myfault = " + faultVariableName + ";");
        ArrayList catches = Util.getAllElements(faultHandlers, "catch");
        Element catchAll = Util.getFirstElement(faultHandlers, "catchAll");
        boolean ifStarted = false;
        int i = 0;
        while (i < catches.size()) {
            Element ctch = (Element)catches.get(i);
            String faultName = ctch.getAttribute("faultName");
            ctch.getAttribute("faultVariable");
            ctch.getAttribute("faultMessageType");
            ctch.getAttribute("faultElement");
            if (ctch.hasAttribute("faultVariable")) {
                throw new BPELTranslatorException(this.compiler_util, (Node)ctch, "attribute 'faultVariable' on <catch> activity is currently not supported");
            }
            if (ctch.hasAttribute("faultMessageType")) {
                throw new BPELTranslatorException(this.compiler_util, (Node)ctch, "attribute 'faultMessageType' on <catch> activity is currently not supported");
            }
            if (ctch.hasAttribute("faultElement")) {
                throw new BPELTranslatorException(this.compiler_util, (Node)ctch, "attribute 'faultElement' on <catch> activity is currently not supported");
            }
            if (ifStarted) {
                state.appendNoLine("} else ");
            } else {
                ifStarted = true;
            }
            state.appendLine("if (" + faultVariableName + ".getFaultName().equals(\"" + TranslatorUtils.toJavaString(faultName) + "\")) {");
            state.appendLine("//CATCH " + faultName);
            this.translateActivities(state, ctch);
            state.appendLine("}");
            state.appendLine("//END CATCH");
            ++i;
        }
        if (catchAll != null) {
            if (ifStarted) {
                state.appendLine("} else {");
                state.appendLine("//CATCH ALL");
            } else {
                ifStarted = true;
                state.appendLine("//CATCH ALL");
                state.appendLine("if (true) {");
            }
            this.translateActivities(state, catchAll);
            state.appendLine("}");
            state.appendLine("//END CATCH");
        } else {
            if (ifStarted) {
                state.appendLine("} else {");
            }
            state.appendLine("throw " + faultVariableName + ";");
            if (ifStarted) {
                state.appendLine("}");
            }
        }
        state.appendLine("}");
        state.appendLine("//END FAULT HANDLERS");
    }

    private String getStackTrace(Throwable t) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(os);
        t.printStackTrace(ps);
        return os.toString();
    }

    public void translateReceive(BPELState state, Element receive) throws BPELTranslatorException, NamespaceException {
        String createInstance;
        state.appendLine("//RECEIVE");
        state.incrementScope();
        String partnerLink = receive.getAttribute("partnerLink");
        String operation = receive.getAttribute("operation");
        String inputVariable = receive.getAttribute("variable");
        String messageExchange = receive.getAttribute("messageExchange");
        if (!receive.hasAttribute("operation")) {
            throw new BPELTranslatorException(this.compiler_util, (Node)receive, "No 'operation' attribute found");
        }
        if (!receive.hasAttribute("partnerLink")) {
            throw new BPELTranslatorException(this.compiler_util, (Node)receive, "No 'partnerLink' attribute found");
        }
        if (messageExchange == null) {
            messageExchange = "";
        }
        if ((createInstance = receive.getAttribute("createInstance")).equals("yes")) {
            throw new BPELTranslatorException(this.compiler_util, (Node)receive, "createInstance=\"yes\" is not supported");
        }
        this.addVariableRef(inputVariable, receive);
        BPELPartnerLink plink = (BPELPartnerLink)this.partnerLinks.get(partnerLink);
        if (plink == null) {
            throw new BPELTranslatorException(this.compiler_util, (Node)receive, "No partnerLink '" + partnerLink + "' found");
        }
        BPELPartnerLinkRole prole = plink.myRole;
        String portType = prole.getQualifiedPortType();
        WSDLPortType wsdl_pt = this.wsdlmap.getPortType(portType);
        if (wsdl_pt == null) {
            throw new BPELTranslatorException(this.compiler_util, (Node)receive, "No portType '" + portType + "' found");
        }
        WSDLOperation wsdl_op = (WSDLOperation)wsdl_pt.name_to_operation.get(operation);
        if (wsdl_op == null) {
            throw new BPELTranslatorException(this.compiler_util, (Node)receive, "No operation '" + operation + "' found in portType '" + portType + "'");
        }
        String input_type = (String)wsdl_op.message_types.get("input");
        if (inputVariable == null || inputVariable.length() == 0) {
            throw new BPELTranslatorException(this.compiler_util, (Node)receive, "no input variable specified for receive (port " + portType + " operation " + operation + ")");
        }
        if (input_type == null) {
            throw new BPELTranslatorException(this.compiler_util, (Node)receive, "no input type found for receive (port " + portType + " operation " + operation + ")");
        }
        String qtype = this.scopes.getVariableQtype(inputVariable, receive);
        if (!input_type.equals(qtype)) {
            throw new BPELTranslatorException(this.compiler_util, (Node)receive, "receive variable has type " + this.compiler_util.getQNameFromQName(qtype) + " but operation requires different WSDL message type " + this.compiler_util.getQNameFromQName(input_type));
        }
        String partnerLinkFieldName = "bpel_partner_link" + this.nextUID();
        String eprFieldName = String.valueOf(partnerLinkFieldName) + ".myRole";
        int correlationSetID = this.nextUID();
        String correlationSetFieldName = "bpel_receive_correlation_" + correlationSetID;
        Element correlations = Util.getFirstElement(receive, "correlations");
        String inputMsgFieldName = "";
        int inputID = this.nextUID();
        if (inputVariable.length() > 0) {
            inputMsgFieldName = "param" + inputID;
        }
        String invoc = null;
        WSDLBindingTranslator used_binding = null;
        StringBuffer problems = new StringBuffer();
        int i = 0;
        while (i < this.bindings.length) {
            try {
                invoc = this.bindings[i].translateReceive(this.nt, portType, plink.requiredBindingName, operation, messageExchange, eprFieldName, correlationSetFieldName, inputMsgFieldName);
                used_binding = this.bindings[i];
                break;
            }
            catch (WSDLBindingTranslatorException e) {
                problems.append(this.getStackTrace(e));
                ++i;
            }
        }
        if (used_binding == null) {
            throw new BPELTranslatorException(this.compiler_util, (Node)receive, "no binding translator found for invocation.  partnerLink=" + partnerLink + ", operation=" + operation);
        }
        if (used_binding instanceof InternalBindingTranslator) {
            state.appendLine("BPELPartnerLink " + partnerLinkFieldName + " = BPELPartnerLink.getPartnerLink(\"" + this.getPartnerLinkName(plink.name) + "\");");
            state.appendLine("Message " + inputMsgFieldName + " = new Message();");
            if (correlations != null) {
                throw new BPELTranslatorException(this.compiler_util, (Node)receive, "<correlation> not supported for this binding");
            }
            if (invoc.endsWith("\n")) {
                state.appendNoLine(invoc);
            } else {
                state.appendLine(invoc);
            }
            state.appendLine("BPELVariable.setMessage(engine,\"" + this.scopes.getVariableName(inputVariable, receive) + "\"," + inputMsgFieldName + ");");
        } else {
            state.appendLine("BPELPartnerLink " + partnerLinkFieldName + " = BPELPartnerLink.getPartnerLink(\"" + this.getPartnerLinkName(plink.name) + "\");");
            state.appendLine(String.valueOf(input_type) + " " + inputMsgFieldName + " = new " + input_type + "();");
            state.appendLine("BPELCorrelationSet " + correlationSetFieldName + " = null;");
            if (invoc.endsWith("\n")) {
                state.appendNoLine(invoc);
            } else {
                state.appendLine(invoc);
            }
            if (correlations != null) {
                this.translateCorrelations(state, correlations, correlationSetFieldName, inputMsgFieldName, input_type, false, false);
            }
            state.appendLine("BPELVariable.setMessage(engine,\"" + this.scopes.getVariableName(inputVariable, receive) + "\"," + input_type + ".toEngineMessage(" + inputMsgFieldName + "));");
        }
        state.decrementScope();
        state.appendLine("");
        state.appendLine("//END RECEIVE");
    }

    public void translateReply(BPELState state, Element reply) throws BPELTranslatorException, NamespaceException {
        state.appendLine("//REPLY");
        state.incrementScope();
        String partnerLink = reply.getAttribute("partnerLink");
        String operation = reply.getAttribute("operation");
        String messageExchange = reply.getAttribute("messageExchange");
        String outputVariable = reply.getAttribute("variable");
        reply.getAttribute("faultName");
        if (!reply.hasAttribute("operation")) {
            throw new BPELTranslatorException(this.compiler_util, (Node)reply, "No 'operation' attribute found");
        }
        if (!reply.hasAttribute("partnerLink")) {
            throw new BPELTranslatorException(this.compiler_util, (Node)reply, "No 'partnerLink' attribute found");
        }
        if (messageExchange == null) {
            messageExchange = "";
        }
        this.addVariableRef(outputVariable, reply);
        BPELPartnerLink plink = (BPELPartnerLink)this.partnerLinks.get(partnerLink);
        if (plink == null) {
            throw new BPELTranslatorException(this.compiler_util, (Node)reply, "No partnerLink '" + partnerLink + "' found");
        }
        BPELPartnerLinkRole prole = plink.myRole;
        String portType = prole.getQualifiedPortType();
        WSDLPortType wsdl_pt = this.wsdlmap.getPortType(portType);
        if (wsdl_pt == null) {
            throw new BPELTranslatorException(this.compiler_util, (Node)reply, "No portType '" + portType + "' found");
        }
        WSDLOperation wsdl_op = (WSDLOperation)wsdl_pt.name_to_operation.get(operation);
        if (wsdl_op == null) {
            throw new BPELTranslatorException(this.compiler_util, (Node)reply, "No operation '" + operation + "' found in portType '" + portType + "'");
        }
        String output_type = (String)wsdl_op.message_types.get("output");
        if (outputVariable == null || outputVariable.length() == 0) {
            throw new BPELTranslatorException(this.compiler_util, (Node)reply, "no input variable specified for reply  (port " + portType + " operation " + operation + ")");
        }
        if (output_type == null) {
            throw new BPELTranslatorException(this.compiler_util, (Node)reply, "no input type found for reply (port " + portType + " operation " + operation + ")");
        }
        String qtype = this.scopes.getVariableQtype(outputVariable, reply);
        if (!output_type.equals(qtype)) {
            throw new BPELTranslatorException(this.compiler_util, (Node)reply, "reply variable has type " + this.compiler_util.getQNameFromQName(qtype) + " but operation requires different WSDL message type " + this.compiler_util.getQNameFromQName(output_type));
        }
        String partnerLinkFieldName = "bpel_partner_link" + this.nextUID();
        String eprFieldName = String.valueOf(partnerLinkFieldName) + ".myRole";
        int correlationSetID = this.nextUID();
        String correlationSetFieldName = "bpel_reply_correlation_" + correlationSetID;
        Element correlations = Util.getFirstElement(reply, "correlations");
        String outputMsgFieldName = "";
        int outputID = this.nextUID();
        if (outputVariable.length() > 0) {
            outputMsgFieldName = "ret" + outputID;
        }
        String invoc = null;
        WSDLBindingTranslator used_binding = null;
        StringBuffer problems = new StringBuffer();
        int i = 0;
        while (i < this.bindings.length) {
            try {
                invoc = this.bindings[i].translateReply(this.nt, portType, plink.requiredBindingName, operation, messageExchange, eprFieldName, correlationSetFieldName, outputMsgFieldName);
                used_binding = this.bindings[i];
                break;
            }
            catch (WSDLBindingTranslatorException e) {
                problems.append(this.getStackTrace(e));
                ++i;
            }
        }
        if (used_binding == null) {
            throw new BPELTranslatorException(this.compiler_util, (Node)reply, "no binding translator found for invocation.  partnerLink=" + partnerLink + ", operation=" + operation);
        }
        if (used_binding instanceof InternalBindingTranslator) {
            state.appendLine("BPELPartnerLink " + partnerLinkFieldName + " = BPELPartnerLink.getPartnerLink(\"" + this.getPartnerLinkName(plink.name) + "\");");
            state.appendLine("Message " + outputMsgFieldName + " = BPELVariable.getMessage(engine,\"" + this.scopes.getVariableName(outputVariable, reply) + "\");");
            if (correlations != null) {
                throw new BPELTranslatorException(this.compiler_util, (Node)reply, "<correlation> not supported for this binding");
            }
            if (invoc.endsWith("\n")) {
                state.appendNoLine(invoc);
            } else {
                state.appendLine(invoc);
            }
        } else {
            state.appendLine("BPELPartnerLink " + partnerLinkFieldName + " = BPELPartnerLink.getPartnerLink(\"" + this.getPartnerLinkName(plink.name) + "\");");
            state.appendLine(String.valueOf(output_type) + " " + outputMsgFieldName + " = (" + output_type + ") " + output_type + ".fromEngineMessage(BPELVariable.getMessage(engine,\"" + this.scopes.getVariableName(outputVariable, reply) + "\"));");
            state.appendLine("BPELCorrelationSet " + correlationSetFieldName + " = null;");
            if (correlations != null) {
                this.translateCorrelations(state, correlations, correlationSetFieldName, outputMsgFieldName, output_type, true, false);
            }
            if (invoc.endsWith("\n")) {
                state.appendNoLine(invoc);
            } else {
                state.appendLine(invoc);
            }
        }
        state.decrementScope();
        state.appendLine("");
        state.appendLine("//END REPLY");
    }

    public void translateCorrelations(BPELState state, Element correlations, String correlationSetFieldName, String xpathAccessibleFieldName, String xpathAccessibleType, boolean outgoing, boolean isInvocation) throws BPELTranslatorException, NamespaceException {
        ArrayList list = Util.getAllElements(correlations, "correlation");
        boolean merge = false;
        int i = 0;
        while (i < list.size()) {
            Element correlation = (Element)list.get(i);
            String set = correlation.getAttribute("set");
            String initiate = correlation.getAttribute("initiate");
            String pattern = correlation.getAttribute("pattern");
            if (initiate == null) {
                initiate = "no";
            }
            if (initiate.length() == 0) {
                initiate = "no";
            }
            boolean translate = false;
            if (!isInvocation) {
                translate = true;
            } else {
                if (pattern == null) {
                    throw new BPELTranslatorException(this.compiler_util, (Node)correlation, "<correlation> on <invoke> activity must specify a pattern (in|out|out-in)");
                }
                if (pattern.equals("in")) {
                    if (!outgoing) {
                        translate = true;
                    }
                } else if (pattern.equals("out")) {
                    if (outgoing) {
                        translate = true;
                    }
                } else if (pattern.equals("out-in")) {
                    translate = true;
                    if (!outgoing && initiate.equals("yes")) {
                        initiate = "no";
                    }
                } else {
                    throw new BPELTranslatorException(this.compiler_util, (Node)correlation, "'pattern' attribute of <correlation> must specify one of 'in', 'out' or 'out-in'");
                }
            }
            if (translate) {
                int k;
                String[] propertyNames;
                if (xpathAccessibleFieldName.length() == 0) {
                    if (isInvocation) {
                        if (outgoing) {
                            throw new BPELTranslatorException(this.compiler_util, (Node)correlations, "Correlation set with pattern=\"out\" specified but no corresponding inputVariable specified");
                        }
                        throw new BPELTranslatorException(this.compiler_util, (Node)correlations, "Correlation set with pattern=\"in\" specified but no corresponding outputVariable specified");
                    }
                    throw new BPELTranslatorException(this.compiler_util, (Node)correlations, "Correlation set specified but no corresponding variable specified");
                }
                if (initiate.equals("yes")) {
                    if (merge) {
                        state.appendLine(String.valueOf(correlationSetFieldName) + ".merge(");
                    } else {
                        state.appendLine(String.valueOf(correlationSetFieldName) + " = ");
                    }
                    state.appendLine("BPELCorrelationSet.createOrError(engine,\"" + this.scopes.getCorrelationSetName(set, correlation) + "\",new " + xpathAccessibleType + "(),");
                    state.incrementScope();
                    propertyNames = this.scopes.getCorrelationSetProperties(set, correlation);
                    state.appendLine("new BPELCorrelationToken[]{");
                    k = 0;
                    while (k < propertyNames.length) {
                        state.appendLine("  new BPELCorrelationToken(\"" + propertyNames[k] + "\"," + xpathAccessibleFieldName + "),");
                        ++k;
                    }
                    state.appendLine("}");
                    state.decrementScope();
                    state.appendLine(")");
                    if (merge) {
                        state.appendLine(")");
                    }
                    state.appendLine(";");
                } else if (initiate.equals("no")) {
                    if (merge) {
                        state.appendLine(String.valueOf(correlationSetFieldName) + ".merge(");
                    } else {
                        state.appendLine(String.valueOf(correlationSetFieldName) + " = ");
                    }
                    state.appendLine("BPELCorrelationSet.getOrError(engine,\"" + this.scopes.getCorrelationSetName(set, correlation) + "\")");
                    if (merge) {
                        state.appendLine(")");
                    }
                    state.appendLine(";");
                } else if (initiate.equals("join")) {
                    if (merge) {
                        state.appendLine(String.valueOf(correlationSetFieldName) + ".merge(");
                    } else {
                        state.appendLine(String.valueOf(correlationSetFieldName) + " = ");
                    }
                    state.appendLine("BPELCorrelationSet.getOrCreate(engine,\"" + this.scopes.getCorrelationSetName(set, correlation) + "\",new " + xpathAccessibleType + "(),");
                    state.incrementScope();
                    propertyNames = this.scopes.getCorrelationSetProperties(set, correlation);
                    state.appendLine("new BPELCorrelationToken[]{");
                    k = 0;
                    while (k < propertyNames.length) {
                        state.appendLine("  new BPELCorrelationToken(\"" + propertyNames[k] + "\"," + xpathAccessibleFieldName + "),");
                        ++k;
                    }
                    state.appendLine("}");
                    state.decrementScope();
                    state.appendLine(")");
                    if (merge) {
                        state.appendLine(")");
                    }
                    state.appendLine(";");
                } else {
                    throw new BPELTranslatorException(this.compiler_util, (Node)correlation, "'initiate' attribute of <correlation> must specify one of 'yes', 'no' or 'join'");
                }
                merge = true;
            }
            ++i;
        }
    }

    public void translateInvoke(BPELState state, Element invoke) throws BPELTranslatorException, NamespaceException {
        String qtype;
        state.appendLine("//INVOKE");
        state.incrementScope();
        String partnerLink = invoke.getAttribute("partnerLink");
        String operation = invoke.getAttribute("operation");
        String inputVariable = invoke.getAttribute("inputVariable");
        String outputVariable = invoke.getAttribute("outputVariable");
        if (!invoke.hasAttribute("operation")) {
            throw new BPELTranslatorException(this.compiler_util, (Node)invoke, "No 'operation' attribute found");
        }
        if (!invoke.hasAttribute("partnerLink")) {
            throw new BPELTranslatorException(this.compiler_util, (Node)invoke, "No 'partnerLink' attribute found");
        }
        this.addVariableRef(inputVariable, invoke);
        this.addVariableRef(outputVariable, invoke);
        BPELPartnerLink plink = (BPELPartnerLink)this.partnerLinks.get(partnerLink);
        if (plink == null) {
            throw new BPELTranslatorException(this.compiler_util, (Node)invoke, "No partnerLink '" + partnerLink + "' found");
        }
        BPELPartnerLinkRole prole = plink.partnerRole;
        String portType = prole.getQualifiedPortType();
        WSDLPortType wsdl_pt = this.wsdlmap.getPortType(portType);
        if (wsdl_pt == null) {
            throw new BPELTranslatorException(this.compiler_util, (Node)invoke, "No portType '" + portType + "' found");
        }
        WSDLOperation wsdl_op = (WSDLOperation)wsdl_pt.name_to_operation.get(operation);
        if (wsdl_op == null) {
            throw new BPELTranslatorException(this.compiler_util, (Node)invoke, "No operation '" + operation + "' found in portType '" + portType + "'");
        }
        String input_type = (String)wsdl_op.message_types.get("input");
        String output_type = (String)wsdl_op.message_types.get("output");
        if (inputVariable.length() > 0 && input_type == null) {
            throw new BPELTranslatorException(this.compiler_util, (Node)invoke, "inputVariable specified for invoke but no input found for that operation (port " + portType + " operation " + operation + ")");
        }
        if (outputVariable.length() > 0 && output_type == null) {
            throw new BPELTranslatorException(this.compiler_util, (Node)invoke, "outputVariable specified for invoke but no output found for that operation (port " + portType + " operation " + operation + ")");
        }
        if (input_type != null && !input_type.equals(qtype = this.scopes.getVariableQtype(inputVariable, invoke))) {
            throw new BPELTranslatorException(this.compiler_util, (Node)invoke, "invoke inputVariable has type " + this.compiler_util.getQNameFromQName(qtype) + " but operation requires different WSDL message type " + this.compiler_util.getQNameFromQName(input_type));
        }
        if (output_type != null && !output_type.equals(qtype = this.scopes.getVariableQtype(outputVariable, invoke))) {
            throw new BPELTranslatorException(this.compiler_util, (Node)invoke, "invoke outputVariable has type " + this.compiler_util.getQNameFromQName(qtype) + " but operation requires different WSDL message type " + this.compiler_util.getQNameFromQName(output_type));
        }
        if (wsdl_op.getType() == 1) {
            if (!invoke.hasAttribute("inputVariable")) {
                throw new BPELTranslatorException(this.compiler_util, (Node)invoke, "no inputVariable attribute specified for WSDL request-response operation");
            }
            if (!invoke.hasAttribute("outputVariable")) {
                throw new BPELTranslatorException(this.compiler_util, (Node)invoke, "no outputVariable attribute specified for WSDL request-response operation");
            }
        }
        if (wsdl_op.getType() == 0 && !invoke.hasAttribute("inputVariable")) {
            throw new BPELTranslatorException(this.compiler_util, (Node)invoke, "no inputVariable attribute specified for WSDL one-way operation");
        }
        String partnerLinkFieldName = "bpel_partner_link" + this.nextUID();
        String eprFieldName = String.valueOf(partnerLinkFieldName) + ".partnerRole";
        int correlationSetID = this.nextUID();
        String correlationSetFieldNameIn = "bpel_invoke_correlation_in_" + correlationSetID;
        String correlationSetFieldNameOut = "bpel_invoke_correlation_out_" + correlationSetID;
        Element correlations = Util.getFirstElement(invoke, "correlations");
        String inputMsgFieldName = "";
        int inputID = this.nextUID();
        String outputMsgFieldName = "";
        int outputID = this.nextUID();
        if (inputVariable.length() > 0) {
            inputMsgFieldName = "param" + inputID;
        }
        if (outputVariable.length() > 0) {
            outputMsgFieldName = "ret" + outputID;
        }
        String invoc = null;
        WSDLBindingTranslator used_binding = null;
        ArrayList<WSDLBindingTranslatorException> exceptions = new ArrayList<WSDLBindingTranslatorException>();
        StringBuffer problems = new StringBuffer();
        int i = 0;
        while (i < this.bindings.length) {
            try {
                invoc = this.bindings[i].translateInvocation(this.nt, portType, plink.requiredBindingName, operation, eprFieldName, correlationSetFieldNameIn, correlationSetFieldNameOut, inputMsgFieldName, outputMsgFieldName);
                used_binding = this.bindings[i];
                break;
            }
            catch (WSDLBindingTranslatorException e) {
                exceptions.add(e);
                problems.append(this.getStackTrace(e));
                ++i;
            }
        }
        if (used_binding == null) {
            i = 0;
            while (i < exceptions.size()) {
                Exception tmp = (Exception)exceptions.get(i);
                this.log.logWarning(this.LOG_SOURCE, "Binding translation failure: " + tmp.getMessage());
                ++i;
            }
            throw new BPELTranslatorException(this.compiler_util, (Node)invoke, "no binding translator found for invocation (see error log for more info).  partnerLink=" + partnerLink + ", operation=" + operation);
        }
        this.translatePreFaultHandlers(state, invoke);
        if (used_binding instanceof InternalBindingTranslator) {
            state.appendLine("BPELPartnerLink " + partnerLinkFieldName + " = BPELPartnerLink.getPartnerLink(\"" + this.getPartnerLinkName(plink.name) + "\");");
            state.appendLine("Message " + inputMsgFieldName + " = BPELVariable.getMessage(engine,\"" + this.scopes.getVariableName(inputVariable, invoke) + "\");");
            if (outputVariable.length() > 0) {
                state.appendLine("Message " + outputMsgFieldName + " = null;");
            }
            if (correlations != null) {
                throw new BPELTranslatorException(this.compiler_util, (Node)invoke, "<correlation> not supported for this binding");
            }
            if (invoc.endsWith("\n")) {
                state.appendNoLine(invoc);
            } else {
                state.appendLine(invoc);
            }
            if (outputVariable.length() > 0) {
                state.appendLine("BPELVariable.setMessage(engine,\"" + this.scopes.getVariableName(outputVariable, invoke) + "\"," + outputMsgFieldName + ");");
            }
        } else {
            state.appendLine("BPELPartnerLink " + partnerLinkFieldName + " = BPELPartnerLink.getPartnerLink(\"" + this.getPartnerLinkName(plink.name) + "\");");
            state.appendLine("try {");
            state.appendLine(String.valueOf(input_type) + " " + inputMsgFieldName + " = (" + input_type + ") " + input_type + ".fromEngineMessage(BPELVariable.getMessage(engine,\"" + this.scopes.getVariableName(inputVariable, invoke) + "\"));");
            if (outputVariable.length() > 0) {
                state.appendLine(String.valueOf(output_type) + " " + outputMsgFieldName + " = new " + output_type + "();");
            }
            state.appendLine("BPELCorrelationSet " + correlationSetFieldNameIn + " = null;");
            state.appendLine("BPELCorrelationSet " + correlationSetFieldNameOut + " = null;");
            if (correlations != null) {
                this.translateCorrelations(state, correlations, correlationSetFieldNameOut, inputMsgFieldName, input_type, true, true);
            }
            if (invoc.endsWith("\n")) {
                state.appendNoLine(invoc);
            } else {
                state.appendLine(invoc);
            }
            if (correlations != null) {
                this.translateCorrelations(state, correlations, correlationSetFieldNameIn, outputMsgFieldName, output_type, false, true);
            }
            if (outputVariable.length() > 0) {
                state.appendLine("BPELVariable.setMessage(engine,\"" + this.scopes.getVariableName(outputVariable, invoke) + "\"," + output_type + ".toEngineMessage(" + outputMsgFieldName + "));");
            }
            state.appendLine("} catch (BPELFault t) {");
            state.appendLine("  throw t;");
            state.appendLine("} catch (Throwable t) {");
            state.appendLine("  throw new BPELFault(t);");
            state.appendLine("}");
        }
        this.translatePostFaultHandlers(state, invoke);
        state.decrementScope();
        state.appendLine("");
    }

    public void translateFlow(BPELState state, Element flow) throws BPELTranslatorException, NamespaceException {
        this.lock_model.pushNewThreads(this.compiler_util, flow);
        this.flow_scopes.pushScope("bpelThreadIdList.get(" + (this.bpel_threads.size() - 1) + ")", false, flow);
        state.appendLine("//FLOW");
        state.incrementScope();
        BPELThread currthread = (BPELThread)this.bpel_threads.peek();
        BPELFlow bpflow = new BPELFlow(currthread);
        currthread.flows.add(bpflow);
        ArrayList list = Util.getAllElements(flow);
        int i = 0;
        while (i < list.size()) {
            Element links = (Element)list.get(i);
            if (NamespaceTranslator.getName(links).equals("links")) {
                this.translateLinks(state, links);
            }
            ++i;
        }
        int flowID = this.nextUID();
        state.appendLine("Message flowMessage" + flowID + " = new Message();");
        state.appendLine("");
        state.appendLine("//launch a new engine runner for each of the activities in this flow");
        state.appendLine("String[] hosts" + flowID + " = engine.getHostsArray();");
        state.appendLine("Message args" + flowID + " = new Message();");
        state.appendLine("Message callstack" + flowID + " = ((Runner)engine).getStackContents();");
        state.appendLine("args" + flowID + ".append(callstack" + flowID + ");");
        state.appendLine("args" + flowID + ".append(bpelThreadIdList);");
        state.appendLine("int threadId" + flowID + " = 1;");
        state.appendLine("Object deploymentStrategy" + flowID + " = " + DeploymentStrategyPort.class.getName() + ".getDeploymentStrategy();");
        state.appendLine(String.valueOf(DeploymentStrategyPort.class.getName()) + ".setDeploymentStrategy(" + DeploymentStrategyPort.class.getName() + ".DEPLOYMENT_STRATEGY_EVEN_SPREAD);");
        int i2 = 0;
        while (i2 < list.size()) {
            Element elem = (Element)list.get(i2);
            boolean threadcopies = false;
            String threadcount = "1";
            if (elem.hasAttribute("threadcount")) {
                try {
                    XPATHTreeTranslator resolver = new XPATHTreeTranslator();
                    String xpath_method = this.getNextXPath();
                    String expr = resolver.resolveToNumber(xpath_method, elem.getAttribute("threadcount"), this.compiler_util.getSwitches(), this.nt, this.scopes, this.flow_scopes, this.wsdlmap, elem);
                    state.appendDeclaration(expr);
                    threadcount = String.valueOf(xpath_method) + "()";
                }
                catch (Exception e) {
                    throw new BPELTranslatorException(this.compiler_util, (Node)elem, e);
                }
                threadcopies = true;
            }
            BPELState newstate = state.newState();
            state.appendLine("int flow_loop_maximum_" + flowID + "_" + i2 + " = (int)" + threadcount + ";");
            state.appendLine("for (int i" + flowID + " = 0; i" + flowID + " < flow_loop_maximum_" + flowID + "_" + i2 + "; i" + flowID + "++) {");
            state.appendLine("  args" + flowID + ".append(threadId" + flowID + ");");
            state.appendLine("  String childBpelThreadId = bpelThreadId + \":\"+(threadId" + flowID + "++);");
            state.appendLine("  bpelThreadIdList.append(childBpelThreadId);");
            state.appendLine("if (deploymentStrategy" + flowID + " == " + DeploymentStrategyPort.class.getName() + ".DEPLOYMENT_STRATEGY_EVEN_SPREAD) { ");
            state.appendLine("  flowMessage" + flowID + ".appendAll(engine.launchRunner(1,\"" + newstate.getMethodName() + "\",((++flowHost)%hosts" + flowID + ".length),args" + flowID + "));");
            state.appendLine("} else if (deploymentStrategy" + flowID + " == " + DeploymentStrategyPort.class.getName() + ".DEPLOYMENT_STRATEGY_SPECIFIC_HOST) { ");
            state.appendLine("  flowMessage" + flowID + ".appendAll(engine.launchRunner(1,\"" + newstate.getMethodName() + "\"," + DeploymentStrategyPort.class.getName() + ".getSpecificHostIndex(),args" + flowID + "));");
            state.appendLine("} else {");
            state.appendLine("  flowMessage" + flowID + ".appendAll(engine.launchRunner(1,\"" + newstate.getMethodName() + "\",0,args" + flowID + "));");
            state.appendLine("}");
            state.appendLine("  args" + flowID + ".pop();");
            state.appendLine("  bpelThreadIdList.pop();");
            state.appendLine("}");
            newstate.appendLine("    Message flow_stack" + flowID + " = (Message)runner_args.get(0);");
            newstate.appendLine("    ((Runner)engine).setStackContents(flow_stack" + flowID + ");");
            newstate.appendLine("    bpelThreadIdList = (Message)runner_args.get(1);");
            newstate.appendLine("    bpelThreadChildIndex = ((Number)runner_args.get(2)).intValue();");
            newstate.appendLine("    bpelThreadId = (String)bpelThreadIdList.get(bpelThreadIdList.length()-1);");
            if (this.debug) {
                newstate.appendLine("    bpelThreadMap = engine.getHashMap(\"BPEL_THREADS_MAP\");");
                newstate.appendLine("    bpelThreadMap.put(bpelThreadId,bpelThreadId);");
                newstate.appendLine("    bpelDebugMap = engine.getHashMap(\"BPEL_DEBUG_MAP\");");
                newstate.appendLine("    bpelDebugSuspend = engine.getVariable(\"BPEL_BREAKPOINT_VAR\");");
                newstate.appendLine("    bpelDebugStack = new Message(0);");
                newstate.appendLine("    bpelDebugStack.append(bpelThreadId);");
                newstate.appendLine("    engine.ipushStack(bpelDebugStack);");
            }
            newstate.appendLine("    engine.ipushStack(\"BPEL **new thread - " + newstate.getMethodName() + " " + TranslatorUtils.toJavaString(this.compiler_util.getBpelLineNumberString(flow)) + "**\");");
            if (this.debug) {
                newstate.appendLine("    try {");
            }
            BPELThread thread = new BPELThread(bpflow);
            thread.multiple_copies = threadcopies;
            thread.state = newstate;
            bpflow.threads.add(thread);
            this.bpel_threads.push(thread);
            this.lock_model.pushNewThread(this.compiler_util, flow, "Thread_" + this.nextUID());
            newstate.appendDeclaration("boolean localVariableInit" + thread.id + " = false;");
            newstate.appendLine("if (!localVariableInit" + thread.id + ") {");
            newstate.mark(INSERT_LOCAL_VARIABLE_CREATION);
            newstate.appendLine("}");
            this.translateActivity(newstate, (Element)list.get(i2), i2 + 1);
            if (this.debug) {
                newstate.appendLine("    } catch (Exception bpelRunnerThreadException) {");
                newstate.appendLine("      bpelDebugMap.put(bpelThreadId+\"_TERMINATED\",new Integer(1));");
                newstate.appendLine("      throw bpelRunnerThreadException;");
                newstate.appendLine("    }");
            }
            this.lock_model.popThread(this.compiler_util, flow);
            if (threadcopies) {
                this.lock_model.duplicatePreviousThread(this.compiler_util, flow);
            }
            this.bpel_threads.pop();
            ++i2;
        }
        state.appendLine("");
        state.appendLine("args" + flowID + " = null;");
        state.appendLine("callstack" + flowID + " = null;");
        state.appendLine("//wait for each of those activities to finish");
        state.appendLine("for (int i = 0; i < flowMessage" + flowID + ".length(); i++) {");
        state.appendLine("  Long tmp = (Long)flowMessage" + flowID + ".get(i);");
        state.appendLine("  engine.joinRunner(tmp);");
        state.appendLine("}");
        state.decrementScope();
        state.appendLine("//END FLOW");
        this.flow_scopes.popScope(flow);
        this.lock_model.popThreads(this.compiler_util, flow);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void translateFrom(BPELState state, Element from, String totypeClass, String totypeField) throws BPELTranslatorException, NamespaceException {
        boolean fieldPassing;
        boolean bl = fieldPassing = totypeField != null;
        if (!fieldPassing) {
            totypeField = totypeClass;
        }
        if (from.hasAttribute("variable")) {
            String fromvariable = from.getAttribute("variable");
            String qtype = this.scopes.getVariableQtype(fromvariable, from);
            this.addVariableRef(fromvariable, from);
            if (from.hasAttribute("part")) {
                String frompart = from.getAttribute("part");
                WSDLMessage wsdlmessage = this.wsdlmap.getMessage(qtype);
                if (wsdlmessage == null) {
                    throw new BPELTranslatorException(this.compiler_util, (Node)from, "WSDL Message " + qtype + " not found");
                }
                String parttype = wsdlmessage.getPartType(frompart);
                if (parttype == null) {
                    throw new BPELTranslatorException(this.compiler_util, (Node)from, "WSDL Message part type " + frompart + " not found (message type " + qtype + ")");
                }
                Element fromQuery = Util.getFirstElement(from, "query");
                if (fromQuery != null) {
                    throw new BPELTranslatorException(this.compiler_util, (Node)from, "<query> element under <assign><copy> has been removed in a more recent version of the BPEL specification");
                }
                state.appendNoLine("((" + qtype + ") " + qtype + ".fromEngineMessage(");
                state.appendNoLine("BPELVariable.getMessage(engine,\"" + this.scopes.getVariableName(fromvariable, from) + "\")");
                state.appendNoLine("))." + NamespaceTranslator.getElement(frompart) + "[0]");
                return;
            } else if (from.hasAttribute("property")) {
                String property = from.getAttribute("property");
                String qpropName = this.nt.qualify(property, false);
                state.appendNoLine("((" + qtype + ") " + qtype + ".fromEngineMessage(");
                state.appendNoLine("BPELVariable.getMessage(engine,\"" + this.scopes.getVariableName(fromvariable, from) + "\")");
                state.appendNoLine(")).getBpelProperty(\"" + qpropName + "\").get(0).getValue()");
                return;
            } else {
                state.appendNoLine("((" + qtype + ") " + qtype + ".fromEngineMessage(");
                state.appendNoLine("BPELVariable.getMessage(engine,\"" + this.scopes.getVariableName(fromvariable, from) + "\")");
                state.appendNoLine("))");
            }
            return;
        }
        if (from.hasAttribute("partnerLink")) {
            String partnerLink = from.getAttribute("partnerLink");
            String role = from.getAttribute("endpointReference");
            String plinkName = this.getPartnerLinkName(partnerLink);
            if (role == null) {
                throw new BPELTranslatorException(this.compiler_util, (Node)from, "copy from partner link must specify endpointReference attribute");
            }
            if (role.equals("myRole")) {
                state.appendNoLine("BPELPartnerLink.getPartnerLink(\"" + plinkName + "\").myRole");
                return;
            } else {
                if (!role.equals("partnerRole")) throw new BPELTranslatorException(this.compiler_util, (Node)from, "endpointReference attribute int partner link assignment must be either 'myRole' or 'partnerRole'");
                state.appendNoLine("BPELPartnerLink.getPartnerLink(\"" + plinkName + "\").partnerRole");
            }
            return;
        }
        if (from.hasAttribute("expression")) {
            throw new BPELTranslatorException(this.compiler_util, (Node)from, "The 'expression' attribute on the <from> part of the <assign><copy> activity was removed in an updated version of the BPEL specification");
        }
        Element literal_elem = Util.getFirstElement(from, "literal");
        if (literal_elem == null) {
            Element expression_elem = Util.getFirstElement(from, "expression");
            if (expression_elem != null) {
                throw new BPELTranslatorException(this.compiler_util, (Node)from, "<expression> element under <assign>..<from> was removed in a later version of the BPEL specification");
            }
            String expression = Util.getTextDirectlyUnder(from);
            try {
                XPATHTreeTranslator resolver = new XPATHTreeTranslator();
                String xpath_method = this.getNextXPath();
                String expr = fieldPassing ? resolver.resolveToTypeUsingInstance(xpath_method, expression, this.compiler_util.getSwitches(), this.nt, totypeClass, totypeField, this.scopes, this.flow_scopes, this.wsdlmap, from) : resolver.resolveToType(xpath_method, expression, this.compiler_util.getSwitches(), this.nt, totypeClass, this.scopes, this.flow_scopes, this.wsdlmap, from);
                state.appendDeclaration(expr);
                if (fieldPassing) {
                    state.appendNoLine(String.valueOf(xpath_method) + "(" + totypeField + ")");
                } else {
                    state.appendNoLine(String.valueOf(xpath_method) + "()");
                }
                this.addVariableRefs(resolver.getReferencedVariables(), from);
                return;
            }
            catch (Exception e) {
                throw new BPELTranslatorException(this.compiler_util, (Node)from, e);
            }
        }
        StringBuffer text = new StringBuffer();
        NodeList list = literal_elem.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            Node node = list.item(i);
            if (node.getNodeType() != Node.COMMENT_NODE) {
                try {
                    String nodeContents = XMLUtil.nodeToString(node);
                    nodeContents = TranslatorUtils.toJavaString(nodeContents);
                    text.append(nodeContents);
                }
                catch (Exception e) {
                    throw new BPELTranslatorException(this.compiler_util, (Node)from, e);
                }
            }
            ++i;
        }
        if (totypeClass == null) {
            throw new BPELTranslatorException(this.compiler_util, (Node)from, "cannot assign an XSD type to an entire WSDL message, need to assign to a part of a message");
        }
        if (this.compiler_util.getSwitches().ASSIGN_CONSTANTS_CACHING) {
            int constID = this.nextUID();
            String assignConstant = "assignConstant" + constID;
            state.appendDeclaration("static " + totypeClass + " " + assignConstant + " = null;");
            if (fieldPassing) {
                state.appendDeclaration("public " + totypeClass + " getAssignConstant" + constID + "(" + totypeClass + " " + totypeField + ") throws Exception {");
            } else {
                state.appendDeclaration("public " + totypeClass + " getAssignConstant" + constID + "() throws Exception {");
            }
            state.appendDeclaration("  if (" + assignConstant + " == null) {");
            if (fieldPassing) {
                state.appendDeclaration("    " + assignConstant + " = (" + totypeClass + ") " + totypeField + ".ifromXML(\"" + text.toString().trim() + "\");");
            } else {
                state.appendDeclaration("    " + assignConstant + " = (" + totypeClass + ") " + totypeField + ".fromXML(\"" + text.toString().trim() + "\");");
            }
            state.appendDeclaration("  }");
            state.appendDeclaration("  return " + assignConstant + ";");
            state.appendDeclaration("}\n");
            if (fieldPassing) {
                state.appendNoLine("getAssignConstant" + constID + "(" + totypeField + ")");
                return;
            } else {
                state.appendNoLine("getAssignConstant" + constID + "()");
            }
            return;
        } else if (fieldPassing) {
            state.appendNoLine("(" + totypeClass + ") " + totypeField + ".ifromXML(\"" + text + "\")");
            return;
        } else {
            state.appendNoLine("(" + totypeClass + ") " + totypeField + ".fromXML(\"" + text + "\")");
        }
    }

    private static String[] getVariableAndPartOnly(Element expression) {
        String query = Util.getTextDirectlyUnder(expression).trim();
        return BPELTranslator.getVariableAndPartOnly(query);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String[] getVariableAndPartOnly(String query) {
        boolean error = false;
        String var = null;
        String part = null;
        int i = 0;
        char[] cs = query.toCharArray();
        while (i < cs.length) {
            if (part != null) {
                if (!Character.isJavaLetterOrDigit(cs[i])) return null;
                part = String.valueOf(part) + cs[i];
            } else if (var != null) {
                if (Character.isJavaLetterOrDigit(cs[i])) {
                    var = String.valueOf(var) + cs[i];
                } else {
                    if (cs[i] != '.') return null;
                    part = "";
                }
            } else {
                if (cs[i] != '$') return null;
                var = "";
            }
            ++i;
        }
        if (!error) return new String[]{var, part};
        return null;
    }

    public void translateCopy(BPELState state, Element copy, int index) throws BPELTranslatorException, NamespaceException {
        state.appendLine("//COPY");
        state.incrementScope();
        Element from = Util.getFirstElement(copy, "from");
        Element to = Util.getFirstElement(copy, "to");
        if (from == null) {
            throw new BPELTranslatorException(this.compiler_util, (Node)copy, "Expected <from> element but found none");
        }
        if (to == null) {
            throw new BPELTranslatorException(this.compiler_util, (Node)copy, "Expected <to> element but found none");
        }
        if (this.compiler_util.getSwitches().APPEND_BPEL_TO_CALLSTACK) {
            state.appendLine("engine.ipushStack(\"BPEL " + TranslatorUtils.toJavaString(copy) + " (elem" + index + ") " + TranslatorUtils.toJavaString(this.compiler_util.getBpelLineNumberString(copy)) + " " + TranslatorUtils.toJavaString(from) + "->" + TranslatorUtils.toJavaString(to) + "\");");
        }
        String[] fromparts = BPELTranslator.getVariableAndPartOnly(from);
        String[] toparts = BPELTranslator.getVariableAndPartOnly(to);
        if (!(from.hasAttribute("variable") || from.hasAttribute("part") || from.hasAttribute("property") || from.hasAttribute("partnerLink") || to.hasAttribute("variable") || to.hasAttribute("part") || to.hasAttribute("property") || to.hasAttribute("partnerLink") || fromparts == null || toparts == null || (fromparts[1] == null || toparts[1] == null) && (fromparts[1] != null || toparts[1] != null))) {
            String[] varpart = BPELTranslator.getVariableAndPartOnly(from);
            if (varpart != null) {
                if (varpart[0] != null) {
                    from.setAttribute("variable", varpart[0]);
                    this.log.logWarning(this.LOG_SOURCE, "Munged <from> element at " + this.compiler_util.getBpelLineNumberString(from) + ", adding variable " + varpart[0]);
                    if (varpart[1] != null) {
                        from.setAttribute("part", varpart[1]);
                        this.log.logWarning(this.LOG_SOURCE, "Munged <from> element at " + this.compiler_util.getBpelLineNumberString(from) + ", adding variable part " + varpart[1]);
                    }
                }
            } else {
                this.log.logWarning(this.LOG_SOURCE, "Couldn't munge <from> element at " + this.compiler_util.getBpelLineNumberString(from));
            }
            if ((varpart = BPELTranslator.getVariableAndPartOnly(to)) != null) {
                if (varpart[0] != null) {
                    to.setAttribute("variable", varpart[0]);
                    this.log.logWarning(this.LOG_SOURCE, "Munged <to> element at " + this.compiler_util.getBpelLineNumberString(to) + ", adding variable " + varpart[0]);
                    if (varpart[1] != null) {
                        to.setAttribute("part", varpart[1]);
                        this.log.logWarning(this.LOG_SOURCE, "Munged <to> element at " + this.compiler_util.getBpelLineNumberString(to) + ", adding variable part " + varpart[1]);
                    }
                }
            } else {
                this.log.logWarning(this.LOG_SOURCE, "Couldn't munge <to> element at " + this.compiler_util.getBpelLineNumberString(to));
            }
        }
        if (to.hasAttribute("variable")) {
            String tovariable = to.getAttribute("variable");
            String qtype = this.scopes.getVariableQtype(tovariable, copy);
            this.addVariableRef(tovariable, to);
            if (qtype == null) {
                throw new BPELTranslatorException(this.compiler_util, (Node)copy, "BPEL <copy>: could not find type for variable " + tovariable);
            }
            Element toQuery = Util.getFirstElement(to, "query");
            if (toQuery != null) {
                throw new BPELTranslatorException(this.compiler_util, (Node)copy, "<query> element under <assign><copy> has been removed in an up to date version of the BPEL specification");
            }
            if (to.hasAttribute("part")) {
                String topart = to.getAttribute("part");
                int msg = this.nextUID();
                state.appendLine(String.valueOf(qtype) + " assign" + msg + " = (" + qtype + ") " + qtype + ".fromEngineMessage(BPELVariable.getMessage(engine,\"" + this.scopes.getVariableName(tovariable, to) + "\"));");
                WSDLMessage wsdlmsg = this.wsdlmap.getMessage(qtype);
                if (wsdlmsg == null) {
                    throw new BPELTranslatorException(this.compiler_util, (Node)copy, "BPEL <copy>: Could not find WSDL Message " + qtype);
                }
                String parttype = (String)wsdlmsg.part_to_xsdtype.get(topart);
                if (parttype == null) {
                    throw new BPELTranslatorException(this.compiler_util, (Node)copy, "XSD part " + topart + " not found in WSDL message " + qtype + ")");
                }
                state.appendLine("assign" + msg + "." + NamespaceTranslator.getElement(topart) + " = new " + parttype + "[1];");
                state.appendNoLine("assign" + msg + "." + NamespaceTranslator.getElement(topart) + "[0] = ");
                this.translateFrom(state, from, parttype, null);
                state.appendLine(";");
                state.appendLine("BPELVariable.setMessage(engine,\"" + this.scopes.getVariableName(tovariable, to) + "\", " + qtype + ".toEngineMessage(assign" + msg + "));");
            } else if (to.hasAttribute("property")) {
                String toproperty = to.getAttribute("property");
                String qpropName = this.nt.qualify(toproperty, false);
                int msg = this.nextUID();
                int nset = this.nextUID();
                state.appendLine(String.valueOf(qtype) + " assign" + msg + " = (" + qtype + ") " + qtype + ".fromEngineMessage(BPELVariable.getMessage(engine,\"" + this.scopes.getVariableName(tovariable, to) + "\"));");
                state.appendNoLine("XNodeSet assignSet" + nset + " = ");
                state.appendNoLine("assign" + msg + ".getBpelProperty(\"" + qpropName + "\")");
                state.appendLine(";");
                state.appendLine("XNode assignNode" + nset + " = assignSet" + nset + ".get(0);");
                String qanyType = XMLAccessible.class.getName();
                state.appendLine(String.valueOf(qanyType) + " assignTo" + nset + " = (" + qanyType + ")assignNode" + nset + ".getValue();");
                state.appendNoLine("assignNode" + nset + ".setValueInContainer(");
                this.translateFrom(state, from, qanyType, "assignTo" + nset);
                state.appendLine(");");
                state.appendLine("while (assignNode" + nset + ".getParent() != null) assignNode" + nset + " = assignNode" + nset + ".getParent();");
                state.appendLine("BPELVariable.setMessage(engine,\"" + this.scopes.getVariableName(tovariable, to) + "\", " + qtype + ".toEngineMessage(assignNode" + nset + ".getValue()));");
            } else {
                state.appendNoLine("BPELVariable.setMessage(engine,\"" + this.scopes.getVariableName(tovariable, to) + "\"," + qtype + ".toEngineMessage(");
                this.translateFrom(state, from, qtype, null);
                state.appendLine("));");
            }
        } else if (to.hasAttribute("partnerLink")) {
            String partnerLink = to.getAttribute("partnerLink");
            String plinkName = this.getPartnerLinkName(partnerLink);
            String pvar = "bpel_partner_link" + this.nextUID();
            state.appendLine("BPELPartnerLink " + pvar + " = BPELPartnerLink.getPartnerLink(\"" + plinkName + "\");\n");
            state.appendNoLine(String.valueOf(pvar) + ".partnerRole = ");
            this.translateFrom(state, from, WSEndpointReference.class.getName(), null);
            state.appendLine(";");
            state.appendLine(String.valueOf(pvar) + ".myRole = " + pvar + ".partnerRole;");
            state.appendLine("BPELPartnerLink.setPartnerLink(\"" + plinkName + "\"," + pvar + ");");
        } else {
            int nset = this.nextUID();
            String query = Util.getTextDirectlyUnder(to);
            StringBuffer variablebuf = new StringBuffer();
            int varStart = query.indexOf(36);
            if (varStart == -1) {
                throw new BPELTranslatorException(this.compiler_util, (Node)to, "could not find variable name under <assign>..<to> element");
            }
            int k = varStart + 1;
            while (k < query.length()) {
                char c = query.charAt(k);
                if (c == '/' || c == '.' || c == '\\' || Character.isWhitespace(c)) break;
                variablebuf.append(c);
                ++k;
            }
            String tovariable = variablebuf.toString();
            String qtype = this.scopes.getVariableQtype(tovariable, copy);
            this.addVariableRef(tovariable, to);
            if (qtype == null) {
                throw new BPELTranslatorException(this.compiler_util, (Node)copy, "BPEL <copy>: could not find type for variable " + tovariable);
            }
            state.appendNoLine("XNodeSet assignSet" + nset + " = ");
            try {
                XPATHTreeTranslator resolver = new XPATHTreeTranslator();
                String xpath_method = this.getNextXPath();
                String expr = resolver.resolveToNodeSet(xpath_method, query, this.compiler_util.getSwitches(), this.nt, this.scopes, this.flow_scopes, this.wsdlmap, to);
                state.appendDeclaration(expr);
                state.appendNoLine(String.valueOf(xpath_method) + "()");
                this.addVariableRefs(resolver.getReferencedVariables(), from);
            }
            catch (Exception e) {
                throw new BPELTranslatorException(this.compiler_util, (Node)from, e);
            }
            state.appendLine(";");
            state.appendLine("XNode assignNode" + nset + " = assignSet" + nset + ".get(0);");
            String qanyType = XMLAccessible.class.getName();
            state.appendLine(String.valueOf(qanyType) + " assignTo" + nset + " = (" + qanyType + ")assignNode" + nset + ".getValue();");
            state.appendNoLine("assignNode" + nset + ".setValueInContainer(");
            this.translateFrom(state, from, qanyType, "assignTo" + nset);
            state.appendNoLine(",true");
            state.appendLine(");");
            state.appendLine("while (assignNode" + nset + ".getParent() != null) assignNode" + nset + " = assignNode" + nset + ".getParent();");
            state.appendLine("BPELVariable.setMessage(engine,\"" + this.scopes.getVariableName(tovariable, to) + "\", " + qtype + ".toEngineMessage(assignNode" + nset + ".getValue()));");
        }
        if (this.compiler_util.getSwitches().APPEND_BPEL_TO_CALLSTACK) {
            state.appendLine("engine.ipopStack();");
        }
        state.decrementScope();
        state.appendLine("");
    }

    public void translateAssign(BPELState state, Element assign) throws BPELTranslatorException, NamespaceException {
        state.appendLine("//ASSIGN");
        state.incrementScope();
        int isolatedScopeIndex = this.pushScope(state, assign, true, true);
        ArrayList list = Util.getAllElements(assign);
        int i = 0;
        while (i < list.size()) {
            Element copy = (Element)list.get(i);
            if (NamespaceTranslator.getName(copy).equals("copy")) {
                this.translateCopy(state, copy, i);
            } else {
                this.log.logWarning(this.LOG_SOURCE, "unrecognised tag name compiling assign \"" + copy.getTagName() + "\"");
            }
            ++i;
        }
        this.popScope(state, assign, isolatedScopeIndex, true);
        state.decrementScope();
        state.appendLine("//END ASSIGN");
        state.appendLine("");
    }

    public void translateForDuration(BPELState state, String for_duration, Node source) throws BPELTranslatorException {
        try {
            this.nt.qualify("xsd:duration", false);
            XPATHTreeTranslator resolver = new XPATHTreeTranslator();
            String xpath_method = this.getNextXPath();
            String expr = resolver.resolveToDurationInMillis(xpath_method, for_duration, this.compiler_util.getSwitches(), this.nt, this.scopes, this.flow_scopes, this.wsdlmap, source);
            state.appendDeclaration(expr);
            state.appendNoLine(String.valueOf(xpath_method) + "()");
            this.addVariableRefs(resolver.getReferencedVariables(), source);
        }
        catch (Exception e) {
            throw new BPELTranslatorException(this.compiler_util, source, e);
        }
    }

    public void translateUntilDeadline(BPELState state, String until_deadline, Node source) throws BPELTranslatorException {
        try {
            this.nt.qualify("xsd:dateTime", false);
            XPATHTreeTranslator resolver = new XPATHTreeTranslator();
            String xpath_method = this.getNextXPath();
            String expr = resolver.resolveToDateOrDateTimeInMillis(xpath_method, until_deadline, this.compiler_util.getSwitches(), this.nt, this.scopes, this.flow_scopes, this.wsdlmap, source);
            state.appendDeclaration(expr);
            state.appendNoLine("Math.max(1, ");
            state.appendNoLine(String.valueOf(xpath_method) + "()-System.currentTimeMillis()");
            state.appendNoLine(" )");
            this.addVariableRefs(resolver.getReferencedVariables(), source);
        }
        catch (Exception e) {
            throw new BPELTranslatorException(this.compiler_util, source, e);
        }
    }

    public void translateWait(BPELState state, Element wt) throws BPELTranslatorException {
        state.appendLine("//WAIT");
        String waitID = "sleepTime" + this.nextUID();
        Element forElem = Util.getFirstElement(wt, "for");
        Element untilElem = Util.getFirstElement(wt, "until");
        if (forElem != null) {
            String for_duration = Util.getTextDirectlyUnder(forElem);
            state.appendNoLine("long " + waitID + " = ");
            this.translateForDuration(state, for_duration, forElem);
            state.appendLine(";");
        } else if (untilElem != null) {
            String until_deadline = Util.getTextDirectlyUnder(untilElem);
            state.appendNoLine("long " + waitID + " = ");
            this.translateUntilDeadline(state, until_deadline, untilElem);
            state.appendLine(";");
        } else {
            throw new BPELTranslatorException(this.compiler_util, (Node)wt, "<wait> must have either <for> or <until> element");
        }
        state.appendLine("if (" + waitID + " > 1) Thread.sleep(" + waitID + ");");
        state.appendLine("");
    }

    public void translateEmpty(BPELState state, Element assign) throws BPELTranslatorException, NamespaceException {
        state.appendLine("//(EMPTY)");
    }

    /*
     * Unable to fully structure code
     */
    public void translatePick(BPELState state, Element pick) throws BPELTranslatorException, NamespaceException {
        block64: {
            BPELState.access$0(state, "//PICK");
            pickID = this.nextUID();
            pick.getAttribute("createInstance");
            onMessageCount = 0;
            onAlarmCount = 0;
            unsorted_incoming = Util.getAllElements(pick);
            incoming = new ArrayList<Element>();
            i = 0;
            while (i < unsorted_incoming.size()) {
                inmsg = (Element)unsorted_incoming.get(i);
                tagname = NamespaceTranslator.getName(inmsg);
                if (tagname.equals("onMessage")) {
                    ++onMessageCount;
                    incoming.add(inmsg);
                }
                ++i;
            }
            i = 0;
            while (i < unsorted_incoming.size()) {
                inmsg = (Element)unsorted_incoming.get(i);
                tagname = NamespaceTranslator.getName(inmsg);
                if (tagname.equals("onAlarm")) {
                    ++onAlarmCount;
                    incoming.add(inmsg);
                }
                ++i;
            }
            inputsId = "pickResults" + pickID + "_";
            timeoutId = "timeoutId" + pickID;
            timeoutIndexId = "timeoutIndexId" + pickID;
            if (onAlarmCount > 0) {
                BPELState.access$0(state, "long " + timeoutId + ";");
            } else {
                BPELState.access$0(state, "long " + timeoutId + ";");
            }
            BPELState.access$0(state, "int " + timeoutIndexId + ";");
            bindingsList = new ArrayList<WSDLBindingTranslator>();
            i = 0;
            while (i < this.bindings.length) {
                bindingsList.add(this.bindings[i]);
                ++i;
            }
            problems = new ArrayList<WSDLBindingTranslatorException>();
            pick_portTypes = new ArrayList<WSDLPortType>();
            pick_operations = new ArrayList<WSDLOperation>();
            pick_inputtypes = new ArrayList<String>();
            pick_variables = new ArrayList<String>();
            alarmIds = new ArrayList<String>();
            alarmIndexes = new ArrayList<Integer>();
            alarmRepeats = new ArrayList<Element>();
            i = 0;
            while (i < incoming.size()) {
                inmsg = (Element)incoming.get(i);
                tagname = NamespaceTranslator.getName(inmsg);
                this.nt.addNamespaces(inmsg);
                if (!tagname.equals("onAlarm")) ** GOTO lbl85
                forElem = Util.getFirstElement(inmsg, "for");
                untilElem = Util.getFirstElement(inmsg, "until");
                repeatElem = Util.getFirstElement(inmsg, "repeatEvery");
                alarmRepeats.add(repeatElem);
                alarmId = "pick_timeout" + pickID + "_" + i;
                alarmIds.add(alarmId);
                alarmIndexes.add(new Integer(i));
                if (forElem != null) {
                    for_duration = Util.getTextDirectlyUnder(forElem);
                    BPELState.access$0(state, "//calculate absolute timeout time for onMessage " + i + " (for)");
                    BPELState.access$4(state, "long " + alarmId + " = System.currentTimeMillis()+");
                    this.translateForDuration(state, for_duration, forElem);
                    BPELState.access$0(state, ";");
                } else if (untilElem != null) {
                    until_deadline = Util.getTextDirectlyUnder(untilElem);
                    BPELState.access$0(state, "//calculate absolute timeout time for onMessage " + i + " (until)");
                    BPELState.access$4(state, "long " + alarmId + " = System.currentTimeMillis()+");
                    this.translateUntilDeadline(state, until_deadline, untilElem);
                    BPELState.access$0(state, ";");
                } else {
                    if (repeatElem != null) {
                        throw new BPELTranslatorException(this.compiler_util, (Node)repeatElem, "<repeatEvery> in <pick> has been removed from BPEL spec");
                    }
                    throw new BPELTranslatorException(this.compiler_util, (Node)inmsg, "<onAlarm> in pick must have one of <for>, <until> or <repeatEvery>");
lbl85:
                    // 1 sources

                    alarmRepeats.add(null);
                }
                this.nt.removeNamespaces(inmsg);
                ++i;
            }
            i = 0;
            while (i < bindingsList.size()) {
                binding = (WSDLBindingTranslator)bindingsList.get(i);
                try {
                    binding.translatePickStart(onMessageCount, onAlarmCount, timeoutId);
                }
                catch (WSDLBindingTranslatorException e) {
                    bindingsList.remove(i--);
                    problems.add(e);
                }
                ++i;
            }
            loopId = "pickLoop" + pickID;
            BPELState.access$0(state, "boolean " + loopId + " = true;");
            BPELState.access$0(state, "while (" + loopId + ") {");
            BPELState.access$1(state);
            BPELState.access$0(state, String.valueOf(loopId) + " = false;");
            if (onAlarmCount > 0) {
                BPELState.access$0(state, "//reset timeout values (ready for finding minimum onAlarm timeout)");
                BPELState.access$0(state, timeoutId + " = Long.MAX_VALUE;");
                BPELState.access$0(state, timeoutIndexId + " = 0;");
                i = 0;
                while (i < alarmIds.size()) {
                    alarmId = (String)alarmIds.get(i);
                    alarmIndex = (Integer)alarmIndexes.get(i);
                    BPELState.access$0(state, "if (" + alarmId + " < " + timeoutId + ") {");
                    BPELState.access$1(state);
                    BPELState.access$0(state, String.valueOf(timeoutId) + " = " + alarmId + ";");
                    BPELState.access$0(state, String.valueOf(timeoutIndexId) + " = " + alarmIndex + ";");
                    BPELState.access$2(state);
                    BPELState.access$0(state, "}");
                    ++i;
                }
                BPELState.access$0(state, "//convert timeout value to relative");
                BPELState.access$0(state, String.valueOf(timeoutId) + " = Math.max(1," + timeoutId + "-System.currentTimeMillis());");
            } else {
                BPELState.access$0(state, "//reset timeout values (0 means no timeout - no onAlarms)");
                BPELState.access$0(state, String.valueOf(timeoutId) + " = 0;");
                BPELState.access$0(state, String.valueOf(timeoutIndexId) + " = 0;");
            }
            correlationElements = new ArrayList<Element>();
            correlationFieldNames = new ArrayList<String>();
            i = 0;
            while (i < incoming.size()) {
                inmsg = (Element)incoming.get(i);
                tagname = NamespaceTranslator.getName(inmsg);
                this.nt.addNamespaces(inmsg);
                if (tagname.equals("onMessage")) {
                    partnerLink = inmsg.getAttribute("partnerLink");
                    operation = inmsg.getAttribute("operation");
                    messageExchange = inmsg.getAttribute("messageExchange");
                    variable = inmsg.getAttribute("variable");
                    if (!inmsg.hasAttribute("operation")) {
                        throw new BPELTranslatorException(this.compiler_util, (Node)inmsg, "No 'operation' attribute found");
                    }
                    if (!inmsg.hasAttribute("partnerLink")) {
                        throw new BPELTranslatorException(this.compiler_util, (Node)inmsg, "No 'partnerLink' attribute found");
                    }
                    if (messageExchange == null) {
                        messageExchange = "";
                    }
                    if ((plink = (BPELPartnerLink)this.partnerLinks.get(partnerLink)) == null) {
                        throw new BPELTranslatorException(this.compiler_util, (Node)inmsg, "No partnerLink '" + partnerLink + "' found");
                    }
                    prole = plink.myRole;
                    portType = prole.getQualifiedPortType();
                    wsdl_pt = this.wsdlmap.getPortType(portType);
                    if (wsdl_pt == null) {
                        throw new BPELTranslatorException(this.compiler_util, (Node)inmsg, "No portType '" + portType + "' found");
                    }
                    wsdl_op = (WSDLOperation)wsdl_pt.name_to_operation.get(operation);
                    if (wsdl_op == null) {
                        throw new BPELTranslatorException(this.compiler_util, (Node)inmsg, "No operation '" + operation + "' found in portType '" + portType + "'");
                    }
                    input_type = (String)wsdl_op.message_types.get("input");
                    if (variable == null || variable.length() == 0) {
                        throw new BPELTranslatorException(this.compiler_util, (Node)inmsg, "no input variable specified for pick onMessage (port " + portType + " operation " + operation + ")");
                    }
                    if (input_type == null) {
                        throw new BPELTranslatorException(this.compiler_util, (Node)inmsg, "no input type found for pick onMessage (port " + portType + " operation " + operation + ")");
                    }
                    qtype = this.scopes.getVariableQtype(variable, inmsg);
                    if (!input_type.equals(qtype)) {
                        throw new BPELTranslatorException(this.compiler_util, (Node)inmsg, "pikc onMessage variable has type " + this.compiler_util.getQNameFromQName(qtype) + " but operation requires different WSDL message type " + this.compiler_util.getQNameFromQName(input_type));
                    }
                    pick_portTypes.add(wsdl_pt);
                    pick_operations.add(wsdl_op);
                    pick_inputtypes.add(input_type);
                    pick_variables.add(this.scopes.getVariableName(variable, inmsg));
                    partnerLinkFieldName = "bpel_partner_link" + this.nextUID();
                    eprFieldName = String.valueOf(partnerLinkFieldName) + ".myRole";
                    BPELState.access$0(state, "BPELPartnerLink " + partnerLinkFieldName + " = BPELPartnerLink.getPartnerLink(\"" + this.getPartnerLinkName(plink.name) + "\");");
                    correlationSetID = this.nextUID();
                    correlationSetFieldName = "bpel_pick_correlation_" + correlationSetID;
                    correlations = Util.getFirstElement(inmsg, "correlations");
                    correlationFieldNames.add(correlationSetFieldName);
                    correlationElements.add(correlations);
                    b = 0;
                    while (b < bindingsList.size()) {
                        binding = (WSDLBindingTranslator)bindingsList.get(b);
                        try {
                            if (binding instanceof InternalBindingTranslator) {
                                binding.translatePickOnMessage(this.nt, portType, plink.requiredBindingName, operation, messageExchange, eprFieldName, correlationSetFieldName, inputsId + i);
                            } else {
                                binding.translatePickOnMessage(this.nt, portType, plink.requiredBindingName, operation, messageExchange, eprFieldName, correlationSetFieldName, inputsId + i);
                            }
                        }
                        catch (WSDLBindingTranslatorException e) {
                            bindingsList.remove(b--);
                            problems.add(e);
                        }
                        ++b;
                    }
                }
                this.nt.removeNamespaces(inmsg);
                ++i;
            }
            indexFieldName = "pickparam" + pickID;
            pickInvoc = null;
            used_binding = null;
            b = 0;
            while (b < bindingsList.size()) {
                used_binding = (WSDLBindingTranslator)bindingsList.get(b);
                try {
                    pickInvoc = used_binding.translatePickFinish(indexFieldName);
                    break;
                }
                catch (WSDLBindingTranslatorException e) {
                    bindingsList.remove(b--);
                    problems.add(e);
                    ++b;
                }
            }
            try {
                if (used_binding != null) {
                    if (used_binding instanceof InternalBindingTranslator) {
                        i = 0;
                        while (i < onMessageCount) {
                            BPELState.access$0(state, "Message " + inputsId + i + " = new Message();\n");
                            if (correlationElements.get(i) != null) {
                                throw new BPELTranslatorException(this.compiler_util, (Node)pick, "<correlation> not supported for this binding");
                            }
                            ++i;
                        }
                        BPELState.access$0(state, "int " + indexFieldName + " = 0;");
                        if (pickInvoc.endsWith("\n")) {
                            BPELState.access$4(state, pickInvoc);
                        } else {
                            BPELState.access$0(state, pickInvoc);
                        }
                        i = 0;
                        while (i < incoming.size()) {
                            pickElem = (Element)incoming.get(i);
                            if (i > 0) {
                                BPELState.access$4(state, "} else ");
                            }
                            if (i < onMessageCount) {
                                BPELState.access$0(state, "if (" + indexFieldName + " == " + i + ") {");
                                BPELState.access$1(state);
                                BPELState.access$0(state, "  engine.ipushStack(\"BPEL " + TranslatorUtils.toJavaString(pickElem) + " " + TranslatorUtils.toJavaString(this.compiler_util.getBpelLineNumberString(pickElem)) + "\");");
                                BPELState.access$0(state, "BPELVariable.setMessage(engine,\"" + pick_variables.get(i) + "\"," + inputsId + i + ");");
                                BPELState.access$0(state, "  //onMessage " + i + " activities");
                                this.translateActivities(state, pickElem);
                                BPELState.access$0(state, "  engine.ipopStack();");
                                BPELState.access$2(state);
                            } else {
                                BPELState.access$0(state, "if (" + timeoutIndexId + " == " + i + ") {");
                                BPELState.access$1(state);
                                BPELState.access$0(state, "  engine.ipushStack(\"BPEL " + TranslatorUtils.toJavaString(pickElem) + " " + TranslatorUtils.toJavaString(this.compiler_util.getBpelLineNumberString(pickElem)) + "\");");
                                BPELState.access$0(state, "  //onAlarm " + i + " activities");
                                this.translateActivities(state, pickElem);
                                repeatElem = (Element)alarmRepeats.get(i);
                                if (repeatElem != null) {
                                    repeat_every = Util.getTextDirectlyUnder(repeatElem);
                                    alarmId = "pick_timeout" + pickID + "_" + i;
                                    BPELState.access$4(state, String.valueOf(alarmId) + " += ");
                                    this.translateForDuration(state, repeat_every, repeatElem);
                                    BPELState.access$0(state, ";");
                                    BPELState.access$0(state, String.valueOf(loopId) + " = true; //repeatEvery");
                                }
                                BPELState.access$0(state, "  engine.ipopStack();");
                                BPELState.access$2(state);
                            }
                            if (i == incoming.size() - 1) {
                                BPELState.access$0(state, "}");
                            }
                            ++i;
                        }
                    } else {
                        i = 0;
                        while (i < onMessageCount) {
                            input_type = (String)pick_inputtypes.get(i);
                            BPELState.access$0(state, String.valueOf(input_type) + " " + inputsId + i + " = new " + input_type + "();");
                            BPELState.access$0(state, "BPELCorrelationSet " + correlationFieldNames.get(i) + " = null;");
                            ++i;
                        }
                        BPELState.access$0(state, "int " + indexFieldName + " = 0;");
                        if (pickInvoc.endsWith("\n")) {
                            BPELState.access$4(state, pickInvoc);
                        } else {
                            BPELState.access$0(state, pickInvoc);
                        }
                        i = 0;
                        while (i < incoming.size()) {
                            pickElem = (Element)incoming.get(i);
                            if (i > 0) {
                                BPELState.access$4(state, "} else ");
                            }
                            if (i < onMessageCount) {
                                BPELState.access$0(state, "if (" + indexFieldName + " == " + i + ") {");
                                if (correlationElements.get(i) != null) {
                                    this.translateCorrelations(state, (Element)correlationElements.get(i), (String)correlationFieldNames.get(i), String.valueOf(inputsId) + i, (String)pick_inputtypes.get(i), false, false);
                                }
                                BPELState.access$0(state, "BPELVariable.setMessage(engine,\"" + pick_variables.get(i) + "\"," + pick_inputtypes.get(i) + ".toEngineMessage(" + inputsId + i + "));");
                                BPELState.access$0(state, "  //onMessage " + i + " activities");
                                BPELState.access$1(state);
                                BPELState.access$0(state, "  engine.ipushStack(\"BPEL " + TranslatorUtils.toJavaString(this.compiler_util.getBpelLineNumberString(pickElem)) + " " + TranslatorUtils.toJavaString(pickElem) + "\");");
                                this.translateActivities(state, pickElem);
                                BPELState.access$0(state, "  engine.ipopStack();");
                                BPELState.access$2(state);
                            } else {
                                BPELState.access$0(state, "if (" + timeoutIndexId + " == " + i + ") {");
                                BPELState.access$1(state);
                                BPELState.access$0(state, "  engine.ipushStack(\"BPEL " + TranslatorUtils.toJavaString(this.compiler_util.getBpelLineNumberString(pickElem)) + " " + TranslatorUtils.toJavaString(pickElem) + "\");");
                                BPELState.access$0(state, "  //onAlarm " + i + " activities");
                                this.translateActivities(state, pickElem);
                                repeatElem = (Element)alarmRepeats.get(i);
                                if (repeatElem != null) {
                                    repeat_every = Util.getTextDirectlyUnder(repeatElem);
                                    alarmId = "pick_timeout" + pickID + "_" + i;
                                    BPELState.access$4(state, String.valueOf(alarmId) + " += ");
                                    this.translateForDuration(state, repeat_every, repeatElem);
                                    BPELState.access$0(state, ";");
                                    BPELState.access$0(state, String.valueOf(loopId) + " = true; //repeatEvery");
                                }
                                BPELState.access$0(state, "  engine.ipopStack();");
                                BPELState.access$2(state);
                            }
                            if (i == incoming.size() - 1) {
                                BPELState.access$0(state, "}");
                            }
                            ++i;
                        }
                    }
                    break block64;
                }
                throw new BPELTranslatorException(this.compiler_util, (Node)pick, "no single binding translator could translate entire pick, see error log for more details");
            }
            catch (BPELTranslatorException x) {
                i = 0;
                ** while (i < problems.size())
            }
lbl-1000:
            // 1 sources

            {
                e = (Exception)problems.get(i);
                this.log.logWarning(this.LOG_SOURCE, "Binding Translation Failed:" + e.getMessage());
                ++i;
                continue;
            }
lbl326:
            // 1 sources

            throw x;
        }
        BPELState.access$2(state);
        BPELState.access$0(state, "}//end while");
    }

    public void translateCondition(BPELState state, Element cond) throws BPELTranslatorException, NamespaceException {
        String condition = Util.getTextDirectlyUnder(cond);
        try {
            XPATHTreeTranslator resolver = new XPATHTreeTranslator();
            String xpath_method = this.getNextXPath();
            String expr = resolver.resolveToBoolean(xpath_method, condition, this.compiler_util.getSwitches(), this.nt, this.scopes, this.flow_scopes, this.wsdlmap, cond);
            state.appendDeclaration(expr);
            state.appendNoLine(String.valueOf(xpath_method) + "()");
            this.addVariableRefs(resolver.getReferencedVariables(), cond);
        }
        catch (Exception e) {
            throw new BPELTranslatorException(this.compiler_util, (Node)cond, e);
        }
    }

    public void translateIf(BPELState state, Element iff) throws BPELTranslatorException, NamespaceException {
        Element then;
        state.appendLine("//IF");
        Element firstcondition = Util.getFirstElement(iff, "condition");
        ArrayList<Element> cases = new ArrayList<Element>();
        if (Util.getFirstElement(iff, "otherwise") != null) {
            this.log.logWarning(this.LOG_SOURCE, "<otherwise> element from original <switch> activity has changed to <else>");
        }
        if (Util.getFirstElement(iff, "case") != null) {
            this.log.logWarning(this.LOG_SOURCE, "<case> element from original <switch> activity has changed to <then> and <elseif>");
        }
        if ((then = Util.getFirstElement(iff, "then")) == null) {
            throw new BPELTranslatorException(this.compiler_util, (Node)iff, "expected <then> element under <if> activity");
        }
        then.appendChild(firstcondition);
        cases.add(then);
        cases.addAll(Util.getAllElements(iff, "elseif"));
        Element otherwise = Util.getFirstElement(iff, "else");
        int i = 0;
        while (i < cases.size()) {
            Element cse = (Element)cases.get(i);
            if (i == 0) {
                state.appendNoLine("if (");
            } else {
                state.appendNoLine("} else if (");
            }
            Element condition = Util.getFirstElement(cse, "condition");
            if (condition == null) {
                throw new BPELTranslatorException(this.compiler_util, (Node)cse, "no condition found under switch case");
            }
            this.translateCondition(state, condition);
            state.appendLine(") {");
            int k = 0;
            while (k < cases.size()) {
                Element alternate = (Element)cases.get(k);
                if (k != i) {
                    this.translateDeadPathElimination(state, alternate);
                }
                ++k;
            }
            this.translateActivities(state, cse);
            ++i;
        }
        if (otherwise != null) {
            state.appendLine("} else {");
            int k = 0;
            while (k < cases.size()) {
                Element alternate = (Element)cases.get(k);
                this.translateDeadPathElimination(state, alternate);
                ++k;
            }
            this.translateActivities(state, otherwise);
            state.appendLine("}");
        } else {
            state.appendLine("}");
        }
    }

    public void translateRepeatUntil(BPELState state, Element rpet) throws BPELTranslatorException, NamespaceException {
        state.appendLine("//REPEAT UNTIL");
        Element condition = Util.getFirstElement(rpet, "condition");
        state.appendNoLine("do {");
        this.translateActivities(state, rpet);
        state.appendLine("} while (");
        if (condition == null) {
            throw new BPELTranslatorException(this.compiler_util, (Node)rpet, "no condition found under repeatUntil");
        }
        this.translateCondition(state, condition);
        state.appendLine(");");
        state.appendLine("//END REPEAT UNTIL");
    }

    public void translateForEach(BPELState state, Element foreach) throws BPELTranslatorException, NamespaceException {
        Element childrenElem;
        Element subElem;
        Element toElem;
        Element fromElem;
        Element copyElem;
        Element assignElem;
        state.appendLine("//FOREACH");
        String counterName = foreach.getAttribute("counterName");
        String parallel = foreach.getAttribute("parallel");
        if (counterName == null) {
            throw new BPELTranslatorException(this.compiler_util, (Node)foreach, "'counterName' attribute required on <forEach> activity");
        }
        if (parallel == null) {
            throw new BPELTranslatorException(this.compiler_util, (Node)foreach, "'parallel' attribute required on <forEach> activity");
        }
        boolean isParallel = parallel.equals("yes");
        if (!isParallel && !parallel.equals("no")) {
            throw new BPELTranslatorException(this.compiler_util, (Node)foreach, "'parallel' attribute on <forEach> activity must be 'yes' or 'no'");
        }
        Element startValueElem = Util.getFirstElement(foreach, "startCounterValue");
        if (startValueElem == null) {
            throw new BPELTranslatorException(this.compiler_util, (Node)foreach, "<forEach> activity must contain a <startCounterValue> element");
        }
        String startCounterValue = Util.getTextDirectlyUnder(startValueElem);
        Element finalValueElem = Util.getFirstElement(foreach, "finalCounterValue");
        if (finalValueElem == null) {
            throw new BPELTranslatorException(this.compiler_util, (Node)foreach, "<forEach> activity must contain a <finalCounterValue> element");
        }
        String finalCounterValue = Util.getTextDirectlyUnder(finalValueElem);
        String tagname = foreach.getTagName();
        String nsbpel = tagname.substring(0, tagname.indexOf(58) + 1);
        Document doc = foreach.getOwnerDocument();
        if (isParallel) {
            Element flowElem = doc.createElement(String.valueOf(nsbpel) + "flow");
            Element scopeElem = doc.createElement(String.valueOf(nsbpel) + "scope");
            scopeElem.setAttribute("isolated", "no");
            scopeElem.setAttribute("threadcount", "1 + ( " + finalCounterValue + " ) - ( " + startCounterValue + " )");
            Element variablesElem = doc.createElement(String.valueOf(nsbpel) + "variables");
            Element variableElem = doc.createElement(String.valueOf(nsbpel) + "variable");
            variableElem.setAttribute("xmlns:xsd", "http://www.w3.org/2001/XMLSchema");
            variableElem.setAttribute("name", counterName);
            variableElem.setAttribute("type", "xsd:int");
            assignElem = doc.createElement(String.valueOf(nsbpel) + "assign");
            copyElem = doc.createElement(String.valueOf(nsbpel) + "copy");
            fromElem = doc.createElement(String.valueOf(nsbpel) + "from");
            Text valueText = doc.createTextNode("( " + startCounterValue + " ) + getThreadChildIndex() - 1");
            toElem = doc.createElement(String.valueOf(nsbpel) + "to");
            toElem.setAttribute("variable", counterName);
            flowElem.appendChild(scopeElem);
            scopeElem.appendChild(variablesElem);
            variablesElem.appendChild(variableElem);
            scopeElem.appendChild(assignElem);
            assignElem.appendChild(copyElem);
            copyElem.appendChild(fromElem);
            fromElem.appendChild(valueText);
            copyElem.appendChild(toElem);
            subElem = flowElem;
            childrenElem = scopeElem;
        } else {
            Element scopeElem = doc.createElement(String.valueOf(nsbpel) + "scope");
            scopeElem.setAttribute("isolated", "no");
            Element variablesElem = doc.createElement(String.valueOf(nsbpel) + "variables");
            Element variableElem = doc.createElement(String.valueOf(nsbpel) + "variable");
            variableElem.setAttribute("xmlns:xsd", "http://www.w3.org/2001/XMLSchema");
            variableElem.setAttribute("name", counterName);
            variableElem.setAttribute("type", "xsd:int");
            Element maxVariableElem = doc.createElement(String.valueOf(nsbpel) + "variable");
            maxVariableElem.setAttribute("xmlns:xsd", "http://www.w3.org/2001/XMLSchema");
            maxVariableElem.setAttribute("name", String.valueOf(counterName) + "_bpel_forEach_generated_maximum");
            maxVariableElem.setAttribute("type", "xsd:int");
            assignElem = doc.createElement(String.valueOf(nsbpel) + "assign");
            copyElem = doc.createElement(String.valueOf(nsbpel) + "copy");
            fromElem = doc.createElement(String.valueOf(nsbpel) + "from");
            Text startText = doc.createTextNode("(" + startCounterValue + ") - 1");
            toElem = doc.createElement(String.valueOf(nsbpel) + "to");
            toElem.setAttribute("variable", counterName);
            Element maxCopyElem = doc.createElement(String.valueOf(nsbpel) + "copy");
            Element maxFromElem = doc.createElement(String.valueOf(nsbpel) + "from");
            Text maxText = doc.createTextNode(finalCounterValue);
            Element maxToElem = doc.createElement(String.valueOf(nsbpel) + "to");
            maxToElem.setAttribute("variable", String.valueOf(counterName) + "_bpel_forEach_generated_maximum");
            Element whileElem = doc.createElement(String.valueOf(nsbpel) + "while");
            Element conditionElem = doc.createElement(String.valueOf(nsbpel) + "condition");
            Text conditionText = doc.createTextNode("$" + counterName + " < $" + counterName + "_bpel_forEach_generated_maximum");
            Element assigniElem = doc.createElement(String.valueOf(nsbpel) + "assign");
            Element copyiElem = doc.createElement(String.valueOf(nsbpel) + "copy");
            Element fromiElem = doc.createElement(String.valueOf(nsbpel) + "from");
            Text fromiText = doc.createTextNode("$" + counterName + " + 1");
            Element toiElem = doc.createElement(String.valueOf(nsbpel) + "to");
            toiElem.setAttribute("variable", counterName);
            scopeElem.appendChild(variablesElem);
            variablesElem.appendChild(variableElem);
            variablesElem.appendChild(maxVariableElem);
            scopeElem.appendChild(assignElem);
            assignElem.appendChild(copyElem);
            copyElem.appendChild(fromElem);
            copyElem.appendChild(toElem);
            fromElem.appendChild(startText);
            assignElem.appendChild(maxCopyElem);
            maxCopyElem.appendChild(maxFromElem);
            maxCopyElem.appendChild(maxToElem);
            maxFromElem.appendChild(maxText);
            scopeElem.appendChild(whileElem);
            whileElem.appendChild(conditionElem);
            conditionElem.appendChild(conditionText);
            whileElem.appendChild(assigniElem);
            assigniElem.appendChild(copyiElem);
            copyiElem.appendChild(fromiElem);
            copyiElem.appendChild(toiElem);
            fromiElem.appendChild(fromiText);
            subElem = scopeElem;
            childrenElem = whileElem;
        }
        NodeList childrenList = foreach.getChildNodes();
        ArrayList<Node> children = new ArrayList<Node>();
        int i = 0;
        while (i < childrenList.getLength()) {
            children.add(childrenList.item(i));
            ++i;
        }
        i = 0;
        while (i < children.size()) {
            foreach.removeChild((Node)children.get(i));
            ++i;
        }
        i = 0;
        while (i < children.size()) {
            childrenElem.appendChild((Node)children.get(i));
            ++i;
        }
        foreach.appendChild(subElem);
        this.translateActivities(state, foreach);
        foreach.removeChild(subElem);
        i = 0;
        while (i < children.size()) {
            childrenElem.removeChild((Node)children.get(i));
            ++i;
        }
        i = 0;
        while (i < children.size()) {
            foreach.appendChild((Node)children.get(i));
            ++i;
        }
        state.appendLine("//END FOREACH");
    }

    public void translateWhile(BPELState state, Element whle) throws BPELTranslatorException, NamespaceException {
        state.appendLine("//WHILE");
        Element condition = Util.getFirstElement(whle, "condition");
        state.appendNoLine("while (");
        if (condition == null) {
            throw new BPELTranslatorException(this.compiler_util, (Node)whle, "no condition found under while");
        }
        this.translateCondition(state, condition);
        state.appendLine(") {");
        this.translateActivities(state, whle);
        state.appendLine("}");
        state.appendLine("//END WHILE");
    }

    public void translateSequence(BPELState state, Element sequence) throws BPELTranslatorException, NamespaceException {
        state.appendLine("//SEQUENCE");
        this.translateActivities(state, sequence);
        state.appendLine("//END SEQUENCE");
    }

    public void translateTargets(BPELState state, Element targets) throws BPELTranslatorException {
        Element join = Util.getFirstElement(targets, "joinCondition");
        if (join != null) {
            String joinExpression = Util.getTextDirectlyUnder(join);
            try {
                XPATHTreeTranslator resolver = new XPATHTreeTranslator();
                String xpath_method = this.getNextXPath();
                String expr = resolver.resolveLinksToBoolean(xpath_method, joinExpression, this.compiler_util.getSwitches(), this.nt, this.scopes, this.flow_scopes, this.wsdlmap, join);
                state.appendDeclaration(expr);
                state.appendLine("if (" + xpath_method + "()) { //begin link scope");
            }
            catch (Exception e) {
                throw new BPELTranslatorException(this.compiler_util, (Node)join, e);
            }
        } else {
            boolean found = false;
            ArrayList list = Util.getAllElements(targets);
            int i = 0;
            while (i < list.size()) {
                Element standard = (Element)list.get(i);
                String tagname = NamespaceTranslator.getName(standard);
                if (tagname.equals("target")) {
                    if (!found) {
                        found = true;
                        state.appendLine("//LINK - TARGET (Message Wait)");
                        state.incrementScope();
                        state.appendNoLine("if (");
                    } else {
                        state.appendNoLine("&&");
                    }
                    String linkName = standard.getAttribute("linkName");
                    state.appendNoLine("BPELLink.incoming(engine,\"" + this.flow_scopes.getLinkName(linkName, join) + "\")");
                }
                ++i;
            }
            if (found) {
                state.appendLine(") { //begin link scope");
            }
        }
    }

    public void translateSources(BPELState state, Element sources) throws BPELTranslatorException {
        boolean found = false;
        ArrayList list = Util.getAllElements(sources);
        int i = 0;
        while (i < list.size()) {
            Element standard = (Element)list.get(i);
            String tagname = NamespaceTranslator.getName(standard);
            if (tagname.equals("source")) {
                if (!found) {
                    found = true;
                    state.appendLine("//LINK - SOURCE (Message Send)");
                    state.incrementScope();
                }
                String linkName = standard.getAttribute("linkName");
                Element transition = Util.getFirstElement(standard, "transitionCondition");
                if (transition != null) {
                    String transitionExpression = Util.getTextDirectlyUnder(transition);
                    try {
                        XPATHTreeTranslator resolver = new XPATHTreeTranslator();
                        String xpath_method = this.getNextXPath();
                        String expr = resolver.resolveToBoolean(xpath_method, transitionExpression, this.compiler_util.getSwitches(), this.nt, this.scopes, this.flow_scopes, this.wsdlmap, transition);
                        state.appendDeclaration(expr);
                        state.appendLine("BPELLink.outgoing(engine,\"" + this.flow_scopes.getLinkName(linkName, transition) + "\"," + xpath_method + "());");
                    }
                    catch (Exception e) {
                        throw new BPELTranslatorException(this.compiler_util, (Node)transition, e);
                    }
                } else {
                    state.appendLine("BPELLink.outgoing(engine,\"" + this.flow_scopes.getLinkName(linkName, transition) + "\",true);");
                }
            }
            ++i;
        }
        if (found) {
            state.decrementScope();
            state.appendLine("");
        }
    }

    public void translatePreEffectiveStandard(BPELState state, Element standards) throws BPELTranslatorException {
        Element targets = Util.getFirstElement(standards, "targets");
        if (targets != null) {
            this.translateTargets(state, targets);
        }
        state.decrementScope();
        state.appendLine("");
    }

    public String[] getDeclaredLinks(Element flow) throws BPELTranslatorException {
        Element links_elem = Util.getFirstElement(flow, "links");
        ArrayList links = Util.getAllElements(links_elem, "link");
        String[] linkNames = new String[links.size()];
        int i = 0;
        while (i < links.size()) {
            Element link = (Element)links.get(i);
            linkNames[i] = link.getAttribute("name");
            ++i;
        }
        return linkNames;
    }

    public void translateDeadPathElimination(BPELState state, Element dpe) throws BPELTranslatorException {
        state.appendLine("//DEAD PATH ELIMINATION");
        this.r_translateDeadPathElimination(state, dpe, new ArrayList());
    }

    public void r_translateDeadPathElimination(BPELState state, Element dpe, ArrayList ignored_links) throws BPELTranslatorException {
        String tagname = NamespaceTranslator.getName(dpe);
        if (tagname.equals("sources")) {
            ArrayList sources = Util.getAllElements(dpe, "source");
            int i = 0;
            while (i < sources.size()) {
                Element source = (Element)sources.get(i);
                String linkName = source.getAttribute("linkName");
                boolean ignored = false;
                int k = 0;
                while (k < ignored_links.size()) {
                    if (linkName.equals(ignored_links.get(k))) {
                        ignored = true;
                    }
                    ++k;
                }
                if (!ignored) {
                    state.appendLine("BPELLink.outgoing(engine,\"" + this.flow_scopes.getLinkName(linkName, source) + "\",false);");
                }
                ++i;
            }
        } else {
            String[] links = new String[]{};
            if (tagname.equals("flow")) {
                links = this.getDeclaredLinks(dpe);
            }
            int i = 0;
            while (i < links.length) {
                ignored_links.add(links[i]);
                ++i;
            }
            ArrayList children = Util.getAllElements(dpe);
            int i2 = 0;
            while (i2 < children.size()) {
                Element child = (Element)children.get(i2);
                this.r_translateDeadPathElimination(state, child, ignored_links);
                ++i2;
            }
            i2 = 0;
            while (i2 < links.length) {
                ignored_links.remove(ignored_links.size() - 1);
                ++i2;
            }
        }
    }

    public void translatePostEffectiveStandard(BPELState state, Element standards) throws BPELTranslatorException {
        Element targets = Util.getFirstElement(standards, "targets");
        Element sources = Util.getFirstElement(standards, "sources");
        if (sources != null) {
            this.translateSources(state, sources);
        }
        if (targets != null) {
            state.appendLine("} else {");
            this.translateDeadPathElimination(state, standards);
            state.appendLine("}//end link scope");
        }
    }

    public void translateLink(BPELState state, Element link) throws BPELTranslatorException {
        String name = link.getAttribute("name");
        this.flow_scopes.addLink(name);
    }

    public void translateLinks(BPELState state, Element links) throws BPELTranslatorException, NamespaceException {
        state.appendLine("//LINKS");
        state.incrementScope();
        ArrayList list = Util.getAllElements(links);
        int i = 0;
        while (i < list.size()) {
            this.translateLink(state, (Element)list.get(i));
            ++i;
        }
        state.decrementScope();
        state.appendLine("//END LINKS");
    }

    public void translateCorrelationSet(BPELState state, Element corrset) throws BPELTranslatorException {
        this.nt.addNamespaces(corrset);
        String name = corrset.getAttribute("name");
        String propertiesList = corrset.getAttribute("properties");
        if (propertiesList == null) {
            throw new BPELTranslatorException(this.compiler_util, (Node)corrset, "<correlationSet> element must specify a 'properties' attribute");
        }
        String[] properties = Util.split(propertiesList);
        int i = 0;
        while (i < properties.length) {
            try {
                properties[i] = this.nt.qualify(properties[i], false);
            }
            catch (NamespaceException namespaceException) {
                throw new BPELTranslatorException(this.compiler_util, (Node)corrset, "Failed to translate namespace for property " + properties[i] + " in correlation set definition");
            }
            ++i;
        }
        this.scopes.addCorrelationSet(name, properties);
        state.appendLine("BPELCorrelationSet.setUninitialised(engine,\"" + this.scopes.getCorrelationSetName(name, corrset) + "\");\n");
        this.nt.removeNamespaces(corrset);
    }

    public void translateCorrelationSets(BPELState state, Element corrsets) throws BPELTranslatorException, NamespaceException {
        state.appendLine("//CORRELATION SETS");
        state.incrementScope();
        ArrayList list = Util.getAllElements(corrsets);
        int i = 0;
        while (i < list.size()) {
            this.translateCorrelationSet(state, (Element)list.get(i));
            ++i;
        }
        state.decrementScope();
        state.appendLine("//END CORRELATION SETS");
    }

    public void translateExit(BPELState state, Element xit) throws BPELTranslatorException, NamespaceException {
        state.appendLine("//EXIT");
        state.appendLine("engine.terminate();");
    }

    private int pushScope(BPELState state, Element source, boolean isolated, boolean ignoreParentIsolation) throws BPELTranslatorException, NamespaceException {
        int isolatedLockIndex = state.getIndex();
        BPELThread cfr_ignored_0 = (BPELThread)this.bpel_threads.peek();
        this.scopes.pushScope("bpelThreadIdList.get(" + (this.bpel_threads.size() - 1) + ")", isolated, source, ignoreParentIsolation);
        return isolatedLockIndex;
    }

    private void popScope(BPELState state, Element source, int isolatedLockIndex, boolean isAssign) throws BPELTranslatorException, NamespaceException {
        this.translateLockUsedVariables(state, isolatedLockIndex, isAssign, source);
        this.scopes.popScope(source);
    }

    public void translateScope(BPELState state, Element scope) throws BPELTranslatorException, NamespaceException {
        String isolated = scope.getAttribute("isolated");
        if (isolated.length() > 0 && !isolated.equals("yes") && !isolated.equals("no")) {
            this.log.logWarning(this.LOG_SOURCE, "Attribute 'isolated' on scope should be 'yes' or 'no' (case sensitive)");
        }
        String debugVariablesId = "bpel_debug_variables_id" + this.nextUID();
        if (this.debug) {
            state.appendDeclaration("Message " + debugVariablesId + ";");
            state.appendLine("    " + debugVariablesId + " = new Message(" + 1 + ");");
            state.appendLine("    engine.ipushStack(" + debugVariablesId + ");");
        }
        int isolatedLockIndex = this.pushScope(state, scope, isolated.equals("yes"), false);
        state.appendLine("//SCOPE");
        Element tmp = Util.getFirstElement(scope, "variables");
        if (tmp != null) {
            this.translateVariables(state, tmp, debugVariablesId);
        }
        state.appendLine("");
        tmp = Util.getFirstElement(scope, "correlationSets");
        if (tmp != null) {
            this.translateCorrelationSets(state, tmp);
        }
        state.appendLine("");
        Element faultHandlers = Util.getFirstElement(scope, "faultHandlers");
        if (faultHandlers != null) {
            this.translatePreFaultHandlers(state, faultHandlers);
        }
        state.appendLine("");
        this.translateActivities(state, scope);
        this.popScope(state, scope, isolatedLockIndex, false);
        if (faultHandlers != null) {
            this.translatePostFaultHandlers(state, faultHandlers);
        }
        if (this.debug) {
            state.appendLine("    engine.ipopStack();");
        }
    }

    private void translateLockUsedVariables(BPELState state, int prefix_index, boolean isAssign, Node source) throws BPELTranslatorException, NamespaceException {
        Object[] names = this.scopes.getIsolatedVariableNames(source);
        if (names.length > 0) {
            Arrays.sort(names);
            String type = "SCOPE";
            if (isAssign) {
                type = "ASSIGN";
            }
            this.log.logInfo(this.LOG_SOURCE, "Variable Locking Order (" + type + ") " + this.compiler_util.getBpelLineNumberString(source) + ":");
        }
        StringBuffer lockBuffer = new StringBuffer();
        StringBuffer releaseBuffer = new StringBuffer();
        lockBuffer.append("try {\n");
        int i = 0;
        while (i < names.length) {
            String scopedName = this.scopes.getVariableName((String)names[i], source);
            scopedName = isAssign ? "ALOCK:\"+\"" + scopedName : "SLOCK:\"+\"" + scopedName;
            this.log.logInfo(this.LOG_SOURCE, "  " + (1 + i) + " - variable '" + (String)names[i] + "' (\"" + scopedName + "\")");
            BPELThread thread = (BPELThread)this.bpel_threads.peek();
            ArrayList<String> parentlist = new ArrayList<String>();
            boolean cfr_ignored_0 = thread.multiple_copies;
            BPELThread tmpthread = thread.getParent();
            while (tmpthread != null) {
                parentlist.add("" + tmpthread.id);
                if (tmpthread.multiple_copies) {
                    // empty if block
                }
                tmpthread = tmpthread.getParent();
            }
            String[] parents = new String[parentlist.size()];
            parentlist.toArray(parents);
            if (!this.compiler_util.getSwitches().LOCK_RESOLVING) {
                lockBuffer.append("BPELVariable.lockVariable(engine,\"" + scopedName + "\");\n");
                releaseBuffer.append("BPELVariable.releaseVariable(engine,\"" + scopedName + "\");\n");
            } else {
                String methodName = "bpelVariableLock_" + this.nextUID();
                if (isAssign) {
                    this.lock_model.pushSync(this.compiler_util, source, "AssignLock:" + (String)names[i], methodName, this.scopes.getScopeLogicalStart(), this.scopes.getScopeLogicalEnd());
                } else {
                    this.lock_model.pushSync(this.compiler_util, source, "IScopeLock:" + (String)names[i], methodName, this.scopes.getScopeLogicalStart(), this.scopes.getScopeLogicalEnd());
                }
                thread.addVariableLock(methodName, scopedName);
                lockBuffer.append(String.valueOf(methodName) + "_LOCK(\"" + scopedName + "\");\n");
                releaseBuffer.append(String.valueOf(methodName) + "_RELEASE(\"" + scopedName + "\");\n");
            }
            ++i;
        }
        state.appendLine(releaseBuffer.toString());
        String tmpFaultName = "bpel_temporary_fault_" + this.nextUID();
        state.appendLine("} catch (BPELFault " + tmpFaultName + ") {");
        state.appendLine(releaseBuffer.toString());
        state.appendLine("  throw " + tmpFaultName + ";");
        state.appendLine("}");
        state.insertLine(lockBuffer.toString(), prefix_index);
    }

    private void translateActivities(BPELState state, Element parent) throws BPELTranslatorException, NamespaceException {
        state.incrementScope();
        ArrayList list = Util.getAllElements(parent);
        int i = 0;
        while (i < list.size()) {
            BPELState newstate = state.newState();
            state.appendLine(String.valueOf(newstate.getMethodName()) + "();");
            this.translateActivity(newstate, (Element)list.get(i), i + 1);
            ++i;
        }
        state.decrementScope();
    }

    private String getVariableFrom(String query, Element source) throws BPELTranslatorException, NamespaceException {
        StringBuffer variablebuf = new StringBuffer();
        int varStart = query.indexOf(36);
        if (varStart == -1) {
            throw new BPELTranslatorException(this.compiler_util, (Node)source, "could not find variable name in assignment query");
        }
        int k = varStart + 1;
        while (k < query.length()) {
            char c = query.charAt(k);
            if (c == '/' || c == '.' || c == '\\' || Character.isWhitespace(c)) break;
            variablebuf.append(c);
            ++k;
        }
        String tovariable = variablebuf.toString();
        return tovariable;
    }

    public void translateJavaImport(BPELState state, Element jimport) throws BPELTranslatorException, NamespaceException {
        String pkg = jimport.getAttribute("package");
        if (pkg == null) {
            throw new BPELTranslatorException(this.compiler_util, (Node)jimport, "<java_import> element without 'package' attribute");
        }
        if (pkg.trim().length() == 0) {
            throw new BPELTranslatorException(this.compiler_util, (Node)jimport, "<java_import> element with empty 'package' attribute");
        }
        this.runner_imports = String.valueOf(this.runner_imports) + "\nimport " + pkg + ";";
    }

    public void translateJavaDebug(BPELState state, Element jdebug) throws BPELTranslatorException, NamespaceException {
        try {
            state.appendLine("//JAVA DEBUG");
            String vars = jdebug.getAttribute("variables");
            String[] variables = new String[]{};
            if (vars == null) {
                vars = "";
            }
            if (vars.length() > 0) {
                variables = Util.split(vars);
            }
            if (variables.length > 0) {
                state.appendLine("{");
            }
            int i = 0;
            while (i < variables.length) {
                String toType = this.getNextXPath();
                String toString = this.getNextXPath();
                String toObj = this.getNextXPath();
                XPATHTreeTranslator translator = new XPATHTreeTranslator();
                state.appendDeclaration(translator.resolveToXmlString(toType, variables[i], this.compiler_util.getSwitches(), this.nt, this.scopes, this.flow_scopes, this.wsdlmap, jdebug));
                this.addVariableRefs(translator.getReferencedVariables(), jdebug);
                translator = new XPATHTreeTranslator();
                state.appendDeclaration(translator.resolveToString(toString, variables[i], this.compiler_util.getSwitches(), this.nt, this.scopes, this.flow_scopes, this.wsdlmap, jdebug));
                this.addVariableRefs(translator.getReferencedVariables(), jdebug);
                translator = new XPATHTreeTranslator();
                state.appendDeclaration(translator.resolveToNodeSet(toObj, variables[i], this.compiler_util.getSwitches(), this.nt, this.scopes, this.flow_scopes, this.wsdlmap, jdebug));
                this.addVariableRefs(translator.getReferencedVariables(), jdebug);
                state.appendLine("String xpath_var" + i + " = \"\"+" + toString + "();");
                state.appendLine("String xml_var" + i + ";");
                state.appendLine("XNode obj_var" + i + ";\n");
                state.appendLine("String ret_var" + i + " = null;");
                state.appendLine("try {\n");
                state.appendLine("\txml_var" + i + " = \"\"+" + toType + "();");
                state.appendLine("} catch (Exception e) {\n");
                state.appendLine("\txml_var" + i + " = xpath_var" + i + ";");
                state.appendLine("}\n");
                state.appendLine("try {\n");
                state.appendLine("\tobj_var" + i + " = " + toObj + "().get(0);\n");
                state.appendLine("} catch (Exception e) {\n");
                state.appendLine("\tobj_var" + i + " = null;");
                state.appendLine("}\n");
                ++i;
            }
            NodeList list = jdebug.getChildNodes();
            int i2 = 0;
            while (i2 < list.getLength()) {
                Node node = list.item(i2);
                if (node.getNodeType() == Node.TEXT_NODE) {
                    state.appendLine(node.getNodeValue());
                }
                ++i2;
            }
            if (variables.length > 0) {
                i2 = 0;
                while (i2 < variables.length) {
                    String tovariable = this.getVariableFrom(variables[i2], jdebug);
                    String qtype = this.scopes.getVariableQtype(tovariable, jdebug);
                    this.addVariableRef(tovariable, jdebug);
                    if (qtype == null) {
                        throw new BPELTranslatorException(this.compiler_util, (Node)jdebug, "BPEL <java_debug>: could not find type for variable " + tovariable);
                    }
                    state.appendLine("if (ret_var" + i2 + " != null) {\n");
                    state.appendLine("ret_var" + i2 + " = XSDUtil.toXMLString(ret_var" + i2 + ");\n");
                    state.appendLine("obj_var" + i2 + ".setValueInContainer( ((org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.internal.XMLAccessible)obj_var" + i2 + ".getValue()).ifromXML(ret_var" + i2 + "), true);\n");
                    state.appendLine("while (obj_var" + i2 + ".getParent() != null) obj_var" + i2 + " = obj_var" + i2 + ".getParent();");
                    state.appendLine("BPELVariable.setMessage(engine,\"" + this.scopes.getVariableName(tovariable, jdebug) + "\", " + qtype + ".toEngineMessage(obj_var" + i2 + ".getValue()));");
                    state.appendLine("}\n");
                    ++i2;
                }
                state.appendLine("}");
            }
            state.appendLine("//END JAVA DEBUG");
        }
        catch (Exception e) {
            throw new BPELTranslatorException(this.compiler_util, (Node)jdebug, e);
        }
    }

    public void translateActivity(BPELState newstate, Element activity, int index) throws BPELTranslatorException, NamespaceException {
        this.nt.addNamespaces(activity);
        if (this.compiler_util.getSwitches().APPEND_BPEL_TO_CALLSTACK) {
            newstate.appendLine("engine.ipushStack(\"BPEL " + TranslatorUtils.toJavaString(activity) + " (elem" + index + ") " + TranslatorUtils.toJavaString(this.compiler_util.getBpelLineNumberString(activity)) + "\");");
        }
        if (this.debug) {
            newstate.appendLine("bpelDebugSuspend.varFetch();");
            newstate.appendLine("while (bpelDebugSuspend.getValueInt() == 1) {");
            newstate.appendLine("  try {");
            newstate.appendLine("    Thread.sleep(2500);");
            newstate.appendLine("  } catch (Exception bpelDebugSuspendInterrupt) {}");
            newstate.appendLine("  bpelDebugSuspend.varFetch();");
            newstate.appendLine("}//end while");
        }
        this.translatePreEffectiveStandard(newstate, activity);
        String tagname = NamespaceTranslator.getName(activity);
        if (tagname.equals("receive")) {
            this.translateReceive(newstate, activity);
        } else if (tagname.equals("reply")) {
            this.translateReply(newstate, activity);
        } else if (tagname.equals("invoke")) {
            this.translateInvoke(newstate, activity);
        } else if (tagname.equals("assign")) {
            this.translateAssign(newstate, activity);
        } else {
            if (tagname.equals("throw")) {
                throw new BPELTranslatorException(this.compiler_util, (Node)activity, "<throw> activity is not currently supported");
            }
            if (tagname.equals("exit")) {
                this.translateExit(newstate, activity);
            } else if (tagname.equals("wait")) {
                this.translateWait(newstate, activity);
            } else if (tagname.equals("empty")) {
                this.translateEmpty(newstate, activity);
            } else if (tagname.equals("sequence")) {
                this.translateSequence(newstate, activity);
            } else if (tagname.equals("if")) {
                this.translateIf(newstate, activity);
            } else {
                if (tagname.equals("switch")) {
                    throw new BPELTranslatorException(this.compiler_util, (Node)activity, "<switch> activity has been renamed in a later BPEL spec to <if>");
                }
                if (tagname.equals("while")) {
                    this.translateWhile(newstate, activity);
                } else if (tagname.equals("forEach")) {
                    this.translateForEach(newstate, activity);
                } else if (tagname.equals("pick")) {
                    this.translatePick(newstate, activity);
                } else if (tagname.equals("flow")) {
                    this.translateFlow(newstate, activity);
                } else if (tagname.equals("scope")) {
                    this.translateScope(newstate, activity);
                } else if (!tagname.equals("compensate")) {
                    if (tagname.equals("java_import")) {
                        this.translateJavaImport(newstate, activity);
                    } else if (tagname.equals("java_debug")) {
                        this.translateJavaDebug(newstate, activity);
                    } else if (!(tagname.equals("for") || tagname.equals("until") || tagname.equals("condition") || tagname.equals("repeatEvery") || tagname.equals("variables") || tagname.equals("variable"))) {
                        if (tagname.equals("terminate")) {
                            throw new BPELTranslatorException(this.compiler_util, (Node)activity, "<terminate> activity has been renamed in a later BPEL spec to <exit>");
                        }
                        if (!(tagname.equals("import") || tagname.equals("startCounterValue") || tagname.equals("finalCounterValue") || tagname.equals("partnerLinks"))) {
                            this.log.logWarning(this.LOG_SOURCE, "unrecognised element compiling activity \"" + tagname + "\"");
                        }
                    }
                }
            }
        }
        this.translatePostEffectiveStandard(newstate, activity);
        if (this.compiler_util.getSwitches().APPEND_BPEL_TO_CALLSTACK) {
            newstate.appendLine("engine.ipopStack();");
        }
        this.nt.removeNamespaces(activity);
    }

    public void translateProcess(BPELState state, Element process) throws BPELTranslatorException, NamespaceException {
        BPELAsset asset;
        Element tmp;
        String name = process.getAttribute("name");
        this.lock_model = new LockModel(name);
        BPELThread thread = new BPELThread();
        thread.state = state;
        this.bpel_threads.push(thread);
        this.nt.addNamespaces(process);
        state.appendLine("    engine.ipushStack(\"BPEL **new thread - bpel process " + TranslatorUtils.toJavaString(this.compiler_util.getBpelLineNumberString(process)) + "**\");");
        if (this.debug) {
            state.appendLine("    try {");
        }
        state.appendLine("    bpelThreadId = \"1\";");
        state.appendLine("    bpelThreadIdList.append(bpelThreadId);");
        if (this.debug) {
            state.appendLine("    bpelThreadMap = engine.newHashMap(\"BPEL_THREADS_MAP\");");
            state.appendLine("    bpelThreadMap.put(bpelThreadId,bpelThreadId);");
            state.appendLine("    bpelDebugMap = engine.newHashMap(\"BPEL_DEBUG_MAP\");");
            state.appendLine("    bpelDebugSuspend = engine.newVariable(\"BPEL_BREAKPOINT_VAR\",SharedVariable.INTEGER,true);");
            state.appendLine("    bpelDebugSuspend.setValue((int)0);");
            state.appendLine("    bpelDebugSuspend.varStore();");
            state.appendLine("    bpelDebugStack = new Message(0);");
            state.appendLine("    bpelDebugStack.append(bpelThreadId);");
            state.appendLine("    engine.ipushStack(bpelDebugStack);");
        }
        state.appendDeclaration("boolean localVariableInit" + thread.id + " = false;");
        state.appendLine("if (!localVariableInit" + thread.id + ") {");
        state.mark(INSERT_LOCAL_VARIABLE_CREATION);
        state.appendLine("}");
        if (this.compiler_util.getSwitches().SINGLE_HOST_ASSET_OPTIMISATION) {
            state.appendConstructor("  //BPEL ASSET DEPLOYMENT");
            state.appendConstructor("  checkForAssetLocalisation();");
        }
        if ((tmp = Util.getFirstElement(process, "partnerLinks")) != null) {
            this.translatePartnerLinks(state, tmp);
        }
        state.appendLine("");
        this.translateScope(state, process);
        if (this.debug) {
            state.appendLine("    } catch (Exception bpelRunnerThreadException) {");
            state.appendLine("      bpelDebugMap.put(bpelThreadId+\"_TERMINATED\",new Integer(1));");
            state.appendLine("      throw bpelRunnerThreadException;");
            state.appendLine("    }");
        }
        state.appendLine("    engine.ipopStack();");
        ArrayList assets = this.getAllAssets();
        int i = 0;
        while (i < assets.size()) {
            asset = (BPELAsset)assets.get(i);
            if (this.canBeLocal(asset)) {
                asset.setLocal(true);
            }
            String atype = asset.getType() == 1 ? "(Synchronisation Link)" : "(Variable)";
            state.appendDeclaration("//" + asset.getJavaRef() + " - " + asset.getName() + " " + atype);
            if (this.compiler_util.getSwitches().FLOW_GRAPH_ASSET_OPTIMISATION) {
                state.appendDeclaration("static boolean " + asset.getJavaRef() + " = " + asset.isLocal() + ";");
                if (asset.isLocal()) {
                    ArrayList threads = asset.threads;
                    if (threads.size() == 0) {
                        this.log.logInfo(this.LOG_SOURCE, "asset " + asset.basename + " is never accessed");
                    } else if (threads.size() == 1) {
                        BPELThread refthread = (BPELThread)threads.get(0);
                        BPELState refstate = refthread.state;
                        int mark = refstate.getMark(INSERT_LOCAL_VARIABLE_CREATION);
                        String qmsg = asset.getVariableQType();
                        refstate.prog.insert(mark, "  if (" + asset.getJavaRef() + ") BPELVariable.createVariable(engine,\"" + asset.name + "\"," + qmsg + ".toEngineMessage(new " + qmsg + "())," + asset.getJavaRef() + ");\n");
                    } else {
                        this.log.logWarning(this.LOG_SOURCE, "asset is local but accessing thread pool size is != 1 (" + threads.size() + ")");
                    }
                }
            } else {
                state.appendDeclaration("static boolean " + asset.getJavaRef() + " = false;");
            }
            ++i;
        }
        if (this.compiler_util.getSwitches().SINGLE_HOST_ASSET_OPTIMISATION) {
            state.appendDeclaration("");
            state.appendDeclaration("//ASSET DEPLOYMENT SPECIAL CASE");
            state.appendDeclaration("public void checkForAssetLocalisation() throws Exception {");
            state.appendDeclaration("  if (engine.getHostsArray().length == 1) {");
            state.appendDeclaration("    //we are running on a single host - everything can be local");
            i = 0;
            while (i < assets.size()) {
                asset = (BPELAsset)assets.get(i);
                state.appendDeclaration("    " + asset.getJavaRef() + " = true;");
                ++i;
            }
            state.appendDeclaration("  }");
            state.appendDeclaration("}");
        }
        if (this.compiler_util.getSwitches().LOCK_RESOLVING) {
            new LockModelScopeOptimiser().optimise(this.lock_model);
            new LockModelEquivalenceOptimiser().optimise(this.lock_model);
            this.log.logInfo(this.LOG_SOURCE, "Variable lock analysis:");
            this.log.logInfo(this.LOG_SOURCE, this.lock_model.toString());
            this.log.logInfo(this.LOG_SOURCE, "Variable lock analysis (enabled locks only):");
            this.log.logInfo(this.LOG_SOURCE, this.lock_model.toStringNoDisabled());
            this.buildLockMethods(thread, state);
        }
        this.nt.removeNamespaces(process);
    }

    private void buildLockMethods(BPELThread thread, BPELState state) {
        ArrayList methods = thread.variableLockMethods;
        ArrayList names = thread.variableScopedNames;
        System.out.println("Building lock methods for " + thread.id + " (" + names.size() + ")");
        int i = 0;
        while (i < names.size()) {
            String cfr_ignored_0 = (String)names.get(i);
            String method = (String)methods.get(i);
            LockSync sync = this.lock_model.getSyncForMethodAlias(method);
            state.appendDeclaration("public void " + method + "_LOCK(String name) throws Exception {\n");
            if (sync.isEnabled()) {
                state.appendDeclaration("  BPELVariable.lockVariable(engine,name);\n");
            } else {
                state.appendDeclaration("  //No lock required (optimisation)\n");
            }
            state.appendDeclaration("}\n\n");
            state.appendDeclaration("public void " + method + "_RELEASE(String name) throws Exception {\n");
            if (sync.isEnabled()) {
                state.appendDeclaration("  BPELVariable.releaseVariable(engine,name);\n");
            } else {
                state.appendDeclaration("  //No lock required (optimisation)\n");
            }
            state.appendDeclaration("}\n\n");
            ++i;
        }
        ArrayList children = thread.getChildren();
        int i2 = 0;
        while (i2 < children.size()) {
            BPELThread child = (BPELThread)children.get(i2);
            this.buildLockMethods(child, state);
            ++i2;
        }
    }

    public BPELState getJava(String bpel, Document doc) throws Exception {
        Element process_element = doc.getDocumentElement();
        if (!NamespaceTranslator.getName(process_element).equals("process")) {
            throw new BPELTranslatorException(this.compiler_util, (Node)process_element, "Expected top level <process> element but found " + process_element.getTagName());
        }
        BPELState program_state = new BPELState();
        this.translateProcess(program_state, process_element);
        int i = 0;
        while (i < this.bindings.length) {
            program_state.appendDeclaration(this.bindings[i].getDeclarations());
            program_state.addImports(this.bindings[i].getImports());
            ++i;
        }
        return program_state;
    }

    private XSDTypeTranslator[] getCodecs(WSDLBindingTranslator[] bindings) throws BPELTranslatorException {
        HashMap codec_classes = new HashMap();
        ArrayList<XSDTypeTranslator> codecs = new ArrayList<XSDTypeTranslator>();
        int i = 0;
        while (i < bindings.length) {
            XSDTypeTranslator[] bcodecs = bindings[i].getCodecs();
            if (bcodecs == null) {
                throw new BPELTranslatorException(this.compiler_util, null, "binding " + bindings[i].getClass().getName() + " returned null codec array");
            }
            int k = 0;
            while (k < bcodecs.length) {
                Class<?> codec_class = bcodecs[k].getClass();
                if (codec_classes.get(codec_class) == null) {
                    codec_classes.put(codec_class, "");
                    codecs.add(bcodecs[k]);
                    this.log.logInfo(this.LOG_SOURCE, "added XSD Codec " + bcodecs[k].getClass().getName());
                }
                ++k;
            }
            ++i;
        }
        XSDTypeTranslator[] ret = new XSDTypeTranslator[codecs.size()];
        int i2 = 0;
        while (i2 < ret.length) {
            ret[i2] = (XSDTypeTranslator)codecs.get(i2);
            ++i2;
        }
        return ret;
    }

    public CompilerUnit[] getSources(String bpel, Document bpel_doc, String[] wsdl, String[] xsd, WSDLBindingTranslator[] bindings, String[] xsd_files, String[] wsdl_files) throws Exception {
        this.bindings = bindings;
        this.xsdmap = new XSDMap(this.compiler_util, this.log, xsd, wsdl);
        this.wsdlmap = new WSDLMap(this.compiler_util, this.log, wsdl);
        int i = 0;
        while (i < bindings.length) {
            this.log.logInfo(this.LOG_SOURCE, "initialising binding " + bindings[i].getClass().getName());
            bindings[i].init(this.compiler_util, this.log, this.xsdmap, this.wsdlmap, this.deps_loader);
            ++i;
        }
        this.codecs = this.getCodecs(bindings);
        i = 0;
        while (i < this.codecs.length) {
            this.log.logInfo(this.LOG_SOURCE, "initialising xsd type translator " + this.codecs[i].getClass().getName());
            this.codecs[i].init(this.compiler_util, this.xsdmap, this.wsdlmap, this.deps_loader);
            ++i;
        }
        WSDLTranslator wsdlt = new WSDLTranslator(this.compiler_util, this.log, this.xsdmap, this.wsdlmap);
        CompilerUnit[] wsdljava = wsdlt.getDefinitionSources(wsdl, bindings, this.codecs, wsdl_files);
        XSDTranslator xsdt = new XSDTranslator(this.compiler_util, this.log, this.xsdmap, this.wsdlmap);
        CompilerUnit[] xsdjava = xsdt.getDefinitionSources(xsd, wsdl, this.codecs, xsd_files, wsdl_files);
        BPELState java = this.getJava(bpel, bpel_doc);
        CompilerUnit[] all = new CompilerUnit[wsdljava.length + xsdjava.length + 1];
        all[0] = java;
        System.arraycopy(wsdljava, 0, all, 1, wsdljava.length);
        System.arraycopy(xsdjava, 0, all, wsdljava.length + 1, xsdjava.length);
        return all;
    }

    private static String resolveToAbsoluteBaseURI(String base_uri, String location_uri) throws Exception {
        String uri = location_uri;
        if (uri.indexOf(58) == -1) {
            uri = String.valueOf(base_uri) + "/" + location_uri;
        }
        String resolvedUri = uri.toString();
        String parentUri = resolvedUri.substring(0, Math.max(resolvedUri.lastIndexOf(47) + 1, resolvedUri.lastIndexOf(92) + 1));
        return parentUri;
    }

    private static String resolveToAbsoluteURI(String base_uri, String location_uri) throws Exception {
        String uri = location_uri;
        if (uri.indexOf(58) == -1) {
            uri = String.valueOf(base_uri) + "/" + location_uri;
        }
        String resolvedUri = uri.toString();
        return resolvedUri;
    }

    private String getFromLocationURI(Element tmp, WsdlImportResolver iresolver, String base_uri, String location_uri) throws Exception {
        System.out.println("LOCATION " + base_uri + " " + location_uri);
        String uri = location_uri;
        if (uri.indexOf(58) == -1) {
            uri = String.valueOf(base_uri) + "/" + location_uri;
        }
        try {
            String contents = iresolver.fetchUrl(new URL(uri), true, true);
            XMLUtil.documentFromString(contents);
            return contents;
        }
        catch (Exception e) {
            this.log.logWarning(this.LOG_SOURCE, "Failed to resolve import URI '" + uri + "'");
            if (tmp != null) {
                throw new BPELTranslatorException(this.compiler_util, (Node)tmp, e);
            }
            throw e;
        }
    }

    private void checkImportType(String imp_type) throws Exception {
        if (!imp_type.equals("http://schemas.xmlsoap.org/wsdl/") && !imp_type.equals("http://www.w3.org/2001/XMLSchema")) {
            this.log.logWarning(this.LOG_SOURCE, "Cannot import unknown import type '" + imp_type + "'");
            throw new Exception("Cannot import unknown import type '" + imp_type + "'");
        }
    }

    public void getAllImports(WsdlImportResolver iresolver, String bpel, String imp_type, String loc_uri, String base_uri, ArrayList files, ArrayList file_uris, ArrayList file_locs) throws Exception {
        DocumentBuilder builder = XMLUtil.getDocumentBuilder();
        Document doc = builder.parse(new ByteArrayInputStream(bpel.getBytes()), loc_uri);
        Element process = doc.getDocumentElement();
        if (!NamespaceTranslator.getName(process).equals("process") && !NamespaceTranslator.getName(process).equals("definitions")) {
            throw new BPELTranslatorException(this.compiler_util, (Node)process, "Expected top level <process> or <definitions> element but found " + process.getTagName());
        }
        NamespaceTranslator nt = this.compiler_util.createNamespaceTranslator();
        nt.addNamespaces(process);
        ArrayList imports = Util.getAllElements(process, "import");
        int i = 0;
        while (i < imports.size()) {
            Element tmp = (Element)imports.get(i);
            tmp.getAttribute("namespace");
            String import_location = tmp.getAttribute("location");
            this.log.logInfo(this.LOG_SOURCE, String.valueOf(loc_uri) + " imports -> " + import_location);
            if (NamespaceTranslator.getName(process).equals("process")) {
                String import_type = tmp.getAttribute("importType");
                this.checkImportType(import_type);
                if (import_type.equals(imp_type)) {
                    String content_uri = BPELTranslator.resolveToAbsoluteBaseURI(base_uri, import_location);
                    String content = this.getFromLocationURI(tmp, iresolver, base_uri, import_location);
                    String content_loc = BPELTranslator.resolveToAbsoluteURI(base_uri, import_location);
                    if (!files.contains(content)) {
                        files.add(content);
                        file_uris.add(content_uri);
                        file_locs.add(content_loc);
                    }
                }
            } else if (NamespaceTranslator.getName(process).equals("definitions")) {
                String content_loc;
                String content;
                String content_uri;
                if (imp_type.equals("http://schemas.xmlsoap.org/wsdl/") && import_location.toLowerCase().endsWith("wsdl")) {
                    content_uri = BPELTranslator.resolveToAbsoluteBaseURI(base_uri, import_location);
                    content = this.getFromLocationURI(tmp, iresolver, base_uri, import_location);
                    content_loc = BPELTranslator.resolveToAbsoluteURI(base_uri, import_location);
                    if (!files.contains(content)) {
                        files.add(content);
                        file_uris.add(content_uri);
                        file_locs.add(content_loc);
                    }
                } else if (imp_type.equals("http://www.w3.org/2001/XMLSchema") && import_location.toLowerCase().endsWith("xsd")) {
                    content_uri = BPELTranslator.resolveToAbsoluteBaseURI(base_uri, import_location);
                    content = this.getFromLocationURI(tmp, iresolver, base_uri, import_location);
                    content_loc = BPELTranslator.resolveToAbsoluteURI(base_uri, import_location);
                    if (!files.contains(content)) {
                        files.add(content);
                        file_uris.add(content_uri);
                        file_locs.add(content_loc);
                    }
                }
            }
            ++i;
        }
        nt.removeNamespaces(process);
    }

    public void getXsdImports(WsdlImportResolver iresolver, String bpel, String loc_uri, String base_uri, ArrayList files, ArrayList file_uris, ArrayList file_locs) throws Exception {
        this.getAllImports(iresolver, bpel, "http://www.w3.org/2001/XMLSchema", loc_uri, base_uri, files, file_uris, file_locs);
    }

    public void getWsdlImports(WsdlImportResolver iresolver, String bpel, String loc_uri, String base_uri, ArrayList files, ArrayList file_uris, ArrayList file_locs) throws Exception {
        this.getAllImports(iresolver, bpel, "http://schemas.xmlsoap.org/wsdl/", loc_uri, base_uri, files, file_uris, file_locs);
    }

    public Program getProgram(boolean debug, String bpel, String base_uri, JavaCompiler jcompiler, WsdlImportResolver iresolver, JARDependency[] deps, WSDLBindingTranslator[] bindings, TranslatorLog log, boolean validateOnly) throws Exception {
        ByteArrayOutputStream bout;
        JarOutputStream jout;
        int i;
        int wsdl_length;
        int xsd_length;
        this.debug = debug;
        this.log = log;
        DocumentBuilder builder = XMLUtil.getDocumentBuilder();
        Document bpel_doc = builder.parse(new ByteArrayInputStream(bpel.getBytes()), this.DEFAULT_BPEL_FILENAME);
        this.compiler_util.setBpelSource(bpel, bpel_doc);
        log.logInfo(this.LOG_SOURCE, String.valueOf(deps.length) + " JAR dependencies for Program compilation");
        URL[] dep_urls = new URL[deps.length];
        int i2 = 0;
        while (i2 < deps.length) {
            dep_urls[i2] = new File(deps[i2].getFilePath()).toURL();
            log.logInfo(this.LOG_SOURCE, "Dependancy ClassLoader URL " + (i2 + 1) + ": " + dep_urls[i2]);
            ++i2;
        }
        this.deps_loader = new URLClassLoader(dep_urls);
        ArrayList xsd = new ArrayList();
        ArrayList xsd_uris = new ArrayList();
        ArrayList xsd_locs = new ArrayList();
        ArrayList<String> wsdl = new ArrayList<String>();
        ArrayList wsdl_uris = new ArrayList();
        ArrayList wsdl_locs = new ArrayList();
        this.getXsdImports(iresolver, bpel, this.DEFAULT_BPEL_FILENAME, base_uri, xsd, xsd_uris, xsd_locs);
        this.getWsdlImports(iresolver, bpel, this.DEFAULT_BPEL_FILENAME, base_uri, wsdl, wsdl_uris, wsdl_locs);
        do {
            xsd_length = xsd.size();
            wsdl_length = wsdl.size();
            i = 0;
            while (i < wsdl_length) {
                this.getXsdImports(iresolver, (String)wsdl.get(i), (String)wsdl_locs.get(i), (String)wsdl_uris.get(i), xsd, xsd_uris, xsd_locs);
                this.getWsdlImports(iresolver, (String)wsdl.get(i), (String)wsdl_locs.get(i), (String)wsdl_uris.get(i), wsdl, wsdl_uris, wsdl_locs);
                ++i;
            }
        } while (xsd_length != xsd.size() || wsdl_length != wsdl.size());
        i = 0;
        while (i < wsdl_locs.size()) {
            log.logInfo(this.LOG_SOURCE, "WSDL Import: " + wsdl_locs.get(i));
            ++i;
        }
        i = 0;
        while (i < xsd_locs.size()) {
            log.logInfo(this.LOG_SOURCE, "XSD Import: " + xsd_locs.get(i));
            ++i;
        }
        DependencyInfo[] alldeps = B2jPlatform.getAllDependencyInfo();
        int i3 = 0;
        while (i3 < alldeps.length) {
            DependencyInfo dep = alldeps[i3];
            Properties[] ports = dep.getAutoJavaPorts();
            int k = 0;
            while (k < ports.length) {
                Properties port = ports[k];
                String clazz = port.getProperty("Class");
                String methods = port.getProperty("Methods").trim();
                if (clazz != null && clazz.length() > 0) {
                    WsdlGenerator gen;
                    String s;
                    log.logInfo(this.LOG_SOURCE, "Auto-generating WSDL for " + clazz);
                    ArrayList<String> allMethods = new ArrayList<String>();
                    if (methods != null && methods.length() != 0) {
                        String[] tmp = StringSplitter.split(methods, " ");
                        int v = 0;
                        while (v < tmp.length) {
                            allMethods.add(tmp[v].trim());
                            ++v;
                        }
                    }
                    if ((s = (gen = new WsdlGenerator(clazz, allMethods, this.deps_loader)).getWsdl()) == null) {
                        throw new Exception("WSDL auto-generation failed for " + clazz);
                    }
                    try {
                        FileOutputStream fout = new FileOutputStream("C:\\temp\\ALLSRC_" + clazz + ".wsdl");
                        fout.write(s.getBytes());
                        fout.close();
                    }
                    catch (Exception exception) {}
                    wsdl.add(s);
                }
                ++k;
            }
            ++i3;
        }
        System.out.println(String.valueOf(wsdl.size()) + " WSDL files");
        String[] xsd_sources = new String[xsd.size()];
        xsd.toArray(xsd_sources);
        String[] wsdl_sources = new String[wsdl.size()];
        wsdl.toArray(wsdl_sources);
        String[] xsd_files = new String[xsd_locs.size()];
        xsd_locs.toArray(xsd_files);
        String[] wsdl_files = new String[wsdl_locs.size()];
        wsdl_locs.toArray(wsdl_files);
        CompilerUnit[] all = this.getSources(bpel, bpel_doc, wsdl_sources, xsd_sources, bindings, xsd_files, wsdl_files);
        if (validateOnly) {
            return null;
        }
        log.logInfo(this.LOG_SOURCE, "Compiling generated Java");
        long jt = System.currentTimeMillis();
        jcompiler.setMainSourceFile(all[0]);
        CompilerUnit[] extra = new CompilerUnit[all.length - 1];
        System.arraycopy(all, 1, extra, 0, extra.length);
        jcompiler.addExtraSources(extra);
        jcompiler.compile();
        jt = System.currentTimeMillis() - jt;
        log.logInfo(this.LOG_SOURCE, "Java compilation complete (" + jt / 1000L + "s)");
        byte[] theclass = jcompiler.getMainSourceClass();
        Object classes = jcompiler.getExtraSourceClasses();
        String[] pkgs = jcompiler.getExtraSourceClassesPackages();
        HashMap<String, ByteArrayOutputStream> pkgbouts = new HashMap<String, ByteArrayOutputStream>();
        HashMap<String, JarOutputStream> pkgjars = new HashMap<String, JarOutputStream>();
        int i4 = 0;
        while (i4 < pkgs.length) {
            String fullname = pkgs[i4];
            String fullpkg = fullname.substring(0, fullname.lastIndexOf(47) + 1);
            jout = (JarOutputStream)pkgjars.get(fullpkg);
            if (jout == null) {
                log.logInfo(this.LOG_SOURCE, "Creating dependency JAR for package " + fullpkg);
                bout = new ByteArrayOutputStream();
                pkgbouts.put(fullpkg, bout);
                jout = new JarOutputStream(bout);
                pkgjars.put(fullpkg, jout);
            }
            jout.putNextEntry(new ZipEntry(fullname));
            jout.write(classes[i4]);
            jout.closeEntry();
            ++i4;
        }
        ArrayList<JARDependency> extradeps = new ArrayList<JARDependency>();
        for (String pkg : pkgjars.keySet()) {
            jout = (JarOutputStream)pkgjars.get(pkg);
            jout.close();
            bout = (ByteArrayOutputStream)pkgbouts.get(pkg);
            JARDependency jardep = new JARDependency(bout.toByteArray(), String.valueOf(pkg) + ".jar");
            pkgjars.put(pkg, null);
            pkgbouts.put(pkg, null);
            extradeps.add(jardep);
        }
        JARDependency[] findeps = new JARDependency[deps.length + extradeps.size()];
        System.arraycopy(deps, 0, findeps, 0, deps.length);
        int i5 = 0;
        while (i5 < extradeps.size()) {
            findeps[deps.length + i5] = (JARDependency)extradeps.get(i5);
            ++i5;
        }
        classes = new byte[0][];
        Program program = JavaProgramFactory.createEngineProgramFromClassFiles(theclass, classes, findeps);
        return program;
    }

    class BPELAsset {
        static final int BPEL_VARIABLE = 0;
        static final int BPEL_LINK = 1;
        int id = 0;
        String name;
        String basename;
        int type;
        String var_qtype;
        boolean isLocal = false;
        ArrayList threads = new ArrayList();

        public BPELAsset(String name, String basename, String var_qtype, int type) {
            this.name = name;
            this.basename = basename;
            this.type = type;
            this.var_qtype = var_qtype;
            this.id = BPELTranslator.this.bpelAssetID++;
        }

        public boolean isLocal() {
            return this.isLocal;
        }

        public void setLocal(boolean b) {
            this.isLocal = this.isLocal || b;
        }

        public int getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        public int getID() {
            return this.id;
        }

        public String getJavaRef() {
            return "bpelAssetId" + this.id;
        }

        public String getVariableQType() {
            return this.var_qtype;
        }
    }

    class BPELFlow {
        BPELThread thread;
        ArrayList threads = new ArrayList();

        public BPELFlow(BPELThread thread) {
            this.thread = thread;
        }
    }

    class BPELPartnerLink {
        String name;
        String qtype;
        String myRoleName;
        String partnerRoleName;
        String requiredBindingName;
        BPELPartnerLinkRole myRole;
        BPELPartnerLinkRole partnerRole;
    }

    class BPELState
    implements CompilerUnit {
        String PREFIX = "JEngineProgram_";
        String POSTFIX = "";
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        int SCOPE = 1;
        StringBuffer decl = new StringBuffer();
        StringBuffer cons = new StringBuffer();
        StringBuffer prog = new StringBuffer();
        String class_name;
        String method_name;
        ArrayList imports = new ArrayList();
        ArrayList substates = new ArrayList();
        HashMap marks = new HashMap();

        public BPELState() {
            this.method_name = BPELTranslator.this.getNextMethod();
            this.POSTFIX = this.sdf.format(new Date(System.currentTimeMillis()));
            this.class_name = String.valueOf(this.PREFIX) + this.POSTFIX;
        }

        public void mark(String markname) {
            this.marks.put(markname, new Integer(this.prog.length()));
        }

        public int getMark(String markname) {
            Integer tmp = (Integer)this.marks.get(markname);
            return tmp;
        }

        public String getPackageName() {
            return "";
        }

        public String getClassName() {
            return this.class_name;
        }

        public String getMethodName() {
            return this.method_name;
        }

        public BPELState newState() {
            BPELState state = new BPELState();
            this.substates.add(state);
            return state;
        }

        private void addImport(String s) {
            this.imports.add(s);
        }

        private void addImports(String[] s) {
            int i = 0;
            while (i < s.length) {
                this.imports.add(s[i]);
                ++i;
            }
        }

        private void appendDeclaration(String s) {
            this.decl.append(s).append("\n");
        }

        private void appendConstructor(String s) {
            this.cons.append(s).append("\n");
        }

        private void appendNoLine(String s) {
            int i = 0;
            while (i < this.SCOPE) {
                this.prog.append("  ");
                ++i;
            }
            this.prog.append(s);
        }

        private void appendLine(String s) {
            int i = 0;
            while (i < this.SCOPE) {
                this.prog.append("  ");
                ++i;
            }
            this.prog.append(s).append("\n");
        }

        private int getIndex() {
            return this.prog.length();
        }

        private void insertLine(String s, int index) {
            StringBuffer tmp = new StringBuffer();
            int i = 0;
            while (i < this.SCOPE) {
                tmp.append("  ");
                ++i;
            }
            tmp.append(s);
            this.prog.insert(index, tmp.toString());
        }

        private void insertNoLine(String s, int index) {
            StringBuffer tmp = new StringBuffer();
            int i = 0;
            while (i < this.SCOPE) {
                tmp.append("  ");
                ++i;
            }
            tmp.append(s);
            this.prog.insert(index, tmp.toString());
        }

        private void incrementScope() {
            ++this.SCOPE;
        }

        private void decrementScope() {
            if (this.SCOPE >= 1) {
                --this.SCOPE;
            }
        }

        public void importsToString(StringBuffer buf) {
            int i = 0;
            while (i < this.imports.size()) {
                buf.append("import ").append((String)this.imports.get(i)).append(";\n");
                ++i;
            }
            i = 0;
            while (i < this.substates.size()) {
                BPELState substate = (BPELState)this.substates.get(i);
                substate.importsToString(buf);
                ++i;
            }
        }

        public void declToString(StringBuffer buf) {
            buf.append(this.decl.toString());
            int i = 0;
            while (i < this.substates.size()) {
                BPELState substate = (BPELState)this.substates.get(i);
                substate.declToString(buf);
                ++i;
            }
        }

        public void consToString(StringBuffer buf) {
            buf.append(this.cons.toString());
            int i = 0;
            while (i < this.substates.size()) {
                BPELState substate = (BPELState)this.substates.get(i);
                substate.consToString(buf);
                ++i;
            }
        }

        public void progToString(StringBuffer buf) {
            buf.append("public void " + this.method_name + "() throws Exception {\n");
            buf.append(this.prog.toString());
            buf.append("}\n\n");
            int i = 0;
            while (i < this.substates.size()) {
                BPELState substate = (BPELState)this.substates.get(i);
                substate.progToString(buf);
                ++i;
            }
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append(BPELTranslator.this.runner_imports);
            this.importsToString(buf);
            buf.append("//@@START_STRIP\n");
            buf.append("public class " + this.class_name + " {\n");
            buf.append("//@@END_STRIP\n");
            buf.append(BPELTranslator.this.runner_template);
            this.declToString(buf);
            buf.append("\n");
            buf.append("//PROGRAM INITIALISATION\n");
            buf.append("public void engine_init() throws Exception {\n");
            this.consToString(buf);
            buf.append("}\n");
            buf.append("\n");
            this.progToString(buf);
            buf.append("\n");
            buf.append("//@@START_STRIP\n");
            buf.append("}//end " + this.class_name + "\n");
            buf.append("//@@END_STRIP\n\n");
            return buf.toString();
        }
    }

    class BPELThread {
        int id = 0;
        boolean multiple_copies = false;
        BPELFlow flow;
        BPELState state;
        ArrayList children = new ArrayList();
        ArrayList flows = new ArrayList();
        ArrayList variableLockMethods = new ArrayList();
        ArrayList variableScopedNames = new ArrayList();

        public BPELThread() {
            this.id = BPELTranslator.this.bpelThreadID++;
        }

        public BPELThread(BPELFlow flow) {
            this.id = BPELTranslator.this.bpelThreadID++;
            this.flow = flow;
            if (flow != null && flow.thread != null) {
                flow.thread.children.add(this);
            }
        }

        public ArrayList getChildren() {
            return this.children;
        }

        public BPELThread getParent() {
            if (this.flow == null) {
                return null;
            }
            return this.flow.thread;
        }

        public boolean hasParent(BPELThread thread) {
            if (this.flow == null) {
                return false;
            }
            if (this.flow.thread == thread) {
                return true;
            }
            return this.flow.thread.hasParent(thread);
        }

        public void addVariableLock(String methodName, String variableName) {
            this.variableLockMethods.add(methodName);
            this.variableScopedNames.add(variableName);
        }
    }
}

