/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.b2j.core.jengine.internal.compiler.locks;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.locks.LockLock;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.locks.LockModel;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.locks.LockModelOptimiser;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.locks.LockObject;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.locks.LockSync;

public class LockModelEquivalenceOptimiser
implements LockModelOptimiser {
    HashMap refCache = new HashMap();

    public void optimise(LockModel model) {
        int k;
        ArrayList syncs;
        LockLock lock;
        LockObject root = model.getRoot();
        ArrayList locks = root.getDeepLockList();
        ArrayList<ArrayList> syncLists = new ArrayList<ArrayList>();
        int i = 0;
        while (i < locks.size()) {
            lock = (LockLock)locks.get(i);
            if (lock.isEnabled()) {
                syncs = new ArrayList();
                this.getAllReferences(lock.getParent(), lock.getName(), syncs, false);
                syncLists.add(syncs);
                System.out.print("LOCK " + lock);
                k = 0;
                while (k < syncs.size()) {
                    System.out.print(" SYNC " + syncs.get(k));
                    ++k;
                }
                System.out.println("");
            } else {
                locks.remove(i--);
            }
            ++i;
        }
        i = 0;
        while (i < locks.size()) {
            lock = (LockLock)locks.get(i);
            syncs = (ArrayList)syncLists.get(i);
            if (lock.isEnabled()) {
                k = 0;
                while (k < locks.size()) {
                    if (i != k) {
                        LockLock tlock = (LockLock)locks.get(k);
                        ArrayList tsyncs = (ArrayList)syncLists.get(k);
                        if (tlock.isEnabled()) {
                            boolean failed = false;
                            int tz = 0;
                            while (tz < tsyncs.size()) {
                                LockSync tsync = (LockSync)tsyncs.get(tz);
                                boolean foundSuperLock = false;
                                int lz = 0;
                                while (lz < syncs.size()) {
                                    LockSync sync = (LockSync)syncs.get(lz);
                                    if (sync.from <= tsync.from && sync.to >= tsync.to) {
                                        foundSuperLock = true;
                                        break;
                                    }
                                    ++lz;
                                }
                                if (!foundSuperLock) {
                                    failed = true;
                                    break;
                                }
                                ++tz;
                            }
                            if (!failed) {
                                tlock.setEnabled(false, "syncs on lock " + lock.getName() + " comprise a superset");
                            }
                        }
                    }
                    ++k;
                }
            }
            ++i;
        }
    }

    private void getAllReferences(LockObject cur, String lockName, ArrayList syncs, boolean breakOnDuplicateLock) {
        if (breakOnDuplicateLock && cur.hasLock(lockName)) {
            System.out.println("HAS LOCK " + lockName);
            return;
        }
        if (cur instanceof LockSync) {
            LockSync sync = (LockSync)cur;
            if (sync.getLockName().equals(lockName)) {
                syncs.add(sync);
            }
        } else {
            int i = 0;
            while (i < cur.size()) {
                LockObject tmp = cur.getChild(i);
                this.getAllReferences(tmp, lockName, syncs, true);
                ++i;
            }
        }
    }
}

