/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.b2j.core.jengine.internal.compiler.xpath;

import java.lang.reflect.Method;
import java.util.ArrayList;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.ScopeStack;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.Switches;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.Util;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.wsdlmap.WSDLMap;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.xmlns.NamespaceTranslator;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.xpath.XPATHTranslatorException;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.xpath.XPATHTreeBuilder;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.xpath.XPATHTreePrecomputer;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.xpath.XPathNode;
import org.eclipse.stp.b2j.core.jengine.internal.utils.TranslatorUtils;
import org.eclipse.stp.b2j.core.jengine.internal.utils.UIDPool;
import org.eclipse.stp.b2j.core.jengine.internal.utils.XPU;
import org.eclipse.stp.b2j.core.xml.internal.w3c.Node;

public class XPATHTreeTranslator {
    public static boolean XPATH_DEBUG = false;
    private static final String INITIAL_NODESET = "initialNodeSet";
    int depth = 1;
    int depthMax = 1;
    int SCOPE = 0;
    static UIDPool uidpool = new UIDPool();
    int UID = uidpool.getUID();
    StringBuffer decl = new StringBuffer();
    ArrayList var_refs = new ArrayList();
    boolean force_no_cache = false;
    boolean variables_are_links = false;
    StringBuffer prefix = new StringBuffer();
    StringBuffer postfix = new StringBuffer();
    StringBuffer sb = new StringBuffer();
    ArrayList exceptions = new ArrayList();

    private String removeQuotes(String s) {
        if (s.length() > 1 && (s.startsWith("\"") && s.endsWith("\"") || s.startsWith("'") && s.endsWith("'"))) {
            return s.substring(1, s.length() - 1);
        }
        return s;
    }

    private int getDepth() {
        return this.depth;
    }

    private int getParentDepth() {
        return this.depth - 1;
    }

    private void incrementDepth() {
        ++this.depth;
        if (this.depth > this.depthMax) {
            this.depthMax = this.depth;
        }
    }

    private void decrementDepth() {
        --this.depth;
    }

    private void incrementScope() {
        ++this.SCOPE;
    }

    private void decrementScope() {
        if (this.SCOPE >= 1) {
            --this.SCOPE;
        }
    }

    public String getVarRef(int index) {
        return "xpath_variable" + index + "_" + this.UID;
    }

    public String getLinkRef(int index) {
        return "xpath_link" + index + "_" + this.UID;
    }

    public String getRetRef() {
        return "xpath_return_" + this.UID;
    }

    public String getDirtyRef() {
        return "xpath_dirty_" + this.UID;
    }

    private void appendDeclaration(String s) {
        this.decl.append(s).append('\n');
    }

    private void appendLine(String s) {
        int i = 0;
        while (i < this.SCOPE) {
            this.sb.append("  ");
            ++i;
        }
        this.sb.append(s).append('\n');
    }

    private void appendNoLine(String s) {
        int i = 0;
        while (i < this.SCOPE) {
            this.sb.append("  ");
            ++i;
        }
        this.sb.append(s);
    }

    public ArrayList getReferencedVariables() {
        return this.var_refs;
    }

    private void checkForExceptions(String expression, Node source) throws Exception {
        int i = 0;
        if (i < this.exceptions.size()) {
            throw XPATHTranslatorException.parserError((Exception)this.exceptions.get(i), expression, source);
        }
    }

    private void error(String s) {
        this.exceptions.add(new Exception(s));
    }

    public String resolveToBoolean(String method, String expression, Switches switches, NamespaceTranslator nt, ScopeStack scopes, ScopeStack flow_scopes, WSDLMap wsdlmap, Node source) throws Exception {
        this.appendLine("boolean " + this.getRetRef() + ";");
        this.appendLine("public boolean " + method + "() throws Exception {");
        int prefix_index = this.sb.length();
        this.resolve(expression, switches, nt, scopes, flow_scopes, wsdlmap, source, false);
        this.appendLine("  " + this.getRetRef() + " = XPU.toBoolean(stack.peek()).booleanValue();\n");
        this.sb.insert(prefix_index, this.prefix.toString());
        this.appendNoLine(this.postfix.toString());
        this.appendLine("    return " + this.getRetRef() + ";");
        this.appendLine("}");
        return String.valueOf(this.decl.toString()) + this.sb.toString();
    }

    public String resolveLinksToBoolean(String method, String expression, Switches switches, NamespaceTranslator nt, ScopeStack scopes, ScopeStack flow_scopes, WSDLMap wsdlmap, Node source) throws Exception {
        this.variables_are_links = true;
        return this.resolveToBoolean(method, expression, switches, nt, scopes, flow_scopes, wsdlmap, source);
    }

    public String resolveToDateOrDateTimeInMillis(String method, String expression, Switches switches, NamespaceTranslator nt, ScopeStack scopes, ScopeStack flow_scopes, WSDLMap wsdlmap, Node source) throws Exception {
        this.appendLine("long " + this.getRetRef() + ";");
        this.appendLine("public long " + method + "() throws Exception {");
        int prefix_index = this.sb.length();
        this.resolve(expression, switches, nt, scopes, flow_scopes, wsdlmap, source, false);
        String d_type = nt.qualify("xsd:date", false);
        String dt_type = nt.qualify("xsd:dateTime", false);
        this.appendLine("  String xpath_tmpreturn = XPU.toString(stack.peek());");
        this.appendLine("  try {");
        this.appendLine("  \t//parse as a dateTime");
        this.appendLine("    " + this.getRetRef() + " = ((" + dt_type + ") " + dt_type + ".fromXML(xpath_tmpreturn)).INTERNAL_VALUE.getTimeInMillis();");
        this.appendLine("  } catch (Exception e) {");
        this.appendLine("  \t//not a dateTime - must be a date");
        this.appendLine("    " + this.getRetRef() + " = ((" + d_type + ") " + d_type + ".fromXML(xpath_tmpreturn)).INTERNAL_VALUE.getTimeInMillis();");
        this.appendLine("  }");
        this.sb.insert(prefix_index, this.prefix.toString());
        this.appendNoLine(this.postfix.toString());
        this.appendLine("    return " + this.getRetRef() + ";");
        this.appendLine("}");
        return String.valueOf(this.decl.toString()) + this.sb.toString();
    }

    public String resolveToDurationInMillis(String method, String expression, Switches switches, NamespaceTranslator nt, ScopeStack scopes, ScopeStack flow_scopes, WSDLMap wsdlmap, Node source) throws Exception {
        this.appendLine("long " + this.getRetRef() + ";");
        this.appendLine("public long " + method + "() throws Exception {");
        int prefix_index = this.sb.length();
        String dtype = nt.qualify("xsd:duration", false);
        this.resolve(expression, switches, nt, scopes, flow_scopes, wsdlmap, source, false);
        this.appendNoLine("  " + this.getRetRef() + " = ");
        this.appendNoLine("Math.max(1, ((" + dtype + ") " + dtype + ".fromXML(");
        this.appendNoLine("XPU.toString(stack.peek())");
        this.appendNoLine(")).INTERNAL_VALUE.longValue() )");
        this.appendLine(";");
        this.sb.insert(prefix_index, this.prefix.toString());
        this.appendNoLine(this.postfix.toString());
        this.appendLine("    return " + this.getRetRef() + ";");
        this.appendLine("}");
        return String.valueOf(this.decl.toString()) + this.sb.toString();
    }

    public String resolveToType(String method, String expression, Switches switches, NamespaceTranslator nt, String type, ScopeStack scopes, ScopeStack flow_scopes, WSDLMap wsdlmap, Node source) throws Exception {
        this.appendLine(type + " " + this.getRetRef() + ";");
        this.appendLine("public " + type + " " + method + "() throws Exception {");
        int prefix_index = this.sb.length();
        this.resolve(expression, switches, nt, scopes, flow_scopes, wsdlmap, source, false);
        this.appendLine("  " + this.getRetRef() + " = (" + type + ") " + type + ".fromXML(XPU.toString(stack.peek()));");
        this.sb.insert(prefix_index, this.prefix.toString());
        this.appendNoLine(this.postfix.toString());
        this.appendLine("    return " + this.getRetRef() + ";");
        this.appendLine("}");
        return String.valueOf(this.decl.toString()) + this.sb.toString();
    }

    public String resolveToTypeUsingInstance(String method, String expression, Switches switches, NamespaceTranslator nt, String type, String instance, ScopeStack scopes, ScopeStack flow_scopes, WSDLMap wsdlmap, Node source) throws Exception {
        this.appendLine(type + " " + this.getRetRef() + ";");
        this.appendLine("public " + type + " " + method + "(" + type + " typeInstance) throws Exception {");
        int prefix_index = this.sb.length();
        this.resolve(expression, switches, nt, scopes, flow_scopes, wsdlmap, source, false);
        this.appendLine("  " + this.getRetRef() + " = (" + type + ") typeInstance.ifromXML(XPU.toString(stack.peek()));");
        this.sb.insert(prefix_index, this.prefix.toString());
        this.appendNoLine(this.postfix.toString());
        this.appendLine("    return " + this.getRetRef() + ";");
        this.appendLine("}");
        return String.valueOf(this.decl.toString()) + this.sb.toString();
    }

    public String resolveToNodeSet(String method, String expression, Switches switches, NamespaceTranslator nt, ScopeStack scopes, ScopeStack flow_scopes, WSDLMap wsdlmap, Node source) throws Exception {
        this.appendLine("XNodeSet " + this.getRetRef() + ";");
        this.appendLine("public XNodeSet " + method + "() throws Exception {");
        int prefix_index = this.sb.length();
        this.resolve(expression, switches, nt, scopes, flow_scopes, wsdlmap, source, false);
        this.appendLine("  " + this.getRetRef() + " = (XNodeSet)stack.peek();");
        this.sb.insert(prefix_index, this.prefix.toString());
        this.appendNoLine(this.postfix.toString());
        this.appendLine("    return " + this.getRetRef() + ";");
        this.appendLine("}");
        return String.valueOf(this.decl.toString()) + this.sb.toString();
    }

    public String resolveVariableQueryToNodeSet(String method, String expression, Util compiler_util, NamespaceTranslator nt, WSDLMap wsdlmap, Node source) throws Exception {
        Switches switches = compiler_util.getSwitches();
        ScopeStack scopes = new ScopeStack(compiler_util);
        ScopeStack flow_scopes = new ScopeStack(compiler_util);
        this.appendLine("XNodeSet " + this.getRetRef() + ";");
        this.appendLine("public XNodeSet " + method + "(XNodeSet " + INITIAL_NODESET + ") throws Exception {");
        int prefix_index = this.sb.length();
        this.resolve(expression, switches, nt, scopes, flow_scopes, wsdlmap, source, true);
        this.appendLine("  " + this.getRetRef() + " = (XNodeSet)stack.peek();");
        this.sb.insert(prefix_index, this.prefix.toString());
        this.appendNoLine(this.postfix.toString());
        this.appendLine("    return " + this.getRetRef() + ";");
        this.appendLine("}");
        return String.valueOf(this.decl.toString()) + this.sb.toString();
    }

    public String resolveToXmlString(String method, String expression, Switches switches, NamespaceTranslator nt, ScopeStack scopes, ScopeStack flow_scopes, WSDLMap wsdlmap, Node source) throws Exception {
        this.appendLine("String " + this.getRetRef() + ";");
        this.appendLine("public String " + method + "() throws Exception {");
        int prefix_index = this.sb.length();
        this.resolve(expression, switches, nt, scopes, flow_scopes, wsdlmap, source, false);
        this.appendLine("  " + this.getRetRef() + " = String.valueOf(((XNodeSet)stack.peek()).get(0).getValue());");
        this.sb.insert(prefix_index, this.prefix.toString());
        this.appendNoLine(this.postfix.toString());
        this.appendLine("    return " + this.getRetRef() + ";");
        this.appendLine("}");
        return String.valueOf(this.decl.toString()) + this.sb.toString();
    }

    public String resolveToString(String method, String expression, Switches switches, NamespaceTranslator nt, ScopeStack scopes, ScopeStack flow_scopes, WSDLMap wsdlmap, Node source) throws Exception {
        this.appendLine("String " + this.getRetRef() + ";");
        this.appendLine("public String " + method + "() throws Exception {");
        int prefix_index = this.sb.length();
        this.resolve(expression, switches, nt, scopes, flow_scopes, wsdlmap, source, false);
        this.appendLine("  " + this.getRetRef() + " = XSDUtil.fromXMLString(XPU.toString(stack.peek()));");
        this.sb.insert(prefix_index, this.prefix.toString());
        this.appendNoLine(this.postfix.toString());
        this.appendLine("    return " + this.getRetRef() + ";");
        this.appendLine("}");
        return String.valueOf(this.decl.toString()) + this.sb.toString();
    }

    public String resolveToNumber(String method, String expression, Switches switches, NamespaceTranslator nt, ScopeStack scopes, ScopeStack flow_scopes, WSDLMap wsdlmap, Node source) throws Exception {
        this.appendLine("double " + this.getRetRef() + ";");
        this.appendLine("public double " + method + "() throws Exception {");
        int prefix_index = this.sb.length();
        this.resolve(expression, switches, nt, scopes, flow_scopes, wsdlmap, source, false);
        this.appendLine("  " + this.getRetRef() + " = XPU.toNumber(stack.peek()).doubleValue();");
        this.sb.insert(prefix_index, this.prefix.toString());
        this.appendNoLine(this.postfix.toString());
        this.appendLine("    return " + this.getRetRef() + ";");
        this.appendLine("}");
        return String.valueOf(this.decl.toString()) + this.sb.toString();
    }

    public String resolveToAny(String method, String expression, Switches switches, NamespaceTranslator nt, ScopeStack scopes, ScopeStack flow_scopes, WSDLMap wsdlmap, Node source) throws Exception {
        this.appendLine("Object " + this.getRetRef() + ";");
        this.appendLine("public Object " + method + "() throws Exception {");
        int prefix_index = this.sb.length();
        this.resolve(expression, switches, nt, scopes, flow_scopes, wsdlmap, source, false);
        this.appendLine("  " + this.getRetRef() + " = stack.peek();");
        this.sb.insert(prefix_index, this.prefix.toString());
        this.appendNoLine(this.postfix.toString());
        this.appendLine("    return " + this.getRetRef() + ";");
        this.appendLine("}");
        return String.valueOf(this.decl.toString()) + this.sb.toString();
    }

    private String resolve(String expression, Switches switches, NamespaceTranslator nt, ScopeStack scopes, ScopeStack flow_scopes, WSDLMap wsdlmap, Node source, boolean expectInitialNodeSet) throws Exception {
        this.force_no_cache = false;
        this.incrementScope();
        this.incrementScope();
        this.appendDeclaration("//////////////////////////////////");
        this.appendDeclaration("// XPATH EXPRESSION - " + expression.replace('\n', ' ').replace('\r', ' '));
        this.appendDeclaration("//////////////////////////////////");
        if (switches.APPEND_BPEL_TO_CALLSTACK) {
            this.appendLine("    Runner.pushStack(\"XPATH expression " + TranslatorUtils.toJavaString(expression) + "\");");
        }
        this.appendLine("");
        this.appendLine("Object func_ret = null;");
        this.appendLine("XNodeSet nsContext = null;");
        this.appendLine("FStack stack = new FStack();");
        this.appendLine("nsTmp" + this.getParentDepth() + " = new XNodeSet();");
        this.appendLine("int xpi" + this.getParentDepth() + " = 0;\n");
        if (expectInitialNodeSet) {
            this.appendLine("nsContext = initialNodeSet;");
            this.appendLine("stack.push(nsContext);\n");
        }
        try {
            XPATHTreeBuilder treebuilder = new XPATHTreeBuilder(nt);
            treebuilder.resolveToTree(expression, scopes, source);
            XPathNode roots = treebuilder.getRootExpressionsContainer();
            if (switches.XPATH_EXPRESSION_PRECOMPUTING) {
                XPATHTreePrecomputer precomputer = new XPATHTreePrecomputer();
                int i = 0;
                while (i < roots.getChildCount()) {
                    precomputer.precompute(roots.getChild(i));
                    ++i;
                }
                roots = treebuilder.getRootExpressionsContainer();
            }
            if (roots.getChildCount() != 1) {
                throw new XPATHTranslatorException("error - found more than one expression to translate");
            }
            this.generateCode(roots.getChild(0), scopes, flow_scopes, wsdlmap, source);
        }
        catch (XPATHTranslatorException t) {
            throw t;
        }
        catch (Throwable t) {
            throw XPATHTranslatorException.parserError(t, expression, source);
        }
        this.decrementScope();
        this.decrementScope();
        if (switches.XPATH_EXPRESSION_CACHING && !this.force_no_cache) {
            this.appendDeclaration("boolean " + this.getDirtyRef() + " = true;");
        }
        int i = 0;
        while (i < this.var_refs.size()) {
            String varname = (String)this.var_refs.get(i);
            String ref = this.getVarRef(i);
            this.appendDeclaration("SharedVariable " + ref + " = null;");
            this.appendDeclaration("Message " + ref + "_val = null;");
            if (i == 0) {
                this.prefix.append("  if (" + ref + " == null) {\n");
                this.prefix.append("    //initialise variable references\n");
            }
            this.prefix.append("    " + ref + " = BPELVariable.getReference(engine,\"" + scopes.getVariableName(varname, source) + "\");\n");
            if (i == this.var_refs.size() - 1) {
                this.prefix.append("  }\n");
            }
            ++i;
        }
        this.prefix.append("  Message tmp_value;\n");
        i = 0;
        while (i < this.var_refs.size()) {
            String cfr_ignored_0 = (String)this.var_refs.get(i);
            String ref = this.getVarRef(i);
            if (switches.XPATH_EXPRESSION_CACHING && !this.force_no_cache) {
                this.prefix.append("  tmp_value = BPELVariable.getMessageFromRef(engine," + ref + ");\n");
                this.prefix.append("  if (tmp_value != " + ref + "_val) {\n");
                this.prefix.append("    " + ref + "_val = tmp_value;\n");
                this.prefix.append("    " + this.getDirtyRef() + " = true;\n");
                this.prefix.append("  }\n");
            } else {
                this.prefix.append("    " + ref + "_val = BPELVariable.getMessageFromRef(engine," + ref + ");\n");
            }
            ++i;
        }
        i = 0;
        while (i < this.var_refs.size()) {
            String cfr_ignored_1 = (String)this.var_refs.get(i);
            this.getVarRef(i);
            ++i;
        }
        if (switches.XPATH_EXPRESSION_CACHING && !this.force_no_cache) {
            this.prefix.append("  if (" + this.getDirtyRef() + ") {\n");
            this.prefix.append("    " + this.getDirtyRef() + " = false;\n");
            this.postfix.append("  }\n");
        }
        i = 0;
        while (i <= this.depthMax) {
            this.prefix.append("    XNodeSet nsRet" + i + ";\n");
            this.prefix.append("    XNodeSet nsTmp" + i + ";\n");
            ++i;
        }
        if (switches.APPEND_BPEL_TO_CALLSTACK) {
            this.appendLine("    Runner.popStack();");
        }
        this.checkForExceptions(expression, source);
        return this.sb.toString();
    }

    public void generate(XPathNode node, ScopeStack scopes, ScopeStack flow_scopes, WSDLMap wsdlmap, Node source) throws Exception {
        this.generateCode(node, scopes, flow_scopes, wsdlmap, source);
    }

    public void generateCode(XPathNode node, ScopeStack scopes, ScopeStack flow_scopes, WSDLMap wsdlmap, Node source) throws Exception {
        switch (node.getType()) {
            case 1: {
                this.appendLine("stack.pop();");
                this.appendLine("nsRet" + this.getDepth() + " = new XNodeSet();");
                this.appendLine("nsTmp" + this.getDepth() + " = nsContext;");
                this.appendLine("for (int xpi" + this.getDepth() + " = 0; xpi" + this.getDepth() + " < nsTmp" + this.getDepth() + ".size(); xpi" + this.getDepth() + "++) {");
                this.appendLine("  nsContext = XPU.getSingleNodeSet(nsTmp" + this.getDepth() + ".get(xpi" + this.getDepth() + "));");
                this.appendLine("  //PREDICATE EXPRESSION");
                this.incrementDepth();
                this.incrementScope();
            }
        }
        int i = 0;
        while (i < node.getChildCount()) {
            this.generateCode(node.getChild(i), scopes, flow_scopes, wsdlmap, source);
            ++i;
        }
        switch (node.getType()) {
            case 1: {
                this.decrementScope();
                this.decrementDepth();
                this.appendLine("  //END PREDICATE EXPRESSION");
                this.appendLine("  Object tmp" + this.getDepth() + " = stack.pop();");
                this.appendLine("  if (tmp" + this.getDepth() + " instanceof Number) {");
                this.appendLine("    if (((Number)tmp" + this.getDepth() + ").intValue() == xpi" + this.getDepth() + ") {");
                this.appendLine("      nsRet" + this.getDepth() + ".addAll(nsContext);");
                this.appendLine("    }");
                this.appendLine("  } else if (XPU.toBoolean(tmp" + this.getDepth() + ").booleanValue()) {");
                this.appendLine("    nsRet" + this.getDepth() + ".addAll(nsContext);");
                this.appendLine("  }");
                this.appendLine("}");
                this.appendLine("nsContext = nsRet" + this.getDepth() + ";");
                this.appendLine("stack.push(nsContext);");
                break;
            }
            case 2: {
                String number = String.valueOf(node.getArg(0));
                this.appendLine("stack.push(new Double(" + number + "));");
                break;
            }
            case 11: {
                String value = String.valueOf(node.getArg(0));
                if (value.equalsIgnoreCase("true")) {
                    this.appendLine("stack.push(Boolean.TRUE);");
                    break;
                }
                this.appendLine("stack.push(Boolean.FALSE);");
                break;
            }
            case 3: {
                String literal = String.valueOf(node.getArg(0));
                if (!literal.startsWith("\"")) {
                    literal = "\"" + literal;
                }
                if (!literal.endsWith("\"")) {
                    literal = String.valueOf(literal) + "\"";
                }
                literal = TranslatorUtils.toJavaString(literal, 1, literal.length() - 2);
                this.appendLine("stack.push(" + literal + ");");
                break;
            }
            case 4: {
                String operator = String.valueOf(node.getArg(0));
                if (operator.equals("+")) {
                    operator = "add";
                } else if (operator.equals("-")) {
                    operator = "subtract";
                } else {
                    this.error("additive operator " + operator + " not found");
                    operator = "add";
                }
                if (XPATH_DEBUG) {
                    this.appendLine("engine.print(\"XPR - \"+stack.peek(2)+\" [" + operator + "] \"+stack.peek());");
                }
                this.appendLine("stack.discardAndPush(2,XPU." + operator + "(stack.peek(2),stack.peek()));");
                if (!XPATH_DEBUG) break;
                this.appendLine("engine.print(\"XPR - " + operator + " = \"+stack.peek());");
                break;
            }
            case 5: {
                String operator = String.valueOf(node.getArg(0));
                if (operator.equals("*")) {
                    operator = "multiply";
                } else if (operator.equals("div")) {
                    operator = "div";
                } else if (operator.equals("mod")) {
                    operator = "mod";
                } else {
                    this.error("multiplicative operator " + operator + " not found");
                    operator = "multiply";
                }
                if (XPATH_DEBUG) {
                    this.appendLine("engine.print(\"XPR - \"+stack.peek(2)+\" [" + operator + "] \"+stack.peek());");
                }
                this.appendLine("stack.discardAndPush(2,XPU." + operator + "(stack.peek(2),stack.peek()));");
                if (!XPATH_DEBUG) break;
                this.appendLine("engine.print(\"XPR - " + operator + " = \"+stack.peek());");
                break;
            }
            case 6: {
                String operator = String.valueOf(node.getArg(0));
                if (operator.equals("-")) {
                    operator = "negate";
                } else {
                    this.error("unary operator " + operator + " not found");
                    operator = "negate";
                }
                if (XPATH_DEBUG) {
                    this.appendLine("engine.print(\"XPR - [" + operator + "] \"+stack.peek());");
                }
                this.appendLine("stack.push(XPU." + operator + "(stack.pop()));");
                if (!XPATH_DEBUG) break;
                this.appendLine("engine.print(\"XPR - " + operator + " = \"+stack.peek());");
                break;
            }
            case 7: {
                String operator = String.valueOf(node.getArg(0));
                if (operator.equals(">")) {
                    operator = "gt";
                } else if (operator.equals(">=")) {
                    operator = "ge";
                } else if (operator.equals("<")) {
                    operator = "lt";
                } else if (operator.equals("<=")) {
                    operator = "le";
                } else {
                    this.error("relational operator " + operator + " not found");
                    operator = "gt";
                }
                if (XPATH_DEBUG) {
                    this.appendLine("engine.print(\"XPR \"+stack.peek(2)+\" [" + operator + "] \"+stack.peek());");
                }
                this.appendLine("stack.discardAndPush(2,XPU." + operator + "(stack.peek(2),stack.peek()));");
                if (!XPATH_DEBUG) break;
                this.appendLine("engine.print(\"XPR " + operator + " = \"+stack.peek());");
                break;
            }
            case 8: {
                String operator = String.valueOf(node.getArg(0));
                if (XPATH_DEBUG) {
                    System.out.println("XPR - equality expr - " + operator);
                }
                if (operator.equals("=")) {
                    operator = "eq";
                } else if (operator.equals("!=")) {
                    operator = "ne";
                } else {
                    this.error("equality operator " + operator + " not found");
                    operator = "ne";
                }
                if (XPATH_DEBUG) {
                    this.appendLine("engine.print(\"XPR \"+stack.peek(2)+\" [" + operator + "] \"+stack.peek());");
                }
                this.appendLine("stack.discardAndPush(2,XPU." + operator + "(stack.peek(2),stack.peek()));");
                if (!XPATH_DEBUG) break;
                this.appendLine("engine.print(\"XPR " + operator + " = \"+stack.peek());");
                break;
            }
            case 9: {
                String.valueOf(node.getArg(0));
                this.appendLine("stack.push(XPU.and(stack.pop(),stack.pop()));");
                break;
            }
            case 10: {
                String.valueOf(node.getArg(0));
                this.appendLine("stack.push(XPU.or(stack.pop(),stack.pop()));");
                break;
            }
            case 12: {
                String qpartType;
                String qtype;
                String tovariable = node.getArg(0);
                if (this.variables_are_links) {
                    this.force_no_cache = true;
                    this.appendLine("stack.push(new Boolean(BPELLink.incoming(engine,\"" + flow_scopes.getLinkName(tovariable, source) + "\")));");
                    break;
                }
                String topart = null;
                int dotindex = tovariable.indexOf(46);
                if (dotindex != -1) {
                    topart = tovariable.substring(dotindex + 1);
                    tovariable = tovariable.substring(0, dotindex);
                }
                if ((qtype = scopes.getVariableQtype(tovariable, source)) == null) {
                    this.error("XPath: could not find variable reference " + tovariable);
                }
                int index = this.var_refs.size();
                this.var_refs.add(tovariable);
                String REF = this.getVarRef(index);
                this.appendLine("nsContext = XPU.getSingleNodeSet( \"" + tovariable + "\", (" + qtype + ") " + qtype + ".fromEngineMessage(" + REF + "_val), null, 0);");
                this.appendLine("stack.push(nsContext);");
                if (topart == null) break;
                if (wsdlmap.getMessage(qtype) == null) {
                    this.error("Could not find WSDL message " + qtype);
                }
                if ((qpartType = wsdlmap.getMessage(qtype).getPartType(topart)) == null) {
                    this.error("No part type " + topart + " found in WSDL message " + qtype);
                }
                this.appendLine("if (((" + qtype + ") nsContext.get(0).getValue())." + NamespaceTranslator.getElement(topart) + ".length == 0) {");
                this.appendLine("((" + qtype + ") nsContext.get(0).getValue())." + NamespaceTranslator.getElement(topart) + " = new " + qpartType + "[1];");
                this.appendLine("((" + qtype + ") nsContext.get(0).getValue())." + NamespaceTranslator.getElement(topart) + "[0] = new " + qpartType + "();");
                this.appendLine("}");
                this.appendLine("nsContext = XPU.getSingleNodeSet( \"" + topart + "\", ((" + qtype + ") nsContext.get(0).getValue())." + NamespaceTranslator.getElement(topart) + "[0], ((" + qtype + ") nsContext.get(0).getValue())." + NamespaceTranslator.getElement(topart) + ", 0, nsContext.get(0));");
                this.appendLine("stack.discardAndPush(1,nsContext);");
                break;
            }
            case 13: {
                String function = node.getArg(0);
                int args = node.getChildCount();
                function = NamespaceTranslator.getName(function);
                if (XPATH_DEBUG) {
                    System.out.println("XPR - function call - " + function + "(" + args + ")");
                }
                if (function.equals("getThreadChildIndex")) {
                    this.appendLine("stack.push(new Double(bpelThreadChildIndex));");
                    break;
                }
                if (function.equals("concat")) {
                    int id = uidpool.getUID();
                    this.appendLine("StringBuffer concat" + id + " = new StringBuffer();");
                    int i2 = 0;
                    while (i2 < args) {
                        this.appendLine("XPU.toString( stack.peek(" + (args - i2) + "), concat" + id + " );");
                        ++i2;
                    }
                    this.appendLine("stack.discardAndPush(" + args + ",concat" + id + ".toString());");
                    break;
                }
                if (function.equals("substring")) {
                    this.appendNoLine("stack.discardAndPush( ");
                    if (args > 2) {
                        this.appendNoLine("3,");
                    } else {
                        this.appendNoLine("2,");
                    }
                    this.appendNoLine("((String)stack.peek(3)).substring(");
                    if (args > 2) {
                        this.appendNoLine("((Number)stack.peek(2)).intValue()");
                        this.appendNoLine(",((Number)stack.peek()).intValue()");
                    } else {
                        this.appendNoLine("((Number)stack.peek()).intValue()");
                    }
                    this.appendNoLine(")");
                    this.appendLine(");");
                    break;
                }
                if (function.equals("getVariableProperty")) {
                    String propname = String.valueOf(node.getArg(2));
                    this.appendLine("stack.discardAndPush(1,((XNodeSet)stack.peek()).get(0).getValue().getBpelProperty(\"" + propname + "\"));");
                    break;
                }
                String origFunction = function;
                if (function.equals("string")) {
                    function = "toString";
                } else if (function.equals("number")) {
                    function = "toNumber";
                } else if (function.equals("boolean")) {
                    function = "toBoolean";
                } else if (function.equals("contains")) {
                    function = "stringContains";
                } else if (function.equals("starts-with")) {
                    function = "stringStartsWith";
                } else if (function.equals("string-length")) {
                    function = "stringLength";
                } else if (function.equals("true")) {
                    function = "booleanTrue";
                } else if (function.equals("false")) {
                    function = "booleanFalse";
                } else if (function.equals("not")) {
                    function = "booleanNot";
                } else if (function.equals("floor")) {
                    function = "numberFloor";
                } else if (function.equals("ceiling")) {
                    function = "numberCeiling";
                } else if (function.equals("round")) {
                    function = "numberRound";
                } else if (function.equals("sum")) {
                    function = "numberSum";
                }
                boolean foundName = false;
                boolean foundArgs = false;
                int extra_arg_count = 3;
                Method[] methods = XPU.class.getDeclaredMethods();
                int k = 0;
                while (k < methods.length) {
                    if (methods[k].getName().equals(function)) {
                        foundName = true;
                        if (methods[k].getParameterTypes().length - extra_arg_count == args) {
                            foundArgs = true;
                            break;
                        }
                    }
                    ++k;
                }
                if (!foundName) {
                    this.error("function '" + origFunction + "' not known");
                }
                if (!foundArgs) {
                    this.error("function '" + origFunction + "' cannot accept " + args + " arguments");
                }
                this.appendNoLine("func_ret = XPU." + function + "(nsContext,");
                int i3 = 0;
                while (i3 < args) {
                    this.appendNoLine("stack.peek(" + (args - i3) + "),");
                    ++i3;
                }
                this.appendLine("xpi" + this.getParentDepth() + ",nsTmp" + this.getParentDepth() + ");");
                this.appendLine("stack.discard(" + args + ");");
                this.appendLine("if (func_ret != null) stack.push(func_ret);");
                break;
            }
            case 16: {
                String.valueOf(node.getArg(0));
                break;
            }
            case 14: {
                String name = String.valueOf(node.getArg(0));
                this.appendLine("stack.pop();");
                this.appendLine("nsContext = XPU.nameTest(nsContext,\"" + name + "\");");
                this.appendLine("stack.push(nsContext);");
                break;
            }
            case 15: {
                String axis = String.valueOf(node.getArg(0));
                this.appendLine("stack.pop();");
                this.appendLine("nsContext = XPU." + axis + "(nsContext,xpi" + this.getParentDepth() + ",nsTmp" + this.getParentDepth() + ");");
                this.appendLine("stack.push(nsContext);");
            }
        }
    }
}

