/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.b2j.core.jengine.internal.compiler.xsd;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.TranslatorLog;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.Util;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.wsdlmap.WSDLMap;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.xmlns.NamespaceException;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.xmlns.NamespaceTranslator;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.xsd.XSDTranslatorException;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.xsdmap.XSDMap;
import org.eclipse.stp.b2j.core.misc.internal.XMLConfigUtil;
import org.eclipse.stp.b2j.core.publicapi.extension.wsdlbinding.XSDTypeTranslator;
import org.eclipse.stp.b2j.core.publicapi.jcompiler.CompilerUnit;
import org.eclipse.stp.b2j.core.xml.internal.w3c.Document;
import org.eclipse.stp.b2j.core.xml.internal.w3c.DocumentBuilder;
import org.eclipse.stp.b2j.core.xml.internal.w3c.Element;

public class XSDTranslator {
    Util compiler_util;
    NamespaceTranslator nt;
    XSDMap xsdmap;
    WSDLMap wsdlmap;
    XSDTypeTranslator[] codecs;
    TranslatorLog log;
    String LOG_SOURCE = "XSDTranslator";
    int COMPLEX = 1;
    int SIMPLE = 1;

    private String getNextComplex() {
        return "UnknownComplexType" + this.COMPLEX++;
    }

    private String getNextSimple() {
        return "UnknownSimpleType" + this.SIMPLE++;
    }

    public XSDTranslator(Util compiler_util, TranslatorLog log, XSDMap xsdmap, WSDLMap wsdlmap) {
        this.xsdmap = xsdmap;
        this.wsdlmap = wsdlmap;
        this.compiler_util = compiler_util;
        this.log = log;
        this.nt = compiler_util.createNamespaceTranslator();
    }

    public void translateElement(ArrayList states, XSDState state, Element element) throws XSDTranslatorException, NamespaceException {
        String name = element.getAttribute("name");
        String type = element.getAttribute("type");
        element.getAttribute("ref");
        element.getAttribute("minOccurs");
        element.getAttribute("maxOccurs");
        String def = element.getAttribute("default");
        String xmldef = XMLConfigUtil.toRawXML(def);
        if (element.hasAttribute("ref")) {
            return;
        }
        if (name.equals("")) {
            return;
        }
        if (type.equals("")) {
            ArrayList elems = Util.getAllElements(element);
            int i = 0;
            while (i < elems.size()) {
                Element complex = (Element)elems.get(i);
                String complexname = NamespaceTranslator.getName(complex);
                if (complexname.equals("complexType")) {
                    type = name;
                    complex.setAttribute("name", type);
                    this.translateComplexType(states, complex);
                } else if (complexname.equals("simpleType")) {
                    type = name;
                    complex.setAttribute("name", type);
                    this.translateSimpleType(states, complex);
                } else {
                    this.log.logWarning(this.LOG_SOURCE, "Unknown element tag name underneath <element> \"" + complexname + "\"");
                }
                ++i;
            }
            type = this.nt.qualify(type, true);
        } else {
            type = this.nt.qualify(type, false);
        }
        String mname = NamespaceTranslator.getElement(name);
        if (state != null) {
            state.addField(type, name, name);
            if (xmldef.length() > 0) {
                state.appendLine("public " + type + " " + NamespaceTranslator.getDefaultElement(mname) + " = new " + type + "(\"" + xmldef + "\");");
            }
            state.appendLine("public " + type + "[] " + mname + " = new " + type + "[0];");
        } else {
            this.log.logWarning(this.LOG_SOURCE, "UNIMPLEMENTED: Couldn't make top level mapping from " + name + " to " + type);
        }
    }

    public void translateSequence(ArrayList states, XSDState state, Element sequence) throws XSDTranslatorException, NamespaceException {
        ArrayList elements = Util.getAllElements(sequence);
        int i = 0;
        while (i < elements.size()) {
            this.translateType(states, state, (Element)elements.get(i));
            ++i;
        }
    }

    public void translateComplexContent(ArrayList states, XSDState state, Element sequence) throws XSDTranslatorException, NamespaceException {
        ArrayList elements = Util.getAllElements(sequence);
        int i = 0;
        while (i < elements.size()) {
            this.translateType(states, state, (Element)elements.get(i));
            ++i;
        }
    }

    public void translateRestriction(ArrayList states, XSDState state, Element sequence) throws XSDTranslatorException, NamespaceException {
        ArrayList elements = Util.getAllElements(sequence);
        int i = 0;
        while (i < elements.size()) {
            this.translateType(states, state, (Element)elements.get(i));
            ++i;
        }
    }

    public void translateExtension(ArrayList states, XSDState state, Element sequence) throws XSDTranslatorException, NamespaceException {
        ArrayList elements = Util.getAllElements(sequence);
        int i = 0;
        while (i < elements.size()) {
            this.translateType(states, state, (Element)elements.get(i));
            ++i;
        }
    }

    public void translateAttribute(ArrayList states, XSDState state, Element attribute) throws XSDTranslatorException, NamespaceException {
        String name = attribute.getAttribute("name");
        attribute.getAttribute("ref");
        String type = attribute.getAttribute("type");
        attribute.getAttribute("use");
        attribute.getAttribute("fixed");
        String def = attribute.getAttribute("default");
        if (attribute.hasAttribute("ref")) {
            return;
        }
        String qtype = this.nt.qualify(type, false);
        String xmldef = XMLConfigUtil.toRawXML(def);
        String mname = NamespaceTranslator.getAttribute(name);
        if (xmldef.length() > 0) {
            state.appendLine("public " + qtype + " " + mname + " = new " + qtype + "(\"" + xmldef + "\");");
        } else {
            state.appendLine("public " + qtype + " " + mname + " = null;");
        }
        state.addAttribute(qtype, name);
    }

    public void translateSimpleType(ArrayList states, Element simple) throws XSDTranslatorException, NamespaceException {
        String name = simple.getAttribute("name");
        String pkg = this.nt.getPackage(name, true);
        String cname = NamespaceTranslator.getName(name);
        XSDState state = new XSDState(pkg, cname);
        String base = this.compiler_util.getSimpleTypeBase(this.nt, simple);
        state.setSuperClass(this.nt.qualify(base, false));
        this.log.logInfo(this.LOG_SOURCE, "simple type - " + this.nt.qualify(name, true) + " (" + base + ")");
        int i = 0;
        while (i < this.codecs.length) {
            try {
                this.codecs[i].translateSimple(this.nt, name, base, simple);
                state.appendLine(this.codecs[i].getMethods());
                state.addInterfaces(this.codecs[i].getImplementations());
                state.addImports(this.codecs[i].getImports());
            }
            catch (Exception e) {
                this.log.logWarning(this.LOG_SOURCE, "Problem when codec " + this.codecs[i].getClass() + " compiling complex XSD type " + name + ": " + e);
            }
            ++i;
        }
        states.add(state);
    }

    public void translateComplexType(ArrayList states, Element complex) throws XSDTranslatorException, NamespaceException {
        String name = complex.getAttribute("name");
        String pkg = this.nt.getPackage(name, true);
        String cname = NamespaceTranslator.getName(name);
        this.log.logInfo(this.LOG_SOURCE, "complex type - " + this.nt.qualify(name, true));
        XSDState state = new XSDState(pkg, cname);
        ArrayList elements = Util.getAllElements(complex);
        int i = 0;
        while (i < elements.size()) {
            this.translateType(states, state, (Element)elements.get(i));
            ++i;
        }
        i = 0;
        while (i < this.codecs.length) {
            try {
                this.codecs[i].translateComplex(this.nt, name, state.getAttributeTypes(), state.getAttributeNames(), state.getFieldTypes(), state.getFieldNames(), state.getFieldElements(), complex);
                state.appendLine(this.codecs[i].getMethods());
                state.addInterfaces(this.codecs[i].getImplementations());
                state.addImports(this.codecs[i].getImports());
            }
            catch (Exception e) {
                this.log.logWarning(this.LOG_SOURCE, "Problem when codec " + this.codecs[i].getClass() + " compiling complex XSD type " + name + ": " + e);
            }
            ++i;
        }
        states.add(state);
    }

    public void translateTopLevelElement(ArrayList states, XSDState state, Element elem) throws XSDTranslatorException, NamespaceException {
        String name = elem.getAttribute("name");
        String type = elem.getAttribute("type");
        if (type.equals("")) {
            if (name.equals("")) {
                throw new XSDTranslatorException("top level XSD element has neither name nor type");
            }
            this.translateElement(states, state, elem);
        } else {
            this.log.logWarning(this.LOG_SOURCE, "UNIMPLEMENTED: unable to map top level elements to types (" + state + ")");
            this.log.logWarning(this.LOG_SOURCE, "making direct alias from " + this.compiler_util.getQNameFromQName(this.nt.qualify(name, true)) + " to " + this.compiler_util.getQNameFromQName(this.nt.qualify(type, false)));
            this.compiler_util.setXsdTypeDirectAlias(this.nt.qualify(name, true), this.nt.qualify(type, false));
        }
    }

    public void translateType(ArrayList states, XSDState state, Element type) throws XSDTranslatorException, NamespaceException {
        String tag = NamespaceTranslator.getName(type);
        if (state != null) {
            if (tag.equals("element")) {
                this.translateElement(states, state, type);
            } else if (tag.equals("sequence")) {
                this.translateSequence(states, state, type);
            } else if (tag.equals("attribute")) {
                this.translateAttribute(states, state, type);
            } else if (tag.equals("complexContent")) {
                this.translateComplexContent(states, state, type);
            } else if (tag.equals("restriction")) {
                this.translateRestriction(states, state, type);
            } else if (tag.equals("extension")) {
                this.translateExtension(states, state, type);
            }
        } else if (tag.equals("element")) {
            this.translateTopLevelElement(states, state, type);
        }
        if (tag.equals("simpleType")) {
            this.translateSimpleType(states, type);
        } else if (tag.equals("complexType")) {
            this.translateComplexType(states, type);
        }
    }

    public void translateSchema(ArrayList states, Element schema) throws XSDTranslatorException, NamespaceException {
        this.nt.addNamespaces(schema);
        ArrayList elements = Util.getAllElements(schema);
        int i = 0;
        while (i < elements.size()) {
            this.translateType(states, null, (Element)elements.get(i));
            ++i;
        }
        this.nt.removeNamespaces(schema);
    }

    public void translateBaseType(ArrayList states, String name) throws XSDTranslatorException, NamespaceException {
        boolean hasParent;
        String pkg = this.nt.getPackage(name, false);
        String cname = NamespaceTranslator.getName(name);
        XSDState state = new XSDState(pkg, cname);
        String mapping = this.compiler_util.getInternalBaseMapping(this.nt, this.nt.qualify(name, false));
        boolean bl = hasParent = !mapping.equals(this.nt.qualify(name, false));
        if (mapping.equals(this.nt.qualify("xsd:string", false))) {
            state.appendLine("public java.lang.String INTERNAL_VALUE = new String(\"\");\n");
        } else if (mapping.equals(this.nt.qualify("xsd:int", false))) {
            state.appendLine("public Integer INTERNAL_VALUE = new Integer(0);\n");
        } else if (mapping.equals(this.nt.qualify("xsd:long", false))) {
            state.appendLine("public Long INTERNAL_VALUE = new Long(0);\n");
        } else if (mapping.equals(this.nt.qualify("xsd:double", false))) {
            state.appendLine("public Double INTERNAL_VALUE = new Double(0);\n");
        } else if (mapping.equals(this.nt.qualify("xsd:boolean", false))) {
            state.appendLine("public Boolean INTERNAL_VALUE = new Boolean(false);\n");
        } else if (mapping.equals(this.nt.qualify("xsd:date", false))) {
            state.appendLine("public java.util.GregorianCalendar INTERNAL_VALUE = new java.util.GregorianCalendar();\n");
        } else if (mapping.equals(this.nt.qualify("xsd:list", false))) {
            state.appendLine("public java.util.List INTERNAL_VALUE = new java.util.ArrayList();\n");
        } else {
            mapping.equals(this.nt.qualify("xsd:anyType", false));
        }
        if (hasParent && !mapping.equals(this.nt.qualify("xsd:anyType", false))) {
            state.setSuperClass(mapping);
        }
        int i = 0;
        while (i < this.codecs.length) {
            try {
                this.codecs[i].translateBase(this.nt, name);
                state.appendLine(this.codecs[i].getMethods());
                state.addInterfaces(this.codecs[i].getImplementations());
                state.addImports(this.codecs[i].getImports());
            }
            catch (XSDTranslatorException e) {
                throw e;
            }
            catch (Exception e) {
                this.log.logWarning(this.LOG_SOURCE, "Problem when codec " + this.codecs[i].getClass() + " compiling XSD base type " + name + ": " + e);
                throw new XSDTranslatorException("Problem when codec " + this.codecs[i].getClass().getName() + " compiling XSD base type " + name + " (see log for more info)");
            }
            ++i;
        }
        states.add(state);
    }

    public void translateXsdAnyType(ArrayList states) throws XSDTranslatorException, NamespaceException {
        this.translateBaseType(states, "xsd:anyType");
    }

    public void translateBaseTypes(ArrayList states) throws XSDTranslatorException, NamespaceException {
        String[] bases = Util.getXSDBaseTypes();
        int i = 0;
        while (i < bases.length) {
            if (!bases[i].equalsIgnoreCase("xsd:anyType")) {
                this.translateBaseType(states, bases[i]);
            }
            ++i;
        }
    }

    public XSDState[] getJava(String[] xsd, String[] wsdl, String[] xsd_files, String[] wsdl_files) throws Exception {
        Document doc;
        DocumentBuilder builder;
        ArrayList states = new ArrayList();
        int i = 0;
        while (i < xsd.length) {
            builder = XMLConfigUtil.getDocumentBuilder();
            doc = builder.parse(new ByteArrayInputStream(xsd[i].getBytes()));
            Element doc_element = doc.getDocumentElement();
            this.translateSchema(states, doc_element);
            ++i;
        }
        i = 0;
        while (i < wsdl.length) {
            builder = XMLConfigUtil.getDocumentBuilder();
            doc = builder.parse(new ByteArrayInputStream(wsdl[i].getBytes()));
            Element definitions = doc.getDocumentElement();
            this.nt.addNamespaces(definitions);
            ArrayList typesList = Util.getAllElements(definitions);
            int k = 0;
            while (k < typesList.size()) {
                Element types = (Element)typesList.get(k);
                this.nt.addNamespaces(types);
                if (this.nt.checkQName(types, "http://schemas.xmlsoap.org/wsdl/", "types")) {
                    ArrayList schemas = Util.getAllElements(types);
                    int z = 0;
                    while (z < schemas.size()) {
                        Element schema = (Element)schemas.get(z);
                        this.nt.addNamespaces(schema);
                        if (this.nt.checkQName(schema, "http://www.w3.org/2001/XMLSchema", "schema")) {
                            this.translateSchema(states, schema);
                        }
                        this.nt.removeNamespaces(schema);
                        ++z;
                    }
                }
                this.nt.removeNamespaces(types);
                ++k;
            }
            this.nt.removeNamespaces(definitions);
            this.translateSchema(states, definitions);
            ++i;
        }
        this.translateBaseTypes(states);
        this.translateXsdAnyType(states);
        HashMap<String, XSDState> test = new HashMap<String, XSDState>();
        int i2 = 0;
        while (i2 < states.size()) {
            XSDState state = (XSDState)states.get(i2);
            if (test.get(state.getClassName()) != null) {
                states.remove(i2--);
            } else {
                test.put(state.getClassName(), state);
            }
            ++i2;
        }
        XSDState[] ret = new XSDState[states.size()];
        int i3 = 0;
        while (i3 < ret.length) {
            ret[i3] = (XSDState)states.get(i3);
            ++i3;
        }
        return ret;
    }

    public CompilerUnit[] getDefinitionSources(String[] xsd, String[] wsdl, XSDTypeTranslator[] codecs, String[] xsd_files, String[] wsdl_files) throws Exception {
        this.codecs = codecs;
        CompilerUnit[] java = this.getJava(xsd, wsdl, xsd_files, wsdl_files);
        return java;
    }

    class XSDState
    implements CompilerUnit {
        int SCOPE = 1;
        StringBuffer decl = new StringBuffer();
        StringBuffer prog = new StringBuffer();
        String pkg_name;
        String class_name;
        String superclass;
        ArrayList imports = new ArrayList();
        ArrayList ifaces = new ArrayList();
        ArrayList field_types = new ArrayList();
        ArrayList field_names = new ArrayList();
        ArrayList field_elems = new ArrayList();
        ArrayList attr_types = new ArrayList();
        ArrayList attr_names = new ArrayList();

        public XSDState(String pkg_name, String class_name) {
            this.pkg_name = pkg_name;
            this.class_name = class_name;
            this.addInterface("org.eclipse.stp.b2j.core.jengine.internal.utils.XPathAccessible");
        }

        public String getPackageName() {
            return this.pkg_name;
        }

        public String getClassName() {
            return NamespaceTranslator.getJavaClassName(this.class_name);
        }

        public String[] getFieldTypes() {
            String[] types = new String[this.field_types.size()];
            int i = 0;
            while (i < types.length) {
                types[i] = (String)this.field_types.get(i);
                ++i;
            }
            return types;
        }

        public String[] getFieldNames() {
            String[] names = new String[this.field_names.size()];
            int i = 0;
            while (i < names.length) {
                names[i] = (String)this.field_names.get(i);
                ++i;
            }
            return names;
        }

        public String[] getFieldElements() {
            String[] elems = new String[this.field_elems.size()];
            int i = 0;
            while (i < elems.length) {
                elems[i] = (String)this.field_elems.get(i);
                ++i;
            }
            return elems;
        }

        public String[] getAttributeTypes() {
            String[] types = new String[this.attr_types.size()];
            int i = 0;
            while (i < types.length) {
                types[i] = (String)this.attr_types.get(i);
                ++i;
            }
            return types;
        }

        public String[] getAttributeNames() {
            String[] names = new String[this.attr_names.size()];
            int i = 0;
            while (i < names.length) {
                names[i] = (String)this.attr_names.get(i);
                ++i;
            }
            return names;
        }

        private void setSuperClass(String sname) {
            this.superclass = sname;
        }

        private void addImport(String iport) {
            this.imports.add(iport);
        }

        private void addImports(String[] imports) {
            int i = 0;
            while (i < imports.length) {
                this.addImport(imports[i]);
                ++i;
            }
        }

        private void addInterface(String iface) {
            this.ifaces.add(iface);
        }

        private void addInterfaces(String[] ifaces) {
            int i = 0;
            while (i < ifaces.length) {
                this.addInterface(ifaces[i]);
                ++i;
            }
        }

        private void addField(String type, String name, String element) {
            this.field_types.add(type);
            this.field_names.add(name);
            this.field_elems.add(element);
        }

        private void addAttribute(String type, String name) {
            this.attr_types.add(type);
            this.attr_names.add(name);
        }

        private void appendLine(String s) {
            int i = 0;
            while (i < this.SCOPE) {
                this.prog.append("  ");
                ++i;
            }
            this.prog.append(s).append("\n");
        }

        private void incrementScope() {
            ++this.SCOPE;
        }

        private void decrementScope() {
            if (this.SCOPE >= 1) {
                --this.SCOPE;
            }
        }

        public void declToString(StringBuffer buf) {
            buf.append(this.decl.toString());
        }

        public void progToString(StringBuffer buf) {
            int i;
            block9: {
                buf.append("//@@START_STRIP\n");
                buf.append("package " + this.pkg_name + ";\n");
                buf.append("import org.eclipse.stp.b2j.core.jengine.internal.utils.*;\n");
                buf.append("import org.eclipse.stp.b2j.core.jengine.internal.core.*;\n");
                buf.append("import org.eclipse.stp.b2j.core.jengine.internal.message.Message;\n");
                i = 0;
                while (i < this.imports.size()) {
                    buf.append("import " + this.imports.get(i) + ";\n");
                    ++i;
                }
                if (this.superclass == null) {
                    String myname = String.valueOf(this.getPackageName()) + "." + this.getClassName();
                    try {
                        if (myname.equals(XSDTranslator.this.nt.qualify("xsd:anyType", false))) {
                            buf.append("public abstract class " + NamespaceTranslator.getJavaClassName(this.class_name) + " \n");
                            break block9;
                        }
                        buf.append("public class " + NamespaceTranslator.getJavaClassName(this.class_name) + " extends " + XSDTranslator.this.nt.qualify("xsd:anyType", false) + " \n");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else {
                    buf.append("public class " + NamespaceTranslator.getJavaClassName(this.class_name) + " extends " + this.superclass + " \n");
                }
            }
            if (this.ifaces.size() > 0) {
                buf.append("  implements\n");
            }
            i = 0;
            while (i < this.ifaces.size()) {
                buf.append("  " + this.ifaces.get(i));
                if (i < this.ifaces.size() - 1) {
                    buf.append(",");
                }
                buf.append("\n");
                ++i;
            }
            buf.append("{\n");
            buf.append("//@@END_STRIP\n");
            buf.append("\n");
            buf.append("  public String " + NamespaceTranslator.getElementTagName() + " = null;\n");
            buf.append("\n");
            buf.append(this.prog.toString());
            this.xpathToString(buf);
            buf.append("//@@START_STRIP\n");
            buf.append("}\n");
            buf.append("//@@END_STRIP\n\n");
        }

        public void xpathToString(StringBuffer buf) {
            String fieldname;
            String realname;
            buf.append("public XNodeSet getFieldSet() {\n");
            buf.append("  XNodeSet fields = new XNodeSet(" + this.field_names.size() + ");\n");
            int i = 0;
            while (i < this.field_names.size()) {
                realname = String.valueOf(this.field_names.get(i));
                fieldname = NamespaceTranslator.getElement(realname);
                buf.append("  if (" + fieldname + " != null)\n");
                buf.append("    for (int i = 0; i < " + fieldname + ".length; i++)\n");
                buf.append("      fields.add(new XNode(\"" + realname + "\"," + fieldname + "[i]," + fieldname + ",i,null));\n");
                ++i;
            }
            buf.append("  return fields;\n");
            buf.append("}\n");
            buf.append("public XNodeSet getFieldSet(XNode parent) {\n");
            buf.append("  XNodeSet fields = new XNodeSet(" + this.field_names.size() + ");\n");
            i = 0;
            while (i < this.field_names.size()) {
                realname = String.valueOf(this.field_names.get(i));
                fieldname = NamespaceTranslator.getElement(realname);
                buf.append("  if (" + fieldname + " != null)\n");
                buf.append("    for (int i = 0; i < " + fieldname + ".length; i++)\n");
                buf.append("      fields.add(new XNode(\"" + realname + "\"," + fieldname + "[i]," + fieldname + ",i,parent));\n");
                ++i;
            }
            buf.append("  return fields;\n");
            buf.append("}\n");
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append("//XSD CLASS\n");
            this.declToString(buf);
            this.progToString(buf);
            return buf.toString();
        }
    }
}

