/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.soap.http;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import org.eclipse.stp.b2j.core.jengine.internal.utils.CharStack;

public class CookieCache {
    private static Object sdf_LOCK = new Object();
    private static SimpleDateFormat sdf = new SimpleDateFormat("EEE, dd-MMM-yyyy HH:mm:ss z");
    ArrayList cookies = new ArrayList();

    public void addCookie(String name, String value, long expiryDate, String domain, String path, boolean secure) {
        Cookie cookie = new Cookie(name, value, expiryDate, domain, path, secure);
        this.cookies.add(cookie);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCookie(String unparsedCookie, String serverhost) {
        CharStack stack = new CharStack(unparsedCookie);
        String name = null;
        String cvalue = null;
        boolean secure = false;
        long expiryDate = Long.MAX_VALUE;
        String domain = serverhost;
        String path = null;
        boolean first = true;
        while (!stack.isEmpty()) {
            String pair = stack.popUntil(';', true);
            pair = pair.trim();
            int eqIndex = pair.indexOf(61);
            int scIndex = pair.indexOf(59);
            if (eqIndex != -1) {
                String key = pair.substring(0, eqIndex);
                String value = scIndex != -1 ? pair.substring(eqIndex + 1, scIndex) : pair.substring(eqIndex + 1);
                if (first) {
                    first = false;
                    name = key;
                    cvalue = value;
                    continue;
                }
                if (key.equalsIgnoreCase("expires")) {
                    try {
                        Object object = sdf_LOCK;
                        synchronized (object) {
                            expiryDate = sdf.parse(value).getTime();
                        }
                    }
                    catch (ParseException parseException) {}
                    continue;
                }
                if (key.equalsIgnoreCase("domain")) {
                    domain = value;
                    continue;
                }
                if (!key.equalsIgnoreCase("path")) continue;
                path = value;
                continue;
            }
            if (!pair.equalsIgnoreCase("secure")) continue;
            secure = true;
        }
        if (name != null && cvalue != null) {
            this.addCookie(name, cvalue, expiryDate, domain, path, secure);
        }
    }

    public String getCookies(String domain, String path, boolean secure) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.cookies.size()) {
            Cookie cookie = (Cookie)this.cookies.get(i);
            if (System.currentTimeMillis() > cookie.expiryDate) {
                this.cookies.remove(i--);
            } else if ((!cookie.secure || secure == cookie.secure) && domain.endsWith(cookie.domain) && path.startsWith(cookie.path)) {
                if (sb.length() > 0) {
                    sb.append("; ");
                }
                sb.append(cookie.name);
                sb.append("=");
                sb.append(cookie.value);
            }
            ++i;
        }
        return sb.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.cookies.size()) {
            Cookie cookie = (Cookie)this.cookies.get(i);
            sb.append("Cookie: " + cookie.name + "=" + cookie.value + " (path=" + cookie.path + ") (domain=" + cookie.domain + ") (secure=" + cookie.secure + ")");
            ++i;
        }
        return sb.toString();
    }

    private class Cookie {
        String name;
        String value;
        long expiryDate = Long.MAX_VALUE;
        String domain;
        String path;
        boolean secure;

        public Cookie(String name, String value, long expiryDate, String domain, String path, boolean secure) {
            this.domain = domain;
            this.expiryDate = expiryDate;
            this.name = name;
            this.path = path;
            this.secure = secure;
            this.value = value;
        }
    }
}

