/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.b2j.core.publicapi.jcompiler;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Properties;
import org.eclipse.stp.b2j.core.jengine.internal.utils.ClassPathHacker;
import org.eclipse.stp.b2j.core.jengine.internal.utils.JARFinder;
import org.eclipse.stp.b2j.core.jengine.internal.utils.StreamUtils;
import org.eclipse.stp.b2j.core.publicapi.B2jPlatform;
import org.eclipse.stp.b2j.core.publicapi.DependencyInfo;
import org.eclipse.stp.b2j.core.publicapi.jcompiler.CompilerUnit;
import org.eclipse.stp.b2j.core.publicapi.jcompiler.JavaCompiler;

public class IndependantJaninoJavaCompiler
implements JavaCompiler {
    CompilerUnit mainsrc;
    CompilerUnit[] allsrc = new CompilerUnit[1];
    byte[] theclass;
    byte[][] classes;
    private String[] classespkgs;

    public void setMainSourceFile(CompilerUnit src) {
        this.allsrc[0] = this.mainsrc = src;
    }

    public void addExtraSources(CompilerUnit[] sources) {
        CompilerUnit[] tmp = new CompilerUnit[this.allsrc.length + sources.length];
        System.arraycopy(this.allsrc, 0, tmp, 0, this.allsrc.length);
        System.arraycopy(sources, 0, tmp, this.allsrc.length, sources.length);
        this.allsrc = tmp;
    }

    public void compile() throws Exception {
        try {
            ClassPathHacker.addFile("./janino.jar");
            File destDirectory = File.createTempFile("IndependantJaninoJavaCompilation", "");
            destDirectory.delete();
            if (!destDirectory.mkdirs()) {
                throw new Exception("Failed to make temporary directory " + destDirectory);
            }
            Class<?> C_DebuggingInformation = Class.forName("org.codehaus.janino.DebuggingInformation");
            Class<?> C_StringPattern = Class.forName("org.codehaus.janino.util.StringPattern");
            Class<?> C_Compiler = Class.forName("org.codehaus.janino.Compiler");
            Class<?> C_ArrayStringPattern = Array.newInstance(C_StringPattern, 0).getClass();
            Constructor<?> con = C_Compiler.getConstructor(File[].class, File[].class, File[].class, File[].class, File.class, String.class, Boolean.TYPE, C_DebuggingInformation, C_ArrayStringPattern, Boolean.TYPE);
            if (con == null) {
                throw new Exception("Failed to get constructor");
            }
            Object[] objectArray = new Object[10];
            objectArray[1] = this.getClassPath();
            objectArray[4] = destDirectory;
            objectArray[6] = new Boolean(false);
            objectArray[7] = C_DebuggingInformation.getField("ALL").get(null);
            objectArray[9] = new Boolean(false);
            Object O_Compiler = con.newInstance(objectArray);
            Method M_compile = C_Compiler.getMethod("compile", File[].class);
            File[] sourceFiles = this.writeSourceFiles(destDirectory.getCanonicalPath());
            Object ret = M_compile.invoke(O_Compiler, new Object[]{sourceFiles});
            if (!((Boolean)ret).booleanValue()) {
                throw new Exception("Compilation failed");
            }
            ArrayList cpaths = new ArrayList();
            JARFinder.searchDir(cpaths, destDirectory, ".class", 1000);
            String cfname = this.getClassFileName(this.allsrc[0].getClassName());
            this.theclass = null;
            String destpath = destDirectory.getAbsolutePath().replace('\\', '/');
            if (!destpath.endsWith("/")) {
                destpath = String.valueOf(destpath) + "/";
            }
            int destpathlen = destpath.length();
            this.classes = new byte[cpaths.size() - 1][];
            this.classespkgs = new String[cpaths.size() - 1];
            int i = 0;
            while (i < cpaths.size()) {
                String path = (String)cpaths.get(i);
                String pkg = path.replace('\\', '/');
                pkg = pkg.substring(destpathlen);
                FileInputStream fin = new FileInputStream(path);
                System.out.println(String.valueOf(cfname) + " ? " + path);
                if (path.endsWith(cfname)) {
                    this.theclass = StreamUtils.readAll(fin);
                } else if (this.theclass == null) {
                    this.classes[i] = StreamUtils.readAll(fin);
                    this.classespkgs[i] = pkg;
                } else {
                    this.classes[i - 1] = StreamUtils.readAll(fin);
                    this.classespkgs[i - 1] = pkg;
                }
                fin.close();
                ++i;
            }
            this.deleteDirs(destDirectory);
        }
        catch (InvocationTargetException e) {
            throw (Exception)e.getTargetException();
        }
    }

    private File[] getClassPath() {
        ArrayList<File> files = new ArrayList<File>();
        files.add(new File(B2jPlatform.getPlatformFolder() + "/b2j.jar"));
        DependencyInfo[] infos = B2jPlatform.getAllDependencyInfo();
        int i = 0;
        while (i < infos.length) {
            Properties[] props = infos[i].getResources();
            int k = 0;
            while (k < props.length) {
                files.add(new File(infos[i].getRelativePath(props[k].getProperty("JAR"))));
                ++k;
            }
            ++i;
        }
        File[] tmp = new File[files.size()];
        files.toArray(tmp);
        return tmp;
    }

    private File[] writeSourceFiles(String dir) throws IOException {
        if (!dir.endsWith(File.separator)) {
            dir = String.valueOf(dir) + File.separator;
        }
        System.out.println("Writing java source code to tmp directory " + dir);
        int CONFIGS_LEN = 0;
        String[] srcnames = new String[CONFIGS_LEN + this.allsrc.length];
        FileOutputStream allout = null;
        try {
            allout = new FileOutputStream("C:\\temp\\ALLSRC.java");
            new File("C:\\temp\\ALLSRC").mkdirs();
        }
        catch (Exception e) {
            System.out.println("Could not open generated source debugging file: " + e);
            allout = null;
        }
        int i = 0;
        while (i < this.allsrc.length) {
            String pkgname = this.allsrc[i].getPackageName();
            String cname = this.allsrc[i].getClassName();
            String srcname = this.getSrcName(pkgname, cname);
            File tmpfile = new File(String.valueOf(dir) + srcname);
            tmpfile.mkdirs();
            tmpfile.delete();
            srcnames[CONFIGS_LEN + i] = String.valueOf(dir) + srcname;
            FileOutputStream fout = new FileOutputStream(String.valueOf(dir) + srcname);
            fout.write(this.allsrc[i].toString().getBytes());
            fout.flush();
            try {
                if (allout != null) {
                    allout.write(this.allsrc[i].toString().getBytes());
                }
            }
            catch (Exception e) {
                System.out.println("Failed to write to generated source debugging file: " + e);
                allout = null;
            }
            try {
                String fname = pkgname;
                fname = fname.substring(fname.indexOf(46) + 1);
                fname = fname.replace('.', '_');
                fname = String.valueOf(fname) + cname;
                FileOutputStream tmpfout = new FileOutputStream("C:\\temp\\ALLSRC\\" + fname + ".java");
                tmpfout.write(this.allsrc[i].toString().getBytes());
                tmpfout.close();
            }
            catch (Exception exception) {}
            fout.close();
            System.out.println("Wrote java source for " + srcname);
            ++i;
        }
        if (allout != null) {
            allout.flush();
            allout.close();
        }
        File[] tmp = new File[srcnames.length];
        int i2 = 0;
        while (i2 < tmp.length) {
            System.out.println(srcnames[i2]);
            tmp[i2] = new File(srcnames[i2]);
            ++i2;
        }
        return tmp;
    }

    public byte[] getMainSourceClass() {
        return this.theclass;
    }

    public byte[][] getExtraSourceClasses() {
        return this.classes;
    }

    public String[] getExtraSourceClassesPackages() {
        return this.classespkgs;
    }

    private String getSrcName(String pkgname, String cname) {
        pkgname = pkgname.replace('.', '/');
        return String.valueOf(pkgname) + '/' + cname + ".java";
    }

    private void deleteDirs(File f) {
        if (f.isDirectory()) {
            File[] files = f.listFiles();
            int i = 0;
            while (i < files.length) {
                this.deleteDirs(files[i]);
                ++i;
            }
            f.delete();
        } else {
            f.delete();
        }
    }

    private String getClassFileName(String cname) {
        return String.valueOf(cname.substring(cname.lastIndexOf(46) + 1)) + ".class";
    }
}

