/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.b2j.core.xml.internal.w3c;

import org.eclipse.stp.b2j.core.xml.internal.w3c.Document;
import org.eclipse.stp.b2j.core.xml.internal.w3c.NamedNodeMap;
import org.eclipse.stp.b2j.core.xml.internal.w3c.NodeList;

public abstract class Node {
    public static short ATTRIBUTE_NODE = 0;
    public static short CDATA_SECTION_NODE = 1;
    public static short COMMENT_NODE = (short)2;
    public static short DOCUMENT_FRAGMENT_NODE = (short)2;
    public static short DOCUMENT_NODE = (short)3;
    public static short DOCUMENT_TYPE_NODE = (short)4;
    public static short ELEMENT_NODE = (short)5;
    public static short ENTITY_NODE = (short)6;
    public static short ENTITY_REFERENCE_NODE = (short)7;
    public static short NOTATION_NODE = (short)8;
    public static short PROCESSING_INSTRUCTION_NODE = (short)9;
    public static short TEXT_NODE = (short)10;
    private Document doc;
    public Node parent;
    public NodeList children = new NodeList();
    int startLine = -1;
    int endLine = -1;
    int writtenLine = -1;
    String fileref;

    public void setFileRef(String fileref) {
        this.fileref = fileref;
    }

    public String getFileRef() {
        return this.fileref;
    }

    public int getEndLine() {
        return this.endLine;
    }

    public void setEndLine(int endLine) {
        this.endLine = endLine;
    }

    public int getStartLine() {
        return this.startLine;
    }

    public void setStartLine(int startLine) {
        this.startLine = startLine;
    }

    public void setWrittenLine(int line) {
        this.writtenLine = line;
    }

    public int getWrittenLine() {
        return this.writtenLine;
    }

    public Node(Node parent, int line) {
        if (parent != null) {
            this.doc = parent.getOwnerDocument();
        }
        this.parent = parent;
    }

    void setParent(Node parent) {
        this.doc = parent.getOwnerDocument();
        this.parent = parent;
    }

    public Node appendChild(Node newChild) {
        this.children.add(newChild);
        return newChild;
    }

    public Node cloneNode(boolean deep) {
        Node clone = this.cloneNode(this.parent);
        if (!deep) {
            return clone;
        }
        int i = 0;
        while (i < this.children.size()) {
            Node child = (Node)this.children.get(i);
            Node child_clone = child.cloneNode(true);
            child_clone.setParent(clone);
            clone.appendChild(child_clone);
            ++i;
        }
        return clone;
    }

    abstract Node cloneNode(Node var1);

    public abstract NamedNodeMap getAttributes();

    public NodeList getChildNodes() {
        return this.children;
    }

    public Node getFirstChild() {
        if (this.children.size() > 0) {
            return (Node)this.children.get(0);
        }
        return null;
    }

    public Node getLastChild() {
        if (this.children.size() > 0) {
            return (Node)this.children.get(this.children.size() - 1);
        }
        return null;
    }

    public String getLocalName() {
        return null;
    }

    public String getNamespaceURI() {
        return null;
    }

    public Node getNextSibling() {
        if (this.parent == null) {
            return null;
        }
        NodeList list = this.parent.getChildNodes();
        int n = list.indexOf(this);
        if (n == -1) {
            return null;
        }
        if (list.size() > n) {
            return list.item(n + 1);
        }
        return null;
    }

    public abstract String getNodeName();

    public abstract short getNodeType();

    public abstract String getNodeValue();

    public Document getOwnerDocument() {
        return this.doc;
    }

    public Node getParentNode() {
        return this.parent;
    }

    public String getPrefix() {
        return null;
    }

    public Node getPreviousSibling() {
        if (this.parent == null) {
            return null;
        }
        NodeList list = this.parent.getChildNodes();
        int n = list.indexOf(this);
        if (n <= 0) {
            return null;
        }
        return list.item(n - 1);
    }

    public abstract boolean hasAttributes();

    public boolean hasChildNodes() {
        return this.children.size() > 0;
    }

    public Node insertBefore(Node newChild, Node refChild) {
        if (refChild == null) {
            this.appendChild(newChild);
            return newChild;
        }
        int n = this.children.indexOf(refChild);
        if (n == -1) {
            return null;
        }
        this.children.add(n, newChild);
        return newChild;
    }

    public boolean isSupported(String feature, String version) {
        return false;
    }

    public void normalize() {
    }

    public Node removeChild(Node oldChild) {
        if (this.children.remove(oldChild)) {
            return oldChild;
        }
        return null;
    }

    public Node replaceChild(Node newChild, Node oldChild) {
        int n = this.children.indexOf(oldChild);
        if (n != -1) {
            Node child = (Node)this.children.remove(n);
            this.children.add(n, newChild);
            return child;
        }
        return null;
    }

    public abstract void setNodeValue(String var1);

    public void setPrefix(String prefix) {
    }

    void filterList(NodeList list, int type_allow) {
        int i = 0;
        while (i < list.size()) {
            Node node = (Node)list.get(i);
            if (node.getNodeType() != type_allow) {
                list.remove(i--);
            }
            ++i;
        }
    }

    void filterList(NodeList list, String name) {
        int i = 0;
        while (i < list.size()) {
            Node node = (Node)list.get(i);
            if (!node.getNodeName().equals(name)) {
                list.remove(i--);
            }
            ++i;
        }
    }

    NodeList getDepthFirstList() {
        NodeList list = new NodeList();
        this.getDepthFirstList(list);
        return list;
    }

    void getDepthFirstList(NodeList list) {
        list.add(this);
        int i = 0;
        while (i < this.children.size()) {
            Node node = (Node)this.children.get(i);
            node.getDepthFirstList(list);
            ++i;
        }
    }
}

