/**********************************************************************
 * Copyright (c) 2006 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.jengine.internal.compiler.locks;

public class LockLock extends LockObject {
	String name;
	boolean enabled = true;
	String reason = "no reason";
	
	public LockLock(LockObject parent, String name) {
		super(parent);
		
		this.name = name;
	}

	public String getName() {
		return name;
	}
	
	public boolean isEnabled() {
		return enabled;
	}
	public void setEnabled(boolean b, String reason) {
		this.enabled = b;
		this.reason = reason;
	}
	
	public String toString() {
		if (enabled) {
			return super.toString()+" "+name;
		} else {
			return super.toString()+" "+name+" DISABLED ("+reason+")";
		}
	}
}