/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.wsif.ports;

import org.eclipse.stp.b2j.core.jengine.internal.core.RunnerInterface;
import org.eclipse.stp.b2j.core.jengine.internal.core.sync.SharedMutex;
import org.eclipse.stp.b2j.core.jengine.internal.core.sync.SharedSemaphore;
import org.eclipse.stp.b2j.core.jengine.internal.message.Message;

/**
 * 
 * @author amiguel
 *
 * A WSIF Java port implementing a workbench host finding port
 */
public class SynchronisationPort {
	
	public void newSemaphore(String name, int initial) throws Exception {
		Thread thread = Thread.currentThread();
		if (thread instanceof RunnerInterface) {
			RunnerInterface engine = (RunnerInterface)thread;
			engine.newSemaphore(name,initial);
		} else {
			throw new Exception("Unable to access synchronisation APIs");
		}
	}

	public void waitSemaphore(String name, int wait) throws Exception {
		Thread thread = Thread.currentThread();
		if (thread instanceof RunnerInterface) {
			RunnerInterface engine = (RunnerInterface)thread;
			SharedSemaphore sem = engine.getSemaphore(name);
			sem.semWait(wait);
		} else {
			throw new Exception("Unable to access synchronisation APIs");
		}
	}

	public void signalSemaphore(String name, int signal) throws Exception {
		Thread thread = Thread.currentThread();
		if (thread instanceof RunnerInterface) {
			RunnerInterface engine = (RunnerInterface)thread;
			SharedSemaphore sem = engine.getSemaphore(name);
			sem.semSignal(signal);
		} else {
			throw new Exception("Unable to access synchronisation APIs");
		}
	}

	public void newMutex(String name) throws Exception {
		Thread thread = Thread.currentThread();
		if (thread instanceof RunnerInterface) {
			RunnerInterface engine = (RunnerInterface)thread;
			engine.newMutex(name);
		} else {
			throw new Exception("Unable to access synchronisation APIs");
		}
	}
	
	public void lockMutex(String name) throws Exception {
		Thread thread = Thread.currentThread();
		if (thread instanceof RunnerInterface) {
			RunnerInterface engine = (RunnerInterface)thread;
			SharedMutex mutex = engine.getMutex(name);
			mutex.lock();
		} else {
			throw new Exception("Unable to access synchronisation APIs");
		}
	}
	
	public void releaseMutex(String name) throws Exception {
		Thread thread = Thread.currentThread();
		if (thread instanceof RunnerInterface) {
			RunnerInterface engine = (RunnerInterface)thread;
			SharedMutex mutex = engine.getMutex(name);
			mutex.release();
		} else {
			throw new Exception("Unable to access synchronisation APIs");
		}
	}
	
	public void newQueue(String name) throws Exception {
		Thread thread = Thread.currentThread();
		if (thread instanceof RunnerInterface) {
//			RunnerInterface engine = (RunnerInterface)thread;
		} else {
			throw new Exception("Unable to access synchronisation APIs");
		}	
	}

	public void addToQueue(String name, String value) throws Exception {
		Thread thread = Thread.currentThread();
		if (thread instanceof RunnerInterface) {
			RunnerInterface engine = (RunnerInterface)thread;
			
			Message m = new Message();
			m.append(value);
			
			engine.sendMessage("QueueSim:"+name,m);
		} else {
			throw new Exception("Unable to access synchronisation APIs");
		}	
	}

	public String getFromQueue(String name) throws Exception {
		Thread thread = Thread.currentThread();
		if (thread instanceof RunnerInterface) {
			RunnerInterface engine = (RunnerInterface)thread;
			Message m = engine.receiveMessage("QueueSim:"+name);
			return (String)m.get(0);
		} else {
			throw new Exception("Unable to access synchronisation APIs");
		}
	}
}