/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. Thisorg.eclipse.stp.b2j.core.
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.wsif.ports;

import java.awt.Polygon;

/**
 * 
 * @author amiguel
 *
 * A WSIF Java mapped type which is part of the Scene port
 */
public class Triangle {

public int x1, y1, x2, y2, x3, y3;
SceneColor color = new SceneColor();	

	public Triangle() {
	}
	public Triangle(int x1, int y1, int x2, int y2, int x3, int y3) {
	}

	public void setColor(SceneColor color) {
		this.color = color;
	}
	public SceneColor getColor() {
		return color;
	}
	
	public Polygon getAwtPolygon() {
		Polygon p = new Polygon();
		p.addPoint(x1,y1);
		p.addPoint(x2,y2);
		p.addPoint(x3,y3);
		return p;
	}
	
	public void setColor(double r, double g, double b) {
		color = new SceneColor(r,g,b);
	}
	
	public void setX1(int x1) {
		this.x1 = x1;
	}
	public void setX2(int x2) {
		this.x2 = x2;
	}
	public void setX3(int x3) {
		this.x3 = x3;
	}
	public void setY1(int y1) {
		this.y1 = y1;
	}
	public void setY2(int y2) {
		this.y2 = y2;
	}
	public void setY3(int y3) {
		this.y3 = y3;
	}
	public int getX1() {
		return x1;
	}
	public int getX2() {
		return x2;
	}
	public int getX3() {
		return x3;
	}
	public int getY1() {
		return y1;
	}
	public int getY2() {
		return y2;
	}
	public int getY3() {
		return y3;
	}

	public String toString() {
		StringBuffer sb = new StringBuffer("TRIANGLE:");
		sb.append(" ");
		sb.append(color);

		sb.append(" (");
		sb.append(x1);
		sb.append(",");
		sb.append(y1);
		sb.append(")");

		sb.append(" (");
		sb.append(x2);
		sb.append(",");
		sb.append(y2);
		sb.append(")");

		sb.append(" (");
		sb.append(x3);
		sb.append(",");
		sb.append(y3);
		sb.append(")");
		
		return sb.toString();
	}
}

