/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.jengine.internal.message;

import java.io.IOException;

/**
 * @author amiguel
 * 
 * Allows (multi-threaded) Message based Transactions.
 * The basis of this class is that the client can do transactions ( 1
 * message to = 1 message from) against a server, dealing only with Message
 * objects.
 *
 * The transaction client would typically be instantiated on one end of a socket
 * using the input and output streams of the socket.
 * 
 * TransactionClients implementing this interface ARE designed for multithreaded use
 * 
 * Any TransactionClient designed for multi-threaded use can obviously also be used
 * for single-threaded use, therefore this interface is a superinterface of
 * STTransactionClient
 */
public interface MTTransactionClient extends STTransactionClient {

	/**
	 * Perform a transaction based a message.
	 * @param m the message to send to the TransactionServer
	 */
	public Message doTransaction(Message m) throws IOException;

}//end class
