/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.jengine.internal.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

/**
 * @author amiguel
 * 
 * A utility class to perform commonly required File functions
 */
public class FileUtil {

	public static String readFileString(InputStream file) throws IOException {
		return new String(readFileBinary(file));
	}

	public static byte[] readFileBinary(InputStream file) throws IOException {
			
		ByteArrayOutputStream bout = new ByteArrayOutputStream();
		byte[] buf = new byte[1024];
		int n = 0;
		
		while (n != -1) {
			n = file.read(buf,0,1024);
			if (n > 0) {
				bout.write(buf,0,n);
			}
		}
		
		file.close();
		
		return bout.toByteArray();		
	}
	
}