/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.jengine.internal.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

/**
 * @author amiguel
 * 
 * Proxies output from a process into given OutputStreams
 */
public class ProcessPrinter {
	
	public ProcessPrinter(Process p, OutputStream out, OutputStream err) {
		Printer pout = new Printer();
		pout.in = p.getInputStream();
		pout.out = out;
		pout.start();
		
		Printer perr = new Printer();
		perr.in = p.getErrorStream();
		perr.out = err;
		perr.start();
	}	
	
	class Printer extends Thread {
		InputStream in;
		OutputStream out;
		IOException exception;
		public void run() {
			try {
				byte[] buf = new byte[1024];
				int n = 0;
				while (n != -1) {
					n = in.read(buf,0,1024);
					if (n > 0) {
						out.write(buf,0,n);	
					}	
				}
			} catch (IOException e) {
				exception = e;	
			}
		}
	}
}