/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.jengine.internal.utils;

import java.lang.reflect.Method;

/**
 * 
 * @author amiguel
 *
 * Used to get the stack trace of the calling thread
 */
public class StackTracer {

static boolean init = false;
static Method stackDepth = null;
static Method getStack = null;

static Method getClass = null;
static Method getFile = null;
static Method getLine = null;
static Method getMethod = null;

	private static void init() {
		init = true;
		try {
			Throwable t = new Throwable();
			Class c = Class.forName("java.lang.Throwable");
			stackDepth = c.getDeclaredMethod("getStackTraceDepth",new Class[]{});
			getStack = c.getDeclaredMethod("getStackTraceElement",new Class[]{int.class});
			
			c = Class.forName("java.lang.StackTraceElement");
			
			getClass = c.getDeclaredMethod("getClassName",new Class[]{});
			getFile = c.getDeclaredMethod("getFileName",new Class[]{});
			getLine = c.getDeclaredMethod("getLineNumber",new Class[]{});
			getMethod = c.getDeclaredMethod("getMethodName",new Class[]{});

			stackDepth.setAccessible(true);
			getStack.setAccessible(true);
		} catch (Throwable t) {
			stackDepth = null;
			getStack = null;
		}
	}

	public static String getCallerTrace() {
		return getCallerTrace(0);
	}

	public static String getCallerTrace(int skip) {
		if (!init) init();
		
		String ret = null;
		if (stackDepth != null) {
			Throwable t = new Throwable();
			try {
				int depth = ((Integer)stackDepth.invoke(t,new Object[]{})).intValue();
				Object stackframe = getStack.invoke(t,new Object[]{new Integer(skip)});
				
				StringBuffer sb = new StringBuffer();
				
				Object[] args = new Object[0];
				sb.append(getClass.invoke(stackframe,args));
				sb.append(".");
				sb.append(getMethod.invoke(stackframe,args));
				sb.append("(");
				sb.append(getFile.invoke(stackframe,args));
				sb.append(":");
				sb.append(getLine.invoke(stackframe,args));
				sb.append(")");
				ret = sb.toString();
			} catch (Exception e) {
			}
		}
		return ret;
	}

	public static void main(String[] args) {
	}

}	
	
