/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.jengine.internal.utils;

import org.eclipse.stp.b2j.core.jengine.internal.core.RunnerInterface;
import org.eclipse.stp.b2j.core.jengine.internal.core.api.TraceListener;
import org.eclipse.stp.b2j.core.jengine.internal.message.Message;

/**
 * @author amiguel
 * 
 * A class to proxy engine logging from a nested engine into the current engine
 */
public class TraceListenerRunnerProxy implements TraceListener {
	
private RunnerInterface runner;	
	public TraceListenerRunnerProxy(RunnerInterface runner) {
		this.runner = runner;
	}
	
	public void trace(Message m) {
		try {
			runner.trace(m);
		} catch (Exception e) {}
	}
	public void print(String s) {
		try {
			runner.print(s);
		} catch (Exception e) {}
	}	
	public void debug(String s) {
		try {
			runner.debug(s);
		} catch (Exception e) {}
	}
}