/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.jengine.internal.utils;

import org.eclipse.stp.b2j.core.misc.internal.XMLConfigUtil;
import org.eclipse.stp.b2j.core.xml.internal.w3c.Element;

/**
 * 
 * @author amiguel
 *
 * A utility class used by the translator classes
 */
public class TranslatorUtils {
	
	public static String toJavaString(Element elem) {
		StringBuffer sb = new StringBuffer();
		XMLConfigUtil.getXmlHead(sb,elem);		
		return toJavaString(sb.toString());
	}
	
	public static String toJavaString(String s, int offset, int length) {
		StringBuffer ts = new StringBuffer();
		
		int slen = s.length();
		for (int c = 0; c < slen; c++) {
			char ch = s.charAt(c);
			
			if (c < offset
				|| c >= offset+length) {
				ts.append(ch);
			} else {
				if (ch == '\"') {
					ts.append('\\');
					ts.append('\"');
				} else if (ch == '\n') {
					ts.append(' ');
				} else if (ch == '\r') {
					ts.append(' ');
				} else if (ch == '\t') {
					ts.append('\\');
					ts.append('t');
				} else if (ch == '\\') {
					ts.append('\\');
					ts.append('\\');
				} else {
					ts.append(ch);
				}
			}
		}

		return ts.toString();
	}
	public static String toJavaString(String s) {
		return toJavaString(s,0,s.length());
/*		StringBuffer sb = new StringBuffer();
		for (int i = 0; i < s.length(); i++) {
			char c = s.charAt(i);
			if (c == '\"') {
				sb.append('\\');
				sb.append('\"');
			} else if (c == '\n') {
				sb.append(' ');
			} else if (c == '\r') {
				sb.append(' ');
			} else if (c == '\t') {
				sb.append('\\');
				sb.append('t');
			} else if (c == '\\') {
				sb.append('\\');
				sb.append('\\');
			} else {
				sb.append(c);
			}
		}
		return sb.toString();*/
	}

	public static String toJavaStringStrict(String s) {
		StringBuffer sb = new StringBuffer();
		for (int i = 0; i < s.length(); i++) {
			char c = s.charAt(i);
			if (c == '\"') {
				sb.append('\\');
				sb.append('\"');
			} else if (c == '\n') {
				sb.append('\\');
				sb.append('n');
			} else if (c == '\r') {
				sb.append('\\');
				sb.append('r');
			} else if (c == '\t') {
				sb.append('\\');
				sb.append('t');
			} else {
				sb.append(c);
			}
		}
		return sb.toString();
	}
	
}