/**********************************************************************
 * Copyright (c) 2006 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.xml.internal.w3c;


public class Document extends Node {
	
	public Document() {
		super(null,1);
	}

	public Document getOwnerDocument() {
		return this;
	}
	
//	////////////////////////////////////
//	 Document interface
//	////////////////////////////////////
	
	public Attr createAttribute(String name) {
		return new Attr(getDocumentElement(),name,"");
	} 
	public Attr createAttributeNS(String namespaceURI, String qualifiedName) {
		return createAttribute(qualifiedName);
	} 
	/*
	public CDATASection createCDATASection(String data) {
		return null;	
	} 
	public Comment createComment(String data) {
		return null;	
	} 
	public DocumentFragment createDocumentFragment() {
		return null;
	} 
	*/
	public Element createElement(String tagName) {
		return new Element(this,tagName);	
	} 
	public Element createElementNS(String namespaceURI, String qualifiedName) {
		return createElement(qualifiedName);	
	} 
	/*
	public EntityReference createEntityReference(String name) {
		return null;
	} 
	public ProcessingInstruction createProcessingInstruction(String target, String data) {
		return null;
	} 
	*/
	public Text createTextNode(String data) {
		return new Text(this,data);
	} 
	/*
	public DocumentType getDoctype() {
		return null;
	} 
	*/
	public Element getDocumentElement() {
		NodeList nl = getChildNodes();
		for (int i = 0; i < nl.getLength(); i++) {
			if (nl.item(i) instanceof Element) {
				return (Element)nl.item(i);
			}
		}
		return null;
//		return (Element)this.getFirstChild();
	} 
	public Element getElementById(String elementId) {
		return null;
	} 
	public NodeList getElementsByTagName(String tagname) {
		NodeList list = getDepthFirstList();
		filterList(list,Node.ELEMENT_NODE);
		if (!tagname.equals("*")) {
			filterList(list,tagname);
		}
		return list; 
	}
	public NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
		return getElementsByTagName(localName);
	} 
	/*
	public DOMImplementation getImplementation() {
		return null;
	} 
	*/
	/*
	public Node importNode(Node importedNode, boolean deep) {
		System.err.println("IMPORT NODE NOT IMPLEMENTED!");
		System.exit(0);
		return null;
	} 
	*/
	
	
//	////////////////////////////////////
//	 Node interface
//	////////////////////////////////////

  public String getNodeName() {
	  return "#document";	
  }

  public String getNodeValue() {
	  return null;	
  }

  public void setNodeValue(String value) {
  }

  public short getNodeType() {
	  return Node.DOCUMENT_NODE;	
  }

  public boolean hasAttributes() {
	  return false;	
  }

  public NamedNodeMap getAttributes() {
	  return null;	
  }

  Node cloneNode(Node parent) {
	  return new Document();
  }
	
}