/**********************************************************************
 * Copyright (c) 2006 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.xml.internal.w3c;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;

import org.eclipse.stp.b2j.core.xml.internal.FastXMLParser;

public class DocumentBuilder {

	public boolean isNamespaceAware() {
		return false;
	}
	public boolean isValidating() {
		return false;
	}
	public Document parse(String xml) throws Exception {
		return parse(xml,null);
	}
	public Document parse(String xml, String fileref) throws Exception {
		FastXMLParser parser = new FastXMLParser();
		parser.setInput(xml);
		NodeTreeBuilder builder = new NodeTreeBuilder(fileref);
		parser.parse(builder);
		return builder.getRootNode();
	}  
	public Document parse(File f) throws Exception {
		return parse(new FileInputStream(f),f.getAbsolutePath());
	} 
	public Document parse(InputStream xml) throws Exception {
		return parse(xml,null);
	}
	public Document parse(InputStream xml, String fileref) throws Exception {
		FastXMLParser parser = new FastXMLParser();
		parser.setInput(xml);
		NodeTreeBuilder builder = new NodeTreeBuilder(fileref);
		parser.parse(builder);
		return builder.getRootNode();
	} 
	public Document newDocument() throws Exception {
		return new Document();
	}
	
	public static Element getElementFrom(String document) throws Exception {
		return new DocumentBuilder().parse(document).getDocumentElement();
	}
}