/**********************************************************************
 * Copyright (c) 2006 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.xml.internal.w3c;

import java.util.HashMap;

import org.eclipse.stp.b2j.core.xml.internal.XMLParserListener;

public class NodeTreeBuilder implements XMLParserListener {

private Element lastElement = null;
	
private Document document = null;
private Node currentnode = null;

boolean lowercase;

String fileref;

	public NodeTreeBuilder() {
	}
	
	public NodeTreeBuilder(String fileref) {
		this.fileref = fileref;
	}

	public Document getRootNode() {
		return document;	
	}
	
	public void startElement(String tag, HashMap h, int lineno) throws Exception {
		boolean doEnd = false;
		if (tag.endsWith("/")) {
			doEnd = true;
			tag = tag.substring(0,tag.length()-1);
		}

		Element tmp;
//		if (currentnode == null) {
//			tmp = new Element(document,tag);
//		} else {
		
			tmp = new Element(currentnode,tag);
//		}
			
		tmp.setFileRef(fileref);
		tmp.setStartLine(lineno);
			
		if (h != null) tmp.attributes.putAll(h);

//		if (currentnode == null) {
//			document.appendChild(tmp);
//			currentnode = tmp;	
//		} else {
			currentnode.appendChild(tmp);
			currentnode = tmp;
//		}
		
		if (doEnd) {
			endElement(tag,lineno);
		}
		
		lastElement = tmp;
	}
	public void endElement(String tag, int lineno) throws Exception {
		
		currentnode.setEndLine(lineno);
		
		if (currentnode.parent != null) {
			currentnode = currentnode.parent;
		}
	}
	public void startDocument() throws Exception {
		document = new Document();
//		currentnode = null;
		currentnode = document;
	}
	public void endDocument() throws Exception {
		//? nothing?
	}
	public void text(String str, int linefrom, int lineto) throws Exception {
//		if (currentnode != null) {
			Text tmp = new Text(currentnode,str);
			tmp.setFileRef(fileref);
			tmp.setStartLine(linefrom);
			tmp.setEndLine(lineto);
			currentnode.appendChild(tmp);
//		}
	}
	public void comment(String str, int linefrom, int lineto) throws Exception {
//		if (currentnode != null) {
		
		if (str.startsWith("LINENO ")) {
			if (lastElement != null) {
				try {
					int fileindex = str.indexOf("file ")+5;
					int numindex = str.indexOf("line ")+5;
					
					String file = str.substring(fileindex,numindex-5).trim();
					int line = Integer.parseInt(str.substring(numindex,str.indexOf(' ',numindex)).trim());
					
					lastElement.setFileRef(file);
					lastElement.setStartLine(line);
				} catch (Exception e) {
					System.err.println("Invalid line number comment: "+str);
				}
			}
		}
		Comment tmp = new Comment(currentnode,str);
		tmp.setFileRef(fileref);
		tmp.setStartLine(linefrom);
		tmp.setEndLine(lineto);
		currentnode.appendChild(tmp);
//		}
	}
}