/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.ui.internal.preferences;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.stp.b2j.core.publicapi.extension.wsdlbinding.WSDLBindingLoader;
import org.eclipse.stp.b2j.core.publicapi.extension.wsdlbinding.WSDLBindingTranslator;
import org.eclipse.stp.b2j.ui.B2jImageManager;
import org.eclipse.stp.b2j.ui.UiPlugin;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class BindingTypeTable extends Composite implements IStructuredContentProvider, ITableLabelProvider, ICellModifier{
	public static final int COL_NAME = 0;
	public static final int COL_ENABLED = 1;
	
	static Object[][] columns = new Object[][] {
			new Object[] {UiPlugin.getString("COL_BINDING"), new Integer(SWT.LEFT), new Integer(200)},
			new Object[] {UiPlugin.getString("COL_ENABLED"), new Integer(SWT.CENTER), new Integer(100)},
	};
	
	static String[] properties = new String[] {
			(String)columns[COL_NAME][0],
			(String)columns[COL_ENABLED][0],
	};
	
	TableViewer transports_viewer;
	
	IPreferenceStore store = UiPlugin.getDefault().getPreferenceStore();
	
	public BindingTypeTable(Composite parent, int hints) {
		super(parent,hints);
		
		setLayout(new FillLayout());
		
		transports_viewer = new TableViewer(new Table(this, SWT.FULL_SELECTION | SWT.SINGLE | SWT.HIDE_SELECTION));
		
		//table stuff
		transports_viewer.getTable().setHeaderVisible(true); 
		transports_viewer.getTable().setLinesVisible(true);
		
		transports_viewer.setContentProvider(this);
		transports_viewer.setLabelProvider(this);

		for (int i = 0; i < columns.length; i++) {
			String col_name = (String)columns[i][0];
			int col_hints = ((Integer)columns[i][1]).intValue();
			int col_width = ((Integer)columns[i][2]).intValue();
			
			TableColumn tc = new TableColumn(transports_viewer.getTable(),col_hints);
			tc.setText(col_name);
			tc.setWidth(col_width);
		}

		CellEditor[] editors = new CellEditor[] {
				new TextCellEditor(transports_viewer.getTable()),
				new CheckboxCellEditor(transports_viewer.getTable()),
		};
		
		transports_viewer.setCellEditors(editors);
		transports_viewer.setCellModifier(this);
		transports_viewer.setColumnProperties(properties);

		transports_viewer.setInput("");
	}
	
	public void dispose() {
	}

	public Object[] getElements(Object inputElement) {
		try {
			return WSDLBindingLoader.getBindingsUnfiltered();
		} catch (Exception e) {
			return new WSDLBindingTranslator[0];
		}
	}

	public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
	}

	public Image getColumnImage(Object element, int columnIndex) {
		if (columnIndex == COL_NAME) {
			return UiPlugin.imageManager.getImage(B2jImageManager.IMG_WSDLBINDING);
		}
		return null;
	}

	public String getColumnText(Object element, int columnIndex) {
		WSDLBindingTranslator translator = (WSDLBindingTranslator)element;
		
		if (columnIndex == COL_NAME) {
			return translator.getHumanReadableName();
		} else if (columnIndex == COL_ENABLED) {
			if (store.getBoolean(PreferenceConstants.getBindingEnabledKey(translator))) {
				return UiPlugin.getString("ENABLED");
			} else {
				return UiPlugin.getString("DISABLED");
			}
		}
		return "";
	}

	public void addListener(ILabelProviderListener listener) {}
	public boolean isLabelProperty(Object element, String property) {
		return false;
	}
	public void removeListener(ILabelProviderListener listener) {}

	
	private int getIndexForProperty(String property) {
		for (int i = 0; i < properties.length; i++) {
			if (property.equals(properties[i])) {
				return i;
			}
		}
		return -1;
	}
		
	public boolean canModify(Object element, String property) {
		WSDLBindingTranslator translator = (WSDLBindingTranslator)element;
		int index = getIndexForProperty(property);
		
//		if (index == COL_ENABLED) {
//			if (!translator.getID().equals(new InternalMessageBindingTranslator().getID())) {
//				//dont allow disabling of the internal binding
//				return true;
//			}
//		}
		return false;
	}

	public Object getValue(Object element, String property) {
		WSDLBindingTranslator translator = (WSDLBindingTranslator)element;
		int index = getIndexForProperty(property);
		
		if (index == COL_NAME) {
			return translator.getHumanReadableName();
		} else if (index == COL_ENABLED) {
			return new Boolean(store.getBoolean(PreferenceConstants.getBindingEnabledKey(translator)));
		}
		return null;
	}

	public void modify(Object element, String property, Object value) {
		WSDLBindingTranslator translator = (WSDLBindingTranslator)((TableItem)element).getData();
		int index = getIndexForProperty(property);
		
		if (index == COL_ENABLED) {
			store.setValue(PreferenceConstants.getBindingEnabledKey(translator),((Boolean)value).booleanValue());
			transports_viewer.setInput("");
		}
	}
}