/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.ui.publicapi.extensionpoints.bpelprovider;

import org.eclipse.swt.graphics.Image;

/**
 * An interface implemented as part of the BPELProvider extension point
 * 
 * @author amiguel
 */
public interface ImageProvider {
	
	/**
	 * Get the image for the specified BPELProvider ID (allows one image provider
	 * for multiple BPEL providers)
	 * @param id the ID of the BPELProvider
	 * @return the Image of the specified BPELProvider
	 */
	public Image getImage(String id);
}