/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.ui.publicapi.program;

import java.util.ArrayList;
import java.util.HashMap;

import org.eclipse.core.runtime.IPath;
import org.eclipse.stp.b2j.core.publicapi.program.BPELProgram;
import org.eclipse.stp.b2j.core.publicapi.transport.session.SessionAddress;
import org.eclipse.stp.b2j.ui.internal.misc.PathUtil;

/**
 * This class is a public API which represents an engine program composed of a single BPEL file
 * 
 * The program can be distributed over multiple hosts and then run using the BPELEngine class
 * 
 * @author amiguel
 *
 */
public class WorkbenchBPELProgram implements BPELProgram {
	
	String name;
	String source;
	String base_uri;
	
	SessionAddress coordinator_daemon;
	SessionAddress coordinator;
	ArrayList worker_daemons = new ArrayList();
	ArrayList workers = new ArrayList();
	
	ArrayList jar_dependencies = new ArrayList();
	
	HashMap compiledData = new HashMap();
	
	/**
	 * Create a new BPEL program which will run the BPEL source file at the given path
	 * @param bpel_file_path the IPath to the BPEL source file
	 */
	public WorkbenchBPELProgram(IPath bpel_file_path) throws Exception {
		base_uri = PathUtil.getLocationFromPath(bpel_file_path);
		source = PathUtil.readFileFromPath(bpel_file_path);

		String bpel_file = bpel_file_path.toString();
		name = bpel_file.substring(Math.max(bpel_file.lastIndexOf('\\'),bpel_file.lastIndexOf('/')) + 1);
	}
	
	public WorkbenchBPELProgram(String name, String base_uri, String source) {
		this.name = name;
		this.base_uri = base_uri;
		this.source = source;
	}

	public String[] getProgramDependencies() {
		String[] deps = new String[jar_dependencies.size()];
		jar_dependencies.toArray(deps);
		return deps;
	}

	
	public String getBaseURI() {
		return base_uri;
	}
	public String getBpelSource() {
		return source;
	}
	
	public SessionAddress[] getWorkerDaemons() {
		SessionAddress[] tmp = new SessionAddress[worker_daemons.size()];
		worker_daemons.toArray(tmp);
		return tmp;
	}
	public SessionAddress[] getWorkerHosts() {
		SessionAddress[] tmp = new SessionAddress[workers.size()];
		worker_daemons.toArray(tmp);
		return tmp;
	}
	
	public SessionAddress getCoordinatorHost() {
		return coordinator;
	}
	
	public SessionAddress getCoordinatorDaemon() {
		return coordinator_daemon;
	}
	
	public String getName() {
		return name;
	}
	
	
	/**
	 * Set the coordinator host if this program is to run over a number of hosts
	 * @param address an address containing a listener host corresponding to the coordinator host
	 */
	public void setCoordinatorHost(SessionAddress daemon_address, SessionAddress coordinator_address) {
		this.coordinator_daemon = daemon_address;
		this.coordinator = coordinator_address;
	}
	
	/**
	 * Add a worker host if this program is to run over a number of hosts
	 * @param address an address containing a listener host corresponding to the worker host
	 */
	public void addWorkerHost(SessionAddress daemon_address, SessionAddress worker_address) {
		worker_daemons.add(daemon_address);
		workers.add(worker_address);
	}
	
	/**
	 * Include a JAR on the classpath of the engine program
	 * @param localJarPath
	 */
	public void addJarDependency(String localJarPath) {
		jar_dependencies.add(localJarPath);
	}

	public void setCompiledData(String key, Object o) {
		compiledData.put(key,o);
	}

	public Object getCompiledData(String key) {
		return compiledData.get(key);
	}
}
