/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.ui.internal.extensions.bpelprovider;

import org.eclipse.stp.b2j.ui.UiPlugin;
import org.eclipse.stp.b2j.ui.publicapi.extensionpoints.bpelprovider.PropertySource;
import org.eclipse.stp.b2j.ui.publicapi.extensionpoints.bpelprovider.PropertySourceUI;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class LocalFileUI implements PropertySourceUI, KeyListener, SelectionListener {

	public static final String PROPERTY_NAME = "org.eclipse.stp.b2j.core.localfile";
	
	PropertySource source;
	
	Label bpel_label;
	Text bpel_file;
	Button bpel_browse;
	
	public void setPropertySource(PropertySource source) {
		this.source = source;
	}

	public int getTabCount() {
		return 1;
	}
	public void createTab(int index, Composite parent) {
		parent.setLayout(new GridLayout(4,false));
		
		bpel_label = new Label(parent,SWT.NONE);
		bpel_label.setText(UiPlugin.getString("LOCAL_BPEL_FILE"));
		bpel_label.setLayoutData(new GridData(GridData.BEGINNING,GridData.END,false,false,4,1));
		
		bpel_file = new Text(parent,SWT.BORDER);
		bpel_file.setLayoutData(new GridData(GridData.FILL,GridData.FILL,true,false,3,1));

		bpel_browse = new Button(parent,SWT.NONE);
		bpel_browse.setText(UiPlugin.getString("BROWSE"));
		bpel_browse.setLayoutData(new GridData(GridData.FILL,GridData.FILL,false,false,1,1));

		
		//
		// Event handling
		//
		bpel_file.addKeyListener(this);
		bpel_browse.addSelectionListener(this);
	}
	
	public String getTabName(int index) {
		return UiPlugin.getString("BP_TAB_LOCAL_FILE");
	}

	public void loadFromPropertySource() {
		Document doc = source.getProperty(PROPERTY_NAME);
		
//		System.out.println("LOADING WORKSPACE FILE UI FROM PROPERTY SOURCE "+doc);
		if (doc != null) {
			Element docelem = doc.getDocumentElement();
			
			if (docelem.hasAttribute("file")) {
				bpel_file.setText(docelem.getAttribute("file"));
			} else {
				bpel_file.setText("");
			}
		}

	}

	public void saveToPropertySource() {
		Document doc = source.createProperty(PROPERTY_NAME);
		
		Element docelem = doc.getDocumentElement();
		
		docelem.setAttribute("file",bpel_file.getText());
		
//		System.out.println("SAVING WORKSPACE FILE UI TO PROPERTY SOURCE "+doc);

		source.setProperty(PROPERTY_NAME,doc);
	}

	public void dispose() {
		bpel_label.dispose();
		bpel_file.dispose();
		bpel_browse.dispose();
	}
	
	//
	// Key listener
	//
	public void keyPressed(KeyEvent e) {
		source.setDirty(true);
	}

	public void keyReleased(KeyEvent e) {
		source.setDirty(true);
	}

	//
	// Selection listener
	//
	public void widgetDefaultSelected(SelectionEvent e) {
		widgetSelected(e);
	}

	String previous_path = null;
	
	public void widgetSelected(SelectionEvent e) {
		Object o = e.getSource();
		if (o == bpel_browse) {
			FileDialog dialog = new FileDialog(bpel_label.getShell(),SWT.NONE);
			
//			ResourceSelectionDialog dialog = new ResourceSelectionDialog(bpel_label.getShell(),ResourcesPlugin.getWorkspace().getRoot(),B2jPlugin.getString("BROWSE_BPEL_MSG"));
			//dialog.setInitialSelections(..);
			
			if (previous_path != null) {
				dialog.setFilterPath(previous_path);
			}
			String file = dialog.open();
			
			if (file != null) {
				bpel_file.setText(file);
				source.setDirty(true);
				
				previous_path = dialog.getFilterPath();
			}
/*			
			Object[] resources = dialog.getResult();
			
			if (resources.length == 1) {
				IResource resource = (IResource)resources[0];
				System.out.println(resource.getFullPath());
				
				bpel_file.setText(resource.getFullPath().toString());
				
			} else {
				MessageBox mbox = new MessageBox(bpel_label.getShell(),SWT.NONE);
				mbox.setMessage(B2jPlugin.getString("ERROR_ONE_BPEL"));
				mbox.setText(B2jPlugin.getString("ERROR"));
				mbox.open();
			}*/
			
//			source.setDirty(true);
		}
	}


}