/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.ui.internal.launchconfig;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.stp.b2j.ui.internal.misc.HexData;
import org.eclipse.stp.b2j.ui.internal.misc.XMLUtil;
import org.eclipse.stp.b2j.ui.publicapi.extensionpoints.bpelprovider.PropertySource;
import org.w3c.dom.Document;

public class LaunchConfigPropertySource implements PropertySource {
	
	private static final String PROPERTY_NAMES = "provider_property_names";
	private static final String PROPERTY_DATAS = "provider_property_datas";
	
	HashMap properties = new HashMap();

	
	public void setProperty(String name, Document doc) {
		try {
//			System.out.println("PUT PROPERTY "+name);			
			String xmlstring = XMLUtil.documentToString(doc);
			String hexstring = HexData.stringToHexString(xmlstring);
			
			properties.put(name,hexstring);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	public Document createProperty(String deftype) {
		try {
			return XMLUtil.blankDocument(deftype);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return null;
	}
	public Document getProperty(String name) {
		try {
//			System.out.println("GET PROPERTY "+name);			
			String hexstring = (String)properties.get(name);
			if (hexstring != null) {
				String xmlstring = HexData.hexStringToString(hexstring);
				
				return XMLUtil.documentFromString(xmlstring);
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		return null;
	}

	public void setDirty(boolean b) {
		//do nothing
	}
	
	public void initializeFrom(ILaunchConfiguration configuration) throws CoreException {
		properties.clear();
		
		List names = configuration.getAttribute(PROPERTY_NAMES,new ArrayList());
		List datas = configuration.getAttribute(PROPERTY_DATAS,new ArrayList());
		
		for (int i = 0; i < names.size(); i++) {
//			System.out.println("LOADING PROPERTY "+names.get(i));			
			properties.put((String)names.get(i),(String)datas.get(i));
		}
		
	}

	public void performApply(ILaunchConfigurationWorkingCopy configuration) {
		ArrayList keys = new ArrayList(properties.keySet());
		
		ArrayList names = new ArrayList();
		ArrayList datas = new ArrayList();

		for (int i = 0; i < keys.size(); i++) {
			String key = (String)keys.get(i);
			String data = (String)properties.get(key);

			names.add(key);
			datas.add(data);
			
//			System.out.println("SAVING PROPERTY "+key);			
		}
		configuration.setAttribute(PROPERTY_NAMES,names);
		configuration.setAttribute(PROPERTY_DATAS,datas);
	}
	
}