/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.ui.publicapi.extensionpoints.bpelprovider;

import java.util.ArrayList;

import org.eclipse.swt.graphics.Image;

public class BPELProviderCategory {
	String name;
	String id;
	String parentId;
	ImageProvider imgProvider;
	
	ArrayList children = new ArrayList();
	ArrayList providers = new ArrayList();
	
	public BPELProviderCategory(String name, String id, String parentId, ImageProvider imgProvider) {
		this.name = name;
		this.id = id;
		this.parentId = parentId;
		this.imgProvider = imgProvider;
		
		if (this.parentId == null) this.parentId = "";
	}
	
	public String getName() {
		return name;
	}
	public String getId() {
		return id;
	}
	public String getParentId() {
		return parentId;
	}
	
	public void add(BPELProviderCategory cat) {
		children.add(cat);
	}
	public void add(BPELProviderNode prov) {
		providers.add(prov);
	}
	
	public Image getImage() {
		if (imgProvider == null) return null;
		return imgProvider.getImage(id);
	}
	
	public int getCategoryCount() {
		return children.size();
	}
	public int getProviderCount() {
		return providers.size();
	}
	public BPELProviderCategory getCategory(int i) {
		return (BPELProviderCategory)children.get(i);
	}
	public BPELProviderNode getProvider(int i) {
		return (BPELProviderNode)providers.get(i);
	}
	
	
	public BPELProviderNode getProvider(String id) {
		for (int i = 0; i < providers.size(); i++ ) {
			BPELProviderNode provider = (BPELProviderNode)providers.get(i);
			if (provider.getId().equals(id)) {
				return provider;
			}
		}
		
		for (int i = 0; i < children.size(); i++) {
			BPELProviderCategory cat = (BPELProviderCategory)children.get(i);
			
			BPELProviderNode provider = cat.getProvider(id);
			if (provider != null) {
				return provider;
			}
		}
		
		return null;
	}
	public BPELProviderCategory getCategory(String id) {
		if (id.equals(this.id)) return this;
		
		for (int i = 0; i < children.size(); i++) {
			BPELProviderCategory cat = (BPELProviderCategory)children.get(i);
			
			BPELProviderCategory ret = cat.getCategory(id);
			
			if (ret != null) return ret;
		}
		
		return null;
	}
	
	public String getTreeString() {
		StringBuffer sb = new StringBuffer();
		getTreeString(0,sb);
		return sb.toString();
	}
	void getTreeString(int depth, StringBuffer sb) {
		for (int i = 0; i < depth; i++) {
			sb.append("---");
		}
		
		sb.append(name);
		sb.append("\n");
		
		for (int i = 0; i < providers.size(); i++) {
			for (int k = 0; k < depth+1; k++) {
				sb.append("---");
			}

			sb.append("(Provider) "+providers.get(i));
			sb.append("\n");
		}
		
		for (int i = 0; i < children.size(); i++) {
			BPELProviderCategory cat = (BPELProviderCategory)children.get(i);
			cat.getTreeString(depth+1,sb);
		}
	}
	public String toString() {
		return name;
	}
}