/**********************************************************************
 * Copyright (c) 2006 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.jengine.internal.compiler.locks;

import java.util.ArrayList;
import java.util.HashMap;

public class LockModelScopeOptimiser implements LockModelOptimiser {
	
	HashMap refCache = new HashMap();
	
	public void optimise(LockModel model) {
		LockObject root = model.getRoot();
		ArrayList locks = root.getDeepLockList();
		
		for (int i = 0; i < locks.size(); i++) {
			LockLock lock = (LockLock)locks.get(i);
			
			//are there multiple threads below the creation of this lock
			
			lock.getParent();
			
			boolean hasConcurrentReferences = checkForConcurrentReferences(lock.getParent(),lock.getName());
			
			if (!hasConcurrentReferences) {
				lock.setEnabled(false,"no concurrent references");
			}
		}
	}
	
	private boolean checkForConcurrentReferences(LockObject cur, String lockName) {
		if (cur instanceof LockFlow) {
			//look for concurrent references (references by more than one element of a single flow)
			
			int refCount = 0;
			
			if (cur.size() > 1) {
				//flow with more than one thread
				for (int i = 0; i < cur.size(); i++) {
					if (checkForReference(cur.getChild(i),lockName)) {
						//something in this thread sub-tree references this lock
						refCount++;
						if (refCount > 1) return true;
					}
				}
			}
		}
		
		//check children
		for (int i = 0; i < cur.size(); i++) {
			LockObject tmp = cur.getChild(i);
			if (checkForConcurrentReferences(tmp,lockName)) {
				return true;
			}
		}
		
		return false;
	}
	
	private boolean checkForReference(LockObject cur, String lockName) {
		
		//if we find a sub-lock of the same name, we can't reference the one in the parent scope
		if (cur.hasLock(lockName)) {
			return false;
		}
		
		//do we reference this lock
		if (cur instanceof LockSync) {
			LockSync sync = (LockSync)cur;
			if (sync.getLockName().equals(lockName)) {
				return true;
			}
		} else {
			
			//check cache
//			refCache.get()
			
			//check children
			for (int i = 0; i < cur.size(); i++) {
				LockObject tmp = cur.getChild(i);
				if (checkForReference(tmp,lockName)) {
					return true;
				}
			}
		}
		
		return false;
	}
}