/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.soap;


import java.util.ArrayList;
import java.util.HashMap;

import org.eclipse.stp.b2j.core.jengine.internal.core.bpel.BPELCorrelationSet;
import org.eclipse.stp.b2j.core.jengine.internal.core.bpel.WSEndpointReference;
import org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.soap.http.SOAPClientTransportHTTP;
import org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.soap.http.SOAPServerTransportHTTP;
import org.eclipse.stp.b2j.core.publicapi.B2jConfig;
import org.eclipse.stp.b2j.core.publicapi.B2jPlatform;

/**
 * 
 * @author amiguel
 *
 * A factory which returns a SOAP transport implementation based on given parameters
 */
public class SOAPFactory {
	
	private static Object config_LOCK = new Object();
	private static boolean loaded = false;
	
	private static String httpsHost = null;
	private static int httpsPort = 8080;
	private static String httpHost = null;
	private static int httpPort = 8080;
	private static String[] excludedHosts = new String[0];
	
	public static final boolean DEBUG = false;

	public static void resetProxySettings() {
		synchronized(config_LOCK) {
			loaded = false;
		}
	}
	
	private static void loadProxySettings() {
		synchronized(config_LOCK) {
			if (loaded) return;
			B2jConfig config = B2jPlatform.getB2jConfig();
			
			if (config != null) {
				
				{
					String s = config.getProperty(B2jConfig.PATH_SOAP_HTTPS_PROXY_USE);
					if (s != null) {
						if (s.equals("true")) {
							httpsHost = config.getProperty(B2jConfig.PATH_SOAP_HTTPS_PROXY_HOST);
							httpsPort = Integer.parseInt(config.getProperty(B2jConfig.PATH_SOAP_HTTPS_PROXY_PORT));
						}
					}
				}
				
				{
					String s = config.getProperty(B2jConfig.PATH_SOAP_HTTP_PROXY_USE); 
					if (s != null) {
						if (s.equals("true")) {
							httpHost = config.getProperty(B2jConfig.PATH_SOAP_HTTP_PROXY_HOST);
							httpPort = Integer.parseInt(config.getProperty(B2jConfig.PATH_SOAP_HTTP_PROXY_PORT));
						}
					}
				}
				
				{
					String[] SOAP_PROXY_EXCLUDED_HOSTS;
					try {
	//					B2jConfig config = getCachedConfig();
	
						ArrayList tmp = new ArrayList();
	//					String proxy_hosts = conf.getProperty("soap_proxy_excluded_hosts").trim();
						String proxy_hosts = config.getProperty(B2jConfig.PATH_SOAP_EXCLUDED_PROXY_HOSTS);
						
						if (proxy_hosts == null) {
							SOAP_PROXY_EXCLUDED_HOSTS = new String[0];
						} else {
						
							int index;
							do {
								index = proxy_hosts.indexOf(',');
								String proxy_host_tmp;
								if (index != -1) {
									proxy_host_tmp = proxy_hosts.substring(0,index);
									proxy_hosts = proxy_hosts.substring(index+1);
								} else {
									proxy_host_tmp = proxy_hosts;
								}
								
								proxy_host_tmp = proxy_host_tmp.trim();
								if (proxy_host_tmp.length() > 0) {
									tmp.add(proxy_host_tmp);
								}
							} while (index != -1);
							
							SOAP_PROXY_EXCLUDED_HOSTS = new String[tmp.size()];
							tmp.toArray(SOAP_PROXY_EXCLUDED_HOSTS);
						}
						
					} catch (NullPointerException e) {
						SOAP_PROXY_EXCLUDED_HOSTS = new String[0];
					}
					excludedHosts = SOAP_PROXY_EXCLUDED_HOSTS;
				}
			}
			
			loaded = true;
		}
	}
	
	static HashMap soapClients = new HashMap();
	static Object soapClients_LOCK = new Object();
	
	public static void addServerTransportListenerForEPR(WSEndpointReference epr, String transportURI, boolean rpc_type, SOAPServerTransportListener listener) throws Exception {

		if (transportURI == null) {
			String addr = epr.getAddress();
			String lc_addr = addr.toLowerCase();
			
			if (lc_addr.startsWith("http")) {
				transportURI = SOAPNamespaces.BINDING_TRANSPORT_HTTP;
			} else {
				throw new Exception("Could not detect valid SOAP transport for endpoint reference ("+addr+")");
			}
		}
		
		//TODO return different transports according to EPR
		//TODO set up transports according to EPR

		if (transportURI.equalsIgnoreCase(SOAPNamespaces.BINDING_TRANSPORT_HTTP)) {
			SOAPServerTransportHTTP proxy = new SOAPServerTransportHTTP(epr,rpc_type,listener);
		} else {
			throw new Exception("Could not detect valid SOAP transport for URI \""+transportURI+"\"");
		}
	}
	public static SOAPClientTransport getClientTransportForEPR(WSEndpointReference epr, BPELCorrelationSet cset, String transportURI) throws Exception {

		if (transportURI == null) {
			String addr = epr.getAddress();
			String lc_addr = addr.toLowerCase();
			
			if (lc_addr.startsWith("http")) {
				transportURI = SOAPNamespaces.BINDING_TRANSPORT_HTTP;
			} else {
				throw new Exception("Could not detect valid SOAP transport for endpoint reference");
			}
		}

		//TODO return different transports according to EPR
		//TODO set up transports according to EPR

		if (transportURI.equalsIgnoreCase(SOAPNamespaces.BINDING_TRANSPORT_HTTP)) {
			String addr = epr.getAddress().toLowerCase();
			
			String proxy_host = null;
			int proxy_port = 8080;
			
			loadProxySettings();
			if (addr.startsWith("https")) {
				proxy_host = httpsHost;
				proxy_port = httpsPort;
/*				
				try {
//					B2jConfig config = B2jPlatform.getB2jConfig();
					B2jConfig config = getCachedConfig();
					String s = config.getProperty(B2jConfig.PATH_SOAP_HTTPS_PROXY_USE);
					if (s != null) {
						if (s.equals("true")) {
							proxy_host = config.getProperty(B2jConfig.PATH_SOAP_HTTPS_PROXY_HOST);
							proxy_port = Integer.parseInt(config.getProperty(B2jConfig.PATH_SOAP_HTTPS_PROXY_PORT));
						}
					}
				} catch (NullPointerException e) {
					if (SOAPFactory.DEBUG) System.out.println("No B2J SOAP proxy config found");
				}*/
/*				if (SoapDaemon.SOAP_HTTPS_PROXY_ON) {
					proxy_host = SoapDaemon.SOAP_HTTPS_PROXY_HOST;
					proxy_port = SoapDaemon.SOAP_HTTPS_PROXY_PORT;
				}*/
			} else {
				proxy_host = httpHost;
				proxy_port = httpPort;
//				B2jConfig config = getCachedConfig();
//				B2jConfig config = B2jPlatform.getB2jConfig();
/*				try {
					String s = config.getProperty(B2jConfig.PATH_SOAP_HTTP_PROXY_USE); 
					if (s != null) {
						if (s.equals("true")) {
							proxy_host = config.getProperty(B2jConfig.PATH_SOAP_HTTP_PROXY_HOST);
							proxy_port = Integer.parseInt(config.getProperty(B2jConfig.PATH_SOAP_HTTP_PROXY_PORT));
						}
					}
				} catch (NullPointerException e) {
					if (SOAPFactory.DEBUG) System.out.println("No B2J SOAP proxy config found");
				}*/
/*				if (SoapDaemon.SOAP_HTTP_PROXY_ON) {
					proxy_host = SoapDaemon.SOAP_HTTP_PROXY_HOST;
					proxy_port = SoapDaemon.SOAP_HTTP_PROXY_PORT;
				}*/
			}
			
			loadProxySettings();
			String[] SOAP_PROXY_EXCLUDED_HOSTS = excludedHosts;
/*			
			
			String[] SOAP_PROXY_EXCLUDED_HOSTS;
			try {
//				B2jConfig config = getCachedConfig();

				ArrayList tmp = new ArrayList();
//				String proxy_hosts = conf.getProperty("soap_proxy_excluded_hosts").trim();
				String proxy_hosts = config.getProperty(B2jConfig.PATH_SOAP_EXCLUDED_PROXY_HOSTS);
				
				if (proxy_hosts == null) {
					SOAP_PROXY_EXCLUDED_HOSTS = new String[0];
				} else {
				
					int index;
					do {
						index = proxy_hosts.indexOf(',');
						String proxy_host_tmp;
						if (index != -1) {
							proxy_host_tmp = proxy_hosts.substring(0,index);
							proxy_hosts = proxy_hosts.substring(index+1);
						} else {
							proxy_host_tmp = proxy_hosts;
						}
						
						proxy_host_tmp = proxy_host_tmp.trim();
						if (proxy_host_tmp.length() > 0) {
							tmp.add(proxy_host_tmp);
						}
					} while (index != -1);
					
					SOAP_PROXY_EXCLUDED_HOSTS = new String[tmp.size()];
					tmp.toArray(SOAP_PROXY_EXCLUDED_HOSTS);
				}
				
			} catch (NullPointerException e) {
				SOAP_PROXY_EXCLUDED_HOSTS = new String[0];
			}*/
			
			return new SOAPClientTransportHTTP(epr.getAddress(),cset,proxy_host,proxy_port,SOAP_PROXY_EXCLUDED_HOSTS);
		} else {
			throw new Exception("Could not detect valid SOAP transport for URI \""+transportURI+"\"");
		}
	}
	/*
	public static SOAPServerInterface getClientForEPR(boolean rpc_style, WSEndpointReference epr) throws Exception {
		return getClientForEPR(rpc_style,epr,null);
		
	}
	public static SOAPServerInterface getClientForEPR(boolean rpc_style, WSEndpointReference epr, String transportURI) throws Exception {

		synchronized(soapClients_LOCK) {
			String key = rpc_style+" : "+transportURI+" : "+epr.toString();
			
			SOAPServer client = (SOAPServer)soapClients.get(key);
			
			if (client == null) {
				client = new SOAPServer(getTransportForEPR(rpc_style,epr,transportURI),rpc_style);
				soapClients.put(key,client);
				//TODO set up client according to EPR
			}

			return client;
		}
	}
	*/

}