/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.jengine.internal.mainengine;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;

import org.eclipse.stp.b2j.core.jengine.internal.Version;
import org.eclipse.stp.b2j.core.jengine.internal.api.Program;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.Switches;
import org.eclipse.stp.b2j.core.jengine.internal.core.datapool.SharedVariable;
import org.eclipse.stp.b2j.core.jengine.internal.mainengine.api.SoapDaemonConnector;
import org.eclipse.stp.b2j.core.jengine.internal.message.MTMessageWriter;
import org.eclipse.stp.b2j.core.jengine.internal.message.MTTransactionClient;
import org.eclipse.stp.b2j.core.jengine.internal.message.MTTransactionServer;
import org.eclipse.stp.b2j.core.jengine.internal.message.Message;
import org.eclipse.stp.b2j.core.jengine.internal.message.MessageReader;
import org.eclipse.stp.b2j.core.jengine.internal.message.MessageUtils;
import org.eclipse.stp.b2j.core.jengine.internal.message.MessageWriter;
import org.eclipse.stp.b2j.core.jengine.internal.message.TransactionListener;
import org.eclipse.stp.b2j.core.jengine.internal.multiplex.MultiplexerInputStream;
import org.eclipse.stp.b2j.core.jengine.internal.multiplex.MultiplexerOutputStream;
import org.eclipse.stp.b2j.core.jengine.internal.mutex.UnqueuedMutex;
import org.eclipse.stp.b2j.core.jengine.internal.transport.session.Session;
import org.eclipse.stp.b2j.core.jengine.internal.transport.session.SessionFactory;
import org.eclipse.stp.b2j.core.jengine.internal.utils.FileUtil;
import org.eclipse.stp.b2j.core.jengine.internal.utils.GCThread;
import org.eclipse.stp.b2j.core.jengine.internal.utils.ID;
import org.eclipse.stp.b2j.core.jengine.internal.utils.LineBasedPrintStream;
import org.eclipse.stp.b2j.core.jengine.internal.utils.Logger;
import org.eclipse.stp.b2j.core.jengine.internal.utils.StreamUtils;
import org.eclipse.stp.b2j.core.misc.internal.HexData;
import org.eclipse.stp.b2j.core.publicapi.JARDependency;
import org.eclipse.stp.b2j.core.publicapi.transport.session.SessionAddress;

/**
 * 
 * @author amiguel
 * 
 * The distributed engine main Controller implementation, see the plugin architecture docs for more info.
 */
public class Controller extends Thread implements TransactionListener {

	public static final String DEPS_CACHE_DIR = "depscache";
	public static final long CACHE_LIMIT_MEGS = 100;
	
public static final String[] CONTROLLER_SOCKET_IDS = new String[]{"Controller:server->client transaction",
																	"Controller:server<-client transaction",
																	"Controller:server<->client notifications"};

	
public static final int CONTROLLER_UNRECOGNISED_MESSAGE = -1;

public static final int CONTROLLER_EMPTY = -2;

public static final int CONTROLLER_INTERNAL_ERROR = -3;

//
// These are used to subdivide the messages into high priority, medium priority and low priority 
//
//public static final int MASK_UNKNOWN_PRIORITY = 	0000000;
//public static final int MASK_LOW_PRIORITY = 		1000000;
//public static final int MASK_MEDIUM_PRIORITY = 		2000000;
//public static final int MASK_HIGH_PRIORITY = 		3000000;
public static final int MASK_PRIORITY = 			0xF00000;

public static final int MASK_UNKNOWN_PRIORITY = 	0x000000;
public static final int MASK_LOW_PRIORITY = 		0x100000;
public static final int MASK_MEDIUM_PRIORITY = 		0x200000;
public static final int MASK_HIGH_PRIORITY = 		0x400000;

//
// These are used to indicate other generic traits about messages
//
public static final int MASK_OTHER = 				0xF000000;

// This is used to indicate that a transaction has been piggybacked onto the transaction response
public static final int MASK_PIGGYBACK = 			0x1000000;


//IN
public static final int CONTROLLER_LAUNCH_PROGRAM = 10 + MASK_LOW_PRIORITY;
	//OUT
	public static final int CONTROLLER_LAUNCH_PROGRAM_OK = 11;
	//OUT
	public static final int CONTROLLER_LAUNCH_PROGRAM_FAIL = 12;
	//String - error message

//IN
public static final int CONTROLLER_SET_PROGRAM = 100 + MASK_LOW_PRIORITY;
//byte[] - program (class file)
	//OUT
	public static final int CONTROLLER_SET_PROGRAM_OK = 101;
	//OUT
	public static final int CONTROLLER_SET_PROGRAM_FAIL = 102;
	//String - error message

//IN
public static final int CONTROLLER_LAUNCH_RUNNER = 200 + MASK_MEDIUM_PRIORITY;
//int - count
//String - method
//int - host index
	//OUT
	public static final int CONTROLLER_LAUNCH_RUNNER_OK = 201;
	//OUT
	public static final int CONTROLLER_LAUNCH_RUNNER_FAIL = 202;
	//String - error message

//IN
public static final int CONTROLLER_MAKE_VARIABLE = 300 + MASK_LOW_PRIORITY;
//String - name
//int - type
	//OUT
	public static final int CONTROLLER_MAKE_VARIABLE_OK = 301;
	//int - id
	//OUT
	public static final int CONTROLLER_MAKE_VARIABLE_FAIL = 302;
	//String - error message
	//OUT
	public static final int CONTROLLER_MAKE_VARIABLE_EXISTS = 303;
	//int - id

//IN
public static final int CONTROLLER_MAKE_SEMAPHORE = 400 + MASK_LOW_PRIORITY;
//String - name
//int - initial value
	//OUT
	public static final int CONTROLLER_MAKE_SEMAPHORE_OK = 401;
	//int - id
	//OUT
	public static final int CONTROLLER_MAKE_SEMAPHORE_FAIL = 402;
	//String - error message
	//OUT
	public static final int CONTROLLER_MAKE_SEMAPHORE_EXISTS = 403;
	//int - id

//IN
public static final int CONTROLLER_WAIT_SEMAPHORE = 500 + MASK_HIGH_PRIORITY;
//int - id
//int - wait value
//long - rid
	//OUT
	public static final int CONTROLLER_WAIT_SEMAPHORE_OK = 501; //just let the thread run
	//OUT
	public static final int CONTROLLER_WAIT_SEMAPHORE_FAIL = 502;
	//String - error message
	//OUT
	public static final int CONTROLLER_WAIT_SEMAPHORE_WILL_NOTIFY = 503; //a message will be sent back when thread can start

//IN
public static final int CONTROLLER_SIGNAL_SEMAPHORE = 600 + MASK_HIGH_PRIORITY;
//int - id
//int - signal value
	//OUT
	public static final int CONTROLLER_SIGNAL_SEMAPHORE_OK = 601;
	//OUT
	public static final int CONTROLLER_SIGNAL_SEMAPHORE_FAIL = 602;
	//String - error message

//	IN
public static final int CONTROLLER_STORE_VARIABLE = 700 + MASK_HIGH_PRIORITY;
//int - variable id
//int - variable type
//Object - variable value 
	  //OUT
	  public static final int CONTROLLER_STORE_VARIABLE_OK = 701;
	  //OUT
	  public static final int CONTROLLER_STORE_VARIABLE_FAIL = 702;
	  //String - error message

//	IN
public static final int CONTROLLER_FETCH_VARIABLE = 800 + MASK_HIGH_PRIORITY;
//int - variable id
//int variable type
	  //OUT
	  public static final int CONTROLLER_FETCH_VARIABLE_OK = 801;
	  //int variable type
	  //Object - variable value
	  //OUT
	  public static final int CONTROLLER_FETCH_VARIABLE_FAIL = 802;
	  //String - error message

//	IN
public static final int CONTROLLER_GET_VARIABLE = 900 + MASK_MEDIUM_PRIORITY;
//String - name
	  //OUT
	  public static final int CONTROLLER_GET_VARIABLE_OK = 901;
	  //int - id
	  //int - type
	  //OUT
	  public static final int CONTROLLER_GET_VARIABLE_FAIL = 902;
	  //String - error message

//	IN
public static final int CONTROLLER_GET_SEMAPHORE = 1000 + MASK_MEDIUM_PRIORITY;
//String - name
	  //OUT
	  public static final int CONTROLLER_GET_SEMAPHORE_OK = 1001;
	  //int - id
	  //int - initial
	  //OUT
	  public static final int CONTROLLER_GET_SEMAPHORE_FAIL = 1002;
	  //String - error message

//IN
public static final int CONTROLLER_MAKE_DIRTY_VARIABLE = 1100 + MASK_LOW_PRIORITY;
//String - name
//int - type
	//OUT
//	public static final int CONTROLLER_MAKE_DIRTY_VARIABLE_OK = 1101;
	//int - id
	//OUT
//	public static final int CONTROLLER_MAKE_DIRTY_VARIABLE_FAIL = 1102;
	//String - error message

//IN
public static final int CONTROLLER_TRACE = 1200;

//IN
public static final int CONTROLLER_SYNC_CLOCK = 1300;
	//OUT
	public static final int CONTROLLER_SYNC_CLOCK_OK = 1301;
	//OUT
	public static final int CONTROLLER_SYNC_CLOCK_FAIL = 1302;

//IN
public static final int CONTROLLER_PRINT = 1400;

//IN
public static final int CONTROLLER_MAKE_HASHMAP = 1500 + MASK_LOW_PRIORITY;
//String - name
	//OUT
	public static final int CONTROLLER_MAKE_HASHMAP_OK = 1501;
	//int - id
	//OUT
	public static final int CONTROLLER_MAKE_HASHMAP_FAIL = 1502;
	//String - error message
	//OUT
	public static final int CONTROLLER_MAKE_HASHMAP_EXISTS = 1503;
	//int - id

//	IN
public static final int CONTROLLER_GET_HASHMAP = 1600 + MASK_MEDIUM_PRIORITY;
//	String - name
	  //OUT
	  public static final int CONTROLLER_GET_HASHMAP_OK = 1601;
	  //int - id
	  //OUT
	  public static final int CONTROLLER_GET_HASHMAP_FAIL = 1602;
	  //String - error message

//	IN
public static final int CONTROLLER_PUT_HASHMAP = 1700 + MASK_HIGH_PRIORITY;
//	String - name
// Object - value
	  //OUT
	  public static final int CONTROLLER_PUT_HASHMAP_OK = 1701;
	  //OUT
	  public static final int CONTROLLER_PUT_HASHMAP_FAIL = 1702;
	  //String - error message

//	IN
public static final int CONTROLLER_RETRIEVE_HASHMAP = 1800 + MASK_HIGH_PRIORITY;
//	String - name
	  //OUT
	  public static final int CONTROLLER_RETRIEVE_HASHMAP_OK = 1801;
	  // Object - value
	  //OUT
	  public static final int CONTROLLER_RETRIEVE_HASHMAP_FAIL = 1802;
	  //String - error message
 	  //OUT
	  public static final int CONTROLLER_RETRIEVE_HASHMAP_NULL = 1803;

/*	  
//	IN
public static final int CONTROLLER_NEW_PICKER = 1900 + MASK_LOW_PRIORITY;
//	String - name
	  //OUT
	  public static final int CONTROLLER_NEW_PICKER_OK = 1901;
	  //OUT
	  public static final int CONTROLLER_NEW_PICKER_FAIL = 1902;
	  //String - error message
	public static final int CONTROLLER_NEW_PICKER_EXISTS = 1903;
	//int - id

//	IN
public static final int CONTROLLER_PICK = 2000 + MASK_HIGH_PRIORITY;
//	int id
	  //OUT
	  public static final int CONTROLLER_PICK_OK = 2001;
	  // int - value
	  //OUT
	  public static final int CONTROLLER_PICK_FAIL = 2002;
	  //String - error message

//	IN
public static final int CONTROLLER_GET_PICKER = 2100 + MASK_MEDIUM_PRIORITY;
//	String - name
	  //OUT
	  public static final int CONTROLLER_GET_PICKER_OK = 2101;
	  //int - id
	  //OUT
	  public static final int CONTROLLER_GET_PICKER_FAIL = 2102;
	  //String - error message
*/
	  
//	IN
public static final int CONTROLLER_CLEAR_HASHMAP = 2200 + MASK_HIGH_PRIORITY;
//	int - id
	  //OUT
	  public static final int CONTROLLER_CLEAR_HASHMAP_OK = 2201;
	  //OUT
	  public static final int CONTROLLER_CLEAR_HASHMAP_FAIL = 2202;
	  //String - error message

//	IN
public static final int CONTROLLER_GET_HOSTS = 2300 + MASK_LOW_PRIORITY;
	  //OUT
	  public static final int CONTROLLER_GET_HOSTS_OK = 2301;
	  // String - host1
	  // String - host2
	  //...
	  //OUT
	  public static final int CONTROLLER_GET_HOSTS_FAIL = 2302;
	  //String - error message

//	IN
public static final int CONTROLLER_GET_VARIABLE_LIST = 2400 + MASK_LOW_PRIORITY;
	  //OUT
	  public static final int CONTROLLER_GET_VARIABLE_LIST_OK = 2401;
	  // String - variable 1
	  // String - variable 2
	  //...
	  //OUT
	  public static final int CONTROLLER_GET_VARIABLE_LIST_FAIL = 2402;
	  //String - error message

//	IN
public static final int CONTROLLER_RUNNER_DEATH = 2500;

//	IN
public static final int CONTROLLER_RUNNER_JOIN = 2600 + MASK_HIGH_PRIORITY;
//long - id
	  //OUT
	  public static final int CONTROLLER_RUNNER_JOIN_OK = 2601;
	  //OUT
	  public static final int CONTROLLER_RUNNER_JOIN_WILL_NOTIFY = 2602;
	  //OUT
	  public static final int CONTROLLER_RUNNER_JOIN_FAIL = 2603;
	  //String - error message

//	IN
public static final int CONTROLLER_ABORT = 2700;

//	IN
public static final int CONTROLLER_MESSAGE_CONSUME = 2800 + MASK_HIGH_PRIORITY;
//long - id
	  //OUT
	  public static final int CONTROLLER_MESSAGE_CONSUME_OK = 2801;
	  //OUT
	  public static final int CONTROLLER_MESSAGE_CONSUME_WILL_NOTIFY = 2802;
	  //OUT
	  public static final int CONTROLLER_MESSAGE_CONSUME_FAIL = 2803;
	  //String - error message

//	IN
public static final int CONTROLLER_MESSAGE_PUBLISH = 2900 + MASK_HIGH_PRIORITY;
//String conversation
//Message msg
	//OUT
	public static final int CONTROLLER_MESSAGE_PUBLISH_OK = 2901;
	//OUT
	public static final int CONTROLLER_MESSAGE_PUBLISH_FAIL = 2902;
	
//	IN
public static final int CONTROLLER_MESSAGE_SEND_AND_RECEIVE = 3000 + MASK_HIGH_PRIORITY;
//long - id
	  //OUT
	  public static final int CONTROLLER_MESSAGE_SEND_AND_RECEIVE_OK = 3001;
	  //OUT
	  public static final int CONTROLLER_MESSAGE_SEND_AND_RECEIVE_WILL_NOTIFY = 3002;
	  //OUT
	  public static final int CONTROLLER_MESSAGE_SEND_AND_RECEIVE_FAIL = 3003;
	  //String - error message
	  
//IN
public static final int CONTROLLER_RUNNER_STACKDUMP = 3100;
	  
//IN
public static final int CONTROLLER_DEBUG = 3200;

//IN
public static final int CONTROLLER_SET_LOG_LEVEL = 3300 + MASK_LOW_PRIORITY;
//boolean - error
//boolean - warning
//boolean - info
	  //OUT
	  public static final int CONTROLLER_SET_LOG_LEVEL_OK = 3301;
	  //OUT
	  public static final int CONTROLLER_SET_LOG_LEVEL_FAIL = 3302;
	  //String - error message

//IN
public static final int CONTROLLER_RETRIEVE_HASHMAP_KEYLIST = 3400 + MASK_HIGH_PRIORITY;
//String - name
  	  //OUT
  	  public static final int CONTROLLER_RETRIEVE_HASHMAP_KEYLIST_OK = 3401;
  	  // Object - value
  	  //OUT
  	  public static final int CONTROLLER_RETRIEVE_HASHMAP_KEYLIST_FAIL = 3402;
  	  //String - error message

//IN
public static final int CONTROLLER_RUNNER_STACKTRACE = 3500;
//int - stacktrace message IDs

//IN
public static final int CONTROLLER_SET_HEADLESS = 3600 + MASK_LOW_PRIORITY;
//boolean - headless
		//OUT
		public static final int CONTROLLER_SET_HEADLESS_OK = 3601;
		//OUT
		public static final int CONTROLLER_SET_HEADLESS_FAIL = 3602;
		//String - error message

//IN
public static final int CONTROLLER_CHECK_DEPS_CACHE = 3700 + MASK_LOW_PRIORITY;
		//OUT
		public static final int CONTROLLER_CHECK_DEPS_CACHE_OK = 3701;
		//OUT
		public static final int CONTROLLER_CHECK_DEPS_CACHE_FAIL = 3702;
				

	  
//public static final String SERVER_CLIENT_TRANS = "server->client transactions";
//public static final String CLIENT_SERVER_TRANS = "client->server transactions";
//public static final String SERVER_CLIENT_NOTIF = "server->client notifications";

		boolean PRINT_INFO = true;
		boolean PRINT_DEBUG = true;
		
private static final int CLIENT_CONTROLLER = 0;

private static final Object LOCK_SERVER = new Object();

long clock = 0;

int id;
//int port;

//Socket client;
//ServerSocket server;

Session session;

Program program;
byte[] programb;
Message jar_dependencies;

//
// Messages going out to the client
//
//private static final Object LOCK_CWRITER = new Object();

//
// Clients
//
private static final Object LOCK_CLIENTS = new Object();
ArrayList clients_client = new ArrayList();
ArrayList clients_server = new ArrayList();
ArrayList clients_nout = new ArrayList();
ArrayList clients_nin = new ArrayList();

//
// Subcontrollers
//
HashMap hosts_map;
ArrayList subcontrollers_hosts = new ArrayList();
ArrayList subcontrollers_client = new ArrayList();
ArrayList subcontrollers_server = new ArrayList();
ArrayList subcontrollers_nout = new ArrayList();
ArrayList subcontrollers_nin = new ArrayList();

//
// Shared stuff
//
//Object shared_vars_LOCK = new Object();
UnqueuedMutex shared_vars_MUTEX = new UnqueuedMutex();
ArrayList shared_vars = new ArrayList();
HashMap shared_vars_map = new HashMap();

Object shared_sems_LOCK = new Object();
ArrayList shared_sems = new ArrayList();
HashMap shared_sems_map = new HashMap();

Object shared_hashmaps_LOCK = new Object();
ArrayList shared_hashmaps = new ArrayList();
HashMap shared_hashmaps_map = new HashMap();

//if one of these dies then the controller shuts down
//at the moment, only non-client threads are critical

CriticalThreadGroup clienttg = new CriticalThreadGroup();

CriticalThreadGroup ctg = new CriticalThreadGroup();
NonCriticalThreadGroup nctg = new NonCriticalThreadGroup();

Object runner_directory_LOCK = new Object();
HashMap runner_directory = new HashMap();

Object conversation_directory_LOCK = new Object();
HashMap conversation_directory = new HashMap();

SessionAddress actual_address;

String client_host;

Message subcontroller_dependencies;

String base_jar_path;

private static boolean redirected = false;

	private static void redirectStdout() {
		redirected = true;
		System.setOut(System.err);
	}

	private static void restoreStdout() {
		restoreStdout(null);
	}
	private static void restoreStdout(String s) {
		if (redirected) {
			redirected = false;
			PrintStream pout = new PrintStream(new BufferedOutputStream(new FileOutputStream(FileDescriptor.out),128));
			pout.println(s);
			System.setOut(pout);
		}
	}

	public static void main(String[] args) {
		redirectStdout();
		
		if (Switches.CONSTANT_GARBAGE_COLLECTION) {
			GCThread.startThread();
		}	

//		int start_port;
		SessionAddress address;
		Message dependencies;
		int id;
		String classpath;
	
		if (args.length < 1) {
			restoreStdout();
			System.out.println("Too few arguments");
			return;	
		}
		
		try {
			id = Integer.parseInt(args[0]);			
		} catch (Throwable e) {
			restoreStdout();
			System.out.println("Invalid id");
			return;
		}

		BufferedReader bread = new BufferedReader(new InputStreamReader(System.in));

		try {
			String req_address = HexData.hexStringToString(bread.readLine().trim());
			
			address = SessionAddress.fromString(req_address);
			
//			start_port = Integer.parseInt(args[0]);			
//			address = SessionAddress.fromString(HexData.hexStringToString(args[0]));
		} catch (Throwable e) {
			restoreStdout();
			System.out.println("Invalid session address");
			return;
		}

		try {
			byte[] req_deps = HexData.hexStringToByteArray(bread.readLine().trim());
			
			dependencies = MessageUtils.bytesToMessage(req_deps);
			
		} catch (Throwable e) {
			restoreStdout();
			System.out.println("Invalid depedencies message");
			return;
		}

		try {
			classpath = bread.readLine().trim();
		} catch (Throwable e) {
			restoreStdout();
			System.out.println("Invalid depedencies message");
			return;
		}
		
		try {
//			Controller con = new Controller(start_port,id);
			Controller con = new Controller(address,id,dependencies,classpath);
		} catch (Throwable e) {
			restoreStdout();
			System.out.println("Controller create failed: "+Logger.getOneLineStackTrace(e));
			e.printStackTrace();
		}
	}


//	public Controller(int start_port, int id) throws Exception {
	public Controller(SessionAddress session_address, int id, Message subc_deps, String classpath) throws Exception {
//		this.port = start_port;
		this.id = id;
		this.subcontroller_dependencies = subc_deps;
		this.base_jar_path = classpath;
		
//		while (port < 65536) {
		
			try {
//				session_address = new SessionAddress("localhost",start_port,start_port,"localhost",start_port,SessionAddress.TRANSPORT_PORT_ANY);
				session = SessionFactory.newSession(session_address,false);
				
				session.beginNonBlocking();
				session.waitUntilSessionTransportBound();
				
				actual_address = session.getActualAddress();
//				actual_address.setRequiresMultipleConnections(true);
				
				//make sure this is the first message on stdout
				restoreStdout(HexData.stringToHexString(SessionAddress.toString(actual_address)));
				System.out.flush();
//				this.port = session.getActualAddress().listener_port_min;
				
//				server = new ServerSocket(port);
//				System.out.println(port);
				
				start();
				
//				break;
			} catch (IOException e) {
				throw new Exception("No free ports!");
//				if (port == 65535) throw new Exception("No free ports!");
//				port++;
			}
//		}

		System.gc();
	} 
	
	public SessionAddress getAddress() {
		return actual_address;
	}
	
//	public int getPort() {
//		return port;	
//	}

	public void run() {
		Thread th = Thread.currentThread();
		th.setName("JEngine Controller [Daemon Server Init] Thread (ID: "+id+") ("+actual_address+")");

//we dont support multiple clients
//		while (true) {

		try {

			session.waitUntilSessionTransportReady();
			
			client_host = session.getActualAddress().getInitiatorHost();
			
			Logger.direct("new Controller (version "+Version.getVersionAsString()+") on "+session.getActualAddress());

			short c_client = 0;
			short c_server = 1;
			short c_notify = 2;

			MultiplexerInputStream mxin = new MultiplexerInputStream(session.getInputStream(Session.DEFAULT_STREAM_INDEX));
			MultiplexerOutputStream mxout = new MultiplexerOutputStream(session.getOutputStream(Session.DEFAULT_STREAM_INDEX));
			
			MTTransactionClient cclient = TransactionFactory.getTransactionClient(mxin.getInputStream(c_client),mxout.getOutputStream(c_client),clienttg,"JEngine Controller [Client Client] Thread (ID: "+id+") ("+actual_address+")");
			MTTransactionServer cserver = TransactionFactory.getTransactionServer(mxin.getInputStream(c_server),mxout.getOutputStream(c_server),this,clienttg,"JEngine Controller [Client Server] Thread (ID: "+id+") ("+actual_address+")");

			MessageReader creader = new MessageReader(mxin.getInputStream(c_notify),clienttg,"JEngine Controller [Client Notify Server] Thread (ID: "+id+") ("+actual_address+")");			
			MTMessageWriter cwriter = new MTMessageWriter(mxout.getOutputStream(c_notify));

			//send the ID of the subcontroller
			cwriter.write(new Message(subcontrollers_client.size()));

				synchronized(LOCK_CLIENTS) {
					clients_client.add(cclient);
					clients_server.add(cserver);
					clients_nout.add(cwriter);
					clients_nin.add(creader);
				}

				subcontrollers_client.add(cclient);
				subcontrollers_server.add(cserver);
				subcontrollers_nout.add(cwriter);
				subcontrollers_nin.add(creader);

			Reader cthread = new Reader(creader,new NonCriticalThreadGroup(),"JEngine Controller [Client Notify Server] Thread (ID: "+id+") ("+actual_address+")");
//			cthread.setDaemon(true);
			cthread.start();
			
//			we dont support multiple clients
//			session = SessionFactory.newSession(actual_address,false);
//			session.begin();
			
		} catch (Throwable t) {
			Logger.error("controller reader thread died",t);
		}
		
//		we dont support multiple clients
//		}
	}
	
	private void setHeadless(boolean headless) throws Exception {
		clienttg.setExitOnException(!headless);
	}
	
	private void setLogLevel(boolean error, boolean warning, boolean info) throws Exception {
		Logger.PRINT_ERROR = error;
		Logger.PRINT_WARNING = warning;
		Logger.PRINT_INFO = info;
		
		for (int i = 0; i < subcontrollers_client.size(); i++) {
			MTTransactionClient tc = (MTTransactionClient)subcontrollers_client.get(i);
			
			Message m = new Message(SubController.SUBCONTROLLER_SET_LOG_LEVEL);
			if (error) {
				m.append(1);
			} else {
				m.append(0);
			}
			if (warning) {
				m.append(1);
			} else {
				m.append(0);
			}
			if (info) {
				m.append(1);
			} else {
				m.append(0);
			}
			
			m = tc.doTransaction(m);

			if (m.getType() != SubController.SUBCONTROLLER_SET_LOG_LEVEL_OK) {
				throw new Exception("SubController set log level failed "+m);			
			}  
		}
		
	}
	
	private void print(String s) {
		if (!PRINT_INFO) return;
		
		Message m = new Message(Controller.CONTROLLER_PRINT);
		m.append(s);
		synchronized(LOCK_CLIENTS) {
			for (int i = 0; i < clients_nout.size(); i++) { 
				try {
					MTMessageWriter cwriter = (MTMessageWriter)clients_nout.get(i);
					cwriter.write(m);
				} catch (Exception e) {}
			}
		}

	}
	
	public static Message checkDependenciesCache(Message check) {
		Message ret = new Message(check.getType());
		
		//TODO check the length of each file in the cache against its real length to ensure it is not broken?
		//or just have people delete the cache when necessary?
		
		File f = new File(DEPS_CACHE_DIR);
		
		if (!f.exists()) {
			f.mkdirs();
		}
		
		long tnow = System.currentTimeMillis();
		
		File[] allFiles = f.listFiles();
		for (int i = 0; i < check.length(); i++) {
			String s = (String)check.get(i);
			boolean cached = false;
			for (int k = 0; k < allFiles.length; k++) {
				if (s.equals(allFiles[k].getName())) {
					//match
					cached = true;
					
					//mark this as used in the cache
					allFiles[k].setLastModified(System.currentTimeMillis());
				}
			}
			if (!cached) {
				ret.append((String)null);
			} else {
				ret.append(s);
			}
		}
		
		//do some cache cleanup
		long tot = 0;
		
		for (int i = 0; i < allFiles.length; i++) {
			tot += allFiles[i].length();
		}
		
		if (tot > CACHE_LIMIT_MEGS * 1024000) {
			//more than 100 megs in the cache, delete the oldest ones that weren't used this time round
		
			Arrays.sort(allFiles,new FileAgeComparator());
			
			for (int i = 0; i < allFiles.length; i++) {
				if (allFiles[i].lastModified()< tnow) {
					//not used this time around (in which case we MUST keep it)
					tot -= allFiles[i].length();
					allFiles[i].delete();
				}
				if (tot < CACHE_LIMIT_MEGS * 1024000) {
					//below the cache limit, stop deleting
					break;
				}
			}
			
		}
		
		return ret;
	}
	
	static class FileAgeComparator implements Comparator {
		public int compare(Object o1, Object o2) {
			File f1 = (File)o1;
			File f2 = (File)o2;
			return (int)(f1.lastModified() - f2.lastModified());
		}
	}
	
	public static void storeNewJarsToCache(Message dependencies) throws Exception {
		File f = new File(DEPS_CACHE_DIR);
		if (!f.exists()) {
			f.mkdirs();
		}
		//Store each of the valid JARs into the dependencies cache
		for (int i = 0; i < dependencies.length(); i++) {
			if (dependencies.getType(i) == Message.TYPE_SUBMESSAGE) {
				JARDependency dep = JARDependency.fromMessage((Message)dependencies.get(i));
				String cachekey = dep.getCacheKey();
				File temp = new File(DEPS_CACHE_DIR+"/temp."+System.currentTimeMillis()+"."+cachekey+".temp");
				File dest = new File(DEPS_CACHE_DIR+"/"+cachekey);
				
				FileOutputStream fout = new FileOutputStream(temp);
				fout.write(dep.getJarData());
				fout.close();
				
				temp.renameTo(dest);
			}
		}
	}

	private void setProgram(byte[] programb, Message dependencies) throws Exception {
		this.programb = programb;
		this.jar_dependencies = dependencies;

		storeNewJarsToCache(dependencies);
	
		this.program = Program.readProgram(programb);

		if (program.getPrintStdouterr()) {
			Logger.direct("Redirecting stdout to engine messaging");
			
			System.setOut(new PrintStream(new LineBasedPrintStream() {
				public void doSomethingWith(String s) {
					try {
						print(s);
					} catch (Exception e) {
						Logger.warning(s);
					}
				}
			}));
			
			System.setErr(new PrintStream(new LineBasedPrintStream() {
				public void doSomethingWith(String s) {
					try {
						print(s);
					} catch (Exception e) {
						Logger.warning(s);
					}
				}
			}));
		}
		PRINT_INFO = program.getPrintInfo();
		PRINT_DEBUG = program.getPrintDebug();
		
		
		//
		// Connect to all subcontrollers
		//
		ArrayList addresses = program.getAddresses();
		ArrayList daemonaddresses = program.getDaemonAddresses();
		
		addresses.add(0,new SessionAddress("CLIENT_MACHINE",0,0,"CLIENT_MACHINE",0,0));
		daemonaddresses.add(0,new SessionAddress("CLIENT_MACHINE",0,0,"CLIENT_MACHINE",0,0));
		int cid = 0;

		if (addresses.size() < 1) throw new IOException("no hosts specified");
		hosts_map = new HashMap();
		
		for (int i = 1; i < addresses.size(); i++) {
			cid++;
			
			SessionAddress address = (SessionAddress)addresses.get(i);
			SessionAddress daemonaddress = (SessionAddress)daemonaddresses.get(i);
			
			subcontrollers_hosts.add(address.getListenerHost());

			hosts_map.put(address.getListenerHost(),new Integer(cid));
			
			Logger.info("CONTROLLER: Creating SubController at "+address);

//			SoapDaemonConnector daemon_connector = new SoapDaemonConnector((SessionAddress)address.clone());
			SoapDaemonConnector daemon_connector = new SoapDaemonConnector((SessionAddress)daemonaddress.clone());
			
			if (!daemon_connector.supportsVersion(Version.getVersion())) {
				//update the remote daemon

				traceDebug("Updating daemon on "+address.getListenerHost()+" (this may take a while)");
				
				FileInputStream fin = new FileInputStream(base_jar_path);
				daemon_connector.addVersion(Version.getVersion(),FileUtil.readFileBinary(fin));
				fin.close();
			}
			
			JARDependency[] subcontroller_deps = new JARDependency[subcontroller_dependencies.length()];
			for (int k = 0; k < subcontroller_deps.length; k++) {
				subcontroller_deps[k] = JARDependency.fromMessage((Message)subcontroller_dependencies.get(k));
			}
			
			SessionAddress subcontroller_address = daemon_connector.newSubController(cid,subcontroller_deps,address);
			
			/*
			
			SessionAddress daemon_address = (SessionAddress)address.clone();
			daemon_address.setTransportProviderClassName(TCPIPTransportProvider.class.getName());
			daemon_address.setRequiresEncryption(false);
			daemon_address.setRequiresLinkReconnection(false);
			daemon_address.setRequiresMultipleStreams(false);
			
			Session daemon_session = SessionFactory.newSession(daemon_address,true);
			daemon_session.begin();

			MTTransactionClient daemonclient = DaemonFactory.getTransactionClient(daemon_session.getInputStream(Session.DEFAULT_STREAM_INDEX),daemon_session.getOutputStream(Session.DEFAULT_STREAM_INDEX),nctg,"JEngine Controller [Daemon Reader] Thread (ID: "+id+") ("+daemon_address+")");
			
			
			//
			// Check to see if the daemon supports this version
			//
			Message m = new Message(Daemon.DAEMON_SUPPORTS_VERSION);
			m.append(Version.getVersion());
			
			m = daemonclient.doTransaction(m);
			
			if (m.getType() == Daemon.DAEMON_SUPPORTS_VERSION_YES) {
				//splendid
			} else if (m.getType() == Daemon.DAEMON_SUPPORTS_VERSION_NO) {
				//need to add our version to this daemon
				
				Logger.info("CONTROLLER: Daemon does not support this version ("+Version.getVersionAsString()+") - updating Daemon now (this may take a while)");
				
				FileInputStream fin = new FileInputStream(base_jar_path);
				
				m = new Message(Daemon.DAEMON_ADD_VERSION);
				m.append(Version.getVersion());
				m.append(FileUtil.readFileBinary(fin));
				
				fin.close();
				
				m = daemonclient.doTransaction(m);
				
				if (m.getType() != Daemon.DAEMON_ADD_VERSION_OK) {
					throw new Exception("Controller add Daemon version failed "+m);
				}
				
				Logger.info("CONTROLLER: Daemon updated OK");
				
			} else {
				throw new Exception("Controller Daemon version support check failed "+m);
			}
			
			
			m = new Message(Daemon.DAEMON_CREATE_SUBCONTROLLER);
			m.append(cid);
			m.append(SessionAddress.toString(address));
//			m.append(host);
			m.append(subcontroller_dependencies);
			m.append(Version.getVersion());

			
			m = daemonclient.doTransaction(m);
			
//			MessageReader min = new MessageReader(s.getInputStream(),ctg,"JEngine Controller [Daemon Reader] Thread (ID: "+id+") (PORT: "+port+") (SUBHOST: "+host+")");
//			MessageWriter mout = new MessageWriter(s.getOutputStream());
			
//			mout.write(m);
			
//			m = min.read();
			
			int type = m.getType();
			*/
/*			if (type == Daemon.DAEMON_CREATE_SUBCONTROLLER_OK) {
				SessionAddress subcontroller_address = SessionAddress.fromString((String)m.get(0));
				*/
//				Integer scport = (Integer)m.get(0);
//				int subport = scport.intValue();

				//close the session to the Daemon
/*				daemon_session.end();*/
//				s.close();

				Logger.info("CONTROLLER: Created OK, connecting to SubController");
				
//				SessionAddress subcontroller_address = new SessionAddress("localhost",SessionAddress.TRANSPORT_PORT_ANY,SessionAddress.TRANSPORT_PORT_ANY,host,scport.intValue(),scport.intValue());
				Session subcontroller_session = SessionFactory.newSession(subcontroller_address,true);
				subcontroller_session.begin();
				
//				Socket  sock = SocketSetup.getSocket(SubController.SUBCONTROLLER_SOCKET_IDS,host,scport.intValue());
				short client = 0;
				short server = 1;
				short notifications = 2;

//				MultiplexerInputStream mxin = new MultiplexerInputStream(sock.getInputStream());
//				MultiplexerOutputStream mxout = new MultiplexerOutputStream(sock.getOutputStream());
				MultiplexerInputStream mxin = new MultiplexerInputStream(subcontroller_session.getInputStream(Session.DEFAULT_STREAM_INDEX));
				MultiplexerOutputStream mxout = new MultiplexerOutputStream(subcontroller_session.getOutputStream(Session.DEFAULT_STREAM_INDEX));
				
//				// we dont want Nagle's algorithm slowing down our transactions here
//				sock.setTcpNoDelay(true);
				
				MTTransactionClient tc = TransactionFactory.getTransactionClient(mxin.getInputStream(client),mxout.getOutputStream(client),ctg,"JEngine Controller [SubController Client Reader] Thread (ID: "+id+") ("+subcontroller_address+")");
				MTTransactionServer ts = TransactionFactory.getTransactionServer(mxin.getInputStream(server),mxout.getOutputStream(server),this,ctg,"JEngine Controller [SubController Server] Thread (ID: "+id+") ("+subcontroller_address+")");
				
				MessageWriter nout = new MessageWriter(mxout.getOutputStream(notifications));
				MessageReader nin = new MessageReader(mxin.getInputStream(notifications),ctg,"JEngine Controller [SubController Notify Reader] Thread (ID: "+id+") ("+subcontroller_address+")");

				Reader scthread = new Reader(nin,ctg,"JEngine Controller [SubController Notify Reader] Thread (ID: "+id+") ("+subcontroller_address+")");
//				scthread.setDaemon(true);
				scthread.start();

				subcontrollers_client.add(tc);
				subcontrollers_server.add(ts);
				subcontrollers_nout.add(nout);
				subcontrollers_nin.add(nin);
				/*
			} else {
				throw new IOException("Daemon failed to create subcontroller ("+m+")");	
			} */
			
		}
	
		//
		// Send them the program
		//
		for (int i = 1; i < subcontrollers_client.size(); i++) {
//			int sub_id = i+1;
			
			MTTransactionClient tc = (MTTransactionClient)subcontrollers_client.get(i);

			Logger.info("CONTROLLER: Setting client host ("+client_host+") on SubController");
			//
			// Tell the subcontroller what the client's IP is
			//
			Message m = new Message(SubController.SUBCONTROLLER_SET_CLIENTHOST);
			m.append(client_host);
			
			m = tc.doTransaction(m);
			
			if (m.getType() != SubController.SUBCONTROLLER_SET_CLIENTHOST_OK) {
				throw new IOException("SubController set client host failed "+m);					
			}
			
			//
			// Check the dependencies in the subcontroller
			//
			m = new Message(SubController.SUBCONTROLLER_CHECK_DEPS_CACHE);
			for (int k = 0; k < dependencies.length(); k++) {
				if (dependencies.getType(k) == Message.TYPE_SUBMESSAGE) {
					JARDependency dep = JARDependency.fromMessage((Message)dependencies.get(k));
					m.append(dep.getCacheKey());
				} else {
					m.append((String)dependencies.get(k));
				}
			}
			m = tc.doTransaction(m);
			if (m.getType() != SubController.SUBCONTROLLER_CHECK_DEPS_CACHE_OK) {
				throw new IOException("SubController check dependencies cache failed "+m);
			}
			
			Message sub_dependencies = new Message();
			for (int k = 0; k < m.length(); k++) {
				String key = (String)m.get(k);
				if (key == null) {
					//subcontroller needs this JAR
					if (jar_dependencies.getType(k) == Message.TYPE_SUBMESSAGE) {
						//we needed it too - pass it on
						sub_dependencies.append((Message)jar_dependencies.get(k));
						Logger.direct("Controller Dependency "+k+" of "+m.length()+" - actual JAR");
					} else {
						//we already had it in our cache - pass it on
						key = (String)jar_dependencies.get(k);
						String path = DEPS_CACHE_DIR+"/"+key;
						
						byte[] dat;
						FileInputStream fin = new FileInputStream(path);
						dat = StreamUtils.readAll(fin);
						fin.close();
						JARDependency jd = new JARDependency(dat,path);
						
						sub_dependencies.append(JARDependency.toMessage(jd));
						Logger.direct("Controller Dependency "+k+" of "+m.length()+" - actual JAR (cached)");
					}
				} else {
					sub_dependencies.append(key);
					Logger.direct("Controller Dependency "+k+" of "+m.length()+" - cache key "+key+" ("+new File(DEPS_CACHE_DIR+"/"+key).exists()+")");
				}
			}
			
			Logger.info("CONTROLLER: Sending program to SubController");
			//
			// Pass the program to the subcontroller
			//
			m = new Message(SubController.SUBCONTROLLER_SET_PROGRAM);
			m.append(programb);	
//			m.append(jar_dependencies);
			m.append(sub_dependencies);

			m = tc.doTransaction(m);
			
			int type = m.getType();
			
			if (type != SubController.SUBCONTROLLER_SET_PROGRAM_OK) {
				throw new IOException("SubController set program failed "+m);					
			}
		}
	}
	
	private void launchProgram() throws IOException {
		MTTransactionClient tc = (MTTransactionClient)subcontrollers_client.get(1);
		
		Message m = new Message(SubController.SUBCONTROLLER_LAUNCH_RUNNER);
		m.append(1);
		m.append("engine_main");

		m = tc.doTransaction(m);

		if (m.getType() != SubController.SUBCONTROLLER_LAUNCH_RUNNER_OK) {
			throw new IOException("Error launching program "+m);
		}
	}

	private Message launchRunner(int host, Integer count, String method, Message args) throws IOException {
//	private Message launchRunner(int host, Integer count, String method, ArrayList args) throws IOException {
		MTTransactionClient tc = (MTTransactionClient)subcontrollers_client.get(host);

		Message m = new Message(SubController.SUBCONTROLLER_LAUNCH_RUNNER);
		m.append(count);
		m.append(method);
	
		m.append(args);
//		for (int i = 0; i < args.size(); i++) {
//			m.append((String)args.get(i));	
//		}

		m = tc.doTransaction(m);
		
		if (m.getType() != SubController.SUBCONTROLLER_LAUNCH_RUNNER_OK) {
			throw new IOException("Error launching program "+m);
		}
		
		Message ids = (Message)m.get(0);

		synchronized(runner_directory_LOCK) {
			for (int i = 0; i < ids.length(); i++) {
				
				Long id = (Long)ids.get(i);
				
				if (runner_directory.get(id) == null) {
					//runner has not died while we were launching, so mark it as alive now
					runner_directory.put(id,new RunnerWait());
				} else {
					//runner died while we were launching, so mark it as dead now and notify anything
					//that was waiting on it
					RunnerWait rwait = (RunnerWait)runner_directory.remove(id);
					
					if (rwait.waiting_runner != RunnerWait.NONE) {
						wakeRunner(rwait.waiting_runner);
					}	
				}
			} 	
		}

		
		return ids;
	}
	
	void signalRunner(long rid) throws IOException {
		int c_index = ID.CONTROLLER_INDEX(rid);
		
		MTTransactionClient tc = (MTTransactionClient)subcontrollers_client.get(c_index);
		
		Message m = new Message(SubController.SUBCONTROLLER_SIGNAL_RUNNER);
		m.append(rid);

		m = tc.doTransaction(m);
		
		if (m.getType() != SubController.SUBCONTROLLER_SIGNAL_RUNNER_OK) {
			throw new IOException("Error signalling runner "+m);
		}
	}

	/**
	 * HIGH PRIORITY TRANSACTIONS (likely to occur frequently)
	 * @param m the incoming message
	 * @param type the type of the incoming message
	 * @return the response message
	 */
	public Message doTransactionHighPriority(Message m, int type) throws Throwable {
		Message r;
		
		if (type == CONTROLLER_FETCH_VARIABLE) {
		  Logger.info("CONTROLLER: Fetch Variable "+m);
		  Integer hid = (Integer)m.get(0);
		  Integer vid = (Integer)m.get(1);
		  Integer vtypeo = (Integer)m.get(2);
		  int vtype = vtypeo.intValue();

		  Variable v = null;
//		  synchronized(shared_vars_LOCK) {
		  shared_vars_MUTEX.lock();
		  	try {
		  		v = (Variable) shared_vars.get(vid.intValue()-1);
				shared_vars_MUTEX.release();
	  		} catch (Throwable e) { 
	  			shared_vars_MUTEX.release();
	  			throw e;
	  		}
//		  }

		  synchronized(v.LOCK) {		  
	  
			  try {
				  if (vtype != v.getType()) {
					  r = new Message(CONTROLLER_FETCH_VARIABLE_FAIL);
				  } else {
					  try {
						  r = new Message(CONTROLLER_FETCH_VARIABLE_OK);
						  r.append(vtype);
						  Object newval = v.getValue();
						  if (newval == null) throw new NullPointerException("variable value is null");
		
						  switch (vtype) {
							  case SharedVariable.INTEGER:
								  r.append((Integer)newval);
								  break;
							  case SharedVariable.STRING:
								  r.append((String)newval);
								  break;
							  case SharedVariable.BYTES:
								  r.append((byte[])newval);
								  break;
							  case SharedVariable.MESSAGE:
								  r.append((Message)newval);
	  							  break;
							  case SharedVariable.LONG:
								  r.append((Long)newval);
								  break;
							  case SharedVariable.DOUBLE:
							  	  r.append((Double)newval);
		//						  long l = Double.doubleToRawLongBits(((Double)newval).doubleValue());
		//						  r.append(l);
								  break;
							  case SharedVariable.FLOAT:
								  r.append(new Double(((Float)newval).doubleValue()));
		//						  int n = Float.floatToRawIntBits(((Float)newval).floatValue());
		//						  r.append(n);
								  break;
							  default:
								  throw new ClassCastException("No recognised type");
						  }
							
						  if (v.getDirtyType()) {
							  boolean[] hosts = v.getDirtyHosts();
							  //host is clean
		//					  hosts[hid.intValue()-1] = false;							
							  hosts[hid.intValue()] = false;							
						  }
							
					  } catch (ClassCastException e) {
						  r = new Message(CONTROLLER_FETCH_VARIABLE_FAIL);
						  r.append(Logger.getStackTrace(e));
					  }
				  }
				} catch (NullPointerException e) {
					r = new Message(CONTROLLER_FETCH_VARIABLE_FAIL);
					r.append(Logger.getStackTrace(e));
				}
			}//end sync		

	  } else if (type == CONTROLLER_MESSAGE_SEND_AND_RECEIVE) {
	  		Logger.info("CONTROLLER: Send And Receive Message "+m);
			String conversation = (String)m.get(0);
			Message msgdata = (Message)m.get(1);
			
			Long waiter_id = (Long)m.get(2);
			Message conversationReturns = (Message)m.get(3);

//Logger.direct("CONTROLLER: Message Publish and Consume (send+receive) "+conversation+" "+msgdata+" "+conversationReturn);

			Message extras = new Message();
			
			long wakeup_id = 0;
			Message wakeup_data = null;
			
			ConversationWait rwait, rwaitReturn;
			synchronized(conversation_directory_LOCK) {
				
				//
				// Message Send
				//
				
				//send lock
				rwait = (ConversationWait)conversation_directory.get(conversation); 
				if (rwait == null) {
					rwait = new ConversationWait();
					conversation_directory.put(conversation,rwait);
				}

				if (rwait.waiting_runners.isEmpty()) {
					//nobody waiting for a message on this conversation
					//add our message to the "available messages" stack
					rwait.available_messages.addLast(msgdata);
//Logger.direct("CONTROLLER: sendAndReceive - added to the available messages stack");
					
				} else {
					//someone is waiting for a message, send it to them
					
//NOTE: we DO NOT remove here - we remove based on the list of conversations later on
//if we remove here and assume we can therefore check and skip it later on then our assumption
//breaks down if the runner is listening on one conversation more than once
//
//NOTE: We lose basically nothing in doing what appears to be a linear search of the conversation for
//the ConversationMember because it is guaranteed to be at the front anyway
//
//					ConversationMember member = (ConversationMember)rwait.waiting_runners.removeFirst();
					ConversationMember member = (ConversationMember)rwait.waiting_runners.getFirst();

					if (member.conversations.length() > 1) {
						//listening on multiple conversations - append the conversation
						msgdata.append(conversation);
					}
					
					Long waiting_runner = member.id;
//					Long waiting_runner = (Long)rwait.waiting_runners.removeFirst();
					
//Logger.direct("CONTROLLER: sendAndReceive - found a waiting runner");
					
					if (ID.CONTROLLER_ID(waiting_runner.longValue()) == ID.CONTROLLER_ID(waiter_id.longValue())) {
						//need to wake a runner on the same controller, so piggy back their wake up call
						//on the end of our reply message
//Logger.direct("CONTROLLER: sendAndReceive - piggyBacking a RECEIVE message");
						extras = new Message(SubController.SUBCONTROLLER_RECEIVE_MESSAGE);
						extras.append(waiting_runner.longValue());
						extras.append(msgdata);

					} else {
//Logger.direct("CONTROLLER: sendAndReceive - just doing a straight send");
						//send them the message
						wakeup_id = waiting_runner.longValue();
						wakeup_data = msgdata;
//						try {
//							notifyMessageConsumer(waiting_runner.longValue(),msgdata);
//						} catch (Exception e) {
//							Logger.error("Error notifying message consumer in sendAndReceive ",e);
//						}
					}
					
					//remove it from the (other) conversations it was listening on
					ArrayList obsolete_conversations = member.conversation_waits;
					for (int i = 0; i < obsolete_conversations.size(); i++) {
						ConversationWait cwait = (ConversationWait)obsolete_conversations.get(i);
						cwait.waiting_runners.remove(member);
					}
					
					
					if (Switches.MESSAGING_CONVERSATION_CLEANUP) {
						if (rwait.available_messages.isEmpty() && rwait.waiting_runners.isEmpty()) {
//Logger.direct("CONTROLLER: sendAndReceive - conversation over - removing it");
							//looks like this conversation could be over
							//might not be but if we dont clear up we will leak memory
							conversation_directory.remove(conversation);
						}
					}
				}
			}//end sync

			if (wakeup_data != null) {
				try {
					notifyMessageConsumer(wakeup_id,wakeup_data);
				} catch (Exception e) {
					Logger.error("Error notifying message consumer in sendAndReceive ",e);
				}
			}

			
			synchronized(conversation_directory_LOCK) {

				//
				// Message Receive
				// 
				
				boolean mustWait = true;
				
				r = null;
				
				for (int i = 0; i < conversationReturns.length(); i++) {
					//check this conversation for an existing message
					String conversationReturn = (String)conversationReturns.get(i);
					
					//get the conversation
					rwaitReturn = (ConversationWait)conversation_directory.get(conversationReturn);
					
					if (rwaitReturn != null) {
						if (!rwaitReturn.available_messages.isEmpty()) {
							//message available, pop the message off the stack and return it
							r = new Message(CONTROLLER_MESSAGE_SEND_AND_RECEIVE_OK);
							
							//pop the next message off this conversation and return it
							Message ret = (Message)rwaitReturn.available_messages.removeFirst();
							
							if (conversationReturns.length() > 1) {
								//listening on multiple conversations - append the conversation
								ret.append(conversationReturn);
							}
							
							//pop the next message off this conversation and return it
							r.append(ret);
							
							//exit this loop
							mustWait = false;
							break;
						}
					}
				}
				
				if (mustWait) {
					ConversationMember member = new ConversationMember(waiter_id,conversationReturns);
					
					//no message available yet, we will notify when it becomes available
					r = new Message(CONTROLLER_MESSAGE_SEND_AND_RECEIVE_WILL_NOTIFY);
					
					for (int i = 0; i < conversationReturns.length(); i++) {
						//wait on each conversation
						String conversation_id = (String)conversationReturns.get(i);
						
						//get the conversation
						rwaitReturn = (ConversationWait)conversation_directory.get(conversation_id);
						
						if (rwaitReturn == null) {
							//need to create a new conversation
							rwaitReturn = new ConversationWait();
							conversation_directory.put(conversation_id,rwaitReturn);
						}
						
						//add out id to the "waiting for messages" list
						rwaitReturn.waiting_runners.addLast(member);
						
						member.conversation_waits.add(rwaitReturn);
					}
				} else if (r == null) {
					r = new Message(Controller.CONTROLLER_MESSAGE_SEND_AND_RECEIVE_FAIL);
				}

				if (extras.length() > 0) {
					r.append(extras);
				}
			
			}//end sync
			
	  } else if (type == CONTROLLER_MESSAGE_CONSUME) {
			Logger.info("CONTROLLER: Receive Message "+m);
			Long waiter_id = (Long)m.get(0);
			Message conversations = (Message)m.get(1);
//			String conversation = (String)m.get(1);

//Logger.direct("CONTROLLER: Message Consume (receive) "+conversations);
			
			ConversationWait rwait;
			synchronized(conversation_directory_LOCK) {
				
				boolean mustWait = true;
				
				r = null;
				
				for (int i = 0; i < conversations.length(); i++) {
					//check this conversation for an existing message
					String conversation = (String)conversations.get(i);
					
					//get the conversation
					rwait = (ConversationWait)conversation_directory.get(conversation); 
					
					if (rwait != null) {
						if (!rwait.available_messages.isEmpty()) {
							//message available, pop the message off the stack and return it
							r = new Message(CONTROLLER_MESSAGE_CONSUME_OK);
						
							//pop the next message off this conversation and return it
							Message ret = (Message)rwait.available_messages.removeFirst();
							
							if (conversations.length() > 1) {
								//listening on multiple conversations - append the conversation
								ret.append(conversation);
							}
							
							r.append(ret);
							
							//exit this loop
							mustWait = false;
							break;
						}
					}
				}
				
				if (mustWait) {
					ConversationMember member = new ConversationMember(waiter_id,conversations);
					
					//no message available yet, we will notify when it becomes available
					r = new Message(CONTROLLER_MESSAGE_CONSUME_WILL_NOTIFY);
						
					for (int i = 0; i < conversations.length(); i++) {
						//wait on each conversation
						String conversation = (String)conversations.get(i);
						
						//get the conversation
						rwait = (ConversationWait)conversation_directory.get(conversation); 
						
						if (rwait == null) {
							//need to create a new conversation
							rwait = new ConversationWait();
							conversation_directory.put(conversation,rwait);
						}
						
						//add our id to the "waiting for messages" list
//						rwait.waiting_runners.addLast(waiter_id);
						rwait.waiting_runners.addLast(member);
						
						member.conversation_waits.add(rwait);
					}
				} else if (r == null) {
					r = new Message(Controller.CONTROLLER_MESSAGE_CONSUME_FAIL);
				}
				
			}//end sync

	  } else if (type == CONTROLLER_MESSAGE_PUBLISH) {
			Logger.info("CONTROLLER: Send Message "+m);
			String conversation = (String)m.get(0);
			Message msgdata = (Message)m.get(1);
			Long rid = (Long)m.get(2);

//Logger.direct("CONTROLLER: Message Publish (send) "+conversation+" "+msgdata);
			
			long wakeup_id = 0;
			Message wakeup_data = null;
			
			ConversationWait rwait;
			synchronized(conversation_directory_LOCK) {
				rwait = (ConversationWait)conversation_directory.get(conversation); 
				if (rwait == null) {
					rwait = new ConversationWait();
					conversation_directory.put(conversation,rwait);
				}

				if (rwait.waiting_runners.isEmpty()) {
					//nobody waiting for a message on this conversation
					//add our message to the "available messages" stack
					rwait.available_messages.addLast(msgdata);
					
					r = new Message(CONTROLLER_MESSAGE_PUBLISH_OK);
					
				} else {
					//someone is waiting for this message, send it to them

//NOTE: we DO NOT remove here - we remove based on the list of conversations later on
//if we remove here and assume we can therefore check and skip it later on then our assumption
//breaks down if the runner is listening on one conversation more than once
//
//NOTE: We lose basically nothing in doing what appears to be a linear search of the conversation for
//the ConversationMember because it is guaranteed to be at the front anyway
//
//					ConversationMember member = (ConversationMember)rwait.waiting_runners.removeFirst();
					ConversationMember member = (ConversationMember)rwait.waiting_runners.getFirst();
					
					if (member.conversations.length() > 1) {
						//listening on multiple conversations - append the conversation
						msgdata.append(conversation);
					}
					
					Long waiting_runner = member.id;
//					Long waiting_runner = (Long)rwait.waiting_runners.removeFirst();
					
					if (ID.CONTROLLER_ID(waiting_runner.longValue()) == ID.CONTROLLER_ID(rid.longValue())) {
						//sender is on same machine as receiver
						Message extras = new Message(SubController.SUBCONTROLLER_RECEIVE_MESSAGE);
						extras.append(waiting_runner);
						extras.append(msgdata);

						r = new Message(CONTROLLER_MESSAGE_PUBLISH_OK);
						r.append(extras);
						
					} else {
						//
						//send them the message
						
//						wakeup_id = waiting_runner.longValue();
//						wakeup_data = msgdata;
//						r = new Message(CONTROLLER_MESSAGE_PUBLISH_OK);
						
						try {
							notifyMessageConsumer(waiting_runner.longValue(),msgdata);
							r = new Message(CONTROLLER_MESSAGE_PUBLISH_OK);
						} catch (Exception e) {
							r = new Message(CONTROLLER_MESSAGE_PUBLISH_FAIL);
							r.append(Logger.getStackTrace(e));
						}
					}

					//remove it from the conversations it was listening on
					ArrayList obsolete_conversations = member.conversation_waits;
					for (int i = 0; i < obsolete_conversations.size(); i++) {
						ConversationWait cwait = (ConversationWait)obsolete_conversations.get(i);
						cwait.waiting_runners.remove(member);
					}

					if (Switches.MESSAGING_CONVERSATION_CLEANUP) {
						if (rwait.available_messages.isEmpty() && rwait.waiting_runners.isEmpty()) {
							//looks like this conversation could be over
							//might not be but if we dont clear up we will leak memory
							conversation_directory.remove(conversation);
						}
					}
				}
				
			}//end sync

			if (wakeup_data != null) {
				//
				// We need to notify a runner and send it a message
				// NOTE: we do this OUTSIDE of the synchronisation block, otherwise we're blocking on I/O
				// and doing nothing when another thread could be checking conversations etc
				//
				try {
					notifyMessageConsumer(wakeup_id,wakeup_data);
				} catch (Exception e) {
					r = new Message(CONTROLLER_MESSAGE_PUBLISH_FAIL);
					r.append(Logger.getStackTrace(e));
				}
			}
			
	  } else if (type == CONTROLLER_WAIT_SEMAPHORE) {
		  Logger.info("CONTROLLER: Wait Semaphore");

		  Integer sid = (Integer)m.get(0);
		  Integer waitcount = (Integer)m.get(1);
		  Long rid = (Long)m.get(2);

		  //sync not needed - shared_sems will only ever grow in size
		  Semaphore s = null;
		  synchronized(shared_sems_LOCK) {
		  	s = (Semaphore)shared_sems.get(sid.intValue()-1);
		  }

		  if (s.addWait(rid.longValue(),waitcount.intValue())) {
			  r = new Message(CONTROLLER_WAIT_SEMAPHORE_OK);	
		  } else {
			  r = new Message(CONTROLLER_WAIT_SEMAPHORE_WILL_NOTIFY);	
		  } 

	  } else if (type == CONTROLLER_SIGNAL_SEMAPHORE) {
		  Logger.info("CONTROLLER: Signal Semaphore");
		  Integer sid = (Integer)m.get(0);
		  Integer signalcount = (Integer)m.get(1);

		  Semaphore s = null;
		  synchronized(shared_sems_LOCK) {
		  	s = (Semaphore)shared_sems.get(sid.intValue()-1);
		  }

		  try {
			  s.addSignal(signalcount.intValue());
			  r = new Message(CONTROLLER_SIGNAL_SEMAPHORE_OK);	
		  } catch (Exception e) {
			  r = new Message(CONTROLLER_SIGNAL_SEMAPHORE_FAIL);
			  r.append(Logger.getStackTrace(e));	
		  }

	  } else if (type == CONTROLLER_RETRIEVE_HASHMAP) {
		  Logger.info("CONTROLLER: Retrieve (get) Hashmap");
		  Integer hid = (Integer)m.get(0);
		  String key = (String)m.get(1);

		  try {
		  	
		  	  //sync not needed - shared_hashmaps will only ever grow in size
			  DataMap map = null;
			  synchronized(shared_hashmaps_LOCK) {
			  	map = (DataMap)shared_hashmaps.get(hid.intValue()-1);
			  }
				
			  Object val = map.get(key);	

			  if (val == null) {
				  r = new Message(CONTROLLER_RETRIEVE_HASHMAP_NULL);
			  } else {
				  r = new Message(CONTROLLER_RETRIEVE_HASHMAP_OK);
				  if (val instanceof String) {
					  r.append((String)val);
				  } else if (val instanceof Integer) {
					  r.append((Integer)val);
				  } else if (val instanceof Long) {
					  r.append((Long)val);
				  } else if (val instanceof Double) {
					  r.append((Double)val);
				  } else if (val instanceof byte[]) {
					  r.append((byte[])val);
				  } else if (val instanceof Message) {
					  r.append((Message)val);
				  } else {
					  r = new Message(CONTROLLER_RETRIEVE_HASHMAP_FAIL);
					  r.append("stored value in hashmap is of unrecognised type");
				  }
			  }
				
		  } catch (Exception e) {
			  r = new Message(CONTROLLER_RETRIEVE_HASHMAP_FAIL);
			  r.append(Logger.getStackTrace(e));				
		  }

	  } else if (type == CONTROLLER_RETRIEVE_HASHMAP_KEYLIST) {
		  Logger.info("CONTROLLER: Retrieve Hashmap Key List");
		  Integer hid = (Integer)m.get(0);
	  	  
		  try {
		  	
			  ArrayList list;
			  
		  	  //sync not needed - shared_hashmaps will only ever grow in size
			  DataMap map = null;
			  synchronized(shared_hashmaps_LOCK) {
			  	map = (DataMap)shared_hashmaps.get(hid.intValue()-1);

				list = new ArrayList(map.keySet());
			  }
				
			  r = new Message(CONTROLLER_RETRIEVE_HASHMAP_KEYLIST_OK);
			  for (int i = 0; i < list.size(); i++) {
			  	r.append((String)list.get(i));
			  }
			  
		  } catch (Exception e) {
		  	r = new Message(CONTROLLER_RETRIEVE_HASHMAP_KEYLIST_FAIL);
		  	r.append(Logger.getStackTrace(e));
		  }
			  
		  
		  
	  } else if (type == CONTROLLER_PUT_HASHMAP) {
		  Logger.info("CONTROLLER: Put Hashmap");
		  Integer hid = (Integer)m.get(0);
		  String newkey = (String)m.get(1);
		  Object newval = m.get(2);
			
		  try {

			  DataMap map = null;
			  synchronized(shared_hashmaps_LOCK) {
			  	map = (DataMap)shared_hashmaps.get(hid.intValue()-1);
			  }
			  map.put(newkey,newval);
	
			  r = new Message(CONTROLLER_PUT_HASHMAP_OK);
		  } catch (Exception e) {
			  r = new Message(CONTROLLER_PUT_HASHMAP_FAIL);
			  r.append(Logger.getStackTrace(e));				
		  }
			
	  } else if (type == CONTROLLER_STORE_VARIABLE) {
		  Logger.info("CONTROLLER: Store Variable "+m);
		  Integer vid = (Integer)m.get(0);
		  Integer vtype = (Integer)m.get(1);
		  Object newval = m.get(2);

		  Variable v = null;
//		  synchronized(shared_vars_LOCK) { 
		  shared_vars_MUTEX.lock();
		  	try {
			  v = (Variable) shared_vars.get(vid.intValue()-1);
			  shared_vars_MUTEX.release();
	  		} catch (Throwable e) { 
	  			shared_vars_MUTEX.release();
	  			throw e;
	  		}
//		  }

		  synchronized(v.LOCK) {		  
	
			  if (vtype.intValue() != v.getType()) {
				  r = new Message(CONTROLLER_STORE_VARIABLE_FAIL);
				  r.append("variable type does not match given type");
			  } else {
					
				  try {
					  switch (vtype.intValue()) {
						  case SharedVariable.INTEGER:
							  v.setValue((Integer)newval);
							  break;
						  case SharedVariable.STRING:
							  v.setValue((String)newval);
							  break;
						  case SharedVariable.BYTES:
							  v.setValue((byte[])newval);
							  break;
						  case SharedVariable.MESSAGE:
							  v.setValue((Message)newval);
							  break;
						  case SharedVariable.LONG:
							  v.setValue((Long)newval);
							  break;
						  case SharedVariable.DOUBLE:
						  	  v.setValue((Double)newval);
	//						  long l = ((Long)newval).longValue();
	//						  v.setValue(new Double(Double.longBitsToDouble(l)));
							  break;
						  case SharedVariable.FLOAT:
						  	  v.setValue(new Float(((Double)newval).floatValue()));
	//						  int n = ((Integer)newval).intValue();
	//						  v.setValue(new Float(Float.intBitsToFloat(n)));
							  break;
						  default:
							  throw new ClassCastException("No recognised type");
					  }
						
					  r = new Message(CONTROLLER_STORE_VARIABLE_OK);
				  } catch (ClassCastException e) {
					  r = new Message(CONTROLLER_STORE_VARIABLE_FAIL);
					  r.append(Logger.getStackTrace(e));
				  }
					
				  try {
					  if (v.getDirtyType()) {
						  boolean[] hosts = v.getDirtyHosts();
	
						  Message n = new Message(SubController.SUBCONTROLLER_NOTIFY_DIRTY);
						  n.append(vid);
	
						  Message ret = null;
						  for (int i = 0; i < hosts.length; i++) {
							  //if host is not dirty
							  if (!hosts[i]) {
								  hosts[i] = true;
									
								  MTTransactionClient tc = (MTTransactionClient)subcontrollers_client.get(i);
								  
								  ret = tc.doTransaction(n);
								  
								  if (ret.getType() != SubController.SUBCONTROLLER_NOTIFY_DIRTY_OK) {
									  r = new Message(CONTROLLER_STORE_VARIABLE_FAIL);
									  r.append("failed to notify all subcontrollers");
									  break;
								  }
							  }
						  }
					  }
				  } catch (Exception e) {
					  r = new Message(CONTROLLER_STORE_VARIABLE_FAIL);
					  r.append("failed to notify all subcontrollers");
					  r.append(Logger.getStackTrace(e));
				  }
			  }
		  }		  
		  
		  Logger.info("CONTROLLER: End Of Store Variable");

		} else if (type == CONTROLLER_RUNNER_JOIN) {
			Logger.info("CONTROLLER: Join Runner");
			Long waiter_id = (Long)m.get(0);
			Long remote_id = (Long)m.get(1);
			
			synchronized(runner_directory_LOCK) {
				RunnerWait rwait = (RunnerWait)runner_directory.get(remote_id); 
				if (rwait == null) {
					//runner has already died
//					Debugger.info("CONTROLLER: Runner Join - runner already died");
					r = new Message(CONTROLLER_RUNNER_JOIN_OK);	
				} else {
					//runner is alive, controller will notify subcontroller when runner dies
//					Debugger.info("CONTROLLER: Runner Join - runner has not died yet");
					r = new Message(CONTROLLER_RUNNER_JOIN_WILL_NOTIFY);
//					Debugger.info("CONTROLLER: Runner "+waiter_id+" Joining with runner "+remote_id);
					rwait.waiting_runner = waiter_id.longValue();	
				}
			}

		} else if (type == CONTROLLER_CLEAR_HASHMAP) {
			Logger.info("CONTROLLER: Clear Hashmap");
			Integer hid = (Integer)m.get(0);

			try {
				DataMap map = null;
				synchronized(shared_hashmaps_LOCK) {
					map = (DataMap)shared_hashmaps.get(hid.intValue()-1);
				}
				map.clear();
				
				r = new Message(CONTROLLER_CLEAR_HASHMAP_OK);
			} catch (Exception e) {
				r = new Message(CONTROLLER_CLEAR_HASHMAP_FAIL);
				r.append(Logger.getStackTrace(e));
			}

		} else {
	
			r = new Message(CONTROLLER_UNRECOGNISED_MESSAGE);
	
		}
		return r;
	}

	/**
	 * MEDIUM PRIORITY TRANSACTIONS (possible to occur frequently)
	 * @param m the incoming message
	 * @param type the type of the incoming message
	 * @return the response message
	 */
	public Message doTransactionMediumPriority(Message m, int type) throws Throwable {
		Message r;

		if (type == CONTROLLER_LAUNCH_RUNNER) {
			Logger.info("CONTROLLER: Launch Runner");
			Integer count = (Integer)m.get(0);
			String method = (String)m.get(1);
			Integer host_index = (Integer)m.get(2);

			Message args = new Message();
			if (m.length() > 3) {
				args.appendAll((Message)m.get(3));
			}
//			ArrayList args = new ArrayList();
//			
//			for (int a = 3; a < m.length(); a++) {
//				args.add((String)m.get(a));	
//			}

			try {
//				Integer host_index = (Integer)hosts_map.get(host);

				Message launched = launchRunner(host_index.intValue() + 1, count, method, args);

				r = new Message(CONTROLLER_LAUNCH_RUNNER_OK);
				r.append(launched);
			} catch (NullPointerException e) {
				r = new Message(CONTROLLER_LAUNCH_RUNNER_FAIL);
				r.append("Did you remember to set the program + hosts before launching a runner?");			
				r.append(Logger.getStackTrace(e));
			} catch (Exception e) {
				r = new Message(CONTROLLER_LAUNCH_RUNNER_FAIL);			
				r.append(Logger.getStackTrace(e));
			}

		} else if (type == CONTROLLER_GET_VARIABLE) {
			Logger.info("CONTROLLER: Get Variable");
			String vname = (String)m.get(0);

			Variable v = null;
//			synchronized(shared_vars_LOCK) {
			shared_vars_MUTEX.lock();
			try {
				v =(Variable)shared_vars_map.get(vname);
				
		  		shared_vars_MUTEX.release();
		  		
		  		if (v != null) {
		  			v.MUTEX.lock();
		  			v.MUTEX.release();
		  		}
				
	  		} catch (Throwable e) { 
	  			shared_vars_MUTEX.release();
	  			throw e;
	  		}
//			}

			if (v == null) {
				r = new Message(CONTROLLER_GET_VARIABLE_FAIL);
				r.append("Variable "+vname+" not found");
			} else {
				r = new Message(CONTROLLER_GET_VARIABLE_OK);
				r.append(v.getID());
				r.append(v.getType());
			}

		} else if (type == CONTROLLER_GET_SEMAPHORE) {
			Logger.info("CONTROLLER: Get Semaphore");
			String name = (String)m.get(0);
		
			Semaphore s = null;
			synchronized(shared_sems_LOCK) {
				s = (Semaphore)shared_sems_map.get(name);
			}

			if (s == null) {
				r = new Message(CONTROLLER_GET_SEMAPHORE_FAIL);
				r.append("Semaphore "+name+" not found");
			} else {			
				r = new Message(CONTROLLER_GET_SEMAPHORE_OK);
				r.append(s.getID());
			}
		
		} else if (type == CONTROLLER_GET_HASHMAP) {
			Logger.info("CONTROLLER: Get HashMap");
			String name = (String)m.get(0);
		
			DataMap map = null;
			synchronized(shared_hashmaps_LOCK) {
				map = (DataMap)shared_hashmaps_map.get(name);
			}

			if (map == null) {
				r = new Message(CONTROLLER_GET_HASHMAP_FAIL);
				r.append("HashMap "+name+" not found");
			} else {			
				r = new Message(CONTROLLER_GET_HASHMAP_OK);
				r.append(map.getID());
			}

		} else {

			r = new Message(CONTROLLER_UNRECOGNISED_MESSAGE);

		}
		
		return r;
	}

	/**
	 * LOW PRIORITY TRANSACTIONS (unlikely/impossible to occur frequently)
	 * @param m the incoming message
	 * @param type the type of the incoming message
	 * @return the response message
	 */
	public Message doTransactionLowPriority(Message m, int type) throws Throwable {

		Message r;

			if (type == CONTROLLER_GET_HOSTS) {
				Logger.info("CONTROLLER: Get Hosts");
				
				r = new Message(CONTROLLER_GET_HOSTS_OK);

				r.append((int)subcontrollers_hosts.size());

				for (int h = 0; h < subcontrollers_hosts.size(); h++) {
					r.append((String)subcontrollers_hosts.get(h));	
				}

			} else if (type == CONTROLLER_GET_VARIABLE_LIST) {
				Logger.info("CONTROLLER: Get Variable List");
				
				r = new Message(CONTROLLER_GET_VARIABLE_LIST_OK);

				//no sync needed, shared_vars will only ever grow in size
				r.append((int)shared_vars.size());
	
//				synchronized(shared_vars_LOCK) {
	  			shared_vars_MUTEX.lock();
				try {
					for (int v = 0; v < shared_vars.size(); v++) {
						Variable var = (Variable)shared_vars.get(v);
						r.append(var.getName());
					}
			  		shared_vars_MUTEX.release();
			  		
		  		} catch (Throwable e) { 
		  			shared_vars_MUTEX.release();
		  			throw e;
		  		}

//				}

			} else if (type == CONTROLLER_LAUNCH_PROGRAM) {
				Logger.info("CONTROLLER: Launch Program");

				try {
					launchProgram();
					r = new Message(CONTROLLER_LAUNCH_PROGRAM_OK);
				} catch (Exception e) {
					r = new Message(CONTROLLER_LAUNCH_PROGRAM_FAIL);			
					r.append(Logger.getStackTrace(e));
				}

			} else if (type == CONTROLLER_MAKE_SEMAPHORE) {
				Logger.info("CONTROLLER: New Semaphore");
				String name = (String)m.get(0);
				Integer initial = (Integer)m.get(1);
			
	
				//synchronize round the whole thing to get atomic get or create
				synchronized(shared_sems_LOCK) {
					Semaphore s = null;		

					s = (Semaphore)shared_sems_map.get(name);
	
					if (s == null) {
						int sid = shared_sems.size()+1;
						s = new Semaphore(name,sid,initial.intValue(),this);
				
						shared_sems.add(s);
						shared_sems_map.put(name,s);
					
						r = new Message(CONTROLLER_MAKE_SEMAPHORE_OK);
						r.append(s.id);
					} else {
						
						r = new Message(CONTROLLER_MAKE_SEMAPHORE_EXISTS);
						r.append(s.id);
					}
				}//end sync

			} else if (type == CONTROLLER_MAKE_VARIABLE ||
						type == CONTROLLER_MAKE_DIRTY_VARIABLE) {
				
				boolean dirty = (type == CONTROLLER_MAKE_DIRTY_VARIABLE);
						
				Logger.info("CONTROLLER: New Variable");
				String vname = (String)m.get(0);
				Integer vtype = (Integer)m.get(1);

				try {
	
					//LOCK ALL VARIABLES
					shared_vars_MUTEX.lock();
					try {

						//see if it exists already
						Variable v = null;
						
						v =(Variable)shared_vars_map.get(vname);

						if (v == null) {
							//new variable

							int vid = shared_vars.size()+1;
	
							v = new Variable(vname, vid, vtype.intValue());
						
							if (dirty) {
								v.setDirtyType(true);
								boolean[] b = new boolean[subcontrollers_client.size()];
								Arrays.fill(b,true);
								v.setDirtyHosts(b);
							} else {
								v.setDirtyType(false);
							}
					
							shared_vars.add(v);
							shared_vars_map.put(vname,v);

							v.MUTEX.lock();
				  			shared_vars_MUTEX.release();
							
				  			try {
								boolean notified = true;
							
								Message n = new Message(SubController.SUBCONTROLLER_MAKE_VARIABLE);
								n.append(type);
								n.append(vname);
								n.append(vtype);
								n.append(v.id);
								
								for (int i = 0; i < subcontrollers_client.size(); i++) {
									MTTransactionClient tc = (MTTransactionClient)subcontrollers_client.get(i);
									Message ret = null;
			
									ret = tc.doTransaction(n);
			
									if (ret.getType() != SubController.SUBCONTROLLER_MAKE_VARIABLE_OK) {
										notified = false;	
									}
								}
		
								if (notified) {
									r = new Message(CONTROLLER_MAKE_VARIABLE_OK);
									r.append(v.id);
								} else {
									r = new Message(CONTROLLER_MAKE_VARIABLE_FAIL);
									r.append("could not notify all subcontrollers of the new variable");
								}
				  			} catch (Throwable t) {
								r = new Message(CONTROLLER_MAKE_VARIABLE_FAIL);
								r.append(Logger.getStackTrace(t));				
				  			}

							v.MUTEX.release();
							
						} else {

							r = new Message(CONTROLLER_MAKE_VARIABLE_EXISTS);
							r.append(v.id);

							shared_vars_MUTEX.release();

				  			v.MUTEX.lock();
							v.MUTEX.release();
						}
					
			  		} catch (Throwable e) { 
			  			shared_vars_MUTEX.release();
						r = new Message(CONTROLLER_MAKE_VARIABLE_FAIL);
						r.append(Logger.getStackTrace(e));				
			  		}
//					}//end sync
					
					/*
					//synchronization required for atomic get or create
					synchronized(shared_vars_LOCK) {
					//see if it exists already
					Variable v = null;
//					synchronized(shared_vars_LOCK) {
						v =(Variable)shared_vars_map.get(vname);
//					}//end sync

					if (v == null) {
						//new variable

//						synchronized(shared_vars_LOCK) {
							int vid = shared_vars.size()+1;
	
							v = new Variable(vname, vid, vtype.intValue());
						
							if (dirty) {
								v.setDirtyType(true);
								boolean[] b = new boolean[subcontrollers_client.size()];
								Arrays.fill(b,true);
								v.setDirtyHosts(b);
							} else {
								v.setDirtyType(false);
							}
					
							shared_vars.add(v);
							shared_vars_map.put(vname,v);
//						}//end sync

						boolean notified = true;
					
						Message n = new Message(SubController.SUBCONTROLLER_MAKE_VARIABLE);
						n.append(type);
						n.append(vname);
						n.append(vtype);
						n.append(v.id);
						for (int i = 0; i < subcontrollers_client.size(); i++) {
							MTTransactionClient tc = (MTTransactionClient)subcontrollers_client.get(i);
							Message ret = null;
	
							ret = tc.doTransaction(n);
	
							if (ret.getType() != SubController.SUBCONTROLLER_MAKE_VARIABLE_OK) {
								notified = false;	
							}
						}

						if (notified) {
							r = new Message(CONTROLLER_MAKE_VARIABLE_OK);
							r.append(v.id);
						} else {
							r = new Message(CONTROLLER_MAKE_VARIABLE_FAIL);
							r.append("could not notify all subcontrollers of the new variable");
						}

					} else {

						r = new Message(CONTROLLER_MAKE_VARIABLE_EXISTS);
						r.append(v.id);
					}
					
					}//end sync*/					
				
				
				} catch (Exception e) {
					r = new Message(CONTROLLER_MAKE_VARIABLE_FAIL);
					r.append(Logger.getStackTrace(e));				
				}
				
			} else if (type == CONTROLLER_MAKE_HASHMAP) {

				Logger.info("CONTROLLER: New HashMap");
				String hname = (String)m.get(0);

				try {

					//top level synchronization required for atomic get or create
					synchronized(shared_hashmaps_LOCK) {
						DataMap h = null;

						h = (DataMap)shared_hashmaps_map.get(hname);

						if (h == null) {
	
							int hid = shared_hashmaps.size()+1;
		
							h = new DataMap(hname,hid);
						
							shared_hashmaps.add(h);
							shared_hashmaps_map.put(hname,h);
					
							r = new Message(CONTROLLER_MAKE_HASHMAP_OK);
							r.append(h.id);
						
						} else {
							
							r = new Message(CONTROLLER_MAKE_HASHMAP_EXISTS);
							r.append(h.id);
						}
					
					}//end sync
				
				} catch (Exception e) {
					r = new Message(CONTROLLER_MAKE_HASHMAP_FAIL);
					r.append(Logger.getStackTrace(e));				
				}

			} else if (type == CONTROLLER_SET_PROGRAM) {
				Logger.info("CONTROLLER: Set Program");
			
				try {
					setProgram((byte[]) m.get(0), (Message)m.get(1));

					r = new Message(CONTROLLER_SET_PROGRAM_OK);
				} catch (Exception e) {
					r = new Message(CONTROLLER_SET_PROGRAM_FAIL);
					r.append(Logger.getStackTrace(e));				
				}
			
			} else if (type == CONTROLLER_CHECK_DEPS_CACHE) {
				Logger.info("CONTROLLER: Check JAR Dependencies Cache");
				
				r = checkDependenciesCache(m);
				r.setType(CONTROLLER_CHECK_DEPS_CACHE_OK);

			} else if (type == CONTROLLER_LAUNCH_PROGRAM) {
				Logger.info("CONTROLLER: Launch Program");

				try {
					launchProgram();
			
					r = new Message(CONTROLLER_LAUNCH_PROGRAM_OK);
				} catch (Exception e) {
					r = new Message(CONTROLLER_LAUNCH_PROGRAM_FAIL);
					r.append(Logger.getStackTrace(e));				
				}
			} else if (type == CONTROLLER_ABORT) {

				r = new Message(CONTROLLER_ABORT);
				abortEngine();

			} else if (type == CONTROLLER_SET_HEADLESS) {
				Logger.info("CONTROLLER: Set Headless");
				
				try {
					setHeadless( ((Integer)m.get(0)).intValue()==1 );
					r = new Message(CONTROLLER_SET_HEADLESS_OK);
				} catch (Exception e) {
					r = new Message(CONTROLLER_SET_HEADLESS_FAIL);
					r.append(Logger.getStackTrace(e));
				}

			} else if (type == CONTROLLER_SET_LOG_LEVEL) {
				Logger.info("CONTROLLER: Set Log Level");
				
				try {
					setLogLevel(((Integer)m.get(0)).intValue()==1,((Integer)m.get(1)).intValue()==1,((Integer)m.get(2)).intValue()==1);

					r = new Message(CONTROLLER_SET_LOG_LEVEL_OK);
				} catch (Exception e) {
					r = new Message(CONTROLLER_SET_LOG_LEVEL_FAIL);
					r.append(Logger.getStackTrace(e));				
				}

			} else if (type == CONTROLLER_RUNNER_STACKTRACE) {
				try {
					doRunnerStackTrace(((Integer)m.get(0)).intValue());
				} catch (Throwable t) {
					Logger.error("Runner stacktrace failed",t);
				}
				r = new Message(CONTROLLER_RUNNER_STACKTRACE);
				
			} else if (type == CONTROLLER_RUNNER_STACKDUMP) {

				try {
					doRunnerStackdump();
				} catch (Throwable t) {
					Logger.error("Runner stackdump failed",t);
				}
				r = new Message(CONTROLLER_RUNNER_STACKDUMP);
				
			} else {

				r = new Message(CONTROLLER_UNRECOGNISED_MESSAGE);

			}
			return r;
	}
	
	public void abortEngine() {
		new AbortThread().start();
	}

	public Message doTransaction(Message m) {
//		synchronized(LOCK_SERVER) {
		Message r;
		int type = m.getType();
					
		if (type == CONTROLLER_EMPTY) {
			r = m;
			
		} else if (type == CONTROLLER_SYNC_CLOCK) {
			clock = System.currentTimeMillis();

			Long offset = (Long)m.get(0);
			
			clock -= offset.longValue();
			
//			Logger.info("CONTROLLER CLOCK    - "+clock);
			
			try {
				
				int attempt = 0;
				for (int i = 1; i < subcontrollers_client.size(); i++) {
					
					MTTransactionClient tc = (MTTransactionClient)subcontrollers_client.get(i);

					//
					//find out how long a transaction takes
					//
					long t = System.currentTimeMillis();
						m = new Message(SubController.SUBCONTROLLER_SYNC_CLOCK);
						m.append(0L);
						r = tc.doTransaction(m);
					t = System.currentTimeMillis()-t;
					t = t/2;	//divide it by two (expect same delay up as down)

					//
					//sync the clock given with the proper offset
					//
					long rt = System.currentTimeMillis();
						m = new Message(SubController.SUBCONTROLLER_SYNC_CLOCK);
						m.append(t + (System.currentTimeMillis()-clock));
						r = tc.doTransaction(m);
					rt = System.currentTimeMillis()-rt;
					rt = rt/2;	//divide it by two (expect same delay up as down)
				
					double max = Math.max(rt,t);
					double min = Math.min(rt,t);
				
					//if it seems we were within 10ms, accept
					if (Math.abs(rt-t) > 10) {
						
						//if after the third try we still cant get 10ms, try 
						//for 10% of the average network lag 
						//if it seems we we're within 10%, accept, otherwise, redo
						if (max/10 < max-min || attempt < 2) {
//Logger.info("redoing... "+attempt);						
							i--;
							attempt++;
						} else {
//Logger.info("within 10%");
							attempt = 0;						
						}
					} else {
//Logger.info("within 10ms");						
						attempt = 0;						
					}
				
					if (r.getType() != SubController.SUBCONTROLLER_SYNC_CLOCK_OK) {
						throw new IOException("SubController clock sync failed - "+r);	
					}
				}

				r = new Message(CONTROLLER_SYNC_CLOCK_OK);
			} catch (IOException e) {
				r = new Message(CONTROLLER_SYNC_CLOCK_FAIL);
				r.append(Logger.getStackTrace(e));
			}

		} else {

			try {
				//
				// The message is a high priority message
				//			
				if (type >= MASK_HIGH_PRIORITY) {
					r = doTransactionHighPriority(m, type);
	
				//
				// The message is a medium priority message
				//			
				} else if (type >= MASK_MEDIUM_PRIORITY) {
					r = doTransactionMediumPriority(m, type);
	
				//
				// The message is a low priority message
				//			
				} else if (type >= MASK_LOW_PRIORITY) {
					r = doTransactionLowPriority(m, type);
	
				//
				// The message has no associated priority, so try the different transaction
				// methods in order of priority
				//
				} else if (type < MASK_LOW_PRIORITY) {
					
						//see if its a high priority message first
						r = doTransactionHighPriority(m, type);
	
						//see if its a medium priority message next
						if (r.getType() == CONTROLLER_UNRECOGNISED_MESSAGE) {
							r = doTransactionMediumPriority(m, type);
						}
	
						//see if its a low priority message last
						if (r.getType() == CONTROLLER_UNRECOGNISED_MESSAGE) {
							r = doTransactionLowPriority(m, type);
						}
	
				//
				// This should be impossible
				//			
				} else {
					r = new Message(CONTROLLER_UNRECOGNISED_MESSAGE);
					r.append("no recognised message priority");
				}
			} catch (Throwable t) {
				t.printStackTrace();
				r = new Message(Controller.CONTROLLER_INTERNAL_ERROR);
				r.append(Logger.getStackTrace(t));
			}
		}
			
		return r;
//		}//end synch
	}
	
	private void notifyDebug(String s) {
		try {
			//TODO all debugs should be buffered and dealt with in a separate thread
			Message m = new Message(CONTROLLER_DEBUG);
			m.append(s);
			synchronized(LOCK_CLIENTS) {
				for (int i = 0; i < clients_nout.size(); i++) { 
					MTMessageWriter cwriter = (MTMessageWriter)clients_nout.get(i);
					cwriter.write(m);
				}
			}
		} catch (Exception e) {
		}
	}

	class AbortThread extends Thread {
		boolean client_notifier = false;
		public AbortThread() {
		}
		private AbortThread(boolean notifier) {
			client_notifier = notifier;
		}
		public void run () {
			if (!client_notifier) {
				new AbortThread(true).start();
			}
			
			for (int i = 3; i > 0; i--) {
				if (!client_notifier) {
					Logger.direct("Aborting in "+i+"...");
				} else {
					notifyDebug("Aborting in "+i+"...");
				}
				try {
					Thread.sleep(750);
				} catch (Exception e) {}
			}
			if (!client_notifier) {
				System.exit(0);
			}
		}
	}
	
	private void traceDebug(String s) {
		try {
			Message m = new Message(CONTROLLER_DEBUG);
			m.append(s);
			
			//send the message to all clients
			synchronized(LOCK_CLIENTS) {
				for (int i = 0; i < clients_nout.size(); i++) { 
					MTMessageWriter cwriter = (MTMessageWriter)clients_nout.get(i);
					cwriter.write(m);
				}
			}
		} catch (Throwable t) {
			//TODO ?
		}
	}
	
	//
	// Messages coming from Daemon or notifies coming from subcontroller
	//
	class Reader extends Thread {

		MessageReader min;
		ThreadGroup tg;

//		Reader(MessageReader min) {
	//		this.min = min;
		//}
		
		Reader(MessageReader min, ThreadGroup tg, String name) {
			super(tg,name);
			this.tg = tg;
			this.min = min;
		}

	
		public void run() {
			Thread th = Thread.currentThread();
			th.setName("JEngine Controller [Daemon Server] Thread (ID: "+id+") ("+actual_address+")");
						
			try {
				while (true) {
					Message m = min.read();
					
					int type = m.getType();
					
					if (type == CONTROLLER_TRACE) {
//						Debugger.info("CONTROLLER: Trace");

						//send the message to all clients
						synchronized(LOCK_CLIENTS) {
							for (int i = 0; i < clients_nout.size(); i++) { 
								try {
									MTMessageWriter cwriter = (MTMessageWriter)clients_nout.get(i);
									cwriter.write(m);
								} catch (Exception e) {}
							}
						}
						
					} else if (type == CONTROLLER_PRINT) {
//						Debugger.info("CONTROLLER: Print");

						if (PRINT_INFO) {
							//send the message to all clients
							synchronized(LOCK_CLIENTS) {
								for (int i = 0; i < clients_nout.size(); i++) { 
									try {
										MTMessageWriter cwriter = (MTMessageWriter)clients_nout.get(i);
										cwriter.write(m);
									} catch (Exception e) {}
								}
							}
						}

					} else if (type == CONTROLLER_DEBUG) {
//						Debugger.info("CONTROLLER: Debug Print");

						if (PRINT_DEBUG) {
							//send the message to all clients
							synchronized(LOCK_CLIENTS) {
								for (int i = 0; i < clients_nout.size(); i++) { 
									try{
										MTMessageWriter cwriter = (MTMessageWriter)clients_nout.get(i);
										cwriter.write(m);
									} catch (Exception e) {}
								}
							}
						}
						
					} else if (type == CONTROLLER_RUNNER_DEATH) {
//						Debugger.info("CONTROLLER: RunnerDeath");
						
						Long lid = (Long)m.get(0);
						
//						Debugger.info("CONTROLLER: RunnerDeath ID "+Long.toHexString(lid.longValue()));
						
						synchronized(runner_directory_LOCK) {
							if (runner_directory.get(lid) == null) {
								//this runner has not been marked Alive yet, so mark it alive
								runner_directory.put(lid,new RunnerWait());
							} else {
								//runner is alive, 
								RunnerWait rwait = (RunnerWait)runner_directory.remove(lid);

								if (rwait.waiting_runner != RunnerWait.NONE) {
									//something is waiting on this runner - notify it of its death	

//									Debugger.info("CONTROLLER: RunnerDeath "+Long.toHexString(rwait.waiting_runner)+" needs to be notified of this death");

									wakeRunner(rwait.waiting_runner);

//								} else {
//									Debugger.info("CONTROLLER: RunnerDeath no runner needs to be notified of this death");
								}
							}
						}
					} else if (type == CONTROLLER_RUNNER_STACKDUMP) {
		
						doRunnerStackdump();
						
					} else {
						
						throw new IOException("unrecognised message "+m);
						
					}
					
				}
			} catch (Throwable t) {
				tg.uncaughtException(this,t);
//				t.printStackTrace();	
			}
		}
	}

	private void doRunnerStackTrace(int msg_id) throws IOException {
		Message m = new Message(SubController.SUBCONTROLLER_RUNNER_STACKTRACE);
		m.append(msg_id);
		
		for (int i = 0; i < subcontrollers_client.size(); i++) {
			MTTransactionClient tc = (MTTransactionClient)subcontrollers_client.get(i);
			tc.doTransaction(m);
		}
	}
	private void doRunnerStackdump() throws IOException {
		  Message m = new Message(SubController.SUBCONTROLLER_RUNNER_STACKDUMP);

		  for (int i = 0; i < subcontrollers_client.size(); i++) {
				  MTTransactionClient tc = (MTTransactionClient)subcontrollers_client.get(i);
				  tc.doTransaction(m);
		  }
	}

	private void notifyMessageConsumer(long rid, Message data) throws IOException {
		int cindex = ID.CONTROLLER_INDEX(rid);
		
		MTTransactionClient stc = (MTTransactionClient)subcontrollers_client.get(cindex);
		Message m = new Message(SubController.SUBCONTROLLER_RECEIVE_MESSAGE);
		m.append(rid);
		m.append(data);
		
		m = stc.doTransaction(m);

		int rtype = m.getType();

		if (rtype != SubController.SUBCONTROLLER_RECEIVE_MESSAGE_OK) {
			throw new IOException("SubController receive message failed "+m);					
		}
		
	}

	private void wakeRunner(long rid) throws IOException {
		int cindex = ID.CONTROLLER_INDEX(rid);

//Debugger.info("Controller: Wake Runner - "+rid+" ("+cindex+")");

		MTTransactionClient stc = (MTTransactionClient)subcontrollers_client.get(cindex);
		Message m = new Message(SubController.SUBCONTROLLER_WAKE_RUNNER);
		m.append(rid);
		m = stc.doTransaction(m);

		int rtype = m.getType();

		if (rtype != SubController.SUBCONTROLLER_WAKE_RUNNER_OK) {
			throw new IOException("SubController wake runner failed "+m);					
		}
			
	}

}