/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.jengine.internal.mainengine;

import org.eclipse.stp.b2j.core.jengine.internal.utils.Logger;

/**
 * 
 * @author amiguel
 * 
 * A thread group used by the distributed engine to identify threads that
 * should kill the engine when they die (e.g. threads responsible for 
 * communication)
 */
public class CriticalThreadGroup extends ThreadGroup {
	
	boolean exitOnException = true;
	
	public CriticalThreadGroup() {
		super("CriticalThreadGroup");	
	}
	
	public void setExitOnException(boolean b) {
		exitOnException = b;
	}
	
	public void uncaughtException(Thread t, Throwable e) {
		if (exitOnException) {
			Logger.warning("Critical Thread Exit! ("+t.getName()+") - ABORTING NOW!"+t,e);
		
			System.exit(0);	
		} else {
			Logger.warning("Non Critical Thread Exit ("+t.getName()+") - NO ABORT REQUIRED"+t,e);
			
		}
	} 
}