/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.jengine.internal.message;


import java.io.IOException;

/**
 * @author amiguel
 * 
 * A BPlane transaction server thread, used to distinguish between 
 * transactions that are being rerouted and transactions that are
 * sourced on the local machine
 */
public class BPlaneServerThread extends Thread {

	ThreadGroup tg = null;
	
	BPlaneTransactionServer server;
	
	MessageReader min;
	MessageWriter mout;
	
	public short plane;
	
	boolean used = false;

	public BPlaneServerThread(BPlaneTransactionServer server, short plane, ThreadGroup tg) {
		super(tg,"BufferPlaneServerThread");
		this.server = server;
		this.plane = plane;
		this.tg = tg;
		
		min = new MessageReader(server.xin.getInputStream(plane));
		mout = new MessageWriter(server.xout.getOutputStream(plane));
	}
	public BPlaneServerThread(BPlaneTransactionServer server, short plane) {
		this.server = server;
		this.plane = plane;
		
		min = new MessageReader(server.xin.getInputStream(plane));
		mout = new MessageWriter(server.xout.getOutputStream(plane));
	}

	public int getPlane() {
		return plane;	
	}
	
	public void run() {
	
		Message m;
	
		while( true ) {
	
			try { 
		
				m = min.read();
			
				if (!used) {
					//first time this buffer plane has been used
					server.startPlaneListener((short)(plane+(short)1));
					used = true;
				}

				
				m = server.tl.doTransaction(m);

				mout.write(m);
	
			} catch (IOException e) {
				if (tg != null) {
					tg.uncaughtException(this,e);
				}
				break;
			}
		
		}//end while
	}//end method
	
	
}