/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.jengine.internal.utils;

/**
 * @author amiguel
 * 
 * A thread which continually calls the garbage collector at a given
 * frequency to ensure engine footprint stays reasonable
 */
public class GCThread extends Thread {
	private static GCThread thread = new GCThread();
	private static int cutoff = 0;
	private static long frequency = 15000;
	
	public static void startThread() {
		if (!thread.isAlive()) {
			thread.setDaemon(true);
			thread.setName("JEngine - GCThread");
			thread.start();	
		}
	}
	
	public static void setCutoff(int bytes) {
		cutoff = bytes;	
	}
	
	public static void setFrequency(long ms) {
		frequency = ms;	
	}
	
	public void run() {
		Runtime runtime = Runtime.getRuntime();
		long used;
		while (true) {
			try {
				Thread.sleep(frequency);				
			} catch (InterruptedException e) {
			}
			used =runtime.totalMemory()-runtime.freeMemory();
//			Logger.info(used); 
			if (used > cutoff) {
				runtime.gc();
			}
		}	
	}
}