/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.jengine.internal.utils;

/**
 * 
 * @author amiguel
 *
 * Used to compare the speed of two runnables
 */
public class SpeedComparator {

private static boolean DEBUG = false;
	
	/**
	 * Returns speed of r1 / speed of r2 (e.g. if r1 twice as fast as r2, returns 2.0)
	 * @param r1
	 * @param r2
	 * @param min_t
	 * @return
	 */
	public static double compare(Runnable r1, Runnable r2, long min_t) {
		long t = 0; 
		
		double s1, s2;
		double MULT;
		
		s1 = 1;
		t = 0;
		MULT = 1;
		while (t < min_t) {
			t = System.currentTimeMillis();
			for (int i = 0; i < MULT; i++) {
				r1.run();
			}
			t = System.currentTimeMillis()-t;
			
			s1 = MULT / (double)t;

			if (DEBUG) {
				if (t >= min_t) {
					System.out.println(r1.getClass()+": "+t+"ms, "+MULT+" runs");
				}
			}

			MULT *= 10;
		}
		
		
		s2 = 1;
		t = 0;
		MULT = 1;
		while (t < min_t) {
			t = System.currentTimeMillis();
			for (int i = 0; i < MULT; i++) {
				r2.run();
			}
			t = System.currentTimeMillis()-t;
			
			s2 = MULT / (double)t;

			if (DEBUG) {
				if (t >= min_t) {
					System.out.println(r2.getClass()+": "+t+"ms, "+MULT+" runs");
				}
			}

			MULT *= 10;
		}
		
		return s1/s2;
	}
	
}