/**********************************************************************
 * Copyright (c) 2006 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.misc.internal;

import java.util.ArrayList;

public class StringSplitter {
	public static String[] split(String src, String chop) {
		ArrayList list = new ArrayList();
		int choplen = chop.length();
		int n = src.indexOf(chop);
		while (n != -1) {
			list.add(src.substring(0,n));
			src = src.substring(n+choplen);
			n = src.indexOf(chop);
		}
		list.add(src);
		
		while (list.size() > 0 && ((String)list.get(list.size()-1)).length() == 0) {
			//we do this to comply with the operation of string.split(str)
			list.remove(list.size()-1);
		}
		
		String[] tmp = new String[list.size()];
		list.toArray(tmp);
		return tmp;
	}
	public static void main(String[] args) {
		print("one/two/three","/");
		print("one/two/","/");
		print("/two/","/");
		print("//two//","/");
	}
	private static void print(String src, String chop) {
		System.out.println("String: "+src);
		System.out.println("Chop: "+chop);
		String[] t = split(src,chop);
		
		for (int i = 0; i < t.length; i++) {
			System.out.println(i+" ["+t[i]+"]");
		}
	}
}