/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.publicapi.extension.sessiontransport;

import org.eclipse.stp.b2j.core.publicapi.transport.session.SessionAddress;

/**
 * 
 * @author amiguel
 *
 * A class which extensions of the b2j main engine transport 
 * extension point must implement.
 */
public interface SessionTransportProvider {
	public String getHumanReadableTypeName();
	public String getProviderClassName();
	public SessionTransport newInstance(SessionAddress address, boolean initiator) throws Exception;
	public boolean supportsEncryption();
	public boolean supportsAuthentication();
}