/**********************************************************************
 * Copyright (c) 2006 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.xml.internal.w3c;

public class Element extends Node {

NamedNodeMap attributes = new NamedNodeMap(this);
String name;

	public Element(Node node, String name) {
		super(node,-1);
		
		this.name = name;
	}
	
////////////////////////////////////////
// Element interface
////////////////////////////////////////
	 public String getAttribute(String name) {
		 String s = (String)attributes.get(name);
		 if (s == null) return "";
		 return s;
	 }
	public String getAttributeNS(String namespaceURI, String localName) {
		return getAttribute(localName);
	}
	public Attr getAttributeNode(String name) {
		 Attr at = new Attr(this,name,getAttribute(name));
		 at.setStartLine(getStartLine());
		 at.setEndLine(getEndLine());
		 return at;
	} 
	public Attr getAttributeNodeNS(String namespaceURI, String localName) {
		 return getAttributeNode(localName);
	} 
	public NodeList getElementsByTagName(String name) {
		NodeList list = getDepthFirstList();
		filterList(list,Node.ELEMENT_NODE);
		if (!name.equals("*")) {
			filterList(list,name);
		}
		return list; 
	}
	public NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
		return getElementsByTagName(localName);
	} 
	public String getTagName() {
		 return name;
	}
	public boolean hasAttribute(String name) {
//		 return getAttribute(name) != null;
		return attributes.containsKey(name);
	} 
	public boolean hasAttributeNS(String namespaceURI, String localName) {
		return hasAttribute(localName);
	}	 
	public void removeAttribute(String name) {
		attributes.remove(name);
	}
	public void removeAttributeNS(String namespaceURI, String localName) {
		removeAttribute(localName);
	}
	public Attr removeAttributeNode(Attr oldAttr) {
		attributes.remove(oldAttr.getName());
		return oldAttr;
	} 
	public void setAttribute(String name, String value) {
		attributes.put(name,value);
	}
	public void setAttributeNS(String namespaceURI, String qualifiedName, String value) {
		setAttribute(qualifiedName,value);
	} 
	public Attr setAttributeNode(Attr newAttr) {
		setAttribute(newAttr.getName(),newAttr.getValue());
		return newAttr;
	}
	public Attr setAttributeNodeNS(Attr newAttr)  {
		return setAttributeNode(newAttr);
	}
		
//	////////////////////////////////////
//	 Node interface
//	////////////////////////////////////

	public String getNodeName() {
		return name;	
	}

	public String getNodeValue() {
		return null;	
	}

	public void setNodeValue(String value) {
		//do nothing
	}

	public short getNodeType() {
		return Node.ELEMENT_NODE;	
	}

	public boolean hasAttributes() {
		return attributes.size() > 0;	
	}

	public NamedNodeMap getAttributes() {
		return attributes;	
	}

	Node cloneNode(Node parent) {
		Element element = new Element(parent,name);
		element.attributes.putAll(attributes);
		return element;
	}
	
}