/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.diagram.edit.parts;

import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.figures.PolylineConnectionEx;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.stp.bpmn.Association;
import org.eclipse.stp.bpmn.BpmnPackage;
import org.eclipse.stp.bpmn.DirectionType;
import org.eclipse.stp.bpmn.diagram.edit.policies.AssociationItemSemanticEditPolicy;
import org.eclipse.stp.bpmn.figures.AssociationPolylineSourceDecoration;
import org.eclipse.stp.bpmn.figures.AssociationPolylineTargetDecoration;
import org.eclipse.stp.bpmn.figures.activities.ActivityPainter;
import org.eclipse.stp.bpmn.policies.BpmnDragDropEditPolicy;
import org.eclipse.stp.bpmn.policies.OpenFileEditPolicy;

public class AssociationEditPart
extends ConnectionNodeEditPart {
    public static final int VISUAL_ID = 3003;
    private static final int[] DASHES = new int[]{1, 2};

    public AssociationEditPart(View view) {
        super(view);
    }

    protected void createDefaultEditPoliciesGen() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new AssociationItemSemanticEditPolicy());
    }

    protected void createDefaultEditPolicies() {
        this.createDefaultEditPoliciesGen();
        this.installEditPolicy("DragDropPolicy", (EditPolicy)new BpmnDragDropEditPolicy((IGraphicalEditPart)this));
        this.installEditPolicy("OpenPolicy", (EditPolicy)new OpenFileEditPolicy());
    }

    protected Connection createConnectionFigure() {
        return new ConnectionAssociationFigure();
    }

    protected void refreshVisuals() {
        this.refreshSourceAnchor();
        this.refreshTargetAnchor();
        super.refreshVisuals();
    }

    protected void handleNotificationEvent(Notification notification) {
        if ((notification.getEventType() == 1 || notification.getEventType() == 2) && BpmnPackage.eINSTANCE.getAssociation_Direction().equals(notification.getFeature())) {
            DirectionType newActivityType = (DirectionType)notification.getNewValue();
            ConnectionAssociationFigure conn = (ConnectionAssociationFigure)this.getFigure();
            conn.updateDirectionType(newActivityType.getValue());
            conn.repaint();
        }
        super.handleNotificationEvent(notification);
    }

    protected ConnectionAnchor getSourceConnectionAnchor() {
        ConnectionAnchor ca = super.getSourceConnectionAnchor();
        this.updateConnectionAnchor(ca, true);
        return ca;
    }

    protected ConnectionAnchor getTargetConnectionAnchor() {
        ConnectionAnchor ca = super.getTargetConnectionAnchor();
        this.updateConnectionAnchor(ca, false);
        return ca;
    }

    protected void updateConnectionAnchor(ConnectionAnchor ca, boolean isSource) {
    }

    protected IFigure createToolTip() {
        return ActivityPainter.createToolTipFigure(this.getToolTipText());
    }

    protected String getToolTipText() {
        return null;
    }

    public class ConnectionAssociationFigure
    extends PolylineConnectionEx {
        public ConnectionAssociationFigure() {
            this.setLineStyle(6);
            this.setLineDash(DASHES);
            this.setSourceDecoration((RotatableDecoration)this.createSourceDecoration());
            this.setTargetDecoration((RotatableDecoration)this.createTargetDecoration());
        }

        public void updateDirectionType(int newDirectionType) {
            ((AssociationPolylineSourceDecoration)super.getSourceDecoration()).updateDirectionType(newDirectionType);
            ((AssociationPolylineTargetDecoration)super.getTargetDecoration()).updateDirectionType(newDirectionType);
        }

        private AssociationPolylineSourceDecoration createSourceDecoration() {
            Association assoc = (Association)AssociationEditPart.this.resolveSemanticElement();
            int dir = assoc == null ? 0 : assoc.getDirection().getValue();
            AssociationPolylineSourceDecoration df = new AssociationPolylineSourceDecoration(dir);
            return df;
        }

        private AssociationPolylineTargetDecoration createTargetDecoration() {
            Association assoc = (Association)AssociationEditPart.this.resolveSemanticElement();
            int dir = assoc == null ? 0 : assoc.getDirection().getValue();
            AssociationPolylineTargetDecoration df = new AssociationPolylineTargetDecoration(dir);
            return df;
        }
    }
}

