/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.palette;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.internal.ui.palette.editparts.SliderPaletteEditPart;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.ui.palette.PaletteEditPartFactory;
import org.eclipse.stp.bpmn.palette.BpmnToolEntryEditPart;
import org.eclipse.swt.graphics.Color;

public class BpmnPaletteEditPartFactory
extends PaletteEditPartFactory {
    private Color _entryBackgroundColor;
    private Color _entryForegroundColor;

    public BpmnPaletteEditPartFactory(Color entryForegroundColor, Color entryBackgroundColor) {
        this._entryBackgroundColor = entryBackgroundColor;
        this._entryForegroundColor = entryForegroundColor;
    }

    public BpmnPaletteEditPartFactory() {
        this._entryBackgroundColor = ColorConstants.button;
        this._entryForegroundColor = ColorConstants.buttonLightest;
    }

    protected EditPart createEntryEditPart(EditPart parentEditPart, Object model) {
        return new BpmnToolEntryEditPart((PaletteEntry)model, this._entryForegroundColor, this._entryBackgroundColor);
    }

    protected EditPart createMainPaletteEditPart(EditPart parentEditPart, Object model) {
        return new SliderPaletteEditPart((PaletteRoot)model){

            public IFigure createFigure() {
                IFigure fig = super.createFigure();
                fig.setBackgroundColor(BpmnPaletteEditPartFactory.this._entryBackgroundColor);
                return fig;
            }
        };
    }
}

