/**
 * 
 */
package client;

import java.util.Iterator;

import org.apache.tuscany.container.java.module.EventContext;
import org.apache.tuscany.container.java.module.TuscanyModuleComponentContext;
import org.apache.tuscany.container.java.module.impl.DefaultScopeStrategy;
import org.apache.tuscany.container.java.module.impl.SDOConfigurer;
import org.apache.tuscany.container.java.module.impl.TuscanyModuleComponentContextImpl;
import org.osoa.sca.SCA;

import services.account.AccountReport;
import services.account.AccountService;
import services.account.AccountSummary;

public class AccountClient extends SCA {

	public void start(){ 
	}

	public void stop(){
	}

	public static void main(String[] args) throws Exception {
		SDOConfigurer configurer = new SDOConfigurer();
		TuscanyModuleComponentContext moduleComponent =
			new TuscanyModuleComponentContextImpl(
					1, "bigbank.account.testclient", "uri",
					new DefaultScopeStrategy(), configurer);

		setModuleContext(moduleComponent);
		moduleComponent.start();
		moduleComponent.fireEvent(EventContext.MODULE_START, null);
		moduleComponent.fireEvent(EventContext.REQUEST_START, null);
		Object key = new Object();
		moduleComponent.fireEvent(EventContext.SESSION_NOTIFY, key);
		AccountService accountService = (AccountService)
			moduleComponent.locateService("AccountServiceComponent");

		AccountReport accountReport=accountService.getAccountReport("12345");
		
		for (Iterator i=accountReport.getAccountSummaries().iterator(); i.hasNext(); ) {
			AccountSummary accountSummary=(AccountSummary)i.next();
			
			System.out.println(accountSummary.getAccountNumber());
			System.out.println(accountSummary.getAccountType());
			System.out.println(accountSummary.getBalance());
		}
		
	}

}
